-------------------------------------------------------------------------------
-- Copyright (c) 1995/2004 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                  Multifunctional, Cascadable, 48-bit Output Arithmetic Block
-- /___/   /\     Filename : X_DSP48A.vhd
-- \   \  /  \    Timestamp : Mon Mar 20 17:25:10 PST 2006
--  \___\/\___\
--
-- Revision:
--    03/25/06 - Initial version.
--    09/22/06 - fixed CR 421339
--    01/17/07 - fixed CR 431766
--    27/05/08 - CR 472154 Removed Vital GSR constructs
-- End Revision
----- CELL X_DSP48A -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_SIGNED.all;
use IEEE.STD_LOGIC_ARITH.all;

library STD;
use STD.TEXTIO.all;


library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.Vcomponents.all;
use simprim.VPACKAGE.all;

entity X_DSP48A is

  generic(

        TimingChecksOn  : boolean       := true;
        InstancePath    : string        := "*";
        Xon             : boolean       := true;
        MsgOn           : boolean       := true;
        B_INPUT         : string        := "DIRECT";
        LOC     	: string        := "UNPLACED";

----- VITAL input wire delays
        tipd_A          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_B          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_BCIN       : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_C          : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_CARRYIN    : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEA        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEB        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEC        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECARRYIN  : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CED        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEM        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEOPMODE   : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEP        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CLK        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_D          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_OPMODE     : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
        tipd_PCIN       : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_RSTA       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTB       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTC       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTCARRYIN : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTD       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTM       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTOPMODE  : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTP       : VitalDelayType01 := ( 0 ps,  0 ps);

----- VITAL pin-to-pin propagation delays

        tpd_A_CARRYOUT  : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_A_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_A_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_B_BCOUT     : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_CARRYOUT  : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_BCIN_BCOUT  : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_CARRYOUT  : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_P      : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_PCOUT  : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_C_CARRYOUT  : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_C_P         : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_C_PCOUT     : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));

        tpd_CARRYIN_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_CARRYIN_P     : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_CLK_BCOUT   : VitalDelayArrayType01 (17 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_CARRYOUT : VitalDelayType01                    := (100 ps, 100 ps);
        tpd_CLK_P       : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_PCOUT   : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));

        tpd_D_BCOUT     : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_D_CARRYOUT  : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_D_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_D_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_OPMODE_BCOUT    : VitalDelayArrayType01 (143 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_CARRYOUT : VitalDelayArrayType01 (7 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_P     : VitalDelayArrayType01 (383 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_PCOUT : VitalDelayArrayType01 (383 downto 0)  := (others => (0 ps, 0 ps));

        tpd_PCIN_CARRYOUT : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_PCIN_P      : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_PCIN_PCOUT  : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
       
        tpd_RSTA_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTA_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTA_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTB_BCOUT    : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTB_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTB_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTB_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTC_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTC_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTC_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTCARRYIN_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTCARRYIN_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTCARRYIN_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTD_BCOUT    : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTD_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTD_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTD_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTM_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTM_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTM_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTOPMODE_BCOUT    : VitalDelayArrayType01 (17 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTOPMODE_CARRYOUT : VitalDelayType01                  := (0 ps, 0 ps);
        tpd_RSTOPMODE_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTOPMODE_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_RSTP_P        : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_RSTP_PCOUT    : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

----- VITAL setup and hold times
       
        tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);

        tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);

        tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);

        tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);

        tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);

        tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);

        tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);

        tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;

        tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;


----- VITAL clock ticd delays
        ticd_CLK        : VitalDelayType  := 0 ps;
     
----- VITAL clock-to-pin tisd delays
        tisd_A_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_B_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_BCIN_CLK           : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_C_CLK              : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_CARRYIN_CLK        : VitalDelayType  := 0 ps;
        tisd_CEA_CLK            : VitalDelayType  := 0 ps;
        tisd_CEB_CLK            : VitalDelayType  := 0 ps;
        tisd_CEC_CLK            : VitalDelayType  := 0 ps;
        tisd_CECARRYIN_CLK      : VitalDelayType  := 0 ps;
        tisd_CED_CLK            : VitalDelayType  := 0 ps;
        tisd_CEM_CLK            : VitalDelayType  := 0 ps;
        tisd_CEOPMODE_CLK       : VitalDelayType  := 0 ps;
        tisd_CEP_CLK            : VitalDelayType  := 0 ps;
        tisd_D_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_OPMODE_CLK         : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_PCIN_CLK           : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_RSTA_CLK           : VitalDelayType := 0 ps;
        tisd_RSTB_CLK           : VitalDelayType := 0 ps;
        tisd_RSTC_CLK           : VitalDelayType := 0 ps;
        tisd_RSTCARRYIN_CLK     : VitalDelayType := 0 ps;
        tisd_RSTD_CLK           : VitalDelayType := 0 ps;
        tisd_RSTM_CLK           : VitalDelayType := 0 ps;
        tisd_RSTOPMODE_CLK      : VitalDelayType := 0 ps;
        tisd_RSTP_CLK           : VitalDelayType := 0 ps;

----- VITAL period check 
        tperiod_CLK_posedge     : VitalDelayType := 0 ps;

----- VITAL pulse width
        tpw_CLK_negedge         : VitalDelayType := 0 ps;
        tpw_CLK_posedge         : VitalDelayType := 0 ps;

----- VITAL Recovery

        A0REG           : integer       := 0;
        A1REG           : integer       := 1;
        B0REG           : integer       := 0;
        B1REG           : integer       := 1;
        CARRYINREG      : integer       := 1;
        CARRYINSEL      : string        := "CARRYIN";
        CREG            : integer       := 1;
        DREG            : integer       := 1;
        MREG            : integer       := 1;
        OPMODEREG       : integer       := 1;
        PREG            : integer       := 1;
        RSTTYPE         : string        := "SYNC"
        );


  port(
        BCOUT                   : out std_logic_vector(17 downto 0);
        CARRYOUT                : out std_ulogic;
        P                       : out std_logic_vector(47 downto 0);
        PCOUT                   : out std_logic_vector(47 downto 0);

        A                       : in  std_logic_vector(17 downto 0);
        B                       : in  std_logic_vector(17 downto 0);
        BCIN                    : in  std_logic_vector(17 downto 0);
        C                       : in  std_logic_vector(47 downto 0);
        CARRYIN                 : in  std_ulogic;
        CEA                     : in  std_ulogic;
        CEB                     : in  std_ulogic;
        CEC                     : in  std_ulogic;
        CECARRYIN               : in  std_ulogic;
        CED                     : in  std_ulogic;
        CEM                     : in  std_ulogic;
        CEOPMODE                : in  std_ulogic;
        CEP                     : in  std_ulogic;
        CLK                     : in  std_ulogic;
        D                       : in  std_logic_vector(17 downto 0);
        OPMODE                  : in  std_logic_vector(7 downto 0);
        PCIN                    : in  std_logic_vector(47 downto 0);
        RSTA                    : in  std_ulogic;
        RSTB                    : in  std_ulogic;
        RSTC                    : in  std_ulogic;
        RSTCARRYIN              : in  std_ulogic;
        RSTD                    : in  std_ulogic;
        RSTM                    : in  std_ulogic;
        RSTOPMODE               : in  std_ulogic;
        RSTP                    : in  std_ulogic
      );

  attribute VITAL_LEVEL0 of X_DSP48A :     entity is true;

end X_DSP48A;

-- architecture body                    --

architecture X_DSP48A_V of X_DSP48A is

    procedure invalid_opmode_preg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48A instance "));
       Write ( Message, string'("requires attribute PREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_preg_msg;

    procedure invalid_opmode_mreg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48A instance "));
       Write ( Message, string'("requires attribute MREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_mreg_msg;

    procedure invalid_opmode_no_mreg_msg( OPMODE : IN string ; 
                                      CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48A instance "));
       Write ( Message, string'("requires attribute MREG set to 0."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_no_mreg_msg;


  attribute VITAL_LEVEL0 of X_DSP48A_V : architecture is true;

  TYPE VitalTimingDataArrayType IS ARRAY (NATURAL RANGE <>)
         OF VitalTimingDataType;



  constant SYNC_PATH_DELAY : time := 100 ps;

  constant MAX_ACCUM      : integer    := 48;
  constant MAX_BCOUT      : integer    := 18;
  constant MAX_P          : integer    := 48;
  constant MAX_PCOUT      : integer    := 48;
  constant MSB_ACCUM      : integer    := MAX_ACCUM - 1;
  constant MSB_BCOUT      : integer    := MAX_BCOUT - 1;
  constant MSB_P          : integer    := MAX_P     - 1;
  constant MSB_PCOUT      : integer    := MAX_PCOUT - 1;

  constant MAX_A          : integer    := 18;
  constant MAX_B          : integer    := 18;
  constant MAX_BCIN       : integer    := 18;
  constant MAX_C          : integer    := 48;
  constant MAX_D          : integer    := 18;
  constant MAX_PREADD     : integer    := 18;
  constant MAX_OPMODE     : integer    := 8;
  constant MAX_PCIN       : integer    := 48;
  constant MSB_A          : integer    := MAX_A      - 1;
  constant MSB_B          : integer    := MAX_B      - 1;
  constant MSB_BCIN       : integer    := MAX_BCIN   - 1;
  constant MSB_C          : integer    := MAX_C      - 1;
  constant MSB_D          : integer    := MAX_D      - 1;
  constant MSB_PREADD     : integer    := MAX_PREADD - 1;
  constant MSB_OPMODE     : integer    := MAX_OPMODE - 1;
  constant MSB_PCIN       : integer    := MAX_PCIN   - 1;


  constant SHIFT_MUXZ     : integer    := 17;

  signal 	A_ipd		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	B_ipd		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_ipd	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_ipd		: std_logic_vector(MSB_C downto 0)    := (others => '0');
  signal 	CARRYIN_ipd	: std_ulogic := '0';
  signal 	CEA_ipd		: std_ulogic := '0';
  signal 	CEB_ipd		: std_ulogic := '0';
  signal 	CEC_ipd		: std_ulogic := '0';
  signal 	CECARRYIN_ipd	: std_ulogic := '0';
  signal 	CED_ipd		: std_ulogic := '0';
  signal 	CEM_ipd		: std_ulogic := '0';
  signal 	CEOPMODE_ipd	: std_ulogic := '0';
  signal 	CEP_ipd		: std_ulogic := '0';
  signal 	CLK_ipd		: std_ulogic := '0';
  signal 	D_ipd		: std_logic_vector(MSB_D downto 0) := (others => '0');
  signal 	GSR_ipd		: std_ulogic := '0';
  signal 	OPMODE_ipd	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_ipd	: std_logic_vector(MSB_PCIN downto 0) := (others => '0');
  signal 	RSTA_ipd	: std_ulogic := '0';
  signal 	RSTB_ipd	: std_ulogic := '0';
  signal 	RSTC_ipd	: std_ulogic := '0';
  signal 	RSTCARRYIN_ipd	: std_ulogic := '0';
  signal 	RSTD_ipd	: std_ulogic := '0';
  signal 	RSTM_ipd	: std_ulogic := '0';
  signal 	RSTOPMODE_ipd	: std_ulogic := '0';
  signal 	RSTP_ipd	: std_ulogic := '0';

  signal 	A_dly		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	B_dly		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_dly	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_dly		: std_logic_vector(MSB_C downto 0)    := (others => '0');
  signal 	CARRYIN_dly	: std_ulogic := '0';
  signal 	CEA_dly		: std_ulogic := '0';
  signal 	CEB_dly		: std_ulogic := '0';
  signal 	CEC_dly		: std_ulogic := '0';
  signal 	CECARRYIN_dly	: std_ulogic := '0';
  signal 	CED_dly		: std_ulogic := '0';
  signal 	CEM_dly		: std_ulogic := '0';
  signal 	CEOPMODE_dly	: std_ulogic := '0';
  signal 	CEP_dly		: std_ulogic := '0';
  signal 	CLK_dly		: std_ulogic := '0';
  signal 	D_dly		: std_logic_vector(MSB_D downto 0) := (others => '0');
  signal 	GSR_dly		: std_ulogic := '0';
  signal 	OPMODE_dly	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_dly	: std_logic_vector(MSB_PCIN downto 0) := (others => '0');
  signal 	RSTA_dly	: std_ulogic := '0';
  signal 	RSTB_dly	: std_ulogic := '0';
  signal 	RSTC_dly	: std_ulogic := '0';
  signal 	RSTCARRYIN_dly	: std_ulogic := '0';
  signal 	RSTD_dly	: std_ulogic := '0';
  signal 	RSTM_dly	: std_ulogic := '0';
  signal 	RSTOPMODE_dly	: std_ulogic := '0';
  signal 	RSTP_dly	: std_ulogic := '0';


  signal	BCOUT_zd	: std_logic_vector(MSB_BCOUT downto 0) := (others => '0');
  signal 	CARRYOUT_zd	: std_ulogic := '0';
  signal	P_zd		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	PCOUT_zd	: std_logic_vector(MSB_PCOUT downto 0) := (others => '0');
  
  --- Internal Signal Declarations
  signal	qa_o_reg1	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_reg2	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_mux	: std_logic_vector(MSB_A downto 0) := (others => '0');

  signal	b_o_mux		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg1	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg2	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_mux0	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_mux	: std_logic_vector(MSB_B downto 0) := (others => '0');

  signal	qc_o_reg        : std_logic_vector(MSB_C downto 0) := (others => '0');
  signal	qc_o_mux	: std_logic_vector(MSB_C downto 0) := (others => '0');

  signal	qd_o_reg        : std_logic_vector(MSB_D downto 0) := (others => '0');
  signal	qd_o_mux	: std_logic_vector(MSB_D downto 0) := (others => '0');

  signal	preadd		: std_logic_vector(MSB_PREADD downto 0) := (others => '0');
  signal	mux_preadd	: std_logic_vector(MSB_PREADD downto 0) := (others => '0');

  signal	mult_o_int	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');
  signal	mult_o_reg	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');
  signal	mult_o_mux	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');

  signal	opmode_o_reg	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');
  signal	opmode_o_mux	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');

  signal	muxx_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxy_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxz_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	subtract_o_reg	: std_ulogic := '0';
  signal	subtract_o_mux	: std_ulogic := '0';

  signal	carryinsel_o_reg	: std_ulogic := '0';
  signal	carryinsel_o_mux	: std_ulogic := '0';

  signal	qcarryin_o_reg1	: std_ulogic := '0';
  signal	carryin0_o_mux	: std_ulogic := '0';
  signal	carryin1_o_mux	: std_ulogic := '0';
  signal	carryin2_o_mux	: std_ulogic := '0';

  signal	qcarryin_o_reg2	: std_ulogic := '0';

  signal	carryin_o_mux	: std_ulogic := '0';

  signal	accum_o		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	qp_o_reg	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	qp_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	add_i_int      : std_logic_vector(47 downto 0) := (others => '0');
  signal	add_o_int      : std_logic_vector(47 downto 0) := (others => '0');

  signal	reg_p_int         : std_logic_vector(47 downto 0) := (others => '0');
  signal	p_o_int         : std_logic_vector(47 downto 0) := (others => '0');

  signal	subtract1_o_int : std_ulogic := '0';
  signal	carryinsel1_o_int : std_logic_vector(1 downto 0) := (others => '0');
  signal	carry1_o_int     : std_ulogic := '0';
  signal	carry2_o_int     : std_ulogic := '0';


  signal	output_x_sig	  : std_ulogic := '0';

  signal	RST_META          : std_ulogic := '0';

  signal	DefDelay          : time := 10 ps;

  signal	rst_async_flag    : std_ulogic := '0';
  signal	carryinsel_attr   : std_ulogic := '0';

  signal	opmode_valid_flg  : boolean := true;

begin

  GSR_dly <= GSR;

  ---------------------
  --  INPUT PATH DELAYs
  ---------------------

  WireDelay     : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalWireDelay (A_ipd(i),    A(i),        tipd_A(i));
    end generate A_Delay;    

    B_Delay : for i in MSB_B downto 0 generate
        VitalWireDelay (B_ipd(i),    B(i),        tipd_B(i));
    end generate B_Delay;    

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalWireDelay (BCIN_ipd(i),    BCIN(i),        tipd_BCIN(i));
    end generate BCIN_Delay;    

    C_Delay : for i in MSB_C downto 0 generate
        VitalWireDelay (C_ipd(i),    C(i),        tipd_C(i));
    end generate C_Delay;    

    VitalWireDelay (CARRYIN_ipd,    CARRYIN,    tipd_CARRYIN);

    VitalWireDelay (CEA_ipd,        CEA,        tipd_CEA);
    VitalWireDelay (CEB_ipd,        CEB,        tipd_CEB);
    VitalWireDelay (CEC_ipd,        CEC,        tipd_CEC);
    VitalWireDelay (CECARRYIN_ipd,  CECARRYIN,  tipd_CECARRYIN);
    VitalWireDelay (CED_ipd,        CED,        tipd_CED);
    VitalWireDelay (CEM_ipd,        CEM,        tipd_CEM);
    VitalWireDelay (CEOPMODE_ipd,   CEOPMODE,   tipd_CEOPMODE);
    VitalWireDelay (CEP_ipd,        CEP,        tipd_CEP);

    VitalWireDelay (CLK_ipd,        CLK,        tipd_CLK);

    D_Delay : for i in MSB_D downto 0 generate
        VitalWireDelay (D_ipd(i),    D(i),        tipd_D(i));
    end generate D_Delay;    

    OPMODE_delay : for i in MSB_OPMODE downto 0 generate
        VitalWireDelay (OPMODE_ipd(i),     OPMODE(i),    tipd_OPMODE(i));    
    end generate OPMODE_delay;

    Pin_Delay : for i in MSB_PCIN downto 0 generate
        VitalWireDelay (PCIN_ipd(i),     PCIN(i),    tipd_PCIN(i));
    end generate Pin_Delay;    

    VitalWireDelay (RSTA_ipd,        RSTA,        tipd_RSTA);
    VitalWireDelay (RSTB_ipd,        RSTB,        tipd_RSTB);
    VitalWireDelay (RSTC_ipd,        RSTC,        tipd_RSTC);
    VitalWireDelay (RSTCARRYIN_ipd,  RSTCARRYIN,  tipd_RSTCARRYIN);
    VitalWireDelay (RSTD_ipd,        RSTD,        tipd_RSTD);
    VitalWireDelay (RSTM_ipd,        RSTM,        tipd_RSTM);
    VitalWireDelay (RSTOPMODE_ipd,   RSTOPMODE,   tipd_RSTOPMODE);
    VitalWireDelay (RSTP_ipd,        RSTP,        tipd_RSTP);

  end block;


  SignalDelay : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalSignalDelay (A_dly(i),     A_ipd(i),    tisd_A_CLK(i));
    end generate A_Delay;

    B_Delay : for i in MSB_B downto 0 generate
        VitalSignalDelay (B_dly(i),     B_ipd(i),    tisd_B_CLK(i));
    end generate B_Delay;

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalSignalDelay (BCIN_dly(i),     BCIN_ipd(i),    tisd_BCIN_CLK(i));
    end generate BCIN_Delay;

    C_Delay : for i in MSB_C downto 0 generate
        VitalSignalDelay (C_dly(i),     C_ipd(i),    tisd_C_CLK(i));
    end generate C_Delay;

    VitalSignalDelay (CARRYIN_dly,    CARRYIN_ipd,    tisd_CARRYIN_CLK);

    VitalSignalDelay (CEA_dly,        CEA_ipd,        tisd_CEA_CLK);
    VitalSignalDelay (CEB_dly,        CEB_ipd,        tisd_CEB_CLK);
    VitalSignalDelay (CEC_dly,        CEC_ipd,        tisd_CEC_CLK);
    VitalSignalDelay (CECARRYIN_dly,  CECARRYIN_ipd,  tisd_CECARRYIN_CLK);
    VitalSignalDelay (CED_dly,        CED_ipd,        tisd_CED_CLK);
    VitalSignalDelay (CEM_dly,        CEM_ipd,        tisd_CEM_CLK);
    VitalSignalDelay (CEOPMODE_dly,   CEOPMODE_ipd,   tisd_CEOPMODE_CLK);
    VitalSignalDelay (CEP_dly,        CEP_ipd,        tisd_CEP_CLK);

    VitalSignalDelay (CLK_dly,        CLK_ipd,        ticd_CLK);

    D_Delay : for i in MSB_D downto 0 generate
        VitalSignalDelay (D_dly(i),     D_ipd(i),    tisd_D_CLK(i));
    end generate D_Delay;


    OPMODE_Delay : for i in MSB_OPMODE downto 0 generate
        VitalSignalDelay (OPMODE_dly(i),     OPMODE_ipd(i),    tisd_OPMODE_CLK(i));
    end generate OPMODE_Delay;

    PCIN_Delay : for i in MSB_PCIN downto 0 generate
        VitalSignalDelay (PCIN_dly(i),     PCIN_ipd(i),    tisd_PCIN_CLK(i));
    end generate PCIN_Delay;

    VitalSignalDelay (RSTA_dly,       RSTA_ipd,       tisd_RSTA_CLK);
    VitalSignalDelay (RSTB_dly,       RSTB_ipd,       tisd_RSTB_CLK);
    VitalSignalDelay (RSTC_dly,       RSTC_ipd,       tisd_RSTC_CLK);
    VitalSignalDelay (RSTCARRYIN_dly,   RSTCARRYIN_ipd,   tisd_RSTCARRYIN_CLK);
    VitalSignalDelay (RSTD_dly,       RSTD_ipd,       tisd_RSTD_CLK);
    VitalSignalDelay (RSTM_dly,       RSTM_ipd,       tisd_RSTM_CLK);
    VitalSignalDelay (RSTOPMODE_dly,  RSTOPMODE,      tisd_RSTOPMODE_CLK);
    VitalSignalDelay (RSTP_dly,       RSTP_ipd,       tisd_RSTP_CLK);


  end block;

  --------------------
  --  BEHAVIOR SECTION
  --------------------


--####################################################################
--#####                        Initialization                      ###
--####################################################################
  prcs_init:process
  begin

-------- A0REG/A1REG  & B0REG/B1REG ------

     if((A0REG /= 0) and (A0REG /= 1 )) then
        assert false
        report "Attribute Syntax Error: Legal values for attribute A0REG on instance X_DSP48A are 0 or 1."
        severity Failure;
     end if;

     if((A1REG /= 0) and (A1REG /= 1 )) then
        assert false
        report "Attribute Syntax Error: Legal values for attribute A1REG on instance X_DSP48A are 0 or 1."
        severity Failure;
     end if;

     if((B0REG /= 0) and (B0REG /= 1 )) then
        assert false
        report "Attribute Syntax Error: Legal values for attribute B0REG on instance X_DSP48A are 0 or 1."
        severity Failure;
     end if;

     if((B1REG /= 0) and (B1REG /= 1 )) then
        assert false
        report "Attribute Syntax Error: Legal values for attribute B1REG on instance X_DSP48A are 0 or 1."
        severity Failure;
     end if;

-------- RSTTYPE ----------

     if((RSTTYPE = "SYNC") or (RSTTYPE = "sync")) then
        rst_async_flag  <= '0';
     elsif((RSTTYPE = "ASYNC") or (RSTTYPE = "async")) then
        rst_async_flag  <= '1';
     else
        assert false
        report "Attribute Syntax Error: The attribute RSTTYPE on X_DSP48A is incorrect. Legal values for this attribute are SYNC or ASYNC."
        severity Failure;
     end if;

-------- CARRYINSEL ---------

     if((CARRYINSEL = "CARRYIN") or (CARRYINSEL = "carryin")) then
        carryinsel_attr  <= '0';
     elsif((CARRYINSEL = "OPMODE5") or (CARRYINSEL = "opmode5")) then
        carryinsel_attr  <= '1';
     else
        assert false
        report "Attribute Syntax Error: The attribute RSTTYPE on X_DSP48A is incorrect. Legal values for this attribute are SYNC or ASYNC."
        severity Failure;
     end if;

     wait;

  end process prcs_init;
--####################################################################
--#####      Input Register A with two levels of registers         ###
--####################################################################

  prcs_qa_2lvl:process(CLK_dly, GSR_dly, RSTA_dly)
  begin
      if(GSR_dly = '1') then
          qa_o_reg1 <= ( others => '0');
          qa_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTA_dly = '1') then
                  qa_o_reg1 <= ( others => '0');
                  qa_o_reg2 <= ( others => '0');
               elsif ((RSTA_dly = '0') and (CEA_dly = '1')) then
                  if(rising_edge(CLK_dly)) then
                     qa_o_reg2 <= qa_o_reg1;
                     qa_o_reg1 <= A_dly;
                  end if;
               end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTA_dly = '1') then
                     qa_o_reg1 <= ( others => '0');
                     qa_o_reg2 <= ( others => '0');
                  elsif ((RSTA_dly = '0') and (CEA_dly = '1')) then
                      qa_o_reg2 <= qa_o_reg1;
                      qa_o_reg1 <= A_dly;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_qa_2lvl;
------------------------------------------------------------------
  prcs_qa_o_mux:process(A_dly, qa_o_reg1, qa_o_reg2)
  begin
     if((A0REG=0) and (A1REG=0)) then
        qa_o_mux <= A_dly;
     elsif(((A0REG=1) and (A1REG=0)) or ((A0REG=0) and (A1REG=1))) then
        qa_o_mux <= qa_o_reg1;
     elsif((A0REG=1) and (A1REG=1)) then
        qa_o_mux <= qa_o_reg2;
     end if; 
  end process prcs_qa_o_mux;

--####################################################################
--#####    Input Register B with two levels of registers and a mux ###
--####################################################################

---- BCIN /B_INPUT is for simprim only

 prcs_b_bcin:process(B_dly, BCIN_dly)
  begin
     if(B_INPUT ="DIRECT") then
        b_o_mux <= B_dly;
     elsif(B_INPUT ="CASCADE") then
        b_o_mux <= BCIN_dly;
     else
        assert false
        report "Attribute Syntax Error: The allowed values for B_INPUT on X_DSP48A instance are DIRECT or CASCADE."
        severity Failure;
     end if;

  end process prcs_b_bcin;

------------------------------------------------------------------

 prcs_qb_2lvl:process(CLK_dly, GSR_dly, RSTB_dly)
  begin
      if(GSR_dly = '1') then
          qb_o_reg1 <= ( others => '0');
          qb_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTB_dly = '1') then
                  qb_o_reg1 <= ( others => '0');
                  qb_o_reg2 <= ( others => '0');
               elsif ((RSTB_dly = '0') and (CEB_dly = '1')) then
                   if(rising_edge(CLK_dly)) then
                      qb_o_reg2 <= mux_preadd;
                      qb_o_reg1 <= b_o_mux;
                   end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTB_dly = '1') then
                     qb_o_reg1 <= ( others => '0');
                     qb_o_reg2 <= ( others => '0');
                  elsif ((RSTB_dly = '0') and (CEB_dly = '1')) then
                      qb_o_reg2 <= mux_preadd;
                      qb_o_reg1 <= b_o_mux;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_qb_2lvl;

------- PRE ADD --------------------------------------------------

  prcs_qb_preadd:process(opmode_o_mux, b_o_mux, qd_o_mux, qb_o_reg1)
  begin
     if(((B0REG=0) and (B1REG=0)) or ((B0REG=0) and (B1REG=1))) then
        qb_o_mux0 <= b_o_mux;
        if(opmode_o_mux(6)='0') then
            preadd <= (qd_o_mux + b_o_mux);
         elsif(opmode_o_mux(6)='1') then
            preadd <= (qd_o_mux - b_o_mux);
         end if;
     elsif(((B0REG=1) and (B1REG=1)) or ((B0REG=1) and (B1REG=0))) then
        qb_o_mux0 <= qb_o_reg1;
        if(opmode_o_mux(6)='0') then
            preadd <= (qd_o_mux + qb_o_reg1);
         elsif(opmode_o_mux(6)='1') then
            preadd <= (qd_o_mux - qb_o_reg1);
         end if;
     end if; 
  end process prcs_qb_preadd;

------------------------------------------------------------------

  prcs_preadd_sel:process(opmode_o_mux(4), preadd, qb_o_mux0)
  begin
     if(opmode_o_mux(4)='1') then
        mux_preadd <= preadd;
     elsif(opmode_o_mux(4)='0') then
        mux_preadd <= qb_o_mux0;
     end if;
  end process prcs_preadd_sel;
------------------------------------------------------------------
-- CR 421339
  prcs_qb_o_mux:process(mux_preadd, qb_o_reg2)
  begin
     if(((B0REG=0) and (B1REG=0)) or ((B0REG=1) and (B1REG=0))) then
        qb_o_mux <= mux_preadd;
     elsif(((B0REG=1) and (B1REG=1)) or ((B0REG=0) and (B1REG=1))) then
        qb_o_mux <= qb_o_reg2;
     end if; 
  end process prcs_qb_o_mux;

--####################################################################
--#####    Input Register C with 0, 1, level of registers        #####
--####################################################################

  prcs_qc_1lvl:process(CLK_dly, GSR_dly, RSTC_dly)

  begin
      if(GSR_dly = '1') then
         qc_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTC_dly = '1') then
                  qc_o_reg <= ( others => '0');
               elsif((RSTC_dly = '0') and (CEC_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     qc_o_reg <= C_dly;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTC_dly = '1') then
                     qc_o_reg <= ( others => '0');
                  elsif ((RSTC_dly = '0') and (CEC_dly = '1')) then
                      qc_o_reg <= C_dly;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_qc_1lvl;
------------------------------------------------------------------
  prcs_qc_o_mux:process(C_dly, qc_o_reg)
  begin
     case CREG is
      when 0 => qc_o_mux <= C_dly;
      when 1 => qc_o_mux <= qc_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for CREG on instace X_DSP48A are 0 or 1"
           severity Failure;
      end case;
  end process prcs_qc_o_mux;

--####################################################################
--#####    Input Register D with 0, 1, level of registers        #####
--####################################################################

  prcs_qd_1lvl:process(CLK_dly, GSR_dly, RSTD_dly)

  begin
      if(GSR_dly = '1') then
         qd_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTD_dly = '1') then
                  qd_o_reg <= ( others => '0');
               elsif((RSTD_dly = '0') and (CED_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     qd_o_reg <= D_dly;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTD_dly = '1') then
                     qd_o_reg <= ( others => '0');
                  elsif ((RSTD_dly = '0') and (CED_dly = '1')) then
                      qd_o_reg <= D_dly;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_qd_1lvl;
------------------------------------------------------------------
  prcs_qd_o_mux:process(D_dly, qd_o_reg)
  begin
     case DREG is
      when 0 => qd_o_mux <= D_dly;
      when 1 => qd_o_mux <= qd_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for DREG on instace X_DSP48A are 0 or 1"
           severity Failure;
      end case;
  end process prcs_qd_o_mux;

--####################################################################
--#####                     Multiplier                           #####
--####################################################################
  prcs_mult:process(qa_o_mux, qb_o_mux)
  begin
     mult_o_int <=  qa_o_mux * qb_o_mux;
  end process prcs_mult;
------------------------------------------------------------------
  prcs_mult_reg:process(CLK_dly, GSR_dly, RSTM_dly)
  begin
      if(GSR_dly = '1') then
         mult_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTM_dly = '1') then
                  mult_o_reg <= ( others => '0');
               elsif((RSTM_dly = '0') and (CEM_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     mult_o_reg <= mult_o_int;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTM_dly = '1') then
                     mult_o_reg <= ( others => '0');
                  elsif ((RSTM_dly = '0') and (CEM_dly = '1')) then
                      mult_o_reg <= mult_o_int;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_mult_reg;
------------------------------------------------------------------
  prcs_mult_mux:process(mult_o_reg, mult_o_int)
  begin
     case MREG is
      when 0 => mult_o_mux <= mult_o_int;
      when 1 => mult_o_mux <= mult_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for MREG on instance X_DSP48A are 0 or 1"
           severity Failure;
      end case;
  end process prcs_mult_mux;

--####################################################################
--#####     OpMode Register with 0, 1, level of registers        #####
--####################################################################

  prcs_opmode_reg:process(CLK_dly, GSR_dly, RSTOPMODE_dly)
  begin
      if(GSR_dly = '1') then
         opmode_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTOPMODE_dly = '1') then
                  opmode_o_reg <= ( others => '0');
               elsif((RSTOPMODE_dly = '0') and (CEOPMODE_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     opmode_o_reg <= OPMODE_dly;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTOPMODE_dly = '1') then
                     opmode_o_reg <= ( others => '0');
                  elsif ((RSTOPMODE_dly = '0') and (CEOPMODE_dly = '1')) then
                      opmode_o_reg <= OPMODE_dly;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_opmode_reg;
------------------------------------------------------------------
  prcs_opmode_mux:process(opmode_o_reg, OPMODE_dly)
  begin
     case OPMODEREG is
      when 0 => opmode_o_mux <= OPMODE_dly;
      when 1 => opmode_o_mux <= opmode_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for OPMODEREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_opmode_mux;
--####################################################################
--#####                        MUX_XYZ                           #####
--####################################################################
  prcs_mux_xz:process(opmode_o_mux, qp_o_mux, qa_o_mux, qb_o_mux, mult_o_mux, 
                       qc_o_mux, qd_o_mux, PCIN_dly, output_x_sig)
  begin
    if(output_x_sig = '1') then
      muxx_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxy_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxz_o_mux(MSB_P downto 0) <= ( others => 'X');
    elsif(output_x_sig = '0') then
    --MUX_X -----
       case opmode_o_mux(1 downto 0) is
         when "00" => muxx_o_mux <= ( others => '0');
         when "01" => muxx_o_mux((MAX_A + MAX_B - 1) downto 0) <= mult_o_mux;
                   if(mult_o_mux(MAX_A + MAX_B - 1) = '1') then
                     muxx_o_mux(MSB_P downto (MAX_A + MAX_B)) <=  ( others => '1');
                   elsif (mult_o_mux(MSB_A + MSB_B + 1) = '0') then 
                     muxx_o_mux(MSB_P downto (MAX_A + MAX_B)) <=  ( others => '0');
                   end if;

         when "10" => muxx_o_mux <= qp_o_mux;
         when "11" => muxx_o_mux(MSB_P downto 0) <=  (qd_o_mux((MSB_P - (MAX_A + MAX_B)) downto 0) & qa_o_mux & qb_o_mux);
      when others => null;
       end case;

    --MUX_Z -----
       case opmode_o_mux(3 downto 2) is
         when "00" => muxz_o_mux <= ( others => '0');
         when "01" => muxz_o_mux <= PCIN_dly;
         when "10" => muxz_o_mux <= qp_o_mux;
         when "11" => muxz_o_mux <= qc_o_mux;
         when others => null;
       end case;
    end if;
  end process prcs_mux_xz;

--####################################################################
--#####        CarryIn   1 level of register                     #####
--####################################################################

  prcs_carryinsel_mux:process(opmode_o_mux(5), CARRYIN_dly)
  begin
     if((CARRYINSEL = "CARRYIN") or (CARRYINSEL = "carryin")) then
        carryinsel_o_mux <= CARRYIN_dly;
     elsif((CARRYINSEL = "OPMODE5") or (CARRYINSEL = "opmode5")) then
        carryinsel_o_mux <= opmode_o_mux(5);
     else
        assert false
            report "Attribute Syntax Error: The allowed values for CARRYINSEL on instance X_DSP48A are CARRYIN or OPMODES."
            severity Failure;
     end if;
  end process prcs_carryinsel_mux;
------------------------------------------
  prcs_carryin_reg:process(CLK_dly, GSR_dly, RSTCARRYIN_dly)
  begin
      if(GSR_dly = '1') then
         qcarryin_o_reg1 <= '0';
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTCARRYIN_dly = '1') then
                  qcarryin_o_reg1 <= '0';
               elsif((RSTCARRYIN_dly = '0') and (CECARRYIN_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     qcarryin_o_reg1 <= carryinsel_o_mux;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTCARRYIN_dly = '1') then
                     qcarryin_o_reg1 <= '0';
                  elsif ((RSTCARRYIN_dly = '0') and (CECARRYIN_dly = '1')) then
                      qcarryin_o_reg1 <= carryinsel_o_mux;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_carryin_reg;
------------------------------------------------------------------
  prcs_carryin_mux:process(qcarryin_o_reg1, carryinsel_o_mux)
  begin
     case CARRYINREG is
       when 0 => carryin_o_mux <= carryinsel_o_mux;
       when 1 => carryin_o_mux <= qcarryin_o_reg1;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for CARRYINREG on instance X_DSP48A are 0 or 1"
            severity Failure;
     end case;
  end process prcs_carryin_mux;
------------------------------------------------------------------
--####################################################################
--#####         Output register P with 1 level of register       #####
--####################################################################

  prcs_qp_reg:process(CLK_dly, GSR_dly, RSTP_dly)
  begin
      if(GSR_dly = '1') then
         qp_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         case rst_async_flag is
            when '1' => 
            -----------// async reset
               if(RSTP_dly = '1') then
                  qp_o_reg <= ( others => '0');
               elsif((RSTP_dly = '0') and (CEP_dly = '1'))then
                  if(rising_edge(CLK_dly)) then
                     qp_o_reg <= accum_o;
                  end if;
                end if;
            when '0' => 
            -----------// sync reset
               if(rising_edge(CLK_dly)) then
                  if(RSTP_dly = '1') then
                     qp_o_reg <= ( others => '0');
                  elsif ((RSTP_dly = '0') and (CEP_dly = '1')) then
                      qp_o_reg <= accum_o;
                  end if;
               end if;
            when others => null;
         end case;
      end if;
  end process prcs_qp_reg;
------------------------------------------------------------------
  prcs_qp_mux:process(accum_o, qp_o_reg)
  begin
     case PREG is
       when 0 => qp_o_mux <= accum_o;
       when 1 => qp_o_mux <= qp_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for PREG on instace X_MDPS1 are 0 or 1"
           severity Failure;
     end case;
   
  end process prcs_qp_mux;
--####################################################################
--#####                   ZERO_DELAY_OUTPUTS                     #####
--####################################################################
  prcs_zero_delay_outputs:process(qb_o_mux, qp_o_mux)
  begin
    BCOUT_zd <= qb_o_mux;
    P_zd     <= qp_o_mux;
    PCOUT_zd <= qp_o_mux;
  end process prcs_zero_delay_outputs;

--####################################################################
--#####                OPMODE DRC                                #####
--####################################################################

  prcs_opmode_drc:process(opmode_o_mux, carryinsel_attr,
                       muxx_o_mux, muxz_o_mux, carryin_o_mux)
  variable Message : line;
  variable invalid_opmode_flg : boolean := true;
  variable opmode_valid_var : boolean := true;
  variable opmode_carryinsel_var : std_logic_vector(8 downto 0) := (others => '0');
  variable accum_o_tmp : std_logic_vector(MAX_ACCUM downto 0) := (others => '0');
  begin
      opmode_carryinsel_var := opmode_o_mux & carryinsel_attr;
      case opmode_carryinsel_var is
               when "000000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111000100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111000101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111100100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111100101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111000011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111100011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111101100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111101101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111001011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111101011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110111" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111010011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110010" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111110011" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111000" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111001" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "001111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "010111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "011111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "100111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "101111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "110111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111011100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111011101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "111111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             opmode_valid_var := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), CARRYINSEL);
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             opmode_valid_var := true;
                             output_x_sig <= '0';
                          end if;
               when "000011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111011011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111010" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111011" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "000111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "001111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "010111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "011111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "100111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "101111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "110111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111110" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
               when "111111111" => 
                          invalid_opmode_flg := true ;
                          opmode_valid_var := true ;
                          output_x_sig <= '0';
                when others    =>
                          if(invalid_opmode_flg = true) then
                             invalid_opmode_flg := false;
                             opmode_valid_var := false;
                             output_x_sig <= '1';
                             accum_o <= (others => 'X');
                             Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
                             Write ( Message,  slv_to_str(opmode_o_mux));
                             Write ( Message, string'(" with CARRYINSEL  "));
                             Write ( Message,  CARRYINSEL);
                             Write ( Message, string'(" to DSP48A instance"));
                             Write ( Message, string'(" is invalid for that specific OPMODE."));
                             assert false report Message.all severity Warning;
                             DEALLOCATE (Message);
                           end if;
      end case;

      opmode_valid_flg <= opmode_valid_var;

      if(opmode_valid_var) then 
         if(opmode_o_mux(7) = '0') then
            accum_o_tmp :=  ('0'& muxz_o_mux) + ('0'& muxx_o_mux) + carryin_o_mux;
         elsif(opmode_o_mux(7) = '1') then
            accum_o_tmp :=  ('0'& muxz_o_mux) - ('0'& muxx_o_mux) - carryin_o_mux;
         end if;

         accum_o <= accum_o_tmp(MSB_ACCUM downto 0);
         CARRYOUT_zd <= accum_o_tmp(MAX_ACCUM);
      end if;
  end process prcs_opmode_drc;

--####################################################################
--#####                   TIMING CHECKS                          #####
--####################################################################
  prcs_tmngchk:process

  variable Tmkr_A_CLK_posedge  : VitalTimingDataArrayType(17 downto 0);
  variable Tviol_A_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');
  variable Tmkr_B_CLK_posedge  : VitalTimingDataArrayType(17 downto 0);
  variable Tviol_B_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');
  variable Tmkr_BCIN_CLK_posedge  : VitalTimingDataArrayType(17 downto 0);
  variable Tviol_BCIN_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');
  variable Tmkr_CARRYIN_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CARRYIN_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CEA_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CEA_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CEB_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CEB_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CEC_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CEC_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CECARRYIN_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CECARRYIN_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CED_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CED_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CEM_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CEM_CLK_posedge : std_ulogic := '0';
  variable Tmkr_CEP_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_CEP_CLK_posedge : std_ulogic := '0';
  variable Tmkr_OPMODE_CLK_posedge  : VitalTimingDataArrayType(7 downto 0);
  variable Tviol_OPMODE_CLK_posedge : std_logic_vector(7 downto 0 ) := (others => '0');
  variable Tmkr_PCIN_CLK_posedge  : VitalTimingDataArrayType(47 downto 0);
  variable Tviol_PCIN_CLK_posedge : std_logic_vector(47 downto 0 ) := (others => '0');
  variable Tmkr_RSTA_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTA_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTB_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTB_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTC_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTC_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTCARRYIN_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTCARRYIN_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTD_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTD_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTM_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTM_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTOPMODE_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTOPMODE_CLK_posedge : std_ulogic := '0';
  variable Tmkr_RSTP_CLK_posedge : VitalTimingDataType := VitalTimingDataInit;
  variable Tviol_RSTP_CLK_posedge : std_ulogic := '0';

  variable BCOUT_GlitchData :  VitalGlitchDataArrayType (17 downto 0 );
  variable CARRYOUT_GlitchData :  VitalGlitchDataType;
  variable P_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );
  variable PCOUT_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );

  begin
--  Setup/Hold Check Violations (all input pins)

     if (TimingChecksOn) then
--=====  Vital SetupHold Checks for Bus signal A =====
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(0),
         TimingData           => Tmkr_A_CLK_posedge(0),
         TestSignal           => A_dly(0),
         TestSignalName       => "A(0)",
         TestDelay            => tisd_A_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(0),
         SetupLow             => tsetup_A_CLK_negedge_posedge(0),
         HoldHigh             => thold_A_CLK_posedge_posedge(0),
         HoldLow              => thold_A_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(1),
         TimingData           => Tmkr_A_CLK_posedge(1),
         TestSignal           => A_dly(1),
         TestSignalName       => "A(1)",
         TestDelay            => tisd_A_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(1),
         SetupLow             => tsetup_A_CLK_negedge_posedge(1),
         HoldHigh             => thold_A_CLK_posedge_posedge(1),
         HoldLow              => thold_A_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(2),
         TimingData           => Tmkr_A_CLK_posedge(2),
         TestSignal           => A_dly(2),
         TestSignalName       => "A(2)",
         TestDelay            => tisd_A_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(2),
         SetupLow             => tsetup_A_CLK_negedge_posedge(2),
         HoldHigh             => thold_A_CLK_posedge_posedge(2),
         HoldLow              => thold_A_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(3),
         TimingData           => Tmkr_A_CLK_posedge(3),
         TestSignal           => A_dly(3),
         TestSignalName       => "A(3)",
         TestDelay            => tisd_A_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(3),
         SetupLow             => tsetup_A_CLK_negedge_posedge(3),
         HoldHigh             => thold_A_CLK_posedge_posedge(3),
         HoldLow              => thold_A_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(4),
         TimingData           => Tmkr_A_CLK_posedge(4),
         TestSignal           => A_dly(4),
         TestSignalName       => "A(4)",
         TestDelay            => tisd_A_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(4),
         SetupLow             => tsetup_A_CLK_negedge_posedge(4),
         HoldHigh             => thold_A_CLK_posedge_posedge(4),
         HoldLow              => thold_A_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(5),
         TimingData           => Tmkr_A_CLK_posedge(5),
         TestSignal           => A_dly(5),
         TestSignalName       => "A(5)",
         TestDelay            => tisd_A_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(5),
         SetupLow             => tsetup_A_CLK_negedge_posedge(5),
         HoldHigh             => thold_A_CLK_posedge_posedge(5),
         HoldLow              => thold_A_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(6),
         TimingData           => Tmkr_A_CLK_posedge(6),
         TestSignal           => A_dly(6),
         TestSignalName       => "A(6)",
         TestDelay            => tisd_A_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(6),
         SetupLow             => tsetup_A_CLK_negedge_posedge(6),
         HoldHigh             => thold_A_CLK_posedge_posedge(6),
         HoldLow              => thold_A_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(7),
         TimingData           => Tmkr_A_CLK_posedge(7),
         TestSignal           => A_dly(7),
         TestSignalName       => "A(7)",
         TestDelay            => tisd_A_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(7),
         SetupLow             => tsetup_A_CLK_negedge_posedge(7),
         HoldHigh             => thold_A_CLK_posedge_posedge(7),
         HoldLow              => thold_A_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(8),
         TimingData           => Tmkr_A_CLK_posedge(8),
         TestSignal           => A_dly(8),
         TestSignalName       => "A(8)",
         TestDelay            => tisd_A_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(8),
         SetupLow             => tsetup_A_CLK_negedge_posedge(8),
         HoldHigh             => thold_A_CLK_posedge_posedge(8),
         HoldLow              => thold_A_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(9),
         TimingData           => Tmkr_A_CLK_posedge(9),
         TestSignal           => A_dly(9),
         TestSignalName       => "A(9)",
         TestDelay            => tisd_A_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(9),
         SetupLow             => tsetup_A_CLK_negedge_posedge(9),
         HoldHigh             => thold_A_CLK_posedge_posedge(9),
         HoldLow              => thold_A_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(10),
         TimingData           => Tmkr_A_CLK_posedge(10),
         TestSignal           => A_dly(10),
         TestSignalName       => "A(10)",
         TestDelay            => tisd_A_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(10),
         SetupLow             => tsetup_A_CLK_negedge_posedge(10),
         HoldHigh             => thold_A_CLK_posedge_posedge(10),
         HoldLow              => thold_A_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(11),
         TimingData           => Tmkr_A_CLK_posedge(11),
         TestSignal           => A_dly(11),
         TestSignalName       => "A(11)",
         TestDelay            => tisd_A_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(11),
         SetupLow             => tsetup_A_CLK_negedge_posedge(11),
         HoldHigh             => thold_A_CLK_posedge_posedge(11),
         HoldLow              => thold_A_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(12),
         TimingData           => Tmkr_A_CLK_posedge(12),
         TestSignal           => A_dly(12),
         TestSignalName       => "A(12)",
         TestDelay            => tisd_A_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(12),
         SetupLow             => tsetup_A_CLK_negedge_posedge(12),
         HoldHigh             => thold_A_CLK_posedge_posedge(12),
         HoldLow              => thold_A_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(13),
         TimingData           => Tmkr_A_CLK_posedge(13),
         TestSignal           => A_dly(13),
         TestSignalName       => "A(13)",
         TestDelay            => tisd_A_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(13),
         SetupLow             => tsetup_A_CLK_negedge_posedge(13),
         HoldHigh             => thold_A_CLK_posedge_posedge(13),
         HoldLow              => thold_A_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(14),
         TimingData           => Tmkr_A_CLK_posedge(14),
         TestSignal           => A_dly(14),
         TestSignalName       => "A(14)",
         TestDelay            => tisd_A_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(14),
         SetupLow             => tsetup_A_CLK_negedge_posedge(14),
         HoldHigh             => thold_A_CLK_posedge_posedge(14),
         HoldLow              => thold_A_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(15),
         TimingData           => Tmkr_A_CLK_posedge(15),
         TestSignal           => A_dly(15),
         TestSignalName       => "A(15)",
         TestDelay            => tisd_A_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(15),
         SetupLow             => tsetup_A_CLK_negedge_posedge(15),
         HoldHigh             => thold_A_CLK_posedge_posedge(15),
         HoldLow              => thold_A_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(16),
         TimingData           => Tmkr_A_CLK_posedge(16),
         TestSignal           => A_dly(16),
         TestSignalName       => "A(16)",
         TestDelay            => tisd_A_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(16),
         SetupLow             => tsetup_A_CLK_negedge_posedge(16),
         HoldHigh             => thold_A_CLK_posedge_posedge(16),
         HoldLow              => thold_A_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(17),
         TimingData           => Tmkr_A_CLK_posedge(17),
         TestSignal           => A_dly(17),
         TestSignalName       => "A(17)",
         TestDelay            => tisd_A_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(17),
         SetupLow             => tsetup_A_CLK_negedge_posedge(17),
         HoldHigh             => thold_A_CLK_posedge_posedge(17),
         HoldLow              => thold_A_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTA_dly) and (CEA_dly)) /= '0') and ((A0REG = 1) or (A1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal B =====
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(0),
         TimingData           => Tmkr_B_CLK_posedge(0),
         TestSignal           => B_dly(0),
         TestSignalName       => "B(0)",
         TestDelay            => tisd_B_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(0),
         SetupLow             => tsetup_B_CLK_negedge_posedge(0),
         HoldHigh             => thold_B_CLK_posedge_posedge(0),
         HoldLow              => thold_B_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(1),
         TimingData           => Tmkr_B_CLK_posedge(1),
         TestSignal           => B_dly(1),
         TestSignalName       => "B(1)",
         TestDelay            => tisd_B_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(1),
         SetupLow             => tsetup_B_CLK_negedge_posedge(1),
         HoldHigh             => thold_B_CLK_posedge_posedge(1),
         HoldLow              => thold_B_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(2),
         TimingData           => Tmkr_B_CLK_posedge(2),
         TestSignal           => B_dly(2),
         TestSignalName       => "B(2)",
         TestDelay            => tisd_B_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(2),
         SetupLow             => tsetup_B_CLK_negedge_posedge(2),
         HoldHigh             => thold_B_CLK_posedge_posedge(2),
         HoldLow              => thold_B_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(3),
         TimingData           => Tmkr_B_CLK_posedge(3),
         TestSignal           => B_dly(3),
         TestSignalName       => "B(3)",
         TestDelay            => tisd_B_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(3),
         SetupLow             => tsetup_B_CLK_negedge_posedge(3),
         HoldHigh             => thold_B_CLK_posedge_posedge(3),
         HoldLow              => thold_B_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(4),
         TimingData           => Tmkr_B_CLK_posedge(4),
         TestSignal           => B_dly(4),
         TestSignalName       => "B(4)",
         TestDelay            => tisd_B_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(4),
         SetupLow             => tsetup_B_CLK_negedge_posedge(4),
         HoldHigh             => thold_B_CLK_posedge_posedge(4),
         HoldLow              => thold_B_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(5),
         TimingData           => Tmkr_B_CLK_posedge(5),
         TestSignal           => B_dly(5),
         TestSignalName       => "B(5)",
         TestDelay            => tisd_B_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(5),
         SetupLow             => tsetup_B_CLK_negedge_posedge(5),
         HoldHigh             => thold_B_CLK_posedge_posedge(5),
         HoldLow              => thold_B_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(6),
         TimingData           => Tmkr_B_CLK_posedge(6),
         TestSignal           => B_dly(6),
         TestSignalName       => "B(6)",
         TestDelay            => tisd_B_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(6),
         SetupLow             => tsetup_B_CLK_negedge_posedge(6),
         HoldHigh             => thold_B_CLK_posedge_posedge(6),
         HoldLow              => thold_B_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(7),
         TimingData           => Tmkr_B_CLK_posedge(7),
         TestSignal           => B_dly(7),
         TestSignalName       => "B(7)",
         TestDelay            => tisd_B_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(7),
         SetupLow             => tsetup_B_CLK_negedge_posedge(7),
         HoldHigh             => thold_B_CLK_posedge_posedge(7),
         HoldLow              => thold_B_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(8),
         TimingData           => Tmkr_B_CLK_posedge(8),
         TestSignal           => B_dly(8),
         TestSignalName       => "B(8)",
         TestDelay            => tisd_B_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(8),
         SetupLow             => tsetup_B_CLK_negedge_posedge(8),
         HoldHigh             => thold_B_CLK_posedge_posedge(8),
         HoldLow              => thold_B_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(9),
         TimingData           => Tmkr_B_CLK_posedge(9),
         TestSignal           => B_dly(9),
         TestSignalName       => "B(9)",
         TestDelay            => tisd_B_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(9),
         SetupLow             => tsetup_B_CLK_negedge_posedge(9),
         HoldHigh             => thold_B_CLK_posedge_posedge(9),
         HoldLow              => thold_B_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(10),
         TimingData           => Tmkr_B_CLK_posedge(10),
         TestSignal           => B_dly(10),
         TestSignalName       => "B(10)",
         TestDelay            => tisd_B_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(10),
         SetupLow             => tsetup_B_CLK_negedge_posedge(10),
         HoldHigh             => thold_B_CLK_posedge_posedge(10),
         HoldLow              => thold_B_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(11),
         TimingData           => Tmkr_B_CLK_posedge(11),
         TestSignal           => B_dly(11),
         TestSignalName       => "B(11)",
         TestDelay            => tisd_B_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(11),
         SetupLow             => tsetup_B_CLK_negedge_posedge(11),
         HoldHigh             => thold_B_CLK_posedge_posedge(11),
         HoldLow              => thold_B_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(12),
         TimingData           => Tmkr_B_CLK_posedge(12),
         TestSignal           => B_dly(12),
         TestSignalName       => "B(12)",
         TestDelay            => tisd_B_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(12),
         SetupLow             => tsetup_B_CLK_negedge_posedge(12),
         HoldHigh             => thold_B_CLK_posedge_posedge(12),
         HoldLow              => thold_B_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(13),
         TimingData           => Tmkr_B_CLK_posedge(13),
         TestSignal           => B_dly(13),
         TestSignalName       => "B(13)",
         TestDelay            => tisd_B_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(13),
         SetupLow             => tsetup_B_CLK_negedge_posedge(13),
         HoldHigh             => thold_B_CLK_posedge_posedge(13),
         HoldLow              => thold_B_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(14),
         TimingData           => Tmkr_B_CLK_posedge(14),
         TestSignal           => B_dly(14),
         TestSignalName       => "B(14)",
         TestDelay            => tisd_B_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(14),
         SetupLow             => tsetup_B_CLK_negedge_posedge(14),
         HoldHigh             => thold_B_CLK_posedge_posedge(14),
         HoldLow              => thold_B_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(15),
         TimingData           => Tmkr_B_CLK_posedge(15),
         TestSignal           => B_dly(15),
         TestSignalName       => "B(15)",
         TestDelay            => tisd_B_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(15),
         SetupLow             => tsetup_B_CLK_negedge_posedge(15),
         HoldHigh             => thold_B_CLK_posedge_posedge(15),
         HoldLow              => thold_B_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(16),
         TimingData           => Tmkr_B_CLK_posedge(16),
         TestSignal           => B_dly(16),
         TestSignalName       => "B(16)",
         TestDelay            => tisd_B_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(16),
         SetupLow             => tsetup_B_CLK_negedge_posedge(16),
         HoldHigh             => thold_B_CLK_posedge_posedge(16),
         HoldLow              => thold_B_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(17),
         TimingData           => Tmkr_B_CLK_posedge(17),
         TestSignal           => B_dly(17),
         TestSignalName       => "B(17)",
         TestDelay            => tisd_B_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(17),
         SetupLow             => tsetup_B_CLK_negedge_posedge(17),
         HoldHigh             => thold_B_CLK_posedge_posedge(17),
         HoldLow              => thold_B_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal BCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(0),
         TimingData           => Tmkr_BCIN_CLK_posedge(0),
         TestSignal           => BCIN_dly(0),
         TestSignalName       => "BCIN(0)",
         TestDelay            => tisd_BCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(1),
         TimingData           => Tmkr_BCIN_CLK_posedge(1),
         TestSignal           => BCIN_dly(1),
         TestSignalName       => "BCIN(1)",
         TestDelay            => tisd_BCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(2),
         TimingData           => Tmkr_BCIN_CLK_posedge(2),
         TestSignal           => BCIN_dly(2),
         TestSignalName       => "BCIN(2)",
         TestDelay            => tisd_BCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(3),
         TimingData           => Tmkr_BCIN_CLK_posedge(3),
         TestSignal           => BCIN_dly(3),
         TestSignalName       => "BCIN(3)",
         TestDelay            => tisd_BCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(4),
         TimingData           => Tmkr_BCIN_CLK_posedge(4),
         TestSignal           => BCIN_dly(4),
         TestSignalName       => "BCIN(4)",
         TestDelay            => tisd_BCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(5),
         TimingData           => Tmkr_BCIN_CLK_posedge(5),
         TestSignal           => BCIN_dly(5),
         TestSignalName       => "BCIN(5)",
         TestDelay            => tisd_BCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(6),
         TimingData           => Tmkr_BCIN_CLK_posedge(6),
         TestSignal           => BCIN_dly(6),
         TestSignalName       => "BCIN(6)",
         TestDelay            => tisd_BCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(7),
         TimingData           => Tmkr_BCIN_CLK_posedge(7),
         TestSignal           => BCIN_dly(7),
         TestSignalName       => "BCIN(7)",
         TestDelay            => tisd_BCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(8),
         TimingData           => Tmkr_BCIN_CLK_posedge(8),
         TestSignal           => BCIN_dly(8),
         TestSignalName       => "BCIN(8)",
         TestDelay            => tisd_BCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(9),
         TimingData           => Tmkr_BCIN_CLK_posedge(9),
         TestSignal           => BCIN_dly(9),
         TestSignalName       => "BCIN(9)",
         TestDelay            => tisd_BCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(10),
         TimingData           => Tmkr_BCIN_CLK_posedge(10),
         TestSignal           => BCIN_dly(10),
         TestSignalName       => "BCIN(10)",
         TestDelay            => tisd_BCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(11),
         TimingData           => Tmkr_BCIN_CLK_posedge(11),
         TestSignal           => BCIN_dly(11),
         TestSignalName       => "BCIN(11)",
         TestDelay            => tisd_BCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(12),
         TimingData           => Tmkr_BCIN_CLK_posedge(12),
         TestSignal           => BCIN_dly(12),
         TestSignalName       => "BCIN(12)",
         TestDelay            => tisd_BCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(13),
         TimingData           => Tmkr_BCIN_CLK_posedge(13),
         TestSignal           => BCIN_dly(13),
         TestSignalName       => "BCIN(13)",
         TestDelay            => tisd_BCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(14),
         TimingData           => Tmkr_BCIN_CLK_posedge(14),
         TestSignal           => BCIN_dly(14),
         TestSignalName       => "BCIN(14)",
         TestDelay            => tisd_BCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(15),
         TimingData           => Tmkr_BCIN_CLK_posedge(15),
         TestSignal           => BCIN_dly(15),
         TestSignalName       => "BCIN(15)",
         TestDelay            => tisd_BCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(16),
         TimingData           => Tmkr_BCIN_CLK_posedge(16),
         TestSignal           => BCIN_dly(16),
         TestSignalName       => "BCIN(16)",
         TestDelay            => tisd_BCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(17),
         TimingData           => Tmkr_BCIN_CLK_posedge(17),
         TestSignal           => BCIN_dly(17),
         TestSignalName       => "BCIN(17)",
         TestDelay            => tisd_BCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTB_dly) and (CEB_dly)) /= '0') and ((B0REG = 1) or (B1REG = 1))and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYIN_CLK_posedge,
         TimingData           => Tmkr_CARRYIN_CLK_posedge,
         TestSignal           => CARRYIN_dly,
         TestSignalName       => "CARRYIN",
         TestDelay            => tisd_CARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01((not RSTCARRYIN_dly) and (CECARRYIN_dly)) /= '0') and (CARRYINSEL = "CARRYIN") and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEA =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEA_CLK_posedge,
         TimingData           => Tmkr_CEA_CLK_posedge,
         TestSignal           => CEA_dly,
         TestSignalName       => "CEA",
         TestDelay            => tisd_CEA_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEA_CLK_posedge_posedge,
         SetupLow             => tsetup_CEA_CLK_negedge_posedge,
         HoldHigh             => thold_CEA_CLK_posedge_posedge,
         HoldLow              => thold_CEA_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTA_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEB_CLK_posedge,
         TimingData           => Tmkr_CEB_CLK_posedge,
         TestSignal           => CEB_dly,
         TestSignalName       => "CEB",
         TestDelay            => tisd_CEB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEB_CLK_posedge_posedge,
         SetupLow             => tsetup_CEB_CLK_negedge_posedge,
         HoldHigh             => thold_CEB_CLK_posedge_posedge,
         HoldLow              => thold_CEB_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTB_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEC_CLK_posedge,
         TimingData           => Tmkr_CEC_CLK_posedge,
         TestSignal           => CEC_dly,
         TestSignalName       => "CEC",
         TestDelay            => tisd_CEC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEC_CLK_posedge_posedge,
         SetupLow             => tsetup_CEC_CLK_negedge_posedge,
         HoldHigh             => thold_CEC_CLK_posedge_posedge,
         HoldLow              => thold_CEC_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTC_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CECARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECARRYIN_CLK_posedge,
         TimingData           => Tmkr_CECARRYIN_CLK_posedge,
         TestSignal           => CECARRYIN_dly,
         TestSignalName       => "CECARRYIN",
         TestDelay            => tisd_CECARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CECARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CECARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CECARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(RSTCARRYIN_dly) /= '1') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CED =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CED_CLK_posedge,
         TimingData           => Tmkr_CED_CLK_posedge,
         TestSignal           => CED_dly,
         TestSignalName       => "CED",
         TestDelay            => tisd_CED_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CED_CLK_posedge_posedge,
         SetupLow             => tsetup_CED_CLK_negedge_posedge,
         HoldHigh             => thold_CED_CLK_posedge_posedge,
         HoldLow              => thold_CED_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTD_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEM_CLK_posedge,
         TimingData           => Tmkr_CEM_CLK_posedge,
         TestSignal           => CEM_dly,
         TestSignalName       => "CEM",
         TestDelay            => tisd_CEM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEM_CLK_posedge_posedge,
         SetupLow             => tsetup_CEM_CLK_negedge_posedge,
         HoldHigh             => thold_CEM_CLK_posedge_posedge,
         HoldLow              => thold_CEM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTM_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal CEP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEP_CLK_posedge,
         TimingData           => Tmkr_CEP_CLK_posedge,
         TestSignal           => CEP_dly,
         TestSignalName       => "CEP",
         TestDelay            => tisd_CEP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEP_CLK_posedge_posedge,
         SetupLow             => tsetup_CEP_CLK_negedge_posedge,
         HoldHigh             => thold_CEP_CLK_posedge_posedge,
         HoldLow              => thold_CEP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(not RSTP_dly) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal OPMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(0),
         TimingData           => Tmkr_OPMODE_CLK_posedge(0),
         TestSignal           => OPMODE_dly(0),
         TestSignalName       => "OPMODE(0)",
         TestDelay            => tisd_OPMODE_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(0),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(0),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(0),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(1),
         TimingData           => Tmkr_OPMODE_CLK_posedge(1),
         TestSignal           => OPMODE_dly(1),
         TestSignalName       => "OPMODE(1)",
         TestDelay            => tisd_OPMODE_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(1),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(1),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(1),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(2),
         TimingData           => Tmkr_OPMODE_CLK_posedge(2),
         TestSignal           => OPMODE_dly(2),
         TestSignalName       => "OPMODE(2)",
         TestDelay            => tisd_OPMODE_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(2),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(2),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(2),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(3),
         TimingData           => Tmkr_OPMODE_CLK_posedge(3),
         TestSignal           => OPMODE_dly(3),
         TestSignalName       => "OPMODE(3)",
         TestDelay            => tisd_OPMODE_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(3),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(3),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(3),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(4),
         TimingData           => Tmkr_OPMODE_CLK_posedge(4),
         TestSignal           => OPMODE_dly(4),
         TestSignalName       => "OPMODE(4)",
         TestDelay            => tisd_OPMODE_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(4),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(4),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(4),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(5),
         TimingData           => Tmkr_OPMODE_CLK_posedge(5),
         TestSignal           => OPMODE_dly(5),
         TestSignalName       => "OPMODE(5)",
         TestDelay            => tisd_OPMODE_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(5),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(5),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(5),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(6),
         TimingData           => Tmkr_OPMODE_CLK_posedge(6),
         TestSignal           => OPMODE_dly(6),
         TestSignalName       => "OPMODE(6)",
         TestDelay            => tisd_OPMODE_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(6),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(6),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(6),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(7),
         TimingData           => Tmkr_OPMODE_CLK_posedge(7),
         TestSignal           => OPMODE_dly(7),
         TestSignalName       => "OPMODE(7)",
         TestDelay            => tisd_OPMODE_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(7),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(7),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(7),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTOPMODE_dly) and (CEOPMODE_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks for Bus signal PCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(0),
         TimingData           => Tmkr_PCIN_CLK_posedge(0),
         TestSignal           => PCIN_dly(0),
         TestSignalName       => "PCIN(0)",
         TestDelay            => tisd_PCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(0),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(1),
         TimingData           => Tmkr_PCIN_CLK_posedge(1),
         TestSignal           => PCIN_dly(1),
         TestSignalName       => "PCIN(1)",
         TestDelay            => tisd_PCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(1),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(2),
         TimingData           => Tmkr_PCIN_CLK_posedge(2),
         TestSignal           => PCIN_dly(2),
         TestSignalName       => "PCIN(2)",
         TestDelay            => tisd_PCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(2),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(3),
         TimingData           => Tmkr_PCIN_CLK_posedge(3),
         TestSignal           => PCIN_dly(3),
         TestSignalName       => "PCIN(3)",
         TestDelay            => tisd_PCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(3),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(4),
         TimingData           => Tmkr_PCIN_CLK_posedge(4),
         TestSignal           => PCIN_dly(4),
         TestSignalName       => "PCIN(4)",
         TestDelay            => tisd_PCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(4),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(5),
         TimingData           => Tmkr_PCIN_CLK_posedge(5),
         TestSignal           => PCIN_dly(5),
         TestSignalName       => "PCIN(5)",
         TestDelay            => tisd_PCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(5),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(6),
         TimingData           => Tmkr_PCIN_CLK_posedge(6),
         TestSignal           => PCIN_dly(6),
         TestSignalName       => "PCIN(6)",
         TestDelay            => tisd_PCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(6),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(7),
         TimingData           => Tmkr_PCIN_CLK_posedge(7),
         TestSignal           => PCIN_dly(7),
         TestSignalName       => "PCIN(7)",
         TestDelay            => tisd_PCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(7),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(8),
         TimingData           => Tmkr_PCIN_CLK_posedge(8),
         TestSignal           => PCIN_dly(8),
         TestSignalName       => "PCIN(8)",
         TestDelay            => tisd_PCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(8),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(9),
         TimingData           => Tmkr_PCIN_CLK_posedge(9),
         TestSignal           => PCIN_dly(9),
         TestSignalName       => "PCIN(9)",
         TestDelay            => tisd_PCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(9),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(10),
         TimingData           => Tmkr_PCIN_CLK_posedge(10),
         TestSignal           => PCIN_dly(10),
         TestSignalName       => "PCIN(10)",
         TestDelay            => tisd_PCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(10),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(11),
         TimingData           => Tmkr_PCIN_CLK_posedge(11),
         TestSignal           => PCIN_dly(11),
         TestSignalName       => "PCIN(11)",
         TestDelay            => tisd_PCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(11),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(12),
         TimingData           => Tmkr_PCIN_CLK_posedge(12),
         TestSignal           => PCIN_dly(12),
         TestSignalName       => "PCIN(12)",
         TestDelay            => tisd_PCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(12),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(13),
         TimingData           => Tmkr_PCIN_CLK_posedge(13),
         TestSignal           => PCIN_dly(13),
         TestSignalName       => "PCIN(13)",
         TestDelay            => tisd_PCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(13),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(14),
         TimingData           => Tmkr_PCIN_CLK_posedge(14),
         TestSignal           => PCIN_dly(14),
         TestSignalName       => "PCIN(14)",
         TestDelay            => tisd_PCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(14),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(15),
         TimingData           => Tmkr_PCIN_CLK_posedge(15),
         TestSignal           => PCIN_dly(15),
         TestSignalName       => "PCIN(15)",
         TestDelay            => tisd_PCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(15),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(16),
         TimingData           => Tmkr_PCIN_CLK_posedge(16),
         TestSignal           => PCIN_dly(16),
         TestSignalName       => "PCIN(16)",
         TestDelay            => tisd_PCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(16),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(17),
         TimingData           => Tmkr_PCIN_CLK_posedge(17),
         TestSignal           => PCIN_dly(17),
         TestSignalName       => "PCIN(17)",
         TestDelay            => tisd_PCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(17),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(18),
         TimingData           => Tmkr_PCIN_CLK_posedge(18),
         TestSignal           => PCIN_dly(18),
         TestSignalName       => "PCIN(18)",
         TestDelay            => tisd_PCIN_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(18),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(18),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(18),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(18),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(19),
         TimingData           => Tmkr_PCIN_CLK_posedge(19),
         TestSignal           => PCIN_dly(19),
         TestSignalName       => "PCIN(19)",
         TestDelay            => tisd_PCIN_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(19),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(19),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(19),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(19),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(20),
         TimingData           => Tmkr_PCIN_CLK_posedge(20),
         TestSignal           => PCIN_dly(20),
         TestSignalName       => "PCIN(20)",
         TestDelay            => tisd_PCIN_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(20),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(20),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(20),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(20),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(21),
         TimingData           => Tmkr_PCIN_CLK_posedge(21),
         TestSignal           => PCIN_dly(21),
         TestSignalName       => "PCIN(21)",
         TestDelay            => tisd_PCIN_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(21),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(21),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(21),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(21),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(22),
         TimingData           => Tmkr_PCIN_CLK_posedge(22),
         TestSignal           => PCIN_dly(22),
         TestSignalName       => "PCIN(22)",
         TestDelay            => tisd_PCIN_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(22),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(22),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(22),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(22),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(23),
         TimingData           => Tmkr_PCIN_CLK_posedge(23),
         TestSignal           => PCIN_dly(23),
         TestSignalName       => "PCIN(23)",
         TestDelay            => tisd_PCIN_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(23),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(23),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(23),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(23),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(24),
         TimingData           => Tmkr_PCIN_CLK_posedge(24),
         TestSignal           => PCIN_dly(24),
         TestSignalName       => "PCIN(24)",
         TestDelay            => tisd_PCIN_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(24),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(24),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(24),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(24),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(25),
         TimingData           => Tmkr_PCIN_CLK_posedge(25),
         TestSignal           => PCIN_dly(25),
         TestSignalName       => "PCIN(25)",
         TestDelay            => tisd_PCIN_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(25),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(25),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(25),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(25),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(26),
         TimingData           => Tmkr_PCIN_CLK_posedge(26),
         TestSignal           => PCIN_dly(26),
         TestSignalName       => "PCIN(26)",
         TestDelay            => tisd_PCIN_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(26),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(26),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(26),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(26),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(27),
         TimingData           => Tmkr_PCIN_CLK_posedge(27),
         TestSignal           => PCIN_dly(27),
         TestSignalName       => "PCIN(27)",
         TestDelay            => tisd_PCIN_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(27),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(27),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(27),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(27),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(28),
         TimingData           => Tmkr_PCIN_CLK_posedge(28),
         TestSignal           => PCIN_dly(28),
         TestSignalName       => "PCIN(28)",
         TestDelay            => tisd_PCIN_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(28),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(28),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(28),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(28),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(29),
         TimingData           => Tmkr_PCIN_CLK_posedge(29),
         TestSignal           => PCIN_dly(29),
         TestSignalName       => "PCIN(29)",
         TestDelay            => tisd_PCIN_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(29),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(29),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(29),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(29),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(30),
         TimingData           => Tmkr_PCIN_CLK_posedge(30),
         TestSignal           => PCIN_dly(30),
         TestSignalName       => "PCIN(30)",
         TestDelay            => tisd_PCIN_CLK(30),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(30),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(30),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(30),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(30),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(31),
         TimingData           => Tmkr_PCIN_CLK_posedge(31),
         TestSignal           => PCIN_dly(31),
         TestSignalName       => "PCIN(31)",
         TestDelay            => tisd_PCIN_CLK(31),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(31),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(31),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(31),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(31),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(32),
         TimingData           => Tmkr_PCIN_CLK_posedge(32),
         TestSignal           => PCIN_dly(32),
         TestSignalName       => "PCIN(32)",
         TestDelay            => tisd_PCIN_CLK(32),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(32),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(32),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(32),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(32),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(33),
         TimingData           => Tmkr_PCIN_CLK_posedge(33),
         TestSignal           => PCIN_dly(33),
         TestSignalName       => "PCIN(33)",
         TestDelay            => tisd_PCIN_CLK(33),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(33),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(33),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(33),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(33),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(34),
         TimingData           => Tmkr_PCIN_CLK_posedge(34),
         TestSignal           => PCIN_dly(34),
         TestSignalName       => "PCIN(34)",
         TestDelay            => tisd_PCIN_CLK(34),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(34),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(34),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(34),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(34),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(35),
         TimingData           => Tmkr_PCIN_CLK_posedge(35),
         TestSignal           => PCIN_dly(35),
         TestSignalName       => "PCIN(35)",
         TestDelay            => tisd_PCIN_CLK(35),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(35),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(35),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(35),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(35),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(36),
         TimingData           => Tmkr_PCIN_CLK_posedge(36),
         TestSignal           => PCIN_dly(36),
         TestSignalName       => "PCIN(36)",
         TestDelay            => tisd_PCIN_CLK(36),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(36),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(36),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(36),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(36),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(37),
         TimingData           => Tmkr_PCIN_CLK_posedge(37),
         TestSignal           => PCIN_dly(37),
         TestSignalName       => "PCIN(37)",
         TestDelay            => tisd_PCIN_CLK(37),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(37),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(37),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(37),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(37),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(38),
         TimingData           => Tmkr_PCIN_CLK_posedge(38),
         TestSignal           => PCIN_dly(38),
         TestSignalName       => "PCIN(38)",
         TestDelay            => tisd_PCIN_CLK(38),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(38),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(38),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(38),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(38),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(39),
         TimingData           => Tmkr_PCIN_CLK_posedge(39),
         TestSignal           => PCIN_dly(39),
         TestSignalName       => "PCIN(39)",
         TestDelay            => tisd_PCIN_CLK(39),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(39),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(39),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(39),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(39),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(40),
         TimingData           => Tmkr_PCIN_CLK_posedge(40),
         TestSignal           => PCIN_dly(40),
         TestSignalName       => "PCIN(40)",
         TestDelay            => tisd_PCIN_CLK(40),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(40),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(40),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(40),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(40),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(41),
         TimingData           => Tmkr_PCIN_CLK_posedge(41),
         TestSignal           => PCIN_dly(41),
         TestSignalName       => "PCIN(41)",
         TestDelay            => tisd_PCIN_CLK(41),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(41),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(41),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(41),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(41),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(42),
         TimingData           => Tmkr_PCIN_CLK_posedge(42),
         TestSignal           => PCIN_dly(42),
         TestSignalName       => "PCIN(42)",
         TestDelay            => tisd_PCIN_CLK(42),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(42),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(42),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(42),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(42),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(43),
         TimingData           => Tmkr_PCIN_CLK_posedge(43),
         TestSignal           => PCIN_dly(43),
         TestSignalName       => "PCIN(43)",
         TestDelay            => tisd_PCIN_CLK(43),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(43),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(43),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(43),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(43),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(44),
         TimingData           => Tmkr_PCIN_CLK_posedge(44),
         TestSignal           => PCIN_dly(44),
         TestSignalName       => "PCIN(44)",
         TestDelay            => tisd_PCIN_CLK(44),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(44),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(44),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(44),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(44),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(45),
         TimingData           => Tmkr_PCIN_CLK_posedge(45),
         TestSignal           => PCIN_dly(45),
         TestSignalName       => "PCIN(45)",
         TestDelay            => tisd_PCIN_CLK(45),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(45),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(45),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(45),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(45),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(46),
         TimingData           => Tmkr_PCIN_CLK_posedge(46),
         TestSignal           => PCIN_dly(46),
         TestSignalName       => "PCIN(46)",
         TestDelay            => tisd_PCIN_CLK(46),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(46),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(46),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(46),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(46),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(47),
         TimingData           => Tmkr_PCIN_CLK_posedge(47),
         TestSignal           => PCIN_dly(47),
         TestSignalName       => "PCIN(47)",
         TestDelay            => tisd_PCIN_CLK(47),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(47),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(47),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(47),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(47),
         CheckEnabled         => (TO_X01((not RSTP_dly) and (CEP_dly)) /= '0') and (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTA =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTA_CLK_posedge,
         TimingData           => Tmkr_RSTA_CLK_posedge,
         TestSignal           => RSTA_dly,
         TestSignalName       => "RSTA",
         TestDelay            => tisd_RSTA_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTA_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTA_CLK_negedge_posedge,
         HoldHigh             => thold_RSTA_CLK_posedge_posedge,
         HoldLow              => thold_RSTA_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTB_CLK_posedge,
         TimingData           => Tmkr_RSTB_CLK_posedge,
         TestSignal           => RSTB_dly,
         TestSignalName       => "RSTB",
         TestDelay            => tisd_RSTB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTB_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTB_CLK_negedge_posedge,
         HoldHigh             => thold_RSTB_CLK_posedge_posedge,
         HoldLow              => thold_RSTB_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTC_CLK_posedge,
         TimingData           => Tmkr_RSTC_CLK_posedge,
         TestSignal           => RSTC_dly,
         TestSignalName       => "RSTC",
         TestDelay            => tisd_RSTC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTC_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTC_CLK_negedge_posedge,
         HoldHigh             => thold_RSTC_CLK_posedge_posedge,
         HoldLow              => thold_RSTC_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTCARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTCARRYIN_CLK_posedge,
         TimingData           => Tmkr_RSTCARRYIN_CLK_posedge,
         TestSignal           => RSTCARRYIN_dly,
         TestSignalName       => "RSTCARRYIN",
         TestDelay            => tisd_RSTCARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTCARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTCARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_RSTCARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_RSTCARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTD =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTD_CLK_posedge,
         TimingData           => Tmkr_RSTD_CLK_posedge,
         TestSignal           => RSTD_dly,
         TestSignalName       => "RSTD",
         TestDelay            => tisd_RSTD_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTD_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTD_CLK_negedge_posedge,
         HoldHigh             => thold_RSTD_CLK_posedge_posedge,
         HoldLow              => thold_RSTD_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTM_CLK_posedge,
         TimingData           => Tmkr_RSTM_CLK_posedge,
         TestSignal           => RSTM_dly,
         TestSignalName       => "RSTM",
         TestDelay            => tisd_RSTM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTM_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTM_CLK_negedge_posedge,
         HoldHigh             => thold_RSTM_CLK_posedge_posedge,
         HoldLow              => thold_RSTM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTOPMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTOPMODE_CLK_posedge,
         TimingData           => Tmkr_RSTOPMODE_CLK_posedge,
         TestSignal           => RSTOPMODE_dly,
         TestSignalName       => "RSTOPMODE",
         TestDelay            => tisd_RSTOPMODE_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTOPMODE_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTOPMODE_CLK_negedge_posedge,
         HoldHigh             => thold_RSTOPMODE_CLK_posedge_posedge,
         HoldLow              => thold_RSTOPMODE_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
--=====  Vital SetupHold Checks signal RSTP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTP_CLK_posedge,
         TimingData           => Tmkr_RSTP_CLK_posedge,
         TestSignal           => RSTP_dly,
         TestSignalName       => "RSTP",
         TestDelay            => tisd_RSTP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTP_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTP_CLK_negedge_posedge,
         HoldHigh             => thold_RSTP_CLK_posedge_posedge,
         HoldLow              => thold_RSTP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) /= '1'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48A",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Warning);
   end if;

-- End of (TimingChecksOn)

-- Start Path Delays

       VitalPathDelay01 (
         OutSignal	=> BCOUT(17),
         GlitchData	=> BCOUT_GlitchData(17),
         OutSignalName	=> "BCOUT(17)",
         OutTemp	=> BCOUT_zd(17),
         Paths		=> (
			0 => (B_dly(17)'last_event, tpd_B_BCOUT((323 - 0)- 18*0), true),
			1 => (B_dly(16)'last_event, tpd_B_BCOUT((323 - 0)- 18*1), true),
			2 => (B_dly(15)'last_event, tpd_B_BCOUT((323 - 0)- 18*2), true),
			3 => (B_dly(14)'last_event, tpd_B_BCOUT((323 - 0)- 18*3), true),
			4 => (B_dly(13)'last_event, tpd_B_BCOUT((323 - 0)- 18*4), true),
			5 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 0)- 18*5), true),
			6 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 0)- 18*6), true),
			7 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 0)- 18*7), true),
			8 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 0)- 18*8), true),
			9 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 0)- 18*9), true),
			10 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 0)- 18*10), true),
			11 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 0)- 18*11), true),
			12 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 0)- 18*12), true),
			13 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 0)- 18*13), true),
			14 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 0)- 18*14), true),
			15 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 0)- 18*15), true),
			16 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 0)- 18*16), true),
			17 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 0)- 18*17), true),
			18 => (BCIN_dly(17)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*0), true),
			19 => (BCIN_dly(16)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*1), true),
			20 => (BCIN_dly(15)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*2), true),
			21 => (BCIN_dly(14)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*3), true),
			22 => (BCIN_dly(13)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*4), true),
			23 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*5), true),
			24 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*6), true),
			25 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*7), true),
			26 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*8), true),
			27 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*9), true),
			28 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*10), true),
			29 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*11), true),
			30 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*12), true),
			31 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*13), true),
			32 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*14), true),
			33 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*15), true),
			34 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*16), true),
			35 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 0)- 18*17), true),
			36 => (D_dly(17)'last_event, tpd_D_BCOUT((323 - 0)- 18*0), true),
			37 => (D_dly(16)'last_event, tpd_D_BCOUT((323 - 0)- 18*1), true),
			38 => (D_dly(15)'last_event, tpd_D_BCOUT((323 - 0)- 18*2), true),
			39 => (D_dly(14)'last_event, tpd_D_BCOUT((323 - 0)- 18*3), true),
			40 => (D_dly(13)'last_event, tpd_D_BCOUT((323 - 0)- 18*4), true),
			41 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 0)- 18*5), true),
			42 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 0)- 18*6), true),
			43 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 0)- 18*7), true),
			44 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 0)- 18*8), true),
			45 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 0)- 18*9), true),
			46 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 0)- 18*10), true),
			47 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 0)- 18*11), true),
			48 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 0)- 18*12), true),
			49 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 0)- 18*13), true),
			50 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 0)- 18*14), true),
			51 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 0)- 18*15), true),
			52 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 0)- 18*16), true),
			53 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 0)- 18*17), true),
			54 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*0), true),
			55 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*1), true),
			56 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*2), true),
			57 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*3), true),
			58 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*4), true),
			59 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*5), true),
			60 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*6), true),
			61 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 0)- 18*7), true),
			62 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(17), true),
			63 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(17), true),
			64 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(17), true),
			65 => (CLK_dly'last_event, tpd_CLK_BCOUT(17), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(16),
         GlitchData	=> BCOUT_GlitchData(16),
         OutSignalName	=> "BCOUT(16)",
         OutTemp	=> BCOUT_zd(16),
         Paths		=> (
			0 => (B_dly(16)'last_event, tpd_B_BCOUT((323 - 1)- 18*1), true),
			1 => (B_dly(15)'last_event, tpd_B_BCOUT((323 - 1)- 18*2), true),
			2 => (B_dly(14)'last_event, tpd_B_BCOUT((323 - 1)- 18*3), true),
			3 => (B_dly(13)'last_event, tpd_B_BCOUT((323 - 1)- 18*4), true),
			4 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 1)- 18*5), true),
			5 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 1)- 18*6), true),
			6 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 1)- 18*7), true),
			7 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 1)- 18*8), true),
			8 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 1)- 18*9), true),
			9 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 1)- 18*10), true),
			10 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 1)- 18*11), true),
			11 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 1)- 18*12), true),
			12 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 1)- 18*13), true),
			13 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 1)- 18*14), true),
			14 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 1)- 18*15), true),
			15 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 1)- 18*16), true),
			16 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 1)- 18*17), true),
			17 => (BCIN_dly(16)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*1), true),
			18 => (BCIN_dly(15)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*2), true),
			19 => (BCIN_dly(14)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*3), true),
			20 => (BCIN_dly(13)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*4), true),
			21 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*5), true),
			22 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*6), true),
			23 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*7), true),
			24 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*8), true),
			25 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*9), true),
			26 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*10), true),
			27 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*11), true),
			28 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*12), true),
			29 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*13), true),
			30 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*14), true),
			31 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*15), true),
			32 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*16), true),
			33 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 1)- 18*17), true),
			34 => (D_dly(16)'last_event, tpd_D_BCOUT((323 - 1)- 18*1), true),
			35 => (D_dly(15)'last_event, tpd_D_BCOUT((323 - 1)- 18*2), true),
			36 => (D_dly(14)'last_event, tpd_D_BCOUT((323 - 1)- 18*3), true),
			37 => (D_dly(13)'last_event, tpd_D_BCOUT((323 - 1)- 18*4), true),
			38 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 1)- 18*5), true),
			39 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 1)- 18*6), true),
			40 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 1)- 18*7), true),
			41 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 1)- 18*8), true),
			42 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 1)- 18*9), true),
			43 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 1)- 18*10), true),
			44 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 1)- 18*11), true),
			45 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 1)- 18*12), true),
			46 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 1)- 18*13), true),
			47 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 1)- 18*14), true),
			48 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 1)- 18*15), true),
			49 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 1)- 18*16), true),
			50 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 1)- 18*17), true),
			51 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*0), true),
			52 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*1), true),
			53 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*2), true),
			54 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*3), true),
			55 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*4), true),
			56 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*5), true),
			57 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*6), true),
			58 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 1)- 18*7), true),
			59 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(16), true),
			60 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(16), true),
			61 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(16), true),
			62 => (CLK_dly'last_event, tpd_CLK_BCOUT(16), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(15),
         GlitchData	=> BCOUT_GlitchData(15),
         OutSignalName	=> "BCOUT(15)",
         OutTemp	=> BCOUT_zd(15),
         Paths		=> (
			0 => (B_dly(15)'last_event, tpd_B_BCOUT((323 - 2)- 18*2), true),
			1 => (B_dly(14)'last_event, tpd_B_BCOUT((323 - 2)- 18*3), true),
			2 => (B_dly(13)'last_event, tpd_B_BCOUT((323 - 2)- 18*4), true),
			3 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 2)- 18*5), true),
			4 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 2)- 18*6), true),
			5 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 2)- 18*7), true),
			6 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 2)- 18*8), true),
			7 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 2)- 18*9), true),
			8 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 2)- 18*10), true),
			9 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 2)- 18*11), true),
			10 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 2)- 18*12), true),
			11 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 2)- 18*13), true),
			12 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 2)- 18*14), true),
			13 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 2)- 18*15), true),
			14 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 2)- 18*16), true),
			15 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 2)- 18*17), true),
			16 => (BCIN_dly(15)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*2), true),
			17 => (BCIN_dly(14)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*3), true),
			18 => (BCIN_dly(13)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*4), true),
			19 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*5), true),
			20 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*6), true),
			21 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*7), true),
			22 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*8), true),
			23 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*9), true),
			24 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*10), true),
			25 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*11), true),
			26 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*12), true),
			27 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*13), true),
			28 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*14), true),
			29 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*15), true),
			30 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*16), true),
			31 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 2)- 18*17), true),
			32 => (D_dly(15)'last_event, tpd_D_BCOUT((323 - 2)- 18*2), true),
			33 => (D_dly(14)'last_event, tpd_D_BCOUT((323 - 2)- 18*3), true),
			34 => (D_dly(13)'last_event, tpd_D_BCOUT((323 - 2)- 18*4), true),
			35 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 2)- 18*5), true),
			36 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 2)- 18*6), true),
			37 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 2)- 18*7), true),
			38 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 2)- 18*8), true),
			39 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 2)- 18*9), true),
			40 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 2)- 18*10), true),
			41 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 2)- 18*11), true),
			42 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 2)- 18*12), true),
			43 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 2)- 18*13), true),
			44 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 2)- 18*14), true),
			45 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 2)- 18*15), true),
			46 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 2)- 18*16), true),
			47 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 2)- 18*17), true),
			48 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*0), true),
			49 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*1), true),
			50 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*2), true),
			51 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*3), true),
			52 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*4), true),
			53 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*5), true),
			54 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*6), true),
			55 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 2)- 18*7), true),
			56 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(15), true),
			57 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(15), true),
			58 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(15), true),
			59 => (CLK_dly'last_event, tpd_CLK_BCOUT(15), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(14),
         GlitchData	=> BCOUT_GlitchData(14),
         OutSignalName	=> "BCOUT(14)",
         OutTemp	=> BCOUT_zd(14),
         Paths		=> (
			0 => (B_dly(14)'last_event, tpd_B_BCOUT((323 - 3)- 18*3), true),
			1 => (B_dly(13)'last_event, tpd_B_BCOUT((323 - 3)- 18*4), true),
			2 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 3)- 18*5), true),
			3 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 3)- 18*6), true),
			4 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 3)- 18*7), true),
			5 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 3)- 18*8), true),
			6 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 3)- 18*9), true),
			7 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 3)- 18*10), true),
			8 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 3)- 18*11), true),
			9 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 3)- 18*12), true),
			10 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 3)- 18*13), true),
			11 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 3)- 18*14), true),
			12 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 3)- 18*15), true),
			13 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 3)- 18*16), true),
			14 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 3)- 18*17), true),
			15 => (BCIN_dly(14)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*3), true),
			16 => (BCIN_dly(13)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*4), true),
			17 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*5), true),
			18 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*6), true),
			19 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*7), true),
			20 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*8), true),
			21 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*9), true),
			22 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*10), true),
			23 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*11), true),
			24 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*12), true),
			25 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*13), true),
			26 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*14), true),
			27 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*15), true),
			28 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*16), true),
			29 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 3)- 18*17), true),
			30 => (D_dly(14)'last_event, tpd_D_BCOUT((323 - 3)- 18*3), true),
			31 => (D_dly(13)'last_event, tpd_D_BCOUT((323 - 3)- 18*4), true),
			32 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 3)- 18*5), true),
			33 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 3)- 18*6), true),
			34 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 3)- 18*7), true),
			35 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 3)- 18*8), true),
			36 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 3)- 18*9), true),
			37 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 3)- 18*10), true),
			38 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 3)- 18*11), true),
			39 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 3)- 18*12), true),
			40 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 3)- 18*13), true),
			41 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 3)- 18*14), true),
			42 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 3)- 18*15), true),
			43 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 3)- 18*16), true),
			44 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 3)- 18*17), true),
			45 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*0), true),
			46 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*1), true),
			47 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*2), true),
			48 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*3), true),
			49 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*4), true),
			50 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*5), true),
			51 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*6), true),
			52 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 3)- 18*7), true),
			53 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(14), true),
			54 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(14), true),
			55 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(14), true),
			56 => (CLK_dly'last_event, tpd_CLK_BCOUT(14), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(13),
         GlitchData	=> BCOUT_GlitchData(13),
         OutSignalName	=> "BCOUT(13)",
         OutTemp	=> BCOUT_zd(13),
         Paths		=> (
			0 => (B_dly(13)'last_event, tpd_B_BCOUT((323 - 4)- 18*4), true),
			1 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 4)- 18*5), true),
			2 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 4)- 18*6), true),
			3 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 4)- 18*7), true),
			4 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 4)- 18*8), true),
			5 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 4)- 18*9), true),
			6 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 4)- 18*10), true),
			7 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 4)- 18*11), true),
			8 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 4)- 18*12), true),
			9 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 4)- 18*13), true),
			10 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 4)- 18*14), true),
			11 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 4)- 18*15), true),
			12 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 4)- 18*16), true),
			13 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 4)- 18*17), true),
			14 => (BCIN_dly(13)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*4), true),
			15 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*5), true),
			16 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*6), true),
			17 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*7), true),
			18 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*8), true),
			19 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*9), true),
			20 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*10), true),
			21 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*11), true),
			22 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*12), true),
			23 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*13), true),
			24 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*14), true),
			25 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*15), true),
			26 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*16), true),
			27 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 4)- 18*17), true),
			28 => (D_dly(13)'last_event, tpd_D_BCOUT((323 - 4)- 18*4), true),
			29 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 4)- 18*5), true),
			30 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 4)- 18*6), true),
			31 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 4)- 18*7), true),
			32 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 4)- 18*8), true),
			33 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 4)- 18*9), true),
			34 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 4)- 18*10), true),
			35 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 4)- 18*11), true),
			36 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 4)- 18*12), true),
			37 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 4)- 18*13), true),
			38 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 4)- 18*14), true),
			39 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 4)- 18*15), true),
			40 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 4)- 18*16), true),
			41 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 4)- 18*17), true),
			42 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*0), true),
			43 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*1), true),
			44 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*2), true),
			45 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*3), true),
			46 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*4), true),
			47 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*5), true),
			48 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*6), true),
			49 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 4)- 18*7), true),
			50 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(13), true),
			51 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(13), true),
			52 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(13), true),
			53 => (CLK_dly'last_event, tpd_CLK_BCOUT(13), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(12),
         GlitchData	=> BCOUT_GlitchData(12),
         OutSignalName	=> "BCOUT(12)",
         OutTemp	=> BCOUT_zd(12),
         Paths		=> (
			0 => (B_dly(12)'last_event, tpd_B_BCOUT((323 - 5)- 18*5), true),
			1 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 5)- 18*6), true),
			2 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 5)- 18*7), true),
			3 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 5)- 18*8), true),
			4 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 5)- 18*9), true),
			5 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 5)- 18*10), true),
			6 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 5)- 18*11), true),
			7 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 5)- 18*12), true),
			8 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 5)- 18*13), true),
			9 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 5)- 18*14), true),
			10 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 5)- 18*15), true),
			11 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 5)- 18*16), true),
			12 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 5)- 18*17), true),
			13 => (BCIN_dly(12)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*5), true),
			14 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*6), true),
			15 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*7), true),
			16 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*8), true),
			17 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*9), true),
			18 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*10), true),
			19 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*11), true),
			20 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*12), true),
			21 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*13), true),
			22 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*14), true),
			23 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*15), true),
			24 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*16), true),
			25 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 5)- 18*17), true),
			26 => (D_dly(12)'last_event, tpd_D_BCOUT((323 - 5)- 18*5), true),
			27 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 5)- 18*6), true),
			28 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 5)- 18*7), true),
			29 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 5)- 18*8), true),
			30 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 5)- 18*9), true),
			31 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 5)- 18*10), true),
			32 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 5)- 18*11), true),
			33 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 5)- 18*12), true),
			34 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 5)- 18*13), true),
			35 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 5)- 18*14), true),
			36 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 5)- 18*15), true),
			37 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 5)- 18*16), true),
			38 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 5)- 18*17), true),
			39 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*0), true),
			40 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*1), true),
			41 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*2), true),
			42 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*3), true),
			43 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*4), true),
			44 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*5), true),
			45 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*6), true),
			46 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 5)- 18*7), true),
			47 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(12), true),
			48 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(12), true),
			49 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(12), true),
			50 => (CLK_dly'last_event, tpd_CLK_BCOUT(12), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(11),
         GlitchData	=> BCOUT_GlitchData(11),
         OutSignalName	=> "BCOUT(11)",
         OutTemp	=> BCOUT_zd(11),
         Paths		=> (
			0 => (B_dly(11)'last_event, tpd_B_BCOUT((323 - 6)- 18*6), true),
			1 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 6)- 18*7), true),
			2 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 6)- 18*8), true),
			3 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 6)- 18*9), true),
			4 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 6)- 18*10), true),
			5 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 6)- 18*11), true),
			6 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 6)- 18*12), true),
			7 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 6)- 18*13), true),
			8 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 6)- 18*14), true),
			9 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 6)- 18*15), true),
			10 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 6)- 18*16), true),
			11 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 6)- 18*17), true),
			12 => (BCIN_dly(11)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*6), true),
			13 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*7), true),
			14 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*8), true),
			15 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*9), true),
			16 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*10), true),
			17 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*11), true),
			18 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*12), true),
			19 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*13), true),
			20 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*14), true),
			21 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*15), true),
			22 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*16), true),
			23 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 6)- 18*17), true),
			24 => (D_dly(11)'last_event, tpd_D_BCOUT((323 - 6)- 18*6), true),
			25 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 6)- 18*7), true),
			26 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 6)- 18*8), true),
			27 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 6)- 18*9), true),
			28 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 6)- 18*10), true),
			29 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 6)- 18*11), true),
			30 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 6)- 18*12), true),
			31 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 6)- 18*13), true),
			32 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 6)- 18*14), true),
			33 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 6)- 18*15), true),
			34 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 6)- 18*16), true),
			35 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 6)- 18*17), true),
			36 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*0), true),
			37 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*1), true),
			38 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*2), true),
			39 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*3), true),
			40 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*4), true),
			41 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*5), true),
			42 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*6), true),
			43 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 6)- 18*7), true),
			44 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(11), true),
			45 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(11), true),
			46 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(11), true),
			47 => (CLK_dly'last_event, tpd_CLK_BCOUT(11), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(10),
         GlitchData	=> BCOUT_GlitchData(10),
         OutSignalName	=> "BCOUT(10)",
         OutTemp	=> BCOUT_zd(10),
         Paths		=> (
			0 => (B_dly(10)'last_event, tpd_B_BCOUT((323 - 7)- 18*7), true),
			1 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 7)- 18*8), true),
			2 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 7)- 18*9), true),
			3 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 7)- 18*10), true),
			4 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 7)- 18*11), true),
			5 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 7)- 18*12), true),
			6 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 7)- 18*13), true),
			7 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 7)- 18*14), true),
			8 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 7)- 18*15), true),
			9 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 7)- 18*16), true),
			10 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 7)- 18*17), true),
			11 => (BCIN_dly(10)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*7), true),
			12 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*8), true),
			13 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*9), true),
			14 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*10), true),
			15 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*11), true),
			16 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*12), true),
			17 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*13), true),
			18 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*14), true),
			19 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*15), true),
			20 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*16), true),
			21 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 7)- 18*17), true),
			22 => (D_dly(10)'last_event, tpd_D_BCOUT((323 - 7)- 18*7), true),
			23 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 7)- 18*8), true),
			24 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 7)- 18*9), true),
			25 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 7)- 18*10), true),
			26 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 7)- 18*11), true),
			27 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 7)- 18*12), true),
			28 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 7)- 18*13), true),
			29 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 7)- 18*14), true),
			30 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 7)- 18*15), true),
			31 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 7)- 18*16), true),
			32 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 7)- 18*17), true),
			33 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*0), true),
			34 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*1), true),
			35 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*2), true),
			36 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*3), true),
			37 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*4), true),
			38 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*5), true),
			39 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*6), true),
			40 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 7)- 18*7), true),
			41 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(10), true),
			42 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(10), true),
			43 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(10), true),
			44 => (CLK_dly'last_event, tpd_CLK_BCOUT(10), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(9),
         GlitchData	=> BCOUT_GlitchData(9),
         OutSignalName	=> "BCOUT(9)",
         OutTemp	=> BCOUT_zd(9),
         Paths		=> (
			0 => (B_dly(9)'last_event, tpd_B_BCOUT((323 - 8)- 18*8), true),
			1 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 8)- 18*9), true),
			2 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 8)- 18*10), true),
			3 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 8)- 18*11), true),
			4 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 8)- 18*12), true),
			5 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 8)- 18*13), true),
			6 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 8)- 18*14), true),
			7 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 8)- 18*15), true),
			8 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 8)- 18*16), true),
			9 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 8)- 18*17), true),
			10 => (BCIN_dly(9)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*8), true),
			11 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*9), true),
			12 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*10), true),
			13 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*11), true),
			14 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*12), true),
			15 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*13), true),
			16 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*14), true),
			17 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*15), true),
			18 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*16), true),
			19 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 8)- 18*17), true),
			20 => (D_dly(9)'last_event, tpd_D_BCOUT((323 - 8)- 18*8), true),
			21 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 8)- 18*9), true),
			22 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 8)- 18*10), true),
			23 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 8)- 18*11), true),
			24 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 8)- 18*12), true),
			25 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 8)- 18*13), true),
			26 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 8)- 18*14), true),
			27 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 8)- 18*15), true),
			28 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 8)- 18*16), true),
			29 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 8)- 18*17), true),
			30 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*0), true),
			31 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*1), true),
			32 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*2), true),
			33 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*3), true),
			34 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*4), true),
			35 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*5), true),
			36 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*6), true),
			37 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 8)- 18*7), true),
			38 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(9), true),
			39 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(9), true),
			40 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(9), true),
			41 => (CLK_dly'last_event, tpd_CLK_BCOUT(9), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(8),
         GlitchData	=> BCOUT_GlitchData(8),
         OutSignalName	=> "BCOUT(8)",
         OutTemp	=> BCOUT_zd(8),
         Paths		=> (
			0 => (B_dly(8)'last_event, tpd_B_BCOUT((323 - 9)- 18*9), true),
			1 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 9)- 18*10), true),
			2 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 9)- 18*11), true),
			3 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 9)- 18*12), true),
			4 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 9)- 18*13), true),
			5 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 9)- 18*14), true),
			6 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 9)- 18*15), true),
			7 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 9)- 18*16), true),
			8 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 9)- 18*17), true),
			9 => (BCIN_dly(8)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*9), true),
			10 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*10), true),
			11 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*11), true),
			12 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*12), true),
			13 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*13), true),
			14 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*14), true),
			15 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*15), true),
			16 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*16), true),
			17 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 9)- 18*17), true),
			18 => (D_dly(8)'last_event, tpd_D_BCOUT((323 - 9)- 18*9), true),
			19 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 9)- 18*10), true),
			20 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 9)- 18*11), true),
			21 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 9)- 18*12), true),
			22 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 9)- 18*13), true),
			23 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 9)- 18*14), true),
			24 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 9)- 18*15), true),
			25 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 9)- 18*16), true),
			26 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 9)- 18*17), true),
			27 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*0), true),
			28 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*1), true),
			29 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*2), true),
			30 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*3), true),
			31 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*4), true),
			32 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*5), true),
			33 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*6), true),
			34 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 9)- 18*7), true),
			35 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(8), true),
			36 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(8), true),
			37 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(8), true),
			38 => (CLK_dly'last_event, tpd_CLK_BCOUT(8), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(7),
         GlitchData	=> BCOUT_GlitchData(7),
         OutSignalName	=> "BCOUT(7)",
         OutTemp	=> BCOUT_zd(7),
         Paths		=> (
			0 => (B_dly(7)'last_event, tpd_B_BCOUT((323 - 10)- 18*10), true),
			1 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 10)- 18*11), true),
			2 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 10)- 18*12), true),
			3 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 10)- 18*13), true),
			4 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 10)- 18*14), true),
			5 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 10)- 18*15), true),
			6 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 10)- 18*16), true),
			7 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 10)- 18*17), true),
			8 => (BCIN_dly(7)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*10), true),
			9 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*11), true),
			10 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*12), true),
			11 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*13), true),
			12 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*14), true),
			13 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*15), true),
			14 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*16), true),
			15 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 10)- 18*17), true),
			16 => (D_dly(7)'last_event, tpd_D_BCOUT((323 - 10)- 18*10), true),
			17 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 10)- 18*11), true),
			18 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 10)- 18*12), true),
			19 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 10)- 18*13), true),
			20 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 10)- 18*14), true),
			21 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 10)- 18*15), true),
			22 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 10)- 18*16), true),
			23 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 10)- 18*17), true),
			24 => (OPMODE_dly(7)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*0), true),
			25 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*1), true),
			26 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*2), true),
			27 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*3), true),
			28 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*4), true),
			29 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*5), true),
			30 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*6), true),
			31 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 10)- 18*7), true),
			32 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(7), true),
			33 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(7), true),
			34 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(7), true),
			35 => (CLK_dly'last_event, tpd_CLK_BCOUT(7), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(6),
         GlitchData	=> BCOUT_GlitchData(6),
         OutSignalName	=> "BCOUT(6)",
         OutTemp	=> BCOUT_zd(6),
         Paths		=> (
			0 => (B_dly(6)'last_event, tpd_B_BCOUT((323 - 11)- 18*11), true),
			1 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 11)- 18*12), true),
			2 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 11)- 18*13), true),
			3 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 11)- 18*14), true),
			4 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 11)- 18*15), true),
			5 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 11)- 18*16), true),
			6 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 11)- 18*17), true),
			7 => (BCIN_dly(6)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*11), true),
			8 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*12), true),
			9 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*13), true),
			10 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*14), true),
			11 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*15), true),
			12 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*16), true),
			13 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 11)- 18*17), true),
			14 => (D_dly(6)'last_event, tpd_D_BCOUT((323 - 11)- 18*11), true),
			15 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 11)- 18*12), true),
			16 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 11)- 18*13), true),
			17 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 11)- 18*14), true),
			18 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 11)- 18*15), true),
			19 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 11)- 18*16), true),
			20 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 11)- 18*17), true),
			21 => (OPMODE_dly(6)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*1), true),
			22 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*2), true),
			23 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*3), true),
			24 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*4), true),
			25 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*5), true),
			26 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*6), true),
			27 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 11)- 18*7), true),
			28 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(6), true),
			29 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(6), true),
			30 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(6), true),
			31 => (CLK_dly'last_event, tpd_CLK_BCOUT(6), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(5),
         GlitchData	=> BCOUT_GlitchData(5),
         OutSignalName	=> "BCOUT(5)",
         OutTemp	=> BCOUT_zd(5),
         Paths		=> (
			0 => (B_dly(5)'last_event, tpd_B_BCOUT((323 - 12)- 18*12), true),
			1 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 12)- 18*13), true),
			2 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 12)- 18*14), true),
			3 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 12)- 18*15), true),
			4 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 12)- 18*16), true),
			5 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 12)- 18*17), true),
			6 => (BCIN_dly(5)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*12), true),
			7 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*13), true),
			8 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*14), true),
			9 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*15), true),
			10 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*16), true),
			11 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 12)- 18*17), true),
			12 => (D_dly(5)'last_event, tpd_D_BCOUT((323 - 12)- 18*12), true),
			13 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 12)- 18*13), true),
			14 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 12)- 18*14), true),
			15 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 12)- 18*15), true),
			16 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 12)- 18*16), true),
			17 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 12)- 18*17), true),
			18 => (OPMODE_dly(5)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*2), true),
			19 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*3), true),
			20 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*4), true),
			21 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*5), true),
			22 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*6), true),
			23 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 12)- 18*7), true),
			24 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(5), true),
			25 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(5), true),
			26 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(5), true),
			27 => (CLK_dly'last_event, tpd_CLK_BCOUT(5), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(4),
         GlitchData	=> BCOUT_GlitchData(4),
         OutSignalName	=> "BCOUT(4)",
         OutTemp	=> BCOUT_zd(4),
         Paths		=> (
			0 => (B_dly(4)'last_event, tpd_B_BCOUT((323 - 13)- 18*13), true),
			1 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 13)- 18*14), true),
			2 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 13)- 18*15), true),
			3 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 13)- 18*16), true),
			4 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 13)- 18*17), true),
			5 => (BCIN_dly(4)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*13), true),
			6 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*14), true),
			7 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*15), true),
			8 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*16), true),
			9 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 13)- 18*17), true),
			10 => (D_dly(4)'last_event, tpd_D_BCOUT((323 - 13)- 18*13), true),
			11 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 13)- 18*14), true),
			12 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 13)- 18*15), true),
			13 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 13)- 18*16), true),
			14 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 13)- 18*17), true),
			15 => (OPMODE_dly(4)'last_event, tpd_OPMODE_BCOUT((143 - 13)- 18*3), true),
			16 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 13)- 18*4), true),
			17 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 13)- 18*5), true),
			18 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 13)- 18*6), true),
			19 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 13)- 18*7), true),
			20 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(4), true),
			21 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(4), true),
			22 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(4), true),
			23 => (CLK_dly'last_event, tpd_CLK_BCOUT(4), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(3),
         GlitchData	=> BCOUT_GlitchData(3),
         OutSignalName	=> "BCOUT(3)",
         OutTemp	=> BCOUT_zd(3),
         Paths		=> (
			0 => (B_dly(3)'last_event, tpd_B_BCOUT((323 - 14)- 18*14), true),
			1 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 14)- 18*15), true),
			2 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 14)- 18*16), true),
			3 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 14)- 18*17), true),
			4 => (BCIN_dly(3)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*14), true),
			5 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*15), true),
			6 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*16), true),
			7 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 14)- 18*17), true),
			8 => (D_dly(3)'last_event, tpd_D_BCOUT((323 - 14)- 18*14), true),
			9 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 14)- 18*15), true),
			10 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 14)- 18*16), true),
			11 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 14)- 18*17), true),
			12 => (OPMODE_dly(3)'last_event, tpd_OPMODE_BCOUT((143 - 14)- 18*4), true),
			13 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 14)- 18*5), true),
			14 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 14)- 18*6), true),
			15 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 14)- 18*7), true),
			16 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(3), true),
			17 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(3), true),
			18 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(3), true),
			19 => (CLK_dly'last_event, tpd_CLK_BCOUT(3), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(2),
         GlitchData	=> BCOUT_GlitchData(2),
         OutSignalName	=> "BCOUT(2)",
         OutTemp	=> BCOUT_zd(2),
         Paths		=> (
			0 => (B_dly(2)'last_event, tpd_B_BCOUT((323 - 15)- 18*15), true),
			1 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 15)- 18*16), true),
			2 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 15)- 18*17), true),
			3 => (BCIN_dly(2)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*15), true),
			4 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*16), true),
			5 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 15)- 18*17), true),
			6 => (D_dly(2)'last_event, tpd_D_BCOUT((323 - 15)- 18*15), true),
			7 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 15)- 18*16), true),
			8 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 15)- 18*17), true),
			9 => (OPMODE_dly(2)'last_event, tpd_OPMODE_BCOUT((143 - 15)- 18*5), true),
			10 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 15)- 18*6), true),
			11 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 15)- 18*7), true),
			12 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(2), true),
			13 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(2), true),
			14 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(2), true),
			15 => (CLK_dly'last_event, tpd_CLK_BCOUT(2), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(1),
         GlitchData	=> BCOUT_GlitchData(1),
         OutSignalName	=> "BCOUT(1)",
         OutTemp	=> BCOUT_zd(1),
         Paths		=> (
			0 => (B_dly(1)'last_event, tpd_B_BCOUT((323 - 16)- 18*16), true),
			1 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 16)- 18*17), true),
			2 => (BCIN_dly(1)'last_event, tpd_BCIN_BCOUT((323 - 16)- 18*16), true),
			3 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 16)- 18*17), true),
			4 => (D_dly(1)'last_event, tpd_D_BCOUT((323 - 16)- 18*16), true),
			5 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 16)- 18*17), true),
			6 => (OPMODE_dly(1)'last_event, tpd_OPMODE_BCOUT((143 - 16)- 18*6), true),
			7 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 16)- 18*7), true),
			8 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(1), true),
			9 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(1), true),
			10 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(1), true),
			11 => (CLK_dly'last_event, tpd_CLK_BCOUT(1), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> BCOUT(0),
         GlitchData	=> BCOUT_GlitchData(0),
         OutSignalName	=> "BCOUT(0)",
         OutTemp	=> BCOUT_zd(0),
         Paths		=> (
			0 => (B_dly(0)'last_event, tpd_B_BCOUT((323 - 17)- 18*17), true),
			1 => (BCIN_dly(0)'last_event, tpd_BCIN_BCOUT((323 - 17)- 18*17), true),
			2 => (D_dly(0)'last_event, tpd_D_BCOUT((323 - 17)- 18*17), true),
			3 => (OPMODE_dly(0)'last_event, tpd_OPMODE_BCOUT((143 - 17)- 18*7), true),
			4 => (RSTB_dly'last_event, tpd_RSTB_BCOUT(0), true),
			5 => (RSTD_dly'last_event, tpd_RSTD_BCOUT(0), true),
			6 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_BCOUT(0), true),
			7 => (CLK_dly'last_event, tpd_CLK_BCOUT(0), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

------------------

       VitalPathDelay01 (
         OutSignal	=> CARRYOUT,
         GlitchData	=> CARRYOUT_GlitchData,
         OutSignalName	=> "CARRYOUT",
         OutTemp	=> CARRYOUT_zd,
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_CARRYOUT(0), true),
			1 => (A_ipd(1)'last_event, tpd_A_CARRYOUT(1), true),
			2 => (A_ipd(2)'last_event, tpd_A_CARRYOUT(2), true),
			3 => (A_ipd(3)'last_event, tpd_A_CARRYOUT(3), true),
			4 => (A_ipd(4)'last_event, tpd_A_CARRYOUT(4), true),
			5 => (A_ipd(5)'last_event, tpd_A_CARRYOUT(5), true),
			6 => (A_ipd(6)'last_event, tpd_A_CARRYOUT(6), true),
			7 => (A_ipd(7)'last_event, tpd_A_CARRYOUT(7), true),
			8 => (A_ipd(8)'last_event, tpd_A_CARRYOUT(8), true),
			9 => (A_ipd(9)'last_event, tpd_A_CARRYOUT(9), true),
			10 => (A_ipd(10)'last_event, tpd_A_CARRYOUT(10), true),
			11 => (A_ipd(11)'last_event, tpd_A_CARRYOUT(11), true),
			12 => (A_ipd(12)'last_event, tpd_A_CARRYOUT(12), true),
			13 => (A_ipd(13)'last_event, tpd_A_CARRYOUT(13), true),
			14 => (A_ipd(14)'last_event, tpd_A_CARRYOUT(14), true),
			15 => (A_ipd(15)'last_event, tpd_A_CARRYOUT(15), true),
			16 => (A_ipd(16)'last_event, tpd_A_CARRYOUT(16), true),
			17 => (A_ipd(17)'last_event, tpd_A_CARRYOUT(17), true),
			18 => (B_ipd(0)'last_event, tpd_B_CARRYOUT(0), true),
			19 => (B_ipd(1)'last_event, tpd_B_CARRYOUT(1), true),
			20 => (B_ipd(2)'last_event, tpd_B_CARRYOUT(2), true),
			21 => (B_ipd(3)'last_event, tpd_B_CARRYOUT(3), true),
			22 => (B_ipd(4)'last_event, tpd_B_CARRYOUT(4), true),
			23 => (B_ipd(5)'last_event, tpd_B_CARRYOUT(5), true),
			24 => (B_ipd(6)'last_event, tpd_B_CARRYOUT(6), true),
			25 => (B_ipd(7)'last_event, tpd_B_CARRYOUT(7), true),
			26 => (B_ipd(8)'last_event, tpd_B_CARRYOUT(8), true),
			27 => (B_ipd(9)'last_event, tpd_B_CARRYOUT(9), true),
			28 => (B_ipd(10)'last_event, tpd_B_CARRYOUT(10), true),
			29 => (B_ipd(11)'last_event, tpd_B_CARRYOUT(11), true),
			30 => (B_ipd(12)'last_event, tpd_B_CARRYOUT(12), true),
			31 => (B_ipd(13)'last_event, tpd_B_CARRYOUT(13), true),
			32 => (B_ipd(14)'last_event, tpd_B_CARRYOUT(14), true),
			33 => (B_ipd(15)'last_event, tpd_B_CARRYOUT(15), true),
			34 => (B_ipd(16)'last_event, tpd_B_CARRYOUT(16), true),
			35 => (B_ipd(17)'last_event, tpd_B_CARRYOUT(17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_CARRYOUT(0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_CARRYOUT(1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_CARRYOUT(2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_CARRYOUT(3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_CARRYOUT(4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_CARRYOUT(5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_CARRYOUT(6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_CARRYOUT(7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_CARRYOUT(8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_CARRYOUT(9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_CARRYOUT(10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_CARRYOUT(11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_CARRYOUT(12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_CARRYOUT(13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_CARRYOUT(14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_CARRYOUT(15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_CARRYOUT(16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_CARRYOUT(17), true),
			54 => (C_ipd(0)'last_event, tpd_C_CARRYOUT(0), true),
			55 => (C_ipd(1)'last_event, tpd_C_CARRYOUT(1), true),
			56 => (C_ipd(2)'last_event, tpd_C_CARRYOUT(2), true),
			57 => (C_ipd(3)'last_event, tpd_C_CARRYOUT(3), true),
			58 => (C_ipd(4)'last_event, tpd_C_CARRYOUT(4), true),
			59 => (C_ipd(5)'last_event, tpd_C_CARRYOUT(5), true),
			60 => (C_ipd(6)'last_event, tpd_C_CARRYOUT(6), true),
			61 => (C_ipd(7)'last_event, tpd_C_CARRYOUT(7), true),
			62 => (C_ipd(8)'last_event, tpd_C_CARRYOUT(8), true),
			63 => (C_ipd(9)'last_event, tpd_C_CARRYOUT(9), true),
			64 => (C_ipd(10)'last_event, tpd_C_CARRYOUT(10), true),
			65 => (C_ipd(11)'last_event, tpd_C_CARRYOUT(11), true),
			66 => (C_ipd(12)'last_event, tpd_C_CARRYOUT(12), true),
			67 => (C_ipd(13)'last_event, tpd_C_CARRYOUT(13), true),
			68 => (C_ipd(14)'last_event, tpd_C_CARRYOUT(14), true),
			69 => (C_ipd(15)'last_event, tpd_C_CARRYOUT(15), true),
			70 => (C_ipd(16)'last_event, tpd_C_CARRYOUT(16), true),
			71 => (C_ipd(17)'last_event, tpd_C_CARRYOUT(17), true),
			72 => (C_ipd(18)'last_event, tpd_C_CARRYOUT(18), true),
			73 => (C_ipd(19)'last_event, tpd_C_CARRYOUT(19), true),
			74 => (C_ipd(20)'last_event, tpd_C_CARRYOUT(20), true),
			75 => (C_ipd(21)'last_event, tpd_C_CARRYOUT(21), true),
			76 => (C_ipd(22)'last_event, tpd_C_CARRYOUT(22), true),
			77 => (C_ipd(23)'last_event, tpd_C_CARRYOUT(23), true),
			78 => (C_ipd(24)'last_event, tpd_C_CARRYOUT(24), true),
			79 => (C_ipd(25)'last_event, tpd_C_CARRYOUT(25), true),
			80 => (C_ipd(26)'last_event, tpd_C_CARRYOUT(26), true),
			81 => (C_ipd(27)'last_event, tpd_C_CARRYOUT(27), true),
			82 => (C_ipd(28)'last_event, tpd_C_CARRYOUT(28), true),
			83 => (C_ipd(29)'last_event, tpd_C_CARRYOUT(29), true),
			84 => (C_ipd(30)'last_event, tpd_C_CARRYOUT(30), true),
			85 => (C_ipd(31)'last_event, tpd_C_CARRYOUT(31), true),
			86 => (C_ipd(32)'last_event, tpd_C_CARRYOUT(32), true),
			87 => (C_ipd(33)'last_event, tpd_C_CARRYOUT(33), true),
			88 => (C_ipd(34)'last_event, tpd_C_CARRYOUT(34), true),
			89 => (C_ipd(35)'last_event, tpd_C_CARRYOUT(35), true),
			90 => (C_ipd(36)'last_event, tpd_C_CARRYOUT(36), true),
			91 => (C_ipd(37)'last_event, tpd_C_CARRYOUT(37), true),
			92 => (C_ipd(38)'last_event, tpd_C_CARRYOUT(38), true),
			93 => (C_ipd(39)'last_event, tpd_C_CARRYOUT(39), true),
			94 => (C_ipd(40)'last_event, tpd_C_CARRYOUT(40), true),
			95 => (C_ipd(41)'last_event, tpd_C_CARRYOUT(41), true),
			96 => (C_ipd(42)'last_event, tpd_C_CARRYOUT(42), true),
			97 => (C_ipd(43)'last_event, tpd_C_CARRYOUT(43), true),
			98 => (C_ipd(44)'last_event, tpd_C_CARRYOUT(44), true),
			99 => (C_ipd(45)'last_event, tpd_C_CARRYOUT(45), true),
			100 => (C_ipd(46)'last_event, tpd_C_CARRYOUT(46), true),
			101 => (C_ipd(47)'last_event, tpd_C_CARRYOUT(47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_CARRYOUT, true),
			103 => (D_ipd(0)'last_event, tpd_D_CARRYOUT(0), true),
			104 => (D_ipd(1)'last_event, tpd_D_CARRYOUT(1), true),
			105 => (D_ipd(2)'last_event, tpd_D_CARRYOUT(2), true),
			106 => (D_ipd(3)'last_event, tpd_D_CARRYOUT(3), true),
			107 => (D_ipd(4)'last_event, tpd_D_CARRYOUT(4), true),
			108 => (D_ipd(5)'last_event, tpd_D_CARRYOUT(5), true),
			109 => (D_ipd(6)'last_event, tpd_D_CARRYOUT(6), true),
			110 => (D_ipd(7)'last_event, tpd_D_CARRYOUT(7), true),
			111 => (D_ipd(8)'last_event, tpd_D_CARRYOUT(8), true),
			112 => (D_ipd(9)'last_event, tpd_D_CARRYOUT(9), true),
			113 => (D_ipd(10)'last_event, tpd_D_CARRYOUT(10), true),
			114 => (D_ipd(11)'last_event, tpd_D_CARRYOUT(11), true),
			115 => (D_ipd(12)'last_event, tpd_D_CARRYOUT(12), true),
			116 => (D_ipd(13)'last_event, tpd_D_CARRYOUT(13), true),
			117 => (D_ipd(14)'last_event, tpd_D_CARRYOUT(14), true),
			118 => (D_ipd(15)'last_event, tpd_D_CARRYOUT(15), true),
			119 => (D_ipd(16)'last_event, tpd_D_CARRYOUT(16), true),
			120 => (D_ipd(17)'last_event, tpd_D_CARRYOUT(17), true),
			121 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_CARRYOUT(0), true),
			122 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_CARRYOUT(1), true),
			123 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_CARRYOUT(2), true),
			124 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_CARRYOUT(3), true),
			125 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_CARRYOUT(4), true),
			126 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_CARRYOUT(5), true),
			127 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_CARRYOUT(6), true),
			128 => (OPMODE_ipd(7)'last_event, tpd_OPMODE_CARRYOUT(7), true),
			129 => (PCIN_ipd(0)'last_event, tpd_PCIN_CARRYOUT(0), true),
			130 => (PCIN_ipd(1)'last_event, tpd_PCIN_CARRYOUT(1), true),
			131 => (PCIN_ipd(2)'last_event, tpd_PCIN_CARRYOUT(2), true),
			132 => (PCIN_ipd(3)'last_event, tpd_PCIN_CARRYOUT(3), true),
			133 => (PCIN_ipd(4)'last_event, tpd_PCIN_CARRYOUT(4), true),
			134 => (PCIN_ipd(5)'last_event, tpd_PCIN_CARRYOUT(5), true),
			135 => (PCIN_ipd(6)'last_event, tpd_PCIN_CARRYOUT(6), true),
			136 => (PCIN_ipd(7)'last_event, tpd_PCIN_CARRYOUT(7), true),
			137 => (PCIN_ipd(8)'last_event, tpd_PCIN_CARRYOUT(8), true),
			138 => (PCIN_ipd(9)'last_event, tpd_PCIN_CARRYOUT(9), true),
			139 => (PCIN_ipd(10)'last_event, tpd_PCIN_CARRYOUT(10), true),
			140 => (PCIN_ipd(11)'last_event, tpd_PCIN_CARRYOUT(11), true),
			141 => (PCIN_ipd(12)'last_event, tpd_PCIN_CARRYOUT(12), true),
			142 => (PCIN_ipd(13)'last_event, tpd_PCIN_CARRYOUT(13), true),
			143 => (PCIN_ipd(14)'last_event, tpd_PCIN_CARRYOUT(14), true),
			144 => (PCIN_ipd(15)'last_event, tpd_PCIN_CARRYOUT(15), true),
			145 => (PCIN_ipd(16)'last_event, tpd_PCIN_CARRYOUT(16), true),
			146 => (PCIN_ipd(17)'last_event, tpd_PCIN_CARRYOUT(17), true),
			147 => (PCIN_ipd(18)'last_event, tpd_PCIN_CARRYOUT(18), true),
			148 => (PCIN_ipd(19)'last_event, tpd_PCIN_CARRYOUT(19), true),
			149 => (PCIN_ipd(20)'last_event, tpd_PCIN_CARRYOUT(20), true),
			150 => (PCIN_ipd(21)'last_event, tpd_PCIN_CARRYOUT(21), true),
			151 => (PCIN_ipd(22)'last_event, tpd_PCIN_CARRYOUT(22), true),
			152 => (PCIN_ipd(23)'last_event, tpd_PCIN_CARRYOUT(23), true),
			153 => (PCIN_ipd(24)'last_event, tpd_PCIN_CARRYOUT(24), true),
			154 => (PCIN_ipd(25)'last_event, tpd_PCIN_CARRYOUT(25), true),
			155 => (PCIN_ipd(26)'last_event, tpd_PCIN_CARRYOUT(26), true),
			156 => (PCIN_ipd(27)'last_event, tpd_PCIN_CARRYOUT(27), true),
			157 => (PCIN_ipd(28)'last_event, tpd_PCIN_CARRYOUT(28), true),
			158 => (PCIN_ipd(29)'last_event, tpd_PCIN_CARRYOUT(29), true),
			159 => (PCIN_ipd(30)'last_event, tpd_PCIN_CARRYOUT(30), true),
			160 => (PCIN_ipd(31)'last_event, tpd_PCIN_CARRYOUT(31), true),
			161 => (PCIN_ipd(32)'last_event, tpd_PCIN_CARRYOUT(32), true),
			162 => (PCIN_ipd(33)'last_event, tpd_PCIN_CARRYOUT(33), true),
			163 => (PCIN_ipd(34)'last_event, tpd_PCIN_CARRYOUT(34), true),
			164 => (PCIN_ipd(35)'last_event, tpd_PCIN_CARRYOUT(35), true),
			165 => (PCIN_ipd(36)'last_event, tpd_PCIN_CARRYOUT(36), true),
			166 => (PCIN_ipd(37)'last_event, tpd_PCIN_CARRYOUT(37), true),
			167 => (PCIN_ipd(38)'last_event, tpd_PCIN_CARRYOUT(38), true),
			168 => (PCIN_ipd(39)'last_event, tpd_PCIN_CARRYOUT(39), true),
			169 => (PCIN_ipd(40)'last_event, tpd_PCIN_CARRYOUT(40), true),
			170 => (PCIN_ipd(41)'last_event, tpd_PCIN_CARRYOUT(41), true),
			171 => (PCIN_ipd(42)'last_event, tpd_PCIN_CARRYOUT(42), true),
			172 => (PCIN_ipd(43)'last_event, tpd_PCIN_CARRYOUT(43), true),
			173 => (PCIN_ipd(44)'last_event, tpd_PCIN_CARRYOUT(44), true),
			174 => (PCIN_ipd(45)'last_event, tpd_PCIN_CARRYOUT(45), true),
			175 => (PCIN_ipd(46)'last_event, tpd_PCIN_CARRYOUT(46), true),
			176 => (PCIN_ipd(47)'last_event, tpd_PCIN_CARRYOUT(47), true),
			177 => (RSTA_dly'last_event, tpd_RSTA_CARRYOUT, RSTTYPE="ASYNC"),
			178 => (RSTB_dly'last_event, tpd_RSTB_CARRYOUT, RSTTYPE="ASYNC"),
			179 => (RSTC_dly'last_event, tpd_RSTC_CARRYOUT, RSTTYPE="ASYNC"),
			180 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_CARRYOUT, RSTTYPE="ASYNC"),
			181 => (RSTD_dly'last_event, tpd_RSTD_CARRYOUT, RSTTYPE="ASYNC"),
			182 => (RSTM_dly'last_event, tpd_RSTM_CARRYOUT, RSTTYPE="ASYNC"),
			183 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_CARRYOUT, RSTTYPE="ASYNC"),
			184 => (CLK_dly'last_event, tpd_CLK_CARRYOUT, true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

-----------------------------------------

       VitalPathDelay01 (
         OutSignal	=> P(47),
         GlitchData	=> P_GlitchData(47),
         OutSignalName	=> "P(47)",
         OutTemp	=> P_zd(47),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 0)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 0)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 0)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 0)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 0)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 0)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 0)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 0)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 0)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 0)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 0)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 0)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 0)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 0)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 0)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 0)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 0)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 0)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 0)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 0)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 0)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 0)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 0)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 0)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 0)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 0)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 0)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 0)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 0)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 0)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 0)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 0)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 0)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 0)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 0)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 0)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 0)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 0)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 0)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 0)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 0)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 0)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 0)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 0)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 0)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 0)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 0)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 0)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 0)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 0)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 0)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 0)- 48*17), true),
			54 => (C_dly(47)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			55 => (C_dly(46)'last_event, tpd_C_P((2303 - 0)- 48*1), true),
			56 => (C_dly(45)'last_event, tpd_C_P((2303 - 0)- 48*2), true),
			57 => (C_dly(44)'last_event, tpd_C_P((2303 - 0)- 48*3), true),
			58 => (C_dly(43)'last_event, tpd_C_P((2303 - 0)- 48*4), true),
			59 => (C_dly(42)'last_event, tpd_C_P((2303 - 0)- 48*5), true),
			60 => (C_dly(41)'last_event, tpd_C_P((2303 - 0)- 48*6), true),
			61 => (C_dly(40)'last_event, tpd_C_P((2303 - 0)- 48*7), true),
			62 => (C_dly(39)'last_event, tpd_C_P((2303 - 0)- 48*8), true),
			63 => (C_dly(38)'last_event, tpd_C_P((2303 - 0)- 48*9), true),
			64 => (C_dly(37)'last_event, tpd_C_P((2303 - 0)- 48*10), true),
			65 => (C_dly(36)'last_event, tpd_C_P((2303 - 0)- 48*11), true),
			66 => (C_dly(35)'last_event, tpd_C_P((2303 - 0)- 48*12), true),
			67 => (C_dly(34)'last_event, tpd_C_P((2303 - 0)- 48*13), true),
			68 => (C_dly(33)'last_event, tpd_C_P((2303 - 0)- 48*14), true),
			69 => (C_dly(32)'last_event, tpd_C_P((2303 - 0)- 48*15), true),
			70 => (C_dly(31)'last_event, tpd_C_P((2303 - 0)- 48*16), true),
			71 => (C_dly(30)'last_event, tpd_C_P((2303 - 0)- 48*17), true),
			72 => (C_dly(29)'last_event, tpd_C_P((2303 - 0)- 48*18), true),
			73 => (C_dly(28)'last_event, tpd_C_P((2303 - 0)- 48*19), true),
			74 => (C_dly(27)'last_event, tpd_C_P((2303 - 0)- 48*20), true),
			75 => (C_dly(26)'last_event, tpd_C_P((2303 - 0)- 48*21), true),
			76 => (C_dly(25)'last_event, tpd_C_P((2303 - 0)- 48*22), true),
			77 => (C_dly(24)'last_event, tpd_C_P((2303 - 0)- 48*23), true),
			78 => (C_dly(23)'last_event, tpd_C_P((2303 - 0)- 48*24), true),
			79 => (C_dly(22)'last_event, tpd_C_P((2303 - 0)- 48*25), true),
			80 => (C_dly(21)'last_event, tpd_C_P((2303 - 0)- 48*26), true),
			81 => (C_dly(20)'last_event, tpd_C_P((2303 - 0)- 48*27), true),
			82 => (C_dly(19)'last_event, tpd_C_P((2303 - 0)- 48*28), true),
			83 => (C_dly(18)'last_event, tpd_C_P((2303 - 0)- 48*29), true),
			84 => (C_dly(17)'last_event, tpd_C_P((2303 - 0)- 48*30), true),
			85 => (C_dly(16)'last_event, tpd_C_P((2303 - 0)- 48*31), true),
			86 => (C_dly(15)'last_event, tpd_C_P((2303 - 0)- 48*32), true),
			87 => (C_dly(14)'last_event, tpd_C_P((2303 - 0)- 48*33), true),
			88 => (C_dly(13)'last_event, tpd_C_P((2303 - 0)- 48*34), true),
			89 => (C_dly(12)'last_event, tpd_C_P((2303 - 0)- 48*35), true),
			90 => (C_dly(11)'last_event, tpd_C_P((2303 - 0)- 48*36), true),
			91 => (C_dly(10)'last_event, tpd_C_P((2303 - 0)- 48*37), true),
			92 => (C_dly(9)'last_event, tpd_C_P((2303 - 0)- 48*38), true),
			93 => (C_dly(8)'last_event, tpd_C_P((2303 - 0)- 48*39), true),
			94 => (C_dly(7)'last_event, tpd_C_P((2303 - 0)- 48*40), true),
			95 => (C_dly(6)'last_event, tpd_C_P((2303 - 0)- 48*41), true),
			96 => (C_dly(5)'last_event, tpd_C_P((2303 - 0)- 48*42), true),
			97 => (C_dly(4)'last_event, tpd_C_P((2303 - 0)- 48*43), true),
			98 => (C_dly(3)'last_event, tpd_C_P((2303 - 0)- 48*44), true),
			99 => (C_dly(2)'last_event, tpd_C_P((2303 - 0)- 48*45), true),
			100 => (C_dly(1)'last_event, tpd_C_P((2303 - 0)- 48*46), true),
			101 => (C_dly(0)'last_event, tpd_C_P((2303 - 0)- 48*47), true),
			102 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(47), true),
			103 => (D_dly(17)'last_event, tpd_D_P((863 - 0)- 48*0), true),
			104 => (D_dly(16)'last_event, tpd_D_P((863 - 0)- 48*1), true),
			105 => (D_dly(15)'last_event, tpd_D_P((863 - 0)- 48*2), true),
			106 => (D_dly(14)'last_event, tpd_D_P((863 - 0)- 48*3), true),
			107 => (D_dly(13)'last_event, tpd_D_P((863 - 0)- 48*4), true),
			108 => (D_dly(12)'last_event, tpd_D_P((863 - 0)- 48*5), true),
			109 => (D_dly(11)'last_event, tpd_D_P((863 - 0)- 48*6), true),
			110 => (D_dly(10)'last_event, tpd_D_P((863 - 0)- 48*7), true),
			111 => (D_dly(9)'last_event, tpd_D_P((863 - 0)- 48*8), true),
			112 => (D_dly(8)'last_event, tpd_D_P((863 - 0)- 48*9), true),
			113 => (D_dly(7)'last_event, tpd_D_P((863 - 0)- 48*10), true),
			114 => (D_dly(6)'last_event, tpd_D_P((863 - 0)- 48*11), true),
			115 => (D_dly(5)'last_event, tpd_D_P((863 - 0)- 48*12), true),
			116 => (D_dly(4)'last_event, tpd_D_P((863 - 0)- 48*13), true),
			117 => (D_dly(3)'last_event, tpd_D_P((863 - 0)- 48*14), true),
			118 => (D_dly(2)'last_event, tpd_D_P((863 - 0)- 48*15), true),
			119 => (D_dly(1)'last_event, tpd_D_P((863 - 0)- 48*16), true),
			120 => (D_dly(0)'last_event, tpd_D_P((863 - 0)- 48*17), true),
			121 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 0)- 48*0), true),
			122 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 0)- 48*1), true),
			123 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 0)- 48*2), true),
			124 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 0)- 48*3), true),
			125 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 0)- 48*4), true),
			126 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 0)- 48*5), true),
			127 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 0)- 48*6), true),
			128 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 0)- 48*7), true),
			129 => (PCIN_dly(47)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			130 => (PCIN_dly(46)'last_event, tpd_PCIN_P((2303 - 0)- 48*1), true),
			131 => (PCIN_dly(45)'last_event, tpd_PCIN_P((2303 - 0)- 48*2), true),
			132 => (PCIN_dly(44)'last_event, tpd_PCIN_P((2303 - 0)- 48*3), true),
			133 => (PCIN_dly(43)'last_event, tpd_PCIN_P((2303 - 0)- 48*4), true),
			134 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 0)- 48*5), true),
			135 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 0)- 48*6), true),
			136 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 0)- 48*7), true),
			137 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 0)- 48*8), true),
			138 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 0)- 48*9), true),
			139 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 0)- 48*10), true),
			140 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 0)- 48*11), true),
			141 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 0)- 48*12), true),
			142 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 0)- 48*13), true),
			143 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 0)- 48*14), true),
			144 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 0)- 48*15), true),
			145 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 0)- 48*16), true),
			146 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 0)- 48*17), true),
			147 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 0)- 48*18), true),
			148 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 0)- 48*19), true),
			149 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 0)- 48*20), true),
			150 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 0)- 48*21), true),
			151 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 0)- 48*22), true),
			152 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 0)- 48*23), true),
			153 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 0)- 48*24), true),
			154 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 0)- 48*25), true),
			155 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 0)- 48*26), true),
			156 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 0)- 48*27), true),
			157 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 0)- 48*28), true),
			158 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 0)- 48*29), true),
			159 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 0)- 48*30), true),
			160 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 0)- 48*31), true),
			161 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 0)- 48*32), true),
			162 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 0)- 48*33), true),
			163 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 0)- 48*34), true),
			164 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 0)- 48*35), true),
			165 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 0)- 48*36), true),
			166 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 0)- 48*37), true),
			167 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 0)- 48*38), true),
			168 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 0)- 48*39), true),
			169 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 0)- 48*40), true),
			170 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 0)- 48*41), true),
			171 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 0)- 48*42), true),
			172 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 0)- 48*43), true),
			173 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 0)- 48*44), true),
			174 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 0)- 48*45), true),
			175 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 0)- 48*46), true),
			176 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 0)- 48*47), true),
			177 => (RSTA_dly'last_event, tpd_RSTA_P(47), true),
			178 => (RSTB_dly'last_event, tpd_RSTB_P(47), true),
			179 => (RSTC_dly'last_event, tpd_RSTC_P(47), true),
			180 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(47), true),
			181 => (RSTD_dly'last_event, tpd_RSTD_P(47), true),
			182 => (RSTM_dly'last_event, tpd_RSTM_P(47), true),
			183 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(47), true),
			184 => (RSTP_dly'last_event, tpd_RSTP_P(47), true),
			185 => (CLK_dly'last_event, tpd_CLK_P(47), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(46),
         GlitchData	=> P_GlitchData(46),
         OutSignalName	=> "P(46)",
         OutTemp	=> P_zd(46),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 1)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 1)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 1)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 1)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 1)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 1)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 1)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 1)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 1)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 1)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 1)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 1)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 1)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 1)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 1)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 1)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 1)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 1)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 1)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 1)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 1)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 1)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 1)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 1)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 1)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 1)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 1)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 1)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 1)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 1)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 1)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 1)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 1)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 1)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 1)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 1)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 1)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 1)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 1)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 1)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 1)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 1)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 1)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 1)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 1)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 1)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 1)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 1)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 1)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 1)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 1)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 1)- 48*17), true),
			54 => (C_dly(46)'last_event, tpd_C_P((2303 - 1)- 48*1), true),
			55 => (C_dly(45)'last_event, tpd_C_P((2303 - 1)- 48*2), true),
			56 => (C_dly(44)'last_event, tpd_C_P((2303 - 1)- 48*3), true),
			57 => (C_dly(43)'last_event, tpd_C_P((2303 - 1)- 48*4), true),
			58 => (C_dly(42)'last_event, tpd_C_P((2303 - 1)- 48*5), true),
			59 => (C_dly(41)'last_event, tpd_C_P((2303 - 1)- 48*6), true),
			60 => (C_dly(40)'last_event, tpd_C_P((2303 - 1)- 48*7), true),
			61 => (C_dly(39)'last_event, tpd_C_P((2303 - 1)- 48*8), true),
			62 => (C_dly(38)'last_event, tpd_C_P((2303 - 1)- 48*9), true),
			63 => (C_dly(37)'last_event, tpd_C_P((2303 - 1)- 48*10), true),
			64 => (C_dly(36)'last_event, tpd_C_P((2303 - 1)- 48*11), true),
			65 => (C_dly(35)'last_event, tpd_C_P((2303 - 1)- 48*12), true),
			66 => (C_dly(34)'last_event, tpd_C_P((2303 - 1)- 48*13), true),
			67 => (C_dly(33)'last_event, tpd_C_P((2303 - 1)- 48*14), true),
			68 => (C_dly(32)'last_event, tpd_C_P((2303 - 1)- 48*15), true),
			69 => (C_dly(31)'last_event, tpd_C_P((2303 - 1)- 48*16), true),
			70 => (C_dly(30)'last_event, tpd_C_P((2303 - 1)- 48*17), true),
			71 => (C_dly(29)'last_event, tpd_C_P((2303 - 1)- 48*18), true),
			72 => (C_dly(28)'last_event, tpd_C_P((2303 - 1)- 48*19), true),
			73 => (C_dly(27)'last_event, tpd_C_P((2303 - 1)- 48*20), true),
			74 => (C_dly(26)'last_event, tpd_C_P((2303 - 1)- 48*21), true),
			75 => (C_dly(25)'last_event, tpd_C_P((2303 - 1)- 48*22), true),
			76 => (C_dly(24)'last_event, tpd_C_P((2303 - 1)- 48*23), true),
			77 => (C_dly(23)'last_event, tpd_C_P((2303 - 1)- 48*24), true),
			78 => (C_dly(22)'last_event, tpd_C_P((2303 - 1)- 48*25), true),
			79 => (C_dly(21)'last_event, tpd_C_P((2303 - 1)- 48*26), true),
			80 => (C_dly(20)'last_event, tpd_C_P((2303 - 1)- 48*27), true),
			81 => (C_dly(19)'last_event, tpd_C_P((2303 - 1)- 48*28), true),
			82 => (C_dly(18)'last_event, tpd_C_P((2303 - 1)- 48*29), true),
			83 => (C_dly(17)'last_event, tpd_C_P((2303 - 1)- 48*30), true),
			84 => (C_dly(16)'last_event, tpd_C_P((2303 - 1)- 48*31), true),
			85 => (C_dly(15)'last_event, tpd_C_P((2303 - 1)- 48*32), true),
			86 => (C_dly(14)'last_event, tpd_C_P((2303 - 1)- 48*33), true),
			87 => (C_dly(13)'last_event, tpd_C_P((2303 - 1)- 48*34), true),
			88 => (C_dly(12)'last_event, tpd_C_P((2303 - 1)- 48*35), true),
			89 => (C_dly(11)'last_event, tpd_C_P((2303 - 1)- 48*36), true),
			90 => (C_dly(10)'last_event, tpd_C_P((2303 - 1)- 48*37), true),
			91 => (C_dly(9)'last_event, tpd_C_P((2303 - 1)- 48*38), true),
			92 => (C_dly(8)'last_event, tpd_C_P((2303 - 1)- 48*39), true),
			93 => (C_dly(7)'last_event, tpd_C_P((2303 - 1)- 48*40), true),
			94 => (C_dly(6)'last_event, tpd_C_P((2303 - 1)- 48*41), true),
			95 => (C_dly(5)'last_event, tpd_C_P((2303 - 1)- 48*42), true),
			96 => (C_dly(4)'last_event, tpd_C_P((2303 - 1)- 48*43), true),
			97 => (C_dly(3)'last_event, tpd_C_P((2303 - 1)- 48*44), true),
			98 => (C_dly(2)'last_event, tpd_C_P((2303 - 1)- 48*45), true),
			99 => (C_dly(1)'last_event, tpd_C_P((2303 - 1)- 48*46), true),
			100 => (C_dly(0)'last_event, tpd_C_P((2303 - 1)- 48*47), true),
			101 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(46), true),
			102 => (D_dly(17)'last_event, tpd_D_P((863 - 1)- 48*0), true),
			103 => (D_dly(16)'last_event, tpd_D_P((863 - 1)- 48*1), true),
			104 => (D_dly(15)'last_event, tpd_D_P((863 - 1)- 48*2), true),
			105 => (D_dly(14)'last_event, tpd_D_P((863 - 1)- 48*3), true),
			106 => (D_dly(13)'last_event, tpd_D_P((863 - 1)- 48*4), true),
			107 => (D_dly(12)'last_event, tpd_D_P((863 - 1)- 48*5), true),
			108 => (D_dly(11)'last_event, tpd_D_P((863 - 1)- 48*6), true),
			109 => (D_dly(10)'last_event, tpd_D_P((863 - 1)- 48*7), true),
			110 => (D_dly(9)'last_event, tpd_D_P((863 - 1)- 48*8), true),
			111 => (D_dly(8)'last_event, tpd_D_P((863 - 1)- 48*9), true),
			112 => (D_dly(7)'last_event, tpd_D_P((863 - 1)- 48*10), true),
			113 => (D_dly(6)'last_event, tpd_D_P((863 - 1)- 48*11), true),
			114 => (D_dly(5)'last_event, tpd_D_P((863 - 1)- 48*12), true),
			115 => (D_dly(4)'last_event, tpd_D_P((863 - 1)- 48*13), true),
			116 => (D_dly(3)'last_event, tpd_D_P((863 - 1)- 48*14), true),
			117 => (D_dly(2)'last_event, tpd_D_P((863 - 1)- 48*15), true),
			118 => (D_dly(1)'last_event, tpd_D_P((863 - 1)- 48*16), true),
			119 => (D_dly(0)'last_event, tpd_D_P((863 - 1)- 48*17), true),
			120 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 1)- 48*0), true),
			121 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 1)- 48*1), true),
			122 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 1)- 48*2), true),
			123 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 1)- 48*3), true),
			124 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 1)- 48*4), true),
			125 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 1)- 48*5), true),
			126 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 1)- 48*6), true),
			127 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 1)- 48*7), true),
			128 => (PCIN_dly(46)'last_event, tpd_PCIN_P((2303 - 1)- 48*1), true),
			129 => (PCIN_dly(45)'last_event, tpd_PCIN_P((2303 - 1)- 48*2), true),
			130 => (PCIN_dly(44)'last_event, tpd_PCIN_P((2303 - 1)- 48*3), true),
			131 => (PCIN_dly(43)'last_event, tpd_PCIN_P((2303 - 1)- 48*4), true),
			132 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 1)- 48*5), true),
			133 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 1)- 48*6), true),
			134 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 1)- 48*7), true),
			135 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 1)- 48*8), true),
			136 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 1)- 48*9), true),
			137 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 1)- 48*10), true),
			138 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 1)- 48*11), true),
			139 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 1)- 48*12), true),
			140 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 1)- 48*13), true),
			141 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 1)- 48*14), true),
			142 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 1)- 48*15), true),
			143 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 1)- 48*16), true),
			144 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 1)- 48*17), true),
			145 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 1)- 48*18), true),
			146 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 1)- 48*19), true),
			147 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 1)- 48*20), true),
			148 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 1)- 48*21), true),
			149 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 1)- 48*22), true),
			150 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 1)- 48*23), true),
			151 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 1)- 48*24), true),
			152 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 1)- 48*25), true),
			153 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 1)- 48*26), true),
			154 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 1)- 48*27), true),
			155 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 1)- 48*28), true),
			156 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 1)- 48*29), true),
			157 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 1)- 48*30), true),
			158 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 1)- 48*31), true),
			159 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 1)- 48*32), true),
			160 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 1)- 48*33), true),
			161 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 1)- 48*34), true),
			162 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 1)- 48*35), true),
			163 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 1)- 48*36), true),
			164 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 1)- 48*37), true),
			165 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 1)- 48*38), true),
			166 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 1)- 48*39), true),
			167 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 1)- 48*40), true),
			168 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 1)- 48*41), true),
			169 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 1)- 48*42), true),
			170 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 1)- 48*43), true),
			171 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 1)- 48*44), true),
			172 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 1)- 48*45), true),
			173 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 1)- 48*46), true),
			174 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 1)- 48*47), true),
			175 => (RSTA_dly'last_event, tpd_RSTA_P(46), true),
			176 => (RSTB_dly'last_event, tpd_RSTB_P(46), true),
			177 => (RSTC_dly'last_event, tpd_RSTC_P(46), true),
			178 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(46), true),
			179 => (RSTD_dly'last_event, tpd_RSTD_P(46), true),
			180 => (RSTM_dly'last_event, tpd_RSTM_P(46), true),
			181 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(46), true),
			182 => (RSTP_dly'last_event, tpd_RSTP_P(46), true),
			183 => (CLK_dly'last_event, tpd_CLK_P(46), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(45),
         GlitchData	=> P_GlitchData(45),
         OutSignalName	=> "P(45)",
         OutTemp	=> P_zd(45),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 2)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 2)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 2)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 2)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 2)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 2)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 2)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 2)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 2)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 2)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 2)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 2)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 2)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 2)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 2)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 2)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 2)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 2)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 2)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 2)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 2)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 2)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 2)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 2)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 2)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 2)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 2)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 2)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 2)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 2)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 2)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 2)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 2)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 2)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 2)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 2)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 2)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 2)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 2)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 2)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 2)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 2)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 2)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 2)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 2)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 2)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 2)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 2)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 2)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 2)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 2)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 2)- 48*17), true),
			54 => (C_dly(45)'last_event, tpd_C_P((2303 - 2)- 48*2), true),
			55 => (C_dly(44)'last_event, tpd_C_P((2303 - 2)- 48*3), true),
			56 => (C_dly(43)'last_event, tpd_C_P((2303 - 2)- 48*4), true),
			57 => (C_dly(42)'last_event, tpd_C_P((2303 - 2)- 48*5), true),
			58 => (C_dly(41)'last_event, tpd_C_P((2303 - 2)- 48*6), true),
			59 => (C_dly(40)'last_event, tpd_C_P((2303 - 2)- 48*7), true),
			60 => (C_dly(39)'last_event, tpd_C_P((2303 - 2)- 48*8), true),
			61 => (C_dly(38)'last_event, tpd_C_P((2303 - 2)- 48*9), true),
			62 => (C_dly(37)'last_event, tpd_C_P((2303 - 2)- 48*10), true),
			63 => (C_dly(36)'last_event, tpd_C_P((2303 - 2)- 48*11), true),
			64 => (C_dly(35)'last_event, tpd_C_P((2303 - 2)- 48*12), true),
			65 => (C_dly(34)'last_event, tpd_C_P((2303 - 2)- 48*13), true),
			66 => (C_dly(33)'last_event, tpd_C_P((2303 - 2)- 48*14), true),
			67 => (C_dly(32)'last_event, tpd_C_P((2303 - 2)- 48*15), true),
			68 => (C_dly(31)'last_event, tpd_C_P((2303 - 2)- 48*16), true),
			69 => (C_dly(30)'last_event, tpd_C_P((2303 - 2)- 48*17), true),
			70 => (C_dly(29)'last_event, tpd_C_P((2303 - 2)- 48*18), true),
			71 => (C_dly(28)'last_event, tpd_C_P((2303 - 2)- 48*19), true),
			72 => (C_dly(27)'last_event, tpd_C_P((2303 - 2)- 48*20), true),
			73 => (C_dly(26)'last_event, tpd_C_P((2303 - 2)- 48*21), true),
			74 => (C_dly(25)'last_event, tpd_C_P((2303 - 2)- 48*22), true),
			75 => (C_dly(24)'last_event, tpd_C_P((2303 - 2)- 48*23), true),
			76 => (C_dly(23)'last_event, tpd_C_P((2303 - 2)- 48*24), true),
			77 => (C_dly(22)'last_event, tpd_C_P((2303 - 2)- 48*25), true),
			78 => (C_dly(21)'last_event, tpd_C_P((2303 - 2)- 48*26), true),
			79 => (C_dly(20)'last_event, tpd_C_P((2303 - 2)- 48*27), true),
			80 => (C_dly(19)'last_event, tpd_C_P((2303 - 2)- 48*28), true),
			81 => (C_dly(18)'last_event, tpd_C_P((2303 - 2)- 48*29), true),
			82 => (C_dly(17)'last_event, tpd_C_P((2303 - 2)- 48*30), true),
			83 => (C_dly(16)'last_event, tpd_C_P((2303 - 2)- 48*31), true),
			84 => (C_dly(15)'last_event, tpd_C_P((2303 - 2)- 48*32), true),
			85 => (C_dly(14)'last_event, tpd_C_P((2303 - 2)- 48*33), true),
			86 => (C_dly(13)'last_event, tpd_C_P((2303 - 2)- 48*34), true),
			87 => (C_dly(12)'last_event, tpd_C_P((2303 - 2)- 48*35), true),
			88 => (C_dly(11)'last_event, tpd_C_P((2303 - 2)- 48*36), true),
			89 => (C_dly(10)'last_event, tpd_C_P((2303 - 2)- 48*37), true),
			90 => (C_dly(9)'last_event, tpd_C_P((2303 - 2)- 48*38), true),
			91 => (C_dly(8)'last_event, tpd_C_P((2303 - 2)- 48*39), true),
			92 => (C_dly(7)'last_event, tpd_C_P((2303 - 2)- 48*40), true),
			93 => (C_dly(6)'last_event, tpd_C_P((2303 - 2)- 48*41), true),
			94 => (C_dly(5)'last_event, tpd_C_P((2303 - 2)- 48*42), true),
			95 => (C_dly(4)'last_event, tpd_C_P((2303 - 2)- 48*43), true),
			96 => (C_dly(3)'last_event, tpd_C_P((2303 - 2)- 48*44), true),
			97 => (C_dly(2)'last_event, tpd_C_P((2303 - 2)- 48*45), true),
			98 => (C_dly(1)'last_event, tpd_C_P((2303 - 2)- 48*46), true),
			99 => (C_dly(0)'last_event, tpd_C_P((2303 - 2)- 48*47), true),
			100 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(45), true),
			101 => (D_dly(17)'last_event, tpd_D_P((863 - 2)- 48*0), true),
			102 => (D_dly(16)'last_event, tpd_D_P((863 - 2)- 48*1), true),
			103 => (D_dly(15)'last_event, tpd_D_P((863 - 2)- 48*2), true),
			104 => (D_dly(14)'last_event, tpd_D_P((863 - 2)- 48*3), true),
			105 => (D_dly(13)'last_event, tpd_D_P((863 - 2)- 48*4), true),
			106 => (D_dly(12)'last_event, tpd_D_P((863 - 2)- 48*5), true),
			107 => (D_dly(11)'last_event, tpd_D_P((863 - 2)- 48*6), true),
			108 => (D_dly(10)'last_event, tpd_D_P((863 - 2)- 48*7), true),
			109 => (D_dly(9)'last_event, tpd_D_P((863 - 2)- 48*8), true),
			110 => (D_dly(8)'last_event, tpd_D_P((863 - 2)- 48*9), true),
			111 => (D_dly(7)'last_event, tpd_D_P((863 - 2)- 48*10), true),
			112 => (D_dly(6)'last_event, tpd_D_P((863 - 2)- 48*11), true),
			113 => (D_dly(5)'last_event, tpd_D_P((863 - 2)- 48*12), true),
			114 => (D_dly(4)'last_event, tpd_D_P((863 - 2)- 48*13), true),
			115 => (D_dly(3)'last_event, tpd_D_P((863 - 2)- 48*14), true),
			116 => (D_dly(2)'last_event, tpd_D_P((863 - 2)- 48*15), true),
			117 => (D_dly(1)'last_event, tpd_D_P((863 - 2)- 48*16), true),
			118 => (D_dly(0)'last_event, tpd_D_P((863 - 2)- 48*17), true),
			119 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 2)- 48*0), true),
			120 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 2)- 48*1), true),
			121 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 2)- 48*2), true),
			122 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 2)- 48*3), true),
			123 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 2)- 48*4), true),
			124 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 2)- 48*5), true),
			125 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 2)- 48*6), true),
			126 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 2)- 48*7), true),
			127 => (PCIN_dly(45)'last_event, tpd_PCIN_P((2303 - 2)- 48*2), true),
			128 => (PCIN_dly(44)'last_event, tpd_PCIN_P((2303 - 2)- 48*3), true),
			129 => (PCIN_dly(43)'last_event, tpd_PCIN_P((2303 - 2)- 48*4), true),
			130 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 2)- 48*5), true),
			131 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 2)- 48*6), true),
			132 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 2)- 48*7), true),
			133 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 2)- 48*8), true),
			134 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 2)- 48*9), true),
			135 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 2)- 48*10), true),
			136 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 2)- 48*11), true),
			137 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 2)- 48*12), true),
			138 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 2)- 48*13), true),
			139 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 2)- 48*14), true),
			140 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 2)- 48*15), true),
			141 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 2)- 48*16), true),
			142 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 2)- 48*17), true),
			143 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 2)- 48*18), true),
			144 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 2)- 48*19), true),
			145 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 2)- 48*20), true),
			146 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 2)- 48*21), true),
			147 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 2)- 48*22), true),
			148 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 2)- 48*23), true),
			149 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 2)- 48*24), true),
			150 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 2)- 48*25), true),
			151 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 2)- 48*26), true),
			152 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 2)- 48*27), true),
			153 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 2)- 48*28), true),
			154 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 2)- 48*29), true),
			155 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 2)- 48*30), true),
			156 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 2)- 48*31), true),
			157 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 2)- 48*32), true),
			158 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 2)- 48*33), true),
			159 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 2)- 48*34), true),
			160 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 2)- 48*35), true),
			161 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 2)- 48*36), true),
			162 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 2)- 48*37), true),
			163 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 2)- 48*38), true),
			164 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 2)- 48*39), true),
			165 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 2)- 48*40), true),
			166 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 2)- 48*41), true),
			167 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 2)- 48*42), true),
			168 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 2)- 48*43), true),
			169 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 2)- 48*44), true),
			170 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 2)- 48*45), true),
			171 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 2)- 48*46), true),
			172 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 2)- 48*47), true),
			173 => (RSTA_dly'last_event, tpd_RSTA_P(45), true),
			174 => (RSTB_dly'last_event, tpd_RSTB_P(45), true),
			175 => (RSTC_dly'last_event, tpd_RSTC_P(45), true),
			176 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(45), true),
			177 => (RSTD_dly'last_event, tpd_RSTD_P(45), true),
			178 => (RSTM_dly'last_event, tpd_RSTM_P(45), true),
			179 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(45), true),
			180 => (RSTP_dly'last_event, tpd_RSTP_P(45), true),
			181 => (CLK_dly'last_event, tpd_CLK_P(45), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(44),
         GlitchData	=> P_GlitchData(44),
         OutSignalName	=> "P(44)",
         OutTemp	=> P_zd(44),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 3)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 3)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 3)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 3)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 3)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 3)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 3)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 3)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 3)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 3)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 3)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 3)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 3)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 3)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 3)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 3)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 3)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 3)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 3)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 3)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 3)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 3)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 3)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 3)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 3)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 3)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 3)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 3)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 3)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 3)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 3)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 3)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 3)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 3)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 3)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 3)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 3)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 3)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 3)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 3)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 3)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 3)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 3)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 3)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 3)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 3)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 3)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 3)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 3)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 3)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 3)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 3)- 48*17), true),
			54 => (C_dly(44)'last_event, tpd_C_P((2303 - 3)- 48*3), true),
			55 => (C_dly(43)'last_event, tpd_C_P((2303 - 3)- 48*4), true),
			56 => (C_dly(42)'last_event, tpd_C_P((2303 - 3)- 48*5), true),
			57 => (C_dly(41)'last_event, tpd_C_P((2303 - 3)- 48*6), true),
			58 => (C_dly(40)'last_event, tpd_C_P((2303 - 3)- 48*7), true),
			59 => (C_dly(39)'last_event, tpd_C_P((2303 - 3)- 48*8), true),
			60 => (C_dly(38)'last_event, tpd_C_P((2303 - 3)- 48*9), true),
			61 => (C_dly(37)'last_event, tpd_C_P((2303 - 3)- 48*10), true),
			62 => (C_dly(36)'last_event, tpd_C_P((2303 - 3)- 48*11), true),
			63 => (C_dly(35)'last_event, tpd_C_P((2303 - 3)- 48*12), true),
			64 => (C_dly(34)'last_event, tpd_C_P((2303 - 3)- 48*13), true),
			65 => (C_dly(33)'last_event, tpd_C_P((2303 - 3)- 48*14), true),
			66 => (C_dly(32)'last_event, tpd_C_P((2303 - 3)- 48*15), true),
			67 => (C_dly(31)'last_event, tpd_C_P((2303 - 3)- 48*16), true),
			68 => (C_dly(30)'last_event, tpd_C_P((2303 - 3)- 48*17), true),
			69 => (C_dly(29)'last_event, tpd_C_P((2303 - 3)- 48*18), true),
			70 => (C_dly(28)'last_event, tpd_C_P((2303 - 3)- 48*19), true),
			71 => (C_dly(27)'last_event, tpd_C_P((2303 - 3)- 48*20), true),
			72 => (C_dly(26)'last_event, tpd_C_P((2303 - 3)- 48*21), true),
			73 => (C_dly(25)'last_event, tpd_C_P((2303 - 3)- 48*22), true),
			74 => (C_dly(24)'last_event, tpd_C_P((2303 - 3)- 48*23), true),
			75 => (C_dly(23)'last_event, tpd_C_P((2303 - 3)- 48*24), true),
			76 => (C_dly(22)'last_event, tpd_C_P((2303 - 3)- 48*25), true),
			77 => (C_dly(21)'last_event, tpd_C_P((2303 - 3)- 48*26), true),
			78 => (C_dly(20)'last_event, tpd_C_P((2303 - 3)- 48*27), true),
			79 => (C_dly(19)'last_event, tpd_C_P((2303 - 3)- 48*28), true),
			80 => (C_dly(18)'last_event, tpd_C_P((2303 - 3)- 48*29), true),
			81 => (C_dly(17)'last_event, tpd_C_P((2303 - 3)- 48*30), true),
			82 => (C_dly(16)'last_event, tpd_C_P((2303 - 3)- 48*31), true),
			83 => (C_dly(15)'last_event, tpd_C_P((2303 - 3)- 48*32), true),
			84 => (C_dly(14)'last_event, tpd_C_P((2303 - 3)- 48*33), true),
			85 => (C_dly(13)'last_event, tpd_C_P((2303 - 3)- 48*34), true),
			86 => (C_dly(12)'last_event, tpd_C_P((2303 - 3)- 48*35), true),
			87 => (C_dly(11)'last_event, tpd_C_P((2303 - 3)- 48*36), true),
			88 => (C_dly(10)'last_event, tpd_C_P((2303 - 3)- 48*37), true),
			89 => (C_dly(9)'last_event, tpd_C_P((2303 - 3)- 48*38), true),
			90 => (C_dly(8)'last_event, tpd_C_P((2303 - 3)- 48*39), true),
			91 => (C_dly(7)'last_event, tpd_C_P((2303 - 3)- 48*40), true),
			92 => (C_dly(6)'last_event, tpd_C_P((2303 - 3)- 48*41), true),
			93 => (C_dly(5)'last_event, tpd_C_P((2303 - 3)- 48*42), true),
			94 => (C_dly(4)'last_event, tpd_C_P((2303 - 3)- 48*43), true),
			95 => (C_dly(3)'last_event, tpd_C_P((2303 - 3)- 48*44), true),
			96 => (C_dly(2)'last_event, tpd_C_P((2303 - 3)- 48*45), true),
			97 => (C_dly(1)'last_event, tpd_C_P((2303 - 3)- 48*46), true),
			98 => (C_dly(0)'last_event, tpd_C_P((2303 - 3)- 48*47), true),
			99 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(44), true),
			100 => (D_dly(17)'last_event, tpd_D_P((863 - 3)- 48*0), true),
			101 => (D_dly(16)'last_event, tpd_D_P((863 - 3)- 48*1), true),
			102 => (D_dly(15)'last_event, tpd_D_P((863 - 3)- 48*2), true),
			103 => (D_dly(14)'last_event, tpd_D_P((863 - 3)- 48*3), true),
			104 => (D_dly(13)'last_event, tpd_D_P((863 - 3)- 48*4), true),
			105 => (D_dly(12)'last_event, tpd_D_P((863 - 3)- 48*5), true),
			106 => (D_dly(11)'last_event, tpd_D_P((863 - 3)- 48*6), true),
			107 => (D_dly(10)'last_event, tpd_D_P((863 - 3)- 48*7), true),
			108 => (D_dly(9)'last_event, tpd_D_P((863 - 3)- 48*8), true),
			109 => (D_dly(8)'last_event, tpd_D_P((863 - 3)- 48*9), true),
			110 => (D_dly(7)'last_event, tpd_D_P((863 - 3)- 48*10), true),
			111 => (D_dly(6)'last_event, tpd_D_P((863 - 3)- 48*11), true),
			112 => (D_dly(5)'last_event, tpd_D_P((863 - 3)- 48*12), true),
			113 => (D_dly(4)'last_event, tpd_D_P((863 - 3)- 48*13), true),
			114 => (D_dly(3)'last_event, tpd_D_P((863 - 3)- 48*14), true),
			115 => (D_dly(2)'last_event, tpd_D_P((863 - 3)- 48*15), true),
			116 => (D_dly(1)'last_event, tpd_D_P((863 - 3)- 48*16), true),
			117 => (D_dly(0)'last_event, tpd_D_P((863 - 3)- 48*17), true),
			118 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 3)- 48*0), true),
			119 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 3)- 48*1), true),
			120 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 3)- 48*2), true),
			121 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 3)- 48*3), true),
			122 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 3)- 48*4), true),
			123 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 3)- 48*5), true),
			124 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 3)- 48*6), true),
			125 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 3)- 48*7), true),
			126 => (PCIN_dly(44)'last_event, tpd_PCIN_P((2303 - 3)- 48*3), true),
			127 => (PCIN_dly(43)'last_event, tpd_PCIN_P((2303 - 3)- 48*4), true),
			128 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 3)- 48*5), true),
			129 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 3)- 48*6), true),
			130 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 3)- 48*7), true),
			131 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 3)- 48*8), true),
			132 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 3)- 48*9), true),
			133 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 3)- 48*10), true),
			134 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 3)- 48*11), true),
			135 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 3)- 48*12), true),
			136 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 3)- 48*13), true),
			137 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 3)- 48*14), true),
			138 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 3)- 48*15), true),
			139 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 3)- 48*16), true),
			140 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 3)- 48*17), true),
			141 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 3)- 48*18), true),
			142 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 3)- 48*19), true),
			143 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 3)- 48*20), true),
			144 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 3)- 48*21), true),
			145 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 3)- 48*22), true),
			146 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 3)- 48*23), true),
			147 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 3)- 48*24), true),
			148 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 3)- 48*25), true),
			149 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 3)- 48*26), true),
			150 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 3)- 48*27), true),
			151 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 3)- 48*28), true),
			152 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 3)- 48*29), true),
			153 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 3)- 48*30), true),
			154 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 3)- 48*31), true),
			155 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 3)- 48*32), true),
			156 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 3)- 48*33), true),
			157 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 3)- 48*34), true),
			158 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 3)- 48*35), true),
			159 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 3)- 48*36), true),
			160 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 3)- 48*37), true),
			161 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 3)- 48*38), true),
			162 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 3)- 48*39), true),
			163 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 3)- 48*40), true),
			164 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 3)- 48*41), true),
			165 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 3)- 48*42), true),
			166 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 3)- 48*43), true),
			167 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 3)- 48*44), true),
			168 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 3)- 48*45), true),
			169 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 3)- 48*46), true),
			170 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 3)- 48*47), true),
			171 => (RSTA_dly'last_event, tpd_RSTA_P(44), true),
			172 => (RSTB_dly'last_event, tpd_RSTB_P(44), true),
			173 => (RSTC_dly'last_event, tpd_RSTC_P(44), true),
			174 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(44), true),
			175 => (RSTD_dly'last_event, tpd_RSTD_P(44), true),
			176 => (RSTM_dly'last_event, tpd_RSTM_P(44), true),
			177 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(44), true),
			178 => (RSTP_dly'last_event, tpd_RSTP_P(44), true),
			179 => (CLK_dly'last_event, tpd_CLK_P(44), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(43),
         GlitchData	=> P_GlitchData(43),
         OutSignalName	=> "P(43)",
         OutTemp	=> P_zd(43),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 4)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 4)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 4)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 4)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 4)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 4)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 4)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 4)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 4)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 4)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 4)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 4)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 4)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 4)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 4)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 4)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 4)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 4)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 4)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 4)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 4)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 4)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 4)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 4)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 4)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 4)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 4)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 4)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 4)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 4)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 4)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 4)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 4)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 4)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 4)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 4)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 4)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 4)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 4)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 4)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 4)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 4)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 4)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 4)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 4)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 4)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 4)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 4)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 4)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 4)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 4)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 4)- 48*17), true),
			54 => (C_dly(43)'last_event, tpd_C_P((2303 - 4)- 48*4), true),
			55 => (C_dly(42)'last_event, tpd_C_P((2303 - 4)- 48*5), true),
			56 => (C_dly(41)'last_event, tpd_C_P((2303 - 4)- 48*6), true),
			57 => (C_dly(40)'last_event, tpd_C_P((2303 - 4)- 48*7), true),
			58 => (C_dly(39)'last_event, tpd_C_P((2303 - 4)- 48*8), true),
			59 => (C_dly(38)'last_event, tpd_C_P((2303 - 4)- 48*9), true),
			60 => (C_dly(37)'last_event, tpd_C_P((2303 - 4)- 48*10), true),
			61 => (C_dly(36)'last_event, tpd_C_P((2303 - 4)- 48*11), true),
			62 => (C_dly(35)'last_event, tpd_C_P((2303 - 4)- 48*12), true),
			63 => (C_dly(34)'last_event, tpd_C_P((2303 - 4)- 48*13), true),
			64 => (C_dly(33)'last_event, tpd_C_P((2303 - 4)- 48*14), true),
			65 => (C_dly(32)'last_event, tpd_C_P((2303 - 4)- 48*15), true),
			66 => (C_dly(31)'last_event, tpd_C_P((2303 - 4)- 48*16), true),
			67 => (C_dly(30)'last_event, tpd_C_P((2303 - 4)- 48*17), true),
			68 => (C_dly(29)'last_event, tpd_C_P((2303 - 4)- 48*18), true),
			69 => (C_dly(28)'last_event, tpd_C_P((2303 - 4)- 48*19), true),
			70 => (C_dly(27)'last_event, tpd_C_P((2303 - 4)- 48*20), true),
			71 => (C_dly(26)'last_event, tpd_C_P((2303 - 4)- 48*21), true),
			72 => (C_dly(25)'last_event, tpd_C_P((2303 - 4)- 48*22), true),
			73 => (C_dly(24)'last_event, tpd_C_P((2303 - 4)- 48*23), true),
			74 => (C_dly(23)'last_event, tpd_C_P((2303 - 4)- 48*24), true),
			75 => (C_dly(22)'last_event, tpd_C_P((2303 - 4)- 48*25), true),
			76 => (C_dly(21)'last_event, tpd_C_P((2303 - 4)- 48*26), true),
			77 => (C_dly(20)'last_event, tpd_C_P((2303 - 4)- 48*27), true),
			78 => (C_dly(19)'last_event, tpd_C_P((2303 - 4)- 48*28), true),
			79 => (C_dly(18)'last_event, tpd_C_P((2303 - 4)- 48*29), true),
			80 => (C_dly(17)'last_event, tpd_C_P((2303 - 4)- 48*30), true),
			81 => (C_dly(16)'last_event, tpd_C_P((2303 - 4)- 48*31), true),
			82 => (C_dly(15)'last_event, tpd_C_P((2303 - 4)- 48*32), true),
			83 => (C_dly(14)'last_event, tpd_C_P((2303 - 4)- 48*33), true),
			84 => (C_dly(13)'last_event, tpd_C_P((2303 - 4)- 48*34), true),
			85 => (C_dly(12)'last_event, tpd_C_P((2303 - 4)- 48*35), true),
			86 => (C_dly(11)'last_event, tpd_C_P((2303 - 4)- 48*36), true),
			87 => (C_dly(10)'last_event, tpd_C_P((2303 - 4)- 48*37), true),
			88 => (C_dly(9)'last_event, tpd_C_P((2303 - 4)- 48*38), true),
			89 => (C_dly(8)'last_event, tpd_C_P((2303 - 4)- 48*39), true),
			90 => (C_dly(7)'last_event, tpd_C_P((2303 - 4)- 48*40), true),
			91 => (C_dly(6)'last_event, tpd_C_P((2303 - 4)- 48*41), true),
			92 => (C_dly(5)'last_event, tpd_C_P((2303 - 4)- 48*42), true),
			93 => (C_dly(4)'last_event, tpd_C_P((2303 - 4)- 48*43), true),
			94 => (C_dly(3)'last_event, tpd_C_P((2303 - 4)- 48*44), true),
			95 => (C_dly(2)'last_event, tpd_C_P((2303 - 4)- 48*45), true),
			96 => (C_dly(1)'last_event, tpd_C_P((2303 - 4)- 48*46), true),
			97 => (C_dly(0)'last_event, tpd_C_P((2303 - 4)- 48*47), true),
			98 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(43), true),
			99 => (D_dly(17)'last_event, tpd_D_P((863 - 4)- 48*0), true),
			100 => (D_dly(16)'last_event, tpd_D_P((863 - 4)- 48*1), true),
			101 => (D_dly(15)'last_event, tpd_D_P((863 - 4)- 48*2), true),
			102 => (D_dly(14)'last_event, tpd_D_P((863 - 4)- 48*3), true),
			103 => (D_dly(13)'last_event, tpd_D_P((863 - 4)- 48*4), true),
			104 => (D_dly(12)'last_event, tpd_D_P((863 - 4)- 48*5), true),
			105 => (D_dly(11)'last_event, tpd_D_P((863 - 4)- 48*6), true),
			106 => (D_dly(10)'last_event, tpd_D_P((863 - 4)- 48*7), true),
			107 => (D_dly(9)'last_event, tpd_D_P((863 - 4)- 48*8), true),
			108 => (D_dly(8)'last_event, tpd_D_P((863 - 4)- 48*9), true),
			109 => (D_dly(7)'last_event, tpd_D_P((863 - 4)- 48*10), true),
			110 => (D_dly(6)'last_event, tpd_D_P((863 - 4)- 48*11), true),
			111 => (D_dly(5)'last_event, tpd_D_P((863 - 4)- 48*12), true),
			112 => (D_dly(4)'last_event, tpd_D_P((863 - 4)- 48*13), true),
			113 => (D_dly(3)'last_event, tpd_D_P((863 - 4)- 48*14), true),
			114 => (D_dly(2)'last_event, tpd_D_P((863 - 4)- 48*15), true),
			115 => (D_dly(1)'last_event, tpd_D_P((863 - 4)- 48*16), true),
			116 => (D_dly(0)'last_event, tpd_D_P((863 - 4)- 48*17), true),
			117 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 4)- 48*0), true),
			118 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 4)- 48*1), true),
			119 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 4)- 48*2), true),
			120 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 4)- 48*3), true),
			121 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 4)- 48*4), true),
			122 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 4)- 48*5), true),
			123 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 4)- 48*6), true),
			124 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 4)- 48*7), true),
			125 => (PCIN_dly(43)'last_event, tpd_PCIN_P((2303 - 4)- 48*4), true),
			126 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 4)- 48*5), true),
			127 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 4)- 48*6), true),
			128 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 4)- 48*7), true),
			129 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 4)- 48*8), true),
			130 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 4)- 48*9), true),
			131 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 4)- 48*10), true),
			132 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 4)- 48*11), true),
			133 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 4)- 48*12), true),
			134 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 4)- 48*13), true),
			135 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 4)- 48*14), true),
			136 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 4)- 48*15), true),
			137 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 4)- 48*16), true),
			138 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 4)- 48*17), true),
			139 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 4)- 48*18), true),
			140 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 4)- 48*19), true),
			141 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 4)- 48*20), true),
			142 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 4)- 48*21), true),
			143 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 4)- 48*22), true),
			144 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 4)- 48*23), true),
			145 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 4)- 48*24), true),
			146 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 4)- 48*25), true),
			147 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 4)- 48*26), true),
			148 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 4)- 48*27), true),
			149 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 4)- 48*28), true),
			150 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 4)- 48*29), true),
			151 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 4)- 48*30), true),
			152 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 4)- 48*31), true),
			153 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 4)- 48*32), true),
			154 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 4)- 48*33), true),
			155 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 4)- 48*34), true),
			156 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 4)- 48*35), true),
			157 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 4)- 48*36), true),
			158 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 4)- 48*37), true),
			159 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 4)- 48*38), true),
			160 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 4)- 48*39), true),
			161 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 4)- 48*40), true),
			162 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 4)- 48*41), true),
			163 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 4)- 48*42), true),
			164 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 4)- 48*43), true),
			165 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 4)- 48*44), true),
			166 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 4)- 48*45), true),
			167 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 4)- 48*46), true),
			168 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 4)- 48*47), true),
			169 => (RSTA_dly'last_event, tpd_RSTA_P(43), true),
			170 => (RSTB_dly'last_event, tpd_RSTB_P(43), true),
			171 => (RSTC_dly'last_event, tpd_RSTC_P(43), true),
			172 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(43), true),
			173 => (RSTD_dly'last_event, tpd_RSTD_P(43), true),
			174 => (RSTM_dly'last_event, tpd_RSTM_P(43), true),
			175 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(43), true),
			176 => (RSTP_dly'last_event, tpd_RSTP_P(43), true),
			177 => (CLK_dly'last_event, tpd_CLK_P(43), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(42),
         GlitchData	=> P_GlitchData(42),
         OutSignalName	=> "P(42)",
         OutTemp	=> P_zd(42),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 5)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 5)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 5)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 5)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 5)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 5)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 5)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 5)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 5)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 5)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 5)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 5)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 5)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 5)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 5)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 5)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 5)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 5)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 5)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 5)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 5)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 5)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 5)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 5)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 5)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 5)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 5)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 5)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 5)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 5)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 5)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 5)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 5)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 5)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 5)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 5)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 5)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 5)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 5)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 5)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 5)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 5)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 5)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 5)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 5)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 5)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 5)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 5)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 5)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 5)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 5)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 5)- 48*17), true),
			54 => (C_dly(42)'last_event, tpd_C_P((2303 - 5)- 48*5), true),
			55 => (C_dly(41)'last_event, tpd_C_P((2303 - 5)- 48*6), true),
			56 => (C_dly(40)'last_event, tpd_C_P((2303 - 5)- 48*7), true),
			57 => (C_dly(39)'last_event, tpd_C_P((2303 - 5)- 48*8), true),
			58 => (C_dly(38)'last_event, tpd_C_P((2303 - 5)- 48*9), true),
			59 => (C_dly(37)'last_event, tpd_C_P((2303 - 5)- 48*10), true),
			60 => (C_dly(36)'last_event, tpd_C_P((2303 - 5)- 48*11), true),
			61 => (C_dly(35)'last_event, tpd_C_P((2303 - 5)- 48*12), true),
			62 => (C_dly(34)'last_event, tpd_C_P((2303 - 5)- 48*13), true),
			63 => (C_dly(33)'last_event, tpd_C_P((2303 - 5)- 48*14), true),
			64 => (C_dly(32)'last_event, tpd_C_P((2303 - 5)- 48*15), true),
			65 => (C_dly(31)'last_event, tpd_C_P((2303 - 5)- 48*16), true),
			66 => (C_dly(30)'last_event, tpd_C_P((2303 - 5)- 48*17), true),
			67 => (C_dly(29)'last_event, tpd_C_P((2303 - 5)- 48*18), true),
			68 => (C_dly(28)'last_event, tpd_C_P((2303 - 5)- 48*19), true),
			69 => (C_dly(27)'last_event, tpd_C_P((2303 - 5)- 48*20), true),
			70 => (C_dly(26)'last_event, tpd_C_P((2303 - 5)- 48*21), true),
			71 => (C_dly(25)'last_event, tpd_C_P((2303 - 5)- 48*22), true),
			72 => (C_dly(24)'last_event, tpd_C_P((2303 - 5)- 48*23), true),
			73 => (C_dly(23)'last_event, tpd_C_P((2303 - 5)- 48*24), true),
			74 => (C_dly(22)'last_event, tpd_C_P((2303 - 5)- 48*25), true),
			75 => (C_dly(21)'last_event, tpd_C_P((2303 - 5)- 48*26), true),
			76 => (C_dly(20)'last_event, tpd_C_P((2303 - 5)- 48*27), true),
			77 => (C_dly(19)'last_event, tpd_C_P((2303 - 5)- 48*28), true),
			78 => (C_dly(18)'last_event, tpd_C_P((2303 - 5)- 48*29), true),
			79 => (C_dly(17)'last_event, tpd_C_P((2303 - 5)- 48*30), true),
			80 => (C_dly(16)'last_event, tpd_C_P((2303 - 5)- 48*31), true),
			81 => (C_dly(15)'last_event, tpd_C_P((2303 - 5)- 48*32), true),
			82 => (C_dly(14)'last_event, tpd_C_P((2303 - 5)- 48*33), true),
			83 => (C_dly(13)'last_event, tpd_C_P((2303 - 5)- 48*34), true),
			84 => (C_dly(12)'last_event, tpd_C_P((2303 - 5)- 48*35), true),
			85 => (C_dly(11)'last_event, tpd_C_P((2303 - 5)- 48*36), true),
			86 => (C_dly(10)'last_event, tpd_C_P((2303 - 5)- 48*37), true),
			87 => (C_dly(9)'last_event, tpd_C_P((2303 - 5)- 48*38), true),
			88 => (C_dly(8)'last_event, tpd_C_P((2303 - 5)- 48*39), true),
			89 => (C_dly(7)'last_event, tpd_C_P((2303 - 5)- 48*40), true),
			90 => (C_dly(6)'last_event, tpd_C_P((2303 - 5)- 48*41), true),
			91 => (C_dly(5)'last_event, tpd_C_P((2303 - 5)- 48*42), true),
			92 => (C_dly(4)'last_event, tpd_C_P((2303 - 5)- 48*43), true),
			93 => (C_dly(3)'last_event, tpd_C_P((2303 - 5)- 48*44), true),
			94 => (C_dly(2)'last_event, tpd_C_P((2303 - 5)- 48*45), true),
			95 => (C_dly(1)'last_event, tpd_C_P((2303 - 5)- 48*46), true),
			96 => (C_dly(0)'last_event, tpd_C_P((2303 - 5)- 48*47), true),
			97 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(42), true),
			98 => (D_dly(17)'last_event, tpd_D_P((863 - 5)- 48*0), true),
			99 => (D_dly(16)'last_event, tpd_D_P((863 - 5)- 48*1), true),
			100 => (D_dly(15)'last_event, tpd_D_P((863 - 5)- 48*2), true),
			101 => (D_dly(14)'last_event, tpd_D_P((863 - 5)- 48*3), true),
			102 => (D_dly(13)'last_event, tpd_D_P((863 - 5)- 48*4), true),
			103 => (D_dly(12)'last_event, tpd_D_P((863 - 5)- 48*5), true),
			104 => (D_dly(11)'last_event, tpd_D_P((863 - 5)- 48*6), true),
			105 => (D_dly(10)'last_event, tpd_D_P((863 - 5)- 48*7), true),
			106 => (D_dly(9)'last_event, tpd_D_P((863 - 5)- 48*8), true),
			107 => (D_dly(8)'last_event, tpd_D_P((863 - 5)- 48*9), true),
			108 => (D_dly(7)'last_event, tpd_D_P((863 - 5)- 48*10), true),
			109 => (D_dly(6)'last_event, tpd_D_P((863 - 5)- 48*11), true),
			110 => (D_dly(5)'last_event, tpd_D_P((863 - 5)- 48*12), true),
			111 => (D_dly(4)'last_event, tpd_D_P((863 - 5)- 48*13), true),
			112 => (D_dly(3)'last_event, tpd_D_P((863 - 5)- 48*14), true),
			113 => (D_dly(2)'last_event, tpd_D_P((863 - 5)- 48*15), true),
			114 => (D_dly(1)'last_event, tpd_D_P((863 - 5)- 48*16), true),
			115 => (D_dly(0)'last_event, tpd_D_P((863 - 5)- 48*17), true),
			116 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 5)- 48*0), true),
			117 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 5)- 48*1), true),
			118 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 5)- 48*2), true),
			119 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 5)- 48*3), true),
			120 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 5)- 48*4), true),
			121 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 5)- 48*5), true),
			122 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 5)- 48*6), true),
			123 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 5)- 48*7), true),
			124 => (PCIN_dly(42)'last_event, tpd_PCIN_P((2303 - 5)- 48*5), true),
			125 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 5)- 48*6), true),
			126 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 5)- 48*7), true),
			127 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 5)- 48*8), true),
			128 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 5)- 48*9), true),
			129 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 5)- 48*10), true),
			130 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 5)- 48*11), true),
			131 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 5)- 48*12), true),
			132 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 5)- 48*13), true),
			133 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 5)- 48*14), true),
			134 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 5)- 48*15), true),
			135 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 5)- 48*16), true),
			136 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 5)- 48*17), true),
			137 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 5)- 48*18), true),
			138 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 5)- 48*19), true),
			139 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 5)- 48*20), true),
			140 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 5)- 48*21), true),
			141 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 5)- 48*22), true),
			142 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 5)- 48*23), true),
			143 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 5)- 48*24), true),
			144 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 5)- 48*25), true),
			145 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 5)- 48*26), true),
			146 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 5)- 48*27), true),
			147 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 5)- 48*28), true),
			148 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 5)- 48*29), true),
			149 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 5)- 48*30), true),
			150 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 5)- 48*31), true),
			151 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 5)- 48*32), true),
			152 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 5)- 48*33), true),
			153 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 5)- 48*34), true),
			154 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 5)- 48*35), true),
			155 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 5)- 48*36), true),
			156 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 5)- 48*37), true),
			157 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 5)- 48*38), true),
			158 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 5)- 48*39), true),
			159 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 5)- 48*40), true),
			160 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 5)- 48*41), true),
			161 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 5)- 48*42), true),
			162 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 5)- 48*43), true),
			163 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 5)- 48*44), true),
			164 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 5)- 48*45), true),
			165 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 5)- 48*46), true),
			166 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 5)- 48*47), true),
			167 => (RSTA_dly'last_event, tpd_RSTA_P(42), true),
			168 => (RSTB_dly'last_event, tpd_RSTB_P(42), true),
			169 => (RSTC_dly'last_event, tpd_RSTC_P(42), true),
			170 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(42), true),
			171 => (RSTD_dly'last_event, tpd_RSTD_P(42), true),
			172 => (RSTM_dly'last_event, tpd_RSTM_P(42), true),
			173 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(42), true),
			174 => (RSTP_dly'last_event, tpd_RSTP_P(42), true),
			175 => (CLK_dly'last_event, tpd_CLK_P(42), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(41),
         GlitchData	=> P_GlitchData(41),
         OutSignalName	=> "P(41)",
         OutTemp	=> P_zd(41),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 6)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 6)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 6)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 6)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 6)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 6)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 6)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 6)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 6)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 6)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 6)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 6)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 6)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 6)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 6)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 6)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 6)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 6)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 6)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 6)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 6)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 6)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 6)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 6)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 6)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 6)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 6)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 6)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 6)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 6)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 6)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 6)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 6)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 6)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 6)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 6)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 6)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 6)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 6)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 6)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 6)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 6)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 6)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 6)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 6)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 6)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 6)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 6)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 6)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 6)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 6)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 6)- 48*17), true),
			54 => (C_dly(41)'last_event, tpd_C_P((2303 - 6)- 48*6), true),
			55 => (C_dly(40)'last_event, tpd_C_P((2303 - 6)- 48*7), true),
			56 => (C_dly(39)'last_event, tpd_C_P((2303 - 6)- 48*8), true),
			57 => (C_dly(38)'last_event, tpd_C_P((2303 - 6)- 48*9), true),
			58 => (C_dly(37)'last_event, tpd_C_P((2303 - 6)- 48*10), true),
			59 => (C_dly(36)'last_event, tpd_C_P((2303 - 6)- 48*11), true),
			60 => (C_dly(35)'last_event, tpd_C_P((2303 - 6)- 48*12), true),
			61 => (C_dly(34)'last_event, tpd_C_P((2303 - 6)- 48*13), true),
			62 => (C_dly(33)'last_event, tpd_C_P((2303 - 6)- 48*14), true),
			63 => (C_dly(32)'last_event, tpd_C_P((2303 - 6)- 48*15), true),
			64 => (C_dly(31)'last_event, tpd_C_P((2303 - 6)- 48*16), true),
			65 => (C_dly(30)'last_event, tpd_C_P((2303 - 6)- 48*17), true),
			66 => (C_dly(29)'last_event, tpd_C_P((2303 - 6)- 48*18), true),
			67 => (C_dly(28)'last_event, tpd_C_P((2303 - 6)- 48*19), true),
			68 => (C_dly(27)'last_event, tpd_C_P((2303 - 6)- 48*20), true),
			69 => (C_dly(26)'last_event, tpd_C_P((2303 - 6)- 48*21), true),
			70 => (C_dly(25)'last_event, tpd_C_P((2303 - 6)- 48*22), true),
			71 => (C_dly(24)'last_event, tpd_C_P((2303 - 6)- 48*23), true),
			72 => (C_dly(23)'last_event, tpd_C_P((2303 - 6)- 48*24), true),
			73 => (C_dly(22)'last_event, tpd_C_P((2303 - 6)- 48*25), true),
			74 => (C_dly(21)'last_event, tpd_C_P((2303 - 6)- 48*26), true),
			75 => (C_dly(20)'last_event, tpd_C_P((2303 - 6)- 48*27), true),
			76 => (C_dly(19)'last_event, tpd_C_P((2303 - 6)- 48*28), true),
			77 => (C_dly(18)'last_event, tpd_C_P((2303 - 6)- 48*29), true),
			78 => (C_dly(17)'last_event, tpd_C_P((2303 - 6)- 48*30), true),
			79 => (C_dly(16)'last_event, tpd_C_P((2303 - 6)- 48*31), true),
			80 => (C_dly(15)'last_event, tpd_C_P((2303 - 6)- 48*32), true),
			81 => (C_dly(14)'last_event, tpd_C_P((2303 - 6)- 48*33), true),
			82 => (C_dly(13)'last_event, tpd_C_P((2303 - 6)- 48*34), true),
			83 => (C_dly(12)'last_event, tpd_C_P((2303 - 6)- 48*35), true),
			84 => (C_dly(11)'last_event, tpd_C_P((2303 - 6)- 48*36), true),
			85 => (C_dly(10)'last_event, tpd_C_P((2303 - 6)- 48*37), true),
			86 => (C_dly(9)'last_event, tpd_C_P((2303 - 6)- 48*38), true),
			87 => (C_dly(8)'last_event, tpd_C_P((2303 - 6)- 48*39), true),
			88 => (C_dly(7)'last_event, tpd_C_P((2303 - 6)- 48*40), true),
			89 => (C_dly(6)'last_event, tpd_C_P((2303 - 6)- 48*41), true),
			90 => (C_dly(5)'last_event, tpd_C_P((2303 - 6)- 48*42), true),
			91 => (C_dly(4)'last_event, tpd_C_P((2303 - 6)- 48*43), true),
			92 => (C_dly(3)'last_event, tpd_C_P((2303 - 6)- 48*44), true),
			93 => (C_dly(2)'last_event, tpd_C_P((2303 - 6)- 48*45), true),
			94 => (C_dly(1)'last_event, tpd_C_P((2303 - 6)- 48*46), true),
			95 => (C_dly(0)'last_event, tpd_C_P((2303 - 6)- 48*47), true),
			96 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(41), true),
			97 => (D_dly(17)'last_event, tpd_D_P((863 - 6)- 48*0), true),
			98 => (D_dly(16)'last_event, tpd_D_P((863 - 6)- 48*1), true),
			99 => (D_dly(15)'last_event, tpd_D_P((863 - 6)- 48*2), true),
			100 => (D_dly(14)'last_event, tpd_D_P((863 - 6)- 48*3), true),
			101 => (D_dly(13)'last_event, tpd_D_P((863 - 6)- 48*4), true),
			102 => (D_dly(12)'last_event, tpd_D_P((863 - 6)- 48*5), true),
			103 => (D_dly(11)'last_event, tpd_D_P((863 - 6)- 48*6), true),
			104 => (D_dly(10)'last_event, tpd_D_P((863 - 6)- 48*7), true),
			105 => (D_dly(9)'last_event, tpd_D_P((863 - 6)- 48*8), true),
			106 => (D_dly(8)'last_event, tpd_D_P((863 - 6)- 48*9), true),
			107 => (D_dly(7)'last_event, tpd_D_P((863 - 6)- 48*10), true),
			108 => (D_dly(6)'last_event, tpd_D_P((863 - 6)- 48*11), true),
			109 => (D_dly(5)'last_event, tpd_D_P((863 - 6)- 48*12), true),
			110 => (D_dly(4)'last_event, tpd_D_P((863 - 6)- 48*13), true),
			111 => (D_dly(3)'last_event, tpd_D_P((863 - 6)- 48*14), true),
			112 => (D_dly(2)'last_event, tpd_D_P((863 - 6)- 48*15), true),
			113 => (D_dly(1)'last_event, tpd_D_P((863 - 6)- 48*16), true),
			114 => (D_dly(0)'last_event, tpd_D_P((863 - 6)- 48*17), true),
			115 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 6)- 48*0), true),
			116 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 6)- 48*1), true),
			117 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 6)- 48*2), true),
			118 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 6)- 48*3), true),
			119 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 6)- 48*4), true),
			120 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 6)- 48*5), true),
			121 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 6)- 48*6), true),
			122 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 6)- 48*7), true),
			123 => (PCIN_dly(41)'last_event, tpd_PCIN_P((2303 - 6)- 48*6), true),
			124 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 6)- 48*7), true),
			125 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 6)- 48*8), true),
			126 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 6)- 48*9), true),
			127 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 6)- 48*10), true),
			128 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 6)- 48*11), true),
			129 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 6)- 48*12), true),
			130 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 6)- 48*13), true),
			131 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 6)- 48*14), true),
			132 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 6)- 48*15), true),
			133 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 6)- 48*16), true),
			134 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 6)- 48*17), true),
			135 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 6)- 48*18), true),
			136 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 6)- 48*19), true),
			137 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 6)- 48*20), true),
			138 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 6)- 48*21), true),
			139 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 6)- 48*22), true),
			140 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 6)- 48*23), true),
			141 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 6)- 48*24), true),
			142 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 6)- 48*25), true),
			143 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 6)- 48*26), true),
			144 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 6)- 48*27), true),
			145 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 6)- 48*28), true),
			146 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 6)- 48*29), true),
			147 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 6)- 48*30), true),
			148 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 6)- 48*31), true),
			149 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 6)- 48*32), true),
			150 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 6)- 48*33), true),
			151 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 6)- 48*34), true),
			152 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 6)- 48*35), true),
			153 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 6)- 48*36), true),
			154 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 6)- 48*37), true),
			155 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 6)- 48*38), true),
			156 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 6)- 48*39), true),
			157 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 6)- 48*40), true),
			158 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 6)- 48*41), true),
			159 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 6)- 48*42), true),
			160 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 6)- 48*43), true),
			161 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 6)- 48*44), true),
			162 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 6)- 48*45), true),
			163 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 6)- 48*46), true),
			164 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 6)- 48*47), true),
			165 => (RSTA_dly'last_event, tpd_RSTA_P(41), true),
			166 => (RSTB_dly'last_event, tpd_RSTB_P(41), true),
			167 => (RSTC_dly'last_event, tpd_RSTC_P(41), true),
			168 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(41), true),
			169 => (RSTD_dly'last_event, tpd_RSTD_P(41), true),
			170 => (RSTM_dly'last_event, tpd_RSTM_P(41), true),
			171 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(41), true),
			172 => (RSTP_dly'last_event, tpd_RSTP_P(41), true),
			173 => (CLK_dly'last_event, tpd_CLK_P(41), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(40),
         GlitchData	=> P_GlitchData(40),
         OutSignalName	=> "P(40)",
         OutTemp	=> P_zd(40),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 7)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 7)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 7)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 7)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 7)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 7)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 7)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 7)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 7)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 7)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 7)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 7)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 7)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 7)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 7)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 7)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 7)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 7)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 7)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 7)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 7)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 7)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 7)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 7)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 7)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 7)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 7)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 7)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 7)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 7)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 7)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 7)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 7)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 7)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 7)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 7)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 7)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 7)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 7)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 7)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 7)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 7)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 7)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 7)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 7)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 7)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 7)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 7)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 7)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 7)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 7)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 7)- 48*17), true),
			54 => (C_dly(40)'last_event, tpd_C_P((2303 - 7)- 48*7), true),
			55 => (C_dly(39)'last_event, tpd_C_P((2303 - 7)- 48*8), true),
			56 => (C_dly(38)'last_event, tpd_C_P((2303 - 7)- 48*9), true),
			57 => (C_dly(37)'last_event, tpd_C_P((2303 - 7)- 48*10), true),
			58 => (C_dly(36)'last_event, tpd_C_P((2303 - 7)- 48*11), true),
			59 => (C_dly(35)'last_event, tpd_C_P((2303 - 7)- 48*12), true),
			60 => (C_dly(34)'last_event, tpd_C_P((2303 - 7)- 48*13), true),
			61 => (C_dly(33)'last_event, tpd_C_P((2303 - 7)- 48*14), true),
			62 => (C_dly(32)'last_event, tpd_C_P((2303 - 7)- 48*15), true),
			63 => (C_dly(31)'last_event, tpd_C_P((2303 - 7)- 48*16), true),
			64 => (C_dly(30)'last_event, tpd_C_P((2303 - 7)- 48*17), true),
			65 => (C_dly(29)'last_event, tpd_C_P((2303 - 7)- 48*18), true),
			66 => (C_dly(28)'last_event, tpd_C_P((2303 - 7)- 48*19), true),
			67 => (C_dly(27)'last_event, tpd_C_P((2303 - 7)- 48*20), true),
			68 => (C_dly(26)'last_event, tpd_C_P((2303 - 7)- 48*21), true),
			69 => (C_dly(25)'last_event, tpd_C_P((2303 - 7)- 48*22), true),
			70 => (C_dly(24)'last_event, tpd_C_P((2303 - 7)- 48*23), true),
			71 => (C_dly(23)'last_event, tpd_C_P((2303 - 7)- 48*24), true),
			72 => (C_dly(22)'last_event, tpd_C_P((2303 - 7)- 48*25), true),
			73 => (C_dly(21)'last_event, tpd_C_P((2303 - 7)- 48*26), true),
			74 => (C_dly(20)'last_event, tpd_C_P((2303 - 7)- 48*27), true),
			75 => (C_dly(19)'last_event, tpd_C_P((2303 - 7)- 48*28), true),
			76 => (C_dly(18)'last_event, tpd_C_P((2303 - 7)- 48*29), true),
			77 => (C_dly(17)'last_event, tpd_C_P((2303 - 7)- 48*30), true),
			78 => (C_dly(16)'last_event, tpd_C_P((2303 - 7)- 48*31), true),
			79 => (C_dly(15)'last_event, tpd_C_P((2303 - 7)- 48*32), true),
			80 => (C_dly(14)'last_event, tpd_C_P((2303 - 7)- 48*33), true),
			81 => (C_dly(13)'last_event, tpd_C_P((2303 - 7)- 48*34), true),
			82 => (C_dly(12)'last_event, tpd_C_P((2303 - 7)- 48*35), true),
			83 => (C_dly(11)'last_event, tpd_C_P((2303 - 7)- 48*36), true),
			84 => (C_dly(10)'last_event, tpd_C_P((2303 - 7)- 48*37), true),
			85 => (C_dly(9)'last_event, tpd_C_P((2303 - 7)- 48*38), true),
			86 => (C_dly(8)'last_event, tpd_C_P((2303 - 7)- 48*39), true),
			87 => (C_dly(7)'last_event, tpd_C_P((2303 - 7)- 48*40), true),
			88 => (C_dly(6)'last_event, tpd_C_P((2303 - 7)- 48*41), true),
			89 => (C_dly(5)'last_event, tpd_C_P((2303 - 7)- 48*42), true),
			90 => (C_dly(4)'last_event, tpd_C_P((2303 - 7)- 48*43), true),
			91 => (C_dly(3)'last_event, tpd_C_P((2303 - 7)- 48*44), true),
			92 => (C_dly(2)'last_event, tpd_C_P((2303 - 7)- 48*45), true),
			93 => (C_dly(1)'last_event, tpd_C_P((2303 - 7)- 48*46), true),
			94 => (C_dly(0)'last_event, tpd_C_P((2303 - 7)- 48*47), true),
			95 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(40), true),
			96 => (D_dly(17)'last_event, tpd_D_P((863 - 7)- 48*0), true),
			97 => (D_dly(16)'last_event, tpd_D_P((863 - 7)- 48*1), true),
			98 => (D_dly(15)'last_event, tpd_D_P((863 - 7)- 48*2), true),
			99 => (D_dly(14)'last_event, tpd_D_P((863 - 7)- 48*3), true),
			100 => (D_dly(13)'last_event, tpd_D_P((863 - 7)- 48*4), true),
			101 => (D_dly(12)'last_event, tpd_D_P((863 - 7)- 48*5), true),
			102 => (D_dly(11)'last_event, tpd_D_P((863 - 7)- 48*6), true),
			103 => (D_dly(10)'last_event, tpd_D_P((863 - 7)- 48*7), true),
			104 => (D_dly(9)'last_event, tpd_D_P((863 - 7)- 48*8), true),
			105 => (D_dly(8)'last_event, tpd_D_P((863 - 7)- 48*9), true),
			106 => (D_dly(7)'last_event, tpd_D_P((863 - 7)- 48*10), true),
			107 => (D_dly(6)'last_event, tpd_D_P((863 - 7)- 48*11), true),
			108 => (D_dly(5)'last_event, tpd_D_P((863 - 7)- 48*12), true),
			109 => (D_dly(4)'last_event, tpd_D_P((863 - 7)- 48*13), true),
			110 => (D_dly(3)'last_event, tpd_D_P((863 - 7)- 48*14), true),
			111 => (D_dly(2)'last_event, tpd_D_P((863 - 7)- 48*15), true),
			112 => (D_dly(1)'last_event, tpd_D_P((863 - 7)- 48*16), true),
			113 => (D_dly(0)'last_event, tpd_D_P((863 - 7)- 48*17), true),
			114 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 7)- 48*0), true),
			115 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 7)- 48*1), true),
			116 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 7)- 48*2), true),
			117 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 7)- 48*3), true),
			118 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 7)- 48*4), true),
			119 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 7)- 48*5), true),
			120 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 7)- 48*6), true),
			121 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 7)- 48*7), true),
			122 => (PCIN_dly(40)'last_event, tpd_PCIN_P((2303 - 7)- 48*7), true),
			123 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 7)- 48*8), true),
			124 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 7)- 48*9), true),
			125 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 7)- 48*10), true),
			126 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 7)- 48*11), true),
			127 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 7)- 48*12), true),
			128 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 7)- 48*13), true),
			129 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 7)- 48*14), true),
			130 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 7)- 48*15), true),
			131 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 7)- 48*16), true),
			132 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 7)- 48*17), true),
			133 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 7)- 48*18), true),
			134 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 7)- 48*19), true),
			135 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 7)- 48*20), true),
			136 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 7)- 48*21), true),
			137 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 7)- 48*22), true),
			138 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 7)- 48*23), true),
			139 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 7)- 48*24), true),
			140 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 7)- 48*25), true),
			141 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 7)- 48*26), true),
			142 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 7)- 48*27), true),
			143 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 7)- 48*28), true),
			144 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 7)- 48*29), true),
			145 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 7)- 48*30), true),
			146 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 7)- 48*31), true),
			147 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 7)- 48*32), true),
			148 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 7)- 48*33), true),
			149 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 7)- 48*34), true),
			150 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 7)- 48*35), true),
			151 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 7)- 48*36), true),
			152 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 7)- 48*37), true),
			153 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 7)- 48*38), true),
			154 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 7)- 48*39), true),
			155 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 7)- 48*40), true),
			156 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 7)- 48*41), true),
			157 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 7)- 48*42), true),
			158 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 7)- 48*43), true),
			159 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 7)- 48*44), true),
			160 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 7)- 48*45), true),
			161 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 7)- 48*46), true),
			162 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 7)- 48*47), true),
			163 => (RSTA_dly'last_event, tpd_RSTA_P(40), true),
			164 => (RSTB_dly'last_event, tpd_RSTB_P(40), true),
			165 => (RSTC_dly'last_event, tpd_RSTC_P(40), true),
			166 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(40), true),
			167 => (RSTD_dly'last_event, tpd_RSTD_P(40), true),
			168 => (RSTM_dly'last_event, tpd_RSTM_P(40), true),
			169 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(40), true),
			170 => (RSTP_dly'last_event, tpd_RSTP_P(40), true),
			171 => (CLK_dly'last_event, tpd_CLK_P(40), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(39),
         GlitchData	=> P_GlitchData(39),
         OutSignalName	=> "P(39)",
         OutTemp	=> P_zd(39),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 8)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 8)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 8)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 8)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 8)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 8)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 8)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 8)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 8)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 8)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 8)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 8)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 8)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 8)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 8)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 8)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 8)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 8)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 8)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 8)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 8)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 8)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 8)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 8)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 8)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 8)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 8)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 8)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 8)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 8)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 8)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 8)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 8)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 8)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 8)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 8)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 8)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 8)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 8)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 8)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 8)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 8)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 8)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 8)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 8)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 8)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 8)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 8)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 8)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 8)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 8)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 8)- 48*17), true),
			54 => (C_dly(39)'last_event, tpd_C_P((2303 - 8)- 48*8), true),
			55 => (C_dly(38)'last_event, tpd_C_P((2303 - 8)- 48*9), true),
			56 => (C_dly(37)'last_event, tpd_C_P((2303 - 8)- 48*10), true),
			57 => (C_dly(36)'last_event, tpd_C_P((2303 - 8)- 48*11), true),
			58 => (C_dly(35)'last_event, tpd_C_P((2303 - 8)- 48*12), true),
			59 => (C_dly(34)'last_event, tpd_C_P((2303 - 8)- 48*13), true),
			60 => (C_dly(33)'last_event, tpd_C_P((2303 - 8)- 48*14), true),
			61 => (C_dly(32)'last_event, tpd_C_P((2303 - 8)- 48*15), true),
			62 => (C_dly(31)'last_event, tpd_C_P((2303 - 8)- 48*16), true),
			63 => (C_dly(30)'last_event, tpd_C_P((2303 - 8)- 48*17), true),
			64 => (C_dly(29)'last_event, tpd_C_P((2303 - 8)- 48*18), true),
			65 => (C_dly(28)'last_event, tpd_C_P((2303 - 8)- 48*19), true),
			66 => (C_dly(27)'last_event, tpd_C_P((2303 - 8)- 48*20), true),
			67 => (C_dly(26)'last_event, tpd_C_P((2303 - 8)- 48*21), true),
			68 => (C_dly(25)'last_event, tpd_C_P((2303 - 8)- 48*22), true),
			69 => (C_dly(24)'last_event, tpd_C_P((2303 - 8)- 48*23), true),
			70 => (C_dly(23)'last_event, tpd_C_P((2303 - 8)- 48*24), true),
			71 => (C_dly(22)'last_event, tpd_C_P((2303 - 8)- 48*25), true),
			72 => (C_dly(21)'last_event, tpd_C_P((2303 - 8)- 48*26), true),
			73 => (C_dly(20)'last_event, tpd_C_P((2303 - 8)- 48*27), true),
			74 => (C_dly(19)'last_event, tpd_C_P((2303 - 8)- 48*28), true),
			75 => (C_dly(18)'last_event, tpd_C_P((2303 - 8)- 48*29), true),
			76 => (C_dly(17)'last_event, tpd_C_P((2303 - 8)- 48*30), true),
			77 => (C_dly(16)'last_event, tpd_C_P((2303 - 8)- 48*31), true),
			78 => (C_dly(15)'last_event, tpd_C_P((2303 - 8)- 48*32), true),
			79 => (C_dly(14)'last_event, tpd_C_P((2303 - 8)- 48*33), true),
			80 => (C_dly(13)'last_event, tpd_C_P((2303 - 8)- 48*34), true),
			81 => (C_dly(12)'last_event, tpd_C_P((2303 - 8)- 48*35), true),
			82 => (C_dly(11)'last_event, tpd_C_P((2303 - 8)- 48*36), true),
			83 => (C_dly(10)'last_event, tpd_C_P((2303 - 8)- 48*37), true),
			84 => (C_dly(9)'last_event, tpd_C_P((2303 - 8)- 48*38), true),
			85 => (C_dly(8)'last_event, tpd_C_P((2303 - 8)- 48*39), true),
			86 => (C_dly(7)'last_event, tpd_C_P((2303 - 8)- 48*40), true),
			87 => (C_dly(6)'last_event, tpd_C_P((2303 - 8)- 48*41), true),
			88 => (C_dly(5)'last_event, tpd_C_P((2303 - 8)- 48*42), true),
			89 => (C_dly(4)'last_event, tpd_C_P((2303 - 8)- 48*43), true),
			90 => (C_dly(3)'last_event, tpd_C_P((2303 - 8)- 48*44), true),
			91 => (C_dly(2)'last_event, tpd_C_P((2303 - 8)- 48*45), true),
			92 => (C_dly(1)'last_event, tpd_C_P((2303 - 8)- 48*46), true),
			93 => (C_dly(0)'last_event, tpd_C_P((2303 - 8)- 48*47), true),
			94 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(39), true),
			95 => (D_dly(17)'last_event, tpd_D_P((863 - 8)- 48*0), true),
			96 => (D_dly(16)'last_event, tpd_D_P((863 - 8)- 48*1), true),
			97 => (D_dly(15)'last_event, tpd_D_P((863 - 8)- 48*2), true),
			98 => (D_dly(14)'last_event, tpd_D_P((863 - 8)- 48*3), true),
			99 => (D_dly(13)'last_event, tpd_D_P((863 - 8)- 48*4), true),
			100 => (D_dly(12)'last_event, tpd_D_P((863 - 8)- 48*5), true),
			101 => (D_dly(11)'last_event, tpd_D_P((863 - 8)- 48*6), true),
			102 => (D_dly(10)'last_event, tpd_D_P((863 - 8)- 48*7), true),
			103 => (D_dly(9)'last_event, tpd_D_P((863 - 8)- 48*8), true),
			104 => (D_dly(8)'last_event, tpd_D_P((863 - 8)- 48*9), true),
			105 => (D_dly(7)'last_event, tpd_D_P((863 - 8)- 48*10), true),
			106 => (D_dly(6)'last_event, tpd_D_P((863 - 8)- 48*11), true),
			107 => (D_dly(5)'last_event, tpd_D_P((863 - 8)- 48*12), true),
			108 => (D_dly(4)'last_event, tpd_D_P((863 - 8)- 48*13), true),
			109 => (D_dly(3)'last_event, tpd_D_P((863 - 8)- 48*14), true),
			110 => (D_dly(2)'last_event, tpd_D_P((863 - 8)- 48*15), true),
			111 => (D_dly(1)'last_event, tpd_D_P((863 - 8)- 48*16), true),
			112 => (D_dly(0)'last_event, tpd_D_P((863 - 8)- 48*17), true),
			113 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 8)- 48*0), true),
			114 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 8)- 48*1), true),
			115 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 8)- 48*2), true),
			116 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 8)- 48*3), true),
			117 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 8)- 48*4), true),
			118 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 8)- 48*5), true),
			119 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 8)- 48*6), true),
			120 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 8)- 48*7), true),
			121 => (PCIN_dly(39)'last_event, tpd_PCIN_P((2303 - 8)- 48*8), true),
			122 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 8)- 48*9), true),
			123 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 8)- 48*10), true),
			124 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 8)- 48*11), true),
			125 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 8)- 48*12), true),
			126 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 8)- 48*13), true),
			127 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 8)- 48*14), true),
			128 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 8)- 48*15), true),
			129 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 8)- 48*16), true),
			130 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 8)- 48*17), true),
			131 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 8)- 48*18), true),
			132 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 8)- 48*19), true),
			133 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 8)- 48*20), true),
			134 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 8)- 48*21), true),
			135 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 8)- 48*22), true),
			136 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 8)- 48*23), true),
			137 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 8)- 48*24), true),
			138 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 8)- 48*25), true),
			139 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 8)- 48*26), true),
			140 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 8)- 48*27), true),
			141 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 8)- 48*28), true),
			142 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 8)- 48*29), true),
			143 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 8)- 48*30), true),
			144 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 8)- 48*31), true),
			145 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 8)- 48*32), true),
			146 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 8)- 48*33), true),
			147 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 8)- 48*34), true),
			148 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 8)- 48*35), true),
			149 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 8)- 48*36), true),
			150 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 8)- 48*37), true),
			151 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 8)- 48*38), true),
			152 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 8)- 48*39), true),
			153 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 8)- 48*40), true),
			154 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 8)- 48*41), true),
			155 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 8)- 48*42), true),
			156 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 8)- 48*43), true),
			157 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 8)- 48*44), true),
			158 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 8)- 48*45), true),
			159 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 8)- 48*46), true),
			160 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 8)- 48*47), true),
			161 => (RSTA_dly'last_event, tpd_RSTA_P(39), true),
			162 => (RSTB_dly'last_event, tpd_RSTB_P(39), true),
			163 => (RSTC_dly'last_event, tpd_RSTC_P(39), true),
			164 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(39), true),
			165 => (RSTD_dly'last_event, tpd_RSTD_P(39), true),
			166 => (RSTM_dly'last_event, tpd_RSTM_P(39), true),
			167 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(39), true),
			168 => (RSTP_dly'last_event, tpd_RSTP_P(39), true),
			169 => (CLK_dly'last_event, tpd_CLK_P(39), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(38),
         GlitchData	=> P_GlitchData(38),
         OutSignalName	=> "P(38)",
         OutTemp	=> P_zd(38),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 9)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 9)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 9)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 9)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 9)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 9)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 9)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 9)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 9)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 9)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 9)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 9)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 9)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 9)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 9)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 9)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 9)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 9)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 9)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 9)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 9)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 9)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 9)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 9)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 9)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 9)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 9)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 9)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 9)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 9)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 9)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 9)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 9)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 9)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 9)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 9)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 9)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 9)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 9)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 9)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 9)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 9)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 9)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 9)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 9)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 9)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 9)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 9)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 9)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 9)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 9)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 9)- 48*17), true),
			54 => (C_dly(38)'last_event, tpd_C_P((2303 - 9)- 48*9), true),
			55 => (C_dly(37)'last_event, tpd_C_P((2303 - 9)- 48*10), true),
			56 => (C_dly(36)'last_event, tpd_C_P((2303 - 9)- 48*11), true),
			57 => (C_dly(35)'last_event, tpd_C_P((2303 - 9)- 48*12), true),
			58 => (C_dly(34)'last_event, tpd_C_P((2303 - 9)- 48*13), true),
			59 => (C_dly(33)'last_event, tpd_C_P((2303 - 9)- 48*14), true),
			60 => (C_dly(32)'last_event, tpd_C_P((2303 - 9)- 48*15), true),
			61 => (C_dly(31)'last_event, tpd_C_P((2303 - 9)- 48*16), true),
			62 => (C_dly(30)'last_event, tpd_C_P((2303 - 9)- 48*17), true),
			63 => (C_dly(29)'last_event, tpd_C_P((2303 - 9)- 48*18), true),
			64 => (C_dly(28)'last_event, tpd_C_P((2303 - 9)- 48*19), true),
			65 => (C_dly(27)'last_event, tpd_C_P((2303 - 9)- 48*20), true),
			66 => (C_dly(26)'last_event, tpd_C_P((2303 - 9)- 48*21), true),
			67 => (C_dly(25)'last_event, tpd_C_P((2303 - 9)- 48*22), true),
			68 => (C_dly(24)'last_event, tpd_C_P((2303 - 9)- 48*23), true),
			69 => (C_dly(23)'last_event, tpd_C_P((2303 - 9)- 48*24), true),
			70 => (C_dly(22)'last_event, tpd_C_P((2303 - 9)- 48*25), true),
			71 => (C_dly(21)'last_event, tpd_C_P((2303 - 9)- 48*26), true),
			72 => (C_dly(20)'last_event, tpd_C_P((2303 - 9)- 48*27), true),
			73 => (C_dly(19)'last_event, tpd_C_P((2303 - 9)- 48*28), true),
			74 => (C_dly(18)'last_event, tpd_C_P((2303 - 9)- 48*29), true),
			75 => (C_dly(17)'last_event, tpd_C_P((2303 - 9)- 48*30), true),
			76 => (C_dly(16)'last_event, tpd_C_P((2303 - 9)- 48*31), true),
			77 => (C_dly(15)'last_event, tpd_C_P((2303 - 9)- 48*32), true),
			78 => (C_dly(14)'last_event, tpd_C_P((2303 - 9)- 48*33), true),
			79 => (C_dly(13)'last_event, tpd_C_P((2303 - 9)- 48*34), true),
			80 => (C_dly(12)'last_event, tpd_C_P((2303 - 9)- 48*35), true),
			81 => (C_dly(11)'last_event, tpd_C_P((2303 - 9)- 48*36), true),
			82 => (C_dly(10)'last_event, tpd_C_P((2303 - 9)- 48*37), true),
			83 => (C_dly(9)'last_event, tpd_C_P((2303 - 9)- 48*38), true),
			84 => (C_dly(8)'last_event, tpd_C_P((2303 - 9)- 48*39), true),
			85 => (C_dly(7)'last_event, tpd_C_P((2303 - 9)- 48*40), true),
			86 => (C_dly(6)'last_event, tpd_C_P((2303 - 9)- 48*41), true),
			87 => (C_dly(5)'last_event, tpd_C_P((2303 - 9)- 48*42), true),
			88 => (C_dly(4)'last_event, tpd_C_P((2303 - 9)- 48*43), true),
			89 => (C_dly(3)'last_event, tpd_C_P((2303 - 9)- 48*44), true),
			90 => (C_dly(2)'last_event, tpd_C_P((2303 - 9)- 48*45), true),
			91 => (C_dly(1)'last_event, tpd_C_P((2303 - 9)- 48*46), true),
			92 => (C_dly(0)'last_event, tpd_C_P((2303 - 9)- 48*47), true),
			93 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(38), true),
			94 => (D_dly(17)'last_event, tpd_D_P((863 - 9)- 48*0), true),
			95 => (D_dly(16)'last_event, tpd_D_P((863 - 9)- 48*1), true),
			96 => (D_dly(15)'last_event, tpd_D_P((863 - 9)- 48*2), true),
			97 => (D_dly(14)'last_event, tpd_D_P((863 - 9)- 48*3), true),
			98 => (D_dly(13)'last_event, tpd_D_P((863 - 9)- 48*4), true),
			99 => (D_dly(12)'last_event, tpd_D_P((863 - 9)- 48*5), true),
			100 => (D_dly(11)'last_event, tpd_D_P((863 - 9)- 48*6), true),
			101 => (D_dly(10)'last_event, tpd_D_P((863 - 9)- 48*7), true),
			102 => (D_dly(9)'last_event, tpd_D_P((863 - 9)- 48*8), true),
			103 => (D_dly(8)'last_event, tpd_D_P((863 - 9)- 48*9), true),
			104 => (D_dly(7)'last_event, tpd_D_P((863 - 9)- 48*10), true),
			105 => (D_dly(6)'last_event, tpd_D_P((863 - 9)- 48*11), true),
			106 => (D_dly(5)'last_event, tpd_D_P((863 - 9)- 48*12), true),
			107 => (D_dly(4)'last_event, tpd_D_P((863 - 9)- 48*13), true),
			108 => (D_dly(3)'last_event, tpd_D_P((863 - 9)- 48*14), true),
			109 => (D_dly(2)'last_event, tpd_D_P((863 - 9)- 48*15), true),
			110 => (D_dly(1)'last_event, tpd_D_P((863 - 9)- 48*16), true),
			111 => (D_dly(0)'last_event, tpd_D_P((863 - 9)- 48*17), true),
			112 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 9)- 48*0), true),
			113 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 9)- 48*1), true),
			114 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 9)- 48*2), true),
			115 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 9)- 48*3), true),
			116 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 9)- 48*4), true),
			117 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 9)- 48*5), true),
			118 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 9)- 48*6), true),
			119 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 9)- 48*7), true),
			120 => (PCIN_dly(38)'last_event, tpd_PCIN_P((2303 - 9)- 48*9), true),
			121 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 9)- 48*10), true),
			122 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 9)- 48*11), true),
			123 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 9)- 48*12), true),
			124 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 9)- 48*13), true),
			125 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 9)- 48*14), true),
			126 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 9)- 48*15), true),
			127 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 9)- 48*16), true),
			128 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 9)- 48*17), true),
			129 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 9)- 48*18), true),
			130 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 9)- 48*19), true),
			131 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 9)- 48*20), true),
			132 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 9)- 48*21), true),
			133 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 9)- 48*22), true),
			134 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 9)- 48*23), true),
			135 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 9)- 48*24), true),
			136 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 9)- 48*25), true),
			137 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 9)- 48*26), true),
			138 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 9)- 48*27), true),
			139 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 9)- 48*28), true),
			140 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 9)- 48*29), true),
			141 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 9)- 48*30), true),
			142 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 9)- 48*31), true),
			143 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 9)- 48*32), true),
			144 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 9)- 48*33), true),
			145 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 9)- 48*34), true),
			146 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 9)- 48*35), true),
			147 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 9)- 48*36), true),
			148 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 9)- 48*37), true),
			149 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 9)- 48*38), true),
			150 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 9)- 48*39), true),
			151 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 9)- 48*40), true),
			152 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 9)- 48*41), true),
			153 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 9)- 48*42), true),
			154 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 9)- 48*43), true),
			155 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 9)- 48*44), true),
			156 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 9)- 48*45), true),
			157 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 9)- 48*46), true),
			158 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 9)- 48*47), true),
			159 => (RSTA_dly'last_event, tpd_RSTA_P(38), true),
			160 => (RSTB_dly'last_event, tpd_RSTB_P(38), true),
			161 => (RSTC_dly'last_event, tpd_RSTC_P(38), true),
			162 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(38), true),
			163 => (RSTD_dly'last_event, tpd_RSTD_P(38), true),
			164 => (RSTM_dly'last_event, tpd_RSTM_P(38), true),
			165 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(38), true),
			166 => (RSTP_dly'last_event, tpd_RSTP_P(38), true),
			167 => (CLK_dly'last_event, tpd_CLK_P(38), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(37),
         GlitchData	=> P_GlitchData(37),
         OutSignalName	=> "P(37)",
         OutTemp	=> P_zd(37),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 10)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 10)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 10)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 10)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 10)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 10)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 10)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 10)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 10)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 10)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 10)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 10)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 10)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 10)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 10)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 10)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 10)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 10)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 10)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 10)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 10)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 10)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 10)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 10)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 10)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 10)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 10)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 10)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 10)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 10)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 10)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 10)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 10)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 10)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 10)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 10)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 10)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 10)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 10)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 10)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 10)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 10)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 10)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 10)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 10)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 10)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 10)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 10)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 10)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 10)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 10)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 10)- 48*17), true),
			54 => (C_dly(37)'last_event, tpd_C_P((2303 - 10)- 48*10), true),
			55 => (C_dly(36)'last_event, tpd_C_P((2303 - 10)- 48*11), true),
			56 => (C_dly(35)'last_event, tpd_C_P((2303 - 10)- 48*12), true),
			57 => (C_dly(34)'last_event, tpd_C_P((2303 - 10)- 48*13), true),
			58 => (C_dly(33)'last_event, tpd_C_P((2303 - 10)- 48*14), true),
			59 => (C_dly(32)'last_event, tpd_C_P((2303 - 10)- 48*15), true),
			60 => (C_dly(31)'last_event, tpd_C_P((2303 - 10)- 48*16), true),
			61 => (C_dly(30)'last_event, tpd_C_P((2303 - 10)- 48*17), true),
			62 => (C_dly(29)'last_event, tpd_C_P((2303 - 10)- 48*18), true),
			63 => (C_dly(28)'last_event, tpd_C_P((2303 - 10)- 48*19), true),
			64 => (C_dly(27)'last_event, tpd_C_P((2303 - 10)- 48*20), true),
			65 => (C_dly(26)'last_event, tpd_C_P((2303 - 10)- 48*21), true),
			66 => (C_dly(25)'last_event, tpd_C_P((2303 - 10)- 48*22), true),
			67 => (C_dly(24)'last_event, tpd_C_P((2303 - 10)- 48*23), true),
			68 => (C_dly(23)'last_event, tpd_C_P((2303 - 10)- 48*24), true),
			69 => (C_dly(22)'last_event, tpd_C_P((2303 - 10)- 48*25), true),
			70 => (C_dly(21)'last_event, tpd_C_P((2303 - 10)- 48*26), true),
			71 => (C_dly(20)'last_event, tpd_C_P((2303 - 10)- 48*27), true),
			72 => (C_dly(19)'last_event, tpd_C_P((2303 - 10)- 48*28), true),
			73 => (C_dly(18)'last_event, tpd_C_P((2303 - 10)- 48*29), true),
			74 => (C_dly(17)'last_event, tpd_C_P((2303 - 10)- 48*30), true),
			75 => (C_dly(16)'last_event, tpd_C_P((2303 - 10)- 48*31), true),
			76 => (C_dly(15)'last_event, tpd_C_P((2303 - 10)- 48*32), true),
			77 => (C_dly(14)'last_event, tpd_C_P((2303 - 10)- 48*33), true),
			78 => (C_dly(13)'last_event, tpd_C_P((2303 - 10)- 48*34), true),
			79 => (C_dly(12)'last_event, tpd_C_P((2303 - 10)- 48*35), true),
			80 => (C_dly(11)'last_event, tpd_C_P((2303 - 10)- 48*36), true),
			81 => (C_dly(10)'last_event, tpd_C_P((2303 - 10)- 48*37), true),
			82 => (C_dly(9)'last_event, tpd_C_P((2303 - 10)- 48*38), true),
			83 => (C_dly(8)'last_event, tpd_C_P((2303 - 10)- 48*39), true),
			84 => (C_dly(7)'last_event, tpd_C_P((2303 - 10)- 48*40), true),
			85 => (C_dly(6)'last_event, tpd_C_P((2303 - 10)- 48*41), true),
			86 => (C_dly(5)'last_event, tpd_C_P((2303 - 10)- 48*42), true),
			87 => (C_dly(4)'last_event, tpd_C_P((2303 - 10)- 48*43), true),
			88 => (C_dly(3)'last_event, tpd_C_P((2303 - 10)- 48*44), true),
			89 => (C_dly(2)'last_event, tpd_C_P((2303 - 10)- 48*45), true),
			90 => (C_dly(1)'last_event, tpd_C_P((2303 - 10)- 48*46), true),
			91 => (C_dly(0)'last_event, tpd_C_P((2303 - 10)- 48*47), true),
			92 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(37), true),
			93 => (D_dly(17)'last_event, tpd_D_P((863 - 10)- 48*0), true),
			94 => (D_dly(16)'last_event, tpd_D_P((863 - 10)- 48*1), true),
			95 => (D_dly(15)'last_event, tpd_D_P((863 - 10)- 48*2), true),
			96 => (D_dly(14)'last_event, tpd_D_P((863 - 10)- 48*3), true),
			97 => (D_dly(13)'last_event, tpd_D_P((863 - 10)- 48*4), true),
			98 => (D_dly(12)'last_event, tpd_D_P((863 - 10)- 48*5), true),
			99 => (D_dly(11)'last_event, tpd_D_P((863 - 10)- 48*6), true),
			100 => (D_dly(10)'last_event, tpd_D_P((863 - 10)- 48*7), true),
			101 => (D_dly(9)'last_event, tpd_D_P((863 - 10)- 48*8), true),
			102 => (D_dly(8)'last_event, tpd_D_P((863 - 10)- 48*9), true),
			103 => (D_dly(7)'last_event, tpd_D_P((863 - 10)- 48*10), true),
			104 => (D_dly(6)'last_event, tpd_D_P((863 - 10)- 48*11), true),
			105 => (D_dly(5)'last_event, tpd_D_P((863 - 10)- 48*12), true),
			106 => (D_dly(4)'last_event, tpd_D_P((863 - 10)- 48*13), true),
			107 => (D_dly(3)'last_event, tpd_D_P((863 - 10)- 48*14), true),
			108 => (D_dly(2)'last_event, tpd_D_P((863 - 10)- 48*15), true),
			109 => (D_dly(1)'last_event, tpd_D_P((863 - 10)- 48*16), true),
			110 => (D_dly(0)'last_event, tpd_D_P((863 - 10)- 48*17), true),
			111 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 10)- 48*0), true),
			112 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 10)- 48*1), true),
			113 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 10)- 48*2), true),
			114 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 10)- 48*3), true),
			115 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 10)- 48*4), true),
			116 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 10)- 48*5), true),
			117 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 10)- 48*6), true),
			118 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 10)- 48*7), true),
			119 => (PCIN_dly(37)'last_event, tpd_PCIN_P((2303 - 10)- 48*10), true),
			120 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 10)- 48*11), true),
			121 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 10)- 48*12), true),
			122 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 10)- 48*13), true),
			123 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 10)- 48*14), true),
			124 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 10)- 48*15), true),
			125 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 10)- 48*16), true),
			126 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 10)- 48*17), true),
			127 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 10)- 48*18), true),
			128 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 10)- 48*19), true),
			129 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 10)- 48*20), true),
			130 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 10)- 48*21), true),
			131 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 10)- 48*22), true),
			132 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 10)- 48*23), true),
			133 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 10)- 48*24), true),
			134 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 10)- 48*25), true),
			135 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 10)- 48*26), true),
			136 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 10)- 48*27), true),
			137 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 10)- 48*28), true),
			138 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 10)- 48*29), true),
			139 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 10)- 48*30), true),
			140 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 10)- 48*31), true),
			141 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 10)- 48*32), true),
			142 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 10)- 48*33), true),
			143 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 10)- 48*34), true),
			144 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 10)- 48*35), true),
			145 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 10)- 48*36), true),
			146 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 10)- 48*37), true),
			147 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 10)- 48*38), true),
			148 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 10)- 48*39), true),
			149 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 10)- 48*40), true),
			150 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 10)- 48*41), true),
			151 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 10)- 48*42), true),
			152 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 10)- 48*43), true),
			153 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 10)- 48*44), true),
			154 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 10)- 48*45), true),
			155 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 10)- 48*46), true),
			156 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 10)- 48*47), true),
			157 => (RSTA_dly'last_event, tpd_RSTA_P(37), true),
			158 => (RSTB_dly'last_event, tpd_RSTB_P(37), true),
			159 => (RSTC_dly'last_event, tpd_RSTC_P(37), true),
			160 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(37), true),
			161 => (RSTD_dly'last_event, tpd_RSTD_P(37), true),
			162 => (RSTM_dly'last_event, tpd_RSTM_P(37), true),
			163 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(37), true),
			164 => (RSTP_dly'last_event, tpd_RSTP_P(37), true),
			165 => (CLK_dly'last_event, tpd_CLK_P(37), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(36),
         GlitchData	=> P_GlitchData(36),
         OutSignalName	=> "P(36)",
         OutTemp	=> P_zd(36),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 11)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 11)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 11)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 11)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 11)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 11)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 11)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 11)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 11)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 11)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 11)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 11)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 11)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 11)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 11)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 11)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 11)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 11)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 11)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 11)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 11)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 11)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 11)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 11)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 11)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 11)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 11)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 11)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 11)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 11)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 11)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 11)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 11)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 11)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 11)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 11)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 11)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 11)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 11)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 11)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 11)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 11)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 11)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 11)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 11)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 11)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 11)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 11)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 11)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 11)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 11)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 11)- 48*17), true),
			54 => (C_dly(36)'last_event, tpd_C_P((2303 - 11)- 48*11), true),
			55 => (C_dly(35)'last_event, tpd_C_P((2303 - 11)- 48*12), true),
			56 => (C_dly(34)'last_event, tpd_C_P((2303 - 11)- 48*13), true),
			57 => (C_dly(33)'last_event, tpd_C_P((2303 - 11)- 48*14), true),
			58 => (C_dly(32)'last_event, tpd_C_P((2303 - 11)- 48*15), true),
			59 => (C_dly(31)'last_event, tpd_C_P((2303 - 11)- 48*16), true),
			60 => (C_dly(30)'last_event, tpd_C_P((2303 - 11)- 48*17), true),
			61 => (C_dly(29)'last_event, tpd_C_P((2303 - 11)- 48*18), true),
			62 => (C_dly(28)'last_event, tpd_C_P((2303 - 11)- 48*19), true),
			63 => (C_dly(27)'last_event, tpd_C_P((2303 - 11)- 48*20), true),
			64 => (C_dly(26)'last_event, tpd_C_P((2303 - 11)- 48*21), true),
			65 => (C_dly(25)'last_event, tpd_C_P((2303 - 11)- 48*22), true),
			66 => (C_dly(24)'last_event, tpd_C_P((2303 - 11)- 48*23), true),
			67 => (C_dly(23)'last_event, tpd_C_P((2303 - 11)- 48*24), true),
			68 => (C_dly(22)'last_event, tpd_C_P((2303 - 11)- 48*25), true),
			69 => (C_dly(21)'last_event, tpd_C_P((2303 - 11)- 48*26), true),
			70 => (C_dly(20)'last_event, tpd_C_P((2303 - 11)- 48*27), true),
			71 => (C_dly(19)'last_event, tpd_C_P((2303 - 11)- 48*28), true),
			72 => (C_dly(18)'last_event, tpd_C_P((2303 - 11)- 48*29), true),
			73 => (C_dly(17)'last_event, tpd_C_P((2303 - 11)- 48*30), true),
			74 => (C_dly(16)'last_event, tpd_C_P((2303 - 11)- 48*31), true),
			75 => (C_dly(15)'last_event, tpd_C_P((2303 - 11)- 48*32), true),
			76 => (C_dly(14)'last_event, tpd_C_P((2303 - 11)- 48*33), true),
			77 => (C_dly(13)'last_event, tpd_C_P((2303 - 11)- 48*34), true),
			78 => (C_dly(12)'last_event, tpd_C_P((2303 - 11)- 48*35), true),
			79 => (C_dly(11)'last_event, tpd_C_P((2303 - 11)- 48*36), true),
			80 => (C_dly(10)'last_event, tpd_C_P((2303 - 11)- 48*37), true),
			81 => (C_dly(9)'last_event, tpd_C_P((2303 - 11)- 48*38), true),
			82 => (C_dly(8)'last_event, tpd_C_P((2303 - 11)- 48*39), true),
			83 => (C_dly(7)'last_event, tpd_C_P((2303 - 11)- 48*40), true),
			84 => (C_dly(6)'last_event, tpd_C_P((2303 - 11)- 48*41), true),
			85 => (C_dly(5)'last_event, tpd_C_P((2303 - 11)- 48*42), true),
			86 => (C_dly(4)'last_event, tpd_C_P((2303 - 11)- 48*43), true),
			87 => (C_dly(3)'last_event, tpd_C_P((2303 - 11)- 48*44), true),
			88 => (C_dly(2)'last_event, tpd_C_P((2303 - 11)- 48*45), true),
			89 => (C_dly(1)'last_event, tpd_C_P((2303 - 11)- 48*46), true),
			90 => (C_dly(0)'last_event, tpd_C_P((2303 - 11)- 48*47), true),
			91 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(36), true),
			92 => (D_dly(17)'last_event, tpd_D_P((863 - 11)- 48*0), true),
			93 => (D_dly(16)'last_event, tpd_D_P((863 - 11)- 48*1), true),
			94 => (D_dly(15)'last_event, tpd_D_P((863 - 11)- 48*2), true),
			95 => (D_dly(14)'last_event, tpd_D_P((863 - 11)- 48*3), true),
			96 => (D_dly(13)'last_event, tpd_D_P((863 - 11)- 48*4), true),
			97 => (D_dly(12)'last_event, tpd_D_P((863 - 11)- 48*5), true),
			98 => (D_dly(11)'last_event, tpd_D_P((863 - 11)- 48*6), true),
			99 => (D_dly(10)'last_event, tpd_D_P((863 - 11)- 48*7), true),
			100 => (D_dly(9)'last_event, tpd_D_P((863 - 11)- 48*8), true),
			101 => (D_dly(8)'last_event, tpd_D_P((863 - 11)- 48*9), true),
			102 => (D_dly(7)'last_event, tpd_D_P((863 - 11)- 48*10), true),
			103 => (D_dly(6)'last_event, tpd_D_P((863 - 11)- 48*11), true),
			104 => (D_dly(5)'last_event, tpd_D_P((863 - 11)- 48*12), true),
			105 => (D_dly(4)'last_event, tpd_D_P((863 - 11)- 48*13), true),
			106 => (D_dly(3)'last_event, tpd_D_P((863 - 11)- 48*14), true),
			107 => (D_dly(2)'last_event, tpd_D_P((863 - 11)- 48*15), true),
			108 => (D_dly(1)'last_event, tpd_D_P((863 - 11)- 48*16), true),
			109 => (D_dly(0)'last_event, tpd_D_P((863 - 11)- 48*17), true),
			110 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 11)- 48*0), true),
			111 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 11)- 48*1), true),
			112 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 11)- 48*2), true),
			113 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 11)- 48*3), true),
			114 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 11)- 48*4), true),
			115 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 11)- 48*5), true),
			116 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 11)- 48*6), true),
			117 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 11)- 48*7), true),
			118 => (PCIN_dly(36)'last_event, tpd_PCIN_P((2303 - 11)- 48*11), true),
			119 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 11)- 48*12), true),
			120 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 11)- 48*13), true),
			121 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 11)- 48*14), true),
			122 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 11)- 48*15), true),
			123 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 11)- 48*16), true),
			124 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 11)- 48*17), true),
			125 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 11)- 48*18), true),
			126 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 11)- 48*19), true),
			127 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 11)- 48*20), true),
			128 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 11)- 48*21), true),
			129 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 11)- 48*22), true),
			130 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 11)- 48*23), true),
			131 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 11)- 48*24), true),
			132 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 11)- 48*25), true),
			133 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 11)- 48*26), true),
			134 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 11)- 48*27), true),
			135 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 11)- 48*28), true),
			136 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 11)- 48*29), true),
			137 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 11)- 48*30), true),
			138 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 11)- 48*31), true),
			139 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 11)- 48*32), true),
			140 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 11)- 48*33), true),
			141 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 11)- 48*34), true),
			142 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 11)- 48*35), true),
			143 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 11)- 48*36), true),
			144 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 11)- 48*37), true),
			145 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 11)- 48*38), true),
			146 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 11)- 48*39), true),
			147 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 11)- 48*40), true),
			148 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 11)- 48*41), true),
			149 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 11)- 48*42), true),
			150 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 11)- 48*43), true),
			151 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 11)- 48*44), true),
			152 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 11)- 48*45), true),
			153 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 11)- 48*46), true),
			154 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 11)- 48*47), true),
			155 => (RSTA_dly'last_event, tpd_RSTA_P(36), true),
			156 => (RSTB_dly'last_event, tpd_RSTB_P(36), true),
			157 => (RSTC_dly'last_event, tpd_RSTC_P(36), true),
			158 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(36), true),
			159 => (RSTD_dly'last_event, tpd_RSTD_P(36), true),
			160 => (RSTM_dly'last_event, tpd_RSTM_P(36), true),
			161 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(36), true),
			162 => (RSTP_dly'last_event, tpd_RSTP_P(36), true),
			163 => (CLK_dly'last_event, tpd_CLK_P(36), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(35),
         GlitchData	=> P_GlitchData(35),
         OutSignalName	=> "P(35)",
         OutTemp	=> P_zd(35),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 12)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 12)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 12)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 12)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 12)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 12)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 12)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 12)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 12)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 12)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 12)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 12)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 12)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 12)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 12)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 12)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 12)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 12)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 12)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 12)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 12)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 12)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 12)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 12)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 12)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 12)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 12)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 12)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 12)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 12)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 12)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 12)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 12)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 12)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 12)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 12)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 12)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 12)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 12)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 12)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 12)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 12)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 12)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 12)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 12)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 12)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 12)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 12)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 12)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 12)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 12)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 12)- 48*17), true),
			54 => (C_dly(35)'last_event, tpd_C_P((2303 - 12)- 48*12), true),
			55 => (C_dly(34)'last_event, tpd_C_P((2303 - 12)- 48*13), true),
			56 => (C_dly(33)'last_event, tpd_C_P((2303 - 12)- 48*14), true),
			57 => (C_dly(32)'last_event, tpd_C_P((2303 - 12)- 48*15), true),
			58 => (C_dly(31)'last_event, tpd_C_P((2303 - 12)- 48*16), true),
			59 => (C_dly(30)'last_event, tpd_C_P((2303 - 12)- 48*17), true),
			60 => (C_dly(29)'last_event, tpd_C_P((2303 - 12)- 48*18), true),
			61 => (C_dly(28)'last_event, tpd_C_P((2303 - 12)- 48*19), true),
			62 => (C_dly(27)'last_event, tpd_C_P((2303 - 12)- 48*20), true),
			63 => (C_dly(26)'last_event, tpd_C_P((2303 - 12)- 48*21), true),
			64 => (C_dly(25)'last_event, tpd_C_P((2303 - 12)- 48*22), true),
			65 => (C_dly(24)'last_event, tpd_C_P((2303 - 12)- 48*23), true),
			66 => (C_dly(23)'last_event, tpd_C_P((2303 - 12)- 48*24), true),
			67 => (C_dly(22)'last_event, tpd_C_P((2303 - 12)- 48*25), true),
			68 => (C_dly(21)'last_event, tpd_C_P((2303 - 12)- 48*26), true),
			69 => (C_dly(20)'last_event, tpd_C_P((2303 - 12)- 48*27), true),
			70 => (C_dly(19)'last_event, tpd_C_P((2303 - 12)- 48*28), true),
			71 => (C_dly(18)'last_event, tpd_C_P((2303 - 12)- 48*29), true),
			72 => (C_dly(17)'last_event, tpd_C_P((2303 - 12)- 48*30), true),
			73 => (C_dly(16)'last_event, tpd_C_P((2303 - 12)- 48*31), true),
			74 => (C_dly(15)'last_event, tpd_C_P((2303 - 12)- 48*32), true),
			75 => (C_dly(14)'last_event, tpd_C_P((2303 - 12)- 48*33), true),
			76 => (C_dly(13)'last_event, tpd_C_P((2303 - 12)- 48*34), true),
			77 => (C_dly(12)'last_event, tpd_C_P((2303 - 12)- 48*35), true),
			78 => (C_dly(11)'last_event, tpd_C_P((2303 - 12)- 48*36), true),
			79 => (C_dly(10)'last_event, tpd_C_P((2303 - 12)- 48*37), true),
			80 => (C_dly(9)'last_event, tpd_C_P((2303 - 12)- 48*38), true),
			81 => (C_dly(8)'last_event, tpd_C_P((2303 - 12)- 48*39), true),
			82 => (C_dly(7)'last_event, tpd_C_P((2303 - 12)- 48*40), true),
			83 => (C_dly(6)'last_event, tpd_C_P((2303 - 12)- 48*41), true),
			84 => (C_dly(5)'last_event, tpd_C_P((2303 - 12)- 48*42), true),
			85 => (C_dly(4)'last_event, tpd_C_P((2303 - 12)- 48*43), true),
			86 => (C_dly(3)'last_event, tpd_C_P((2303 - 12)- 48*44), true),
			87 => (C_dly(2)'last_event, tpd_C_P((2303 - 12)- 48*45), true),
			88 => (C_dly(1)'last_event, tpd_C_P((2303 - 12)- 48*46), true),
			89 => (C_dly(0)'last_event, tpd_C_P((2303 - 12)- 48*47), true),
			90 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(35), true),
			91 => (D_dly(17)'last_event, tpd_D_P((863 - 12)- 48*0), true),
			92 => (D_dly(16)'last_event, tpd_D_P((863 - 12)- 48*1), true),
			93 => (D_dly(15)'last_event, tpd_D_P((863 - 12)- 48*2), true),
			94 => (D_dly(14)'last_event, tpd_D_P((863 - 12)- 48*3), true),
			95 => (D_dly(13)'last_event, tpd_D_P((863 - 12)- 48*4), true),
			96 => (D_dly(12)'last_event, tpd_D_P((863 - 12)- 48*5), true),
			97 => (D_dly(11)'last_event, tpd_D_P((863 - 12)- 48*6), true),
			98 => (D_dly(10)'last_event, tpd_D_P((863 - 12)- 48*7), true),
			99 => (D_dly(9)'last_event, tpd_D_P((863 - 12)- 48*8), true),
			100 => (D_dly(8)'last_event, tpd_D_P((863 - 12)- 48*9), true),
			101 => (D_dly(7)'last_event, tpd_D_P((863 - 12)- 48*10), true),
			102 => (D_dly(6)'last_event, tpd_D_P((863 - 12)- 48*11), true),
			103 => (D_dly(5)'last_event, tpd_D_P((863 - 12)- 48*12), true),
			104 => (D_dly(4)'last_event, tpd_D_P((863 - 12)- 48*13), true),
			105 => (D_dly(3)'last_event, tpd_D_P((863 - 12)- 48*14), true),
			106 => (D_dly(2)'last_event, tpd_D_P((863 - 12)- 48*15), true),
			107 => (D_dly(1)'last_event, tpd_D_P((863 - 12)- 48*16), true),
			108 => (D_dly(0)'last_event, tpd_D_P((863 - 12)- 48*17), true),
			109 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 12)- 48*0), true),
			110 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 12)- 48*1), true),
			111 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 12)- 48*2), true),
			112 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 12)- 48*3), true),
			113 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 12)- 48*4), true),
			114 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 12)- 48*5), true),
			115 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 12)- 48*6), true),
			116 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 12)- 48*7), true),
			117 => (PCIN_dly(35)'last_event, tpd_PCIN_P((2303 - 12)- 48*12), true),
			118 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 12)- 48*13), true),
			119 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 12)- 48*14), true),
			120 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 12)- 48*15), true),
			121 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 12)- 48*16), true),
			122 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 12)- 48*17), true),
			123 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 12)- 48*18), true),
			124 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 12)- 48*19), true),
			125 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 12)- 48*20), true),
			126 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 12)- 48*21), true),
			127 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 12)- 48*22), true),
			128 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 12)- 48*23), true),
			129 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 12)- 48*24), true),
			130 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 12)- 48*25), true),
			131 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 12)- 48*26), true),
			132 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 12)- 48*27), true),
			133 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 12)- 48*28), true),
			134 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 12)- 48*29), true),
			135 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 12)- 48*30), true),
			136 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 12)- 48*31), true),
			137 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 12)- 48*32), true),
			138 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 12)- 48*33), true),
			139 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 12)- 48*34), true),
			140 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 12)- 48*35), true),
			141 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 12)- 48*36), true),
			142 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 12)- 48*37), true),
			143 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 12)- 48*38), true),
			144 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 12)- 48*39), true),
			145 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 12)- 48*40), true),
			146 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 12)- 48*41), true),
			147 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 12)- 48*42), true),
			148 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 12)- 48*43), true),
			149 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 12)- 48*44), true),
			150 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 12)- 48*45), true),
			151 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 12)- 48*46), true),
			152 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 12)- 48*47), true),
			153 => (RSTA_dly'last_event, tpd_RSTA_P(35), true),
			154 => (RSTB_dly'last_event, tpd_RSTB_P(35), true),
			155 => (RSTC_dly'last_event, tpd_RSTC_P(35), true),
			156 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(35), true),
			157 => (RSTD_dly'last_event, tpd_RSTD_P(35), true),
			158 => (RSTM_dly'last_event, tpd_RSTM_P(35), true),
			159 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(35), true),
			160 => (RSTP_dly'last_event, tpd_RSTP_P(35), true),
			161 => (CLK_dly'last_event, tpd_CLK_P(35), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(34),
         GlitchData	=> P_GlitchData(34),
         OutSignalName	=> "P(34)",
         OutTemp	=> P_zd(34),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 13)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 13)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 13)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 13)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 13)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 13)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 13)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 13)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 13)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 13)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 13)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 13)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 13)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 13)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 13)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 13)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 13)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 13)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 13)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 13)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 13)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 13)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 13)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 13)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 13)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 13)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 13)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 13)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 13)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 13)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 13)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 13)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 13)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 13)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 13)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 13)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 13)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 13)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 13)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 13)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 13)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 13)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 13)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 13)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 13)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 13)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 13)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 13)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 13)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 13)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 13)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 13)- 48*17), true),
			54 => (C_dly(34)'last_event, tpd_C_P((2303 - 13)- 48*13), true),
			55 => (C_dly(33)'last_event, tpd_C_P((2303 - 13)- 48*14), true),
			56 => (C_dly(32)'last_event, tpd_C_P((2303 - 13)- 48*15), true),
			57 => (C_dly(31)'last_event, tpd_C_P((2303 - 13)- 48*16), true),
			58 => (C_dly(30)'last_event, tpd_C_P((2303 - 13)- 48*17), true),
			59 => (C_dly(29)'last_event, tpd_C_P((2303 - 13)- 48*18), true),
			60 => (C_dly(28)'last_event, tpd_C_P((2303 - 13)- 48*19), true),
			61 => (C_dly(27)'last_event, tpd_C_P((2303 - 13)- 48*20), true),
			62 => (C_dly(26)'last_event, tpd_C_P((2303 - 13)- 48*21), true),
			63 => (C_dly(25)'last_event, tpd_C_P((2303 - 13)- 48*22), true),
			64 => (C_dly(24)'last_event, tpd_C_P((2303 - 13)- 48*23), true),
			65 => (C_dly(23)'last_event, tpd_C_P((2303 - 13)- 48*24), true),
			66 => (C_dly(22)'last_event, tpd_C_P((2303 - 13)- 48*25), true),
			67 => (C_dly(21)'last_event, tpd_C_P((2303 - 13)- 48*26), true),
			68 => (C_dly(20)'last_event, tpd_C_P((2303 - 13)- 48*27), true),
			69 => (C_dly(19)'last_event, tpd_C_P((2303 - 13)- 48*28), true),
			70 => (C_dly(18)'last_event, tpd_C_P((2303 - 13)- 48*29), true),
			71 => (C_dly(17)'last_event, tpd_C_P((2303 - 13)- 48*30), true),
			72 => (C_dly(16)'last_event, tpd_C_P((2303 - 13)- 48*31), true),
			73 => (C_dly(15)'last_event, tpd_C_P((2303 - 13)- 48*32), true),
			74 => (C_dly(14)'last_event, tpd_C_P((2303 - 13)- 48*33), true),
			75 => (C_dly(13)'last_event, tpd_C_P((2303 - 13)- 48*34), true),
			76 => (C_dly(12)'last_event, tpd_C_P((2303 - 13)- 48*35), true),
			77 => (C_dly(11)'last_event, tpd_C_P((2303 - 13)- 48*36), true),
			78 => (C_dly(10)'last_event, tpd_C_P((2303 - 13)- 48*37), true),
			79 => (C_dly(9)'last_event, tpd_C_P((2303 - 13)- 48*38), true),
			80 => (C_dly(8)'last_event, tpd_C_P((2303 - 13)- 48*39), true),
			81 => (C_dly(7)'last_event, tpd_C_P((2303 - 13)- 48*40), true),
			82 => (C_dly(6)'last_event, tpd_C_P((2303 - 13)- 48*41), true),
			83 => (C_dly(5)'last_event, tpd_C_P((2303 - 13)- 48*42), true),
			84 => (C_dly(4)'last_event, tpd_C_P((2303 - 13)- 48*43), true),
			85 => (C_dly(3)'last_event, tpd_C_P((2303 - 13)- 48*44), true),
			86 => (C_dly(2)'last_event, tpd_C_P((2303 - 13)- 48*45), true),
			87 => (C_dly(1)'last_event, tpd_C_P((2303 - 13)- 48*46), true),
			88 => (C_dly(0)'last_event, tpd_C_P((2303 - 13)- 48*47), true),
			89 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(34), true),
			90 => (D_dly(17)'last_event, tpd_D_P((863 - 13)- 48*0), true),
			91 => (D_dly(16)'last_event, tpd_D_P((863 - 13)- 48*1), true),
			92 => (D_dly(15)'last_event, tpd_D_P((863 - 13)- 48*2), true),
			93 => (D_dly(14)'last_event, tpd_D_P((863 - 13)- 48*3), true),
			94 => (D_dly(13)'last_event, tpd_D_P((863 - 13)- 48*4), true),
			95 => (D_dly(12)'last_event, tpd_D_P((863 - 13)- 48*5), true),
			96 => (D_dly(11)'last_event, tpd_D_P((863 - 13)- 48*6), true),
			97 => (D_dly(10)'last_event, tpd_D_P((863 - 13)- 48*7), true),
			98 => (D_dly(9)'last_event, tpd_D_P((863 - 13)- 48*8), true),
			99 => (D_dly(8)'last_event, tpd_D_P((863 - 13)- 48*9), true),
			100 => (D_dly(7)'last_event, tpd_D_P((863 - 13)- 48*10), true),
			101 => (D_dly(6)'last_event, tpd_D_P((863 - 13)- 48*11), true),
			102 => (D_dly(5)'last_event, tpd_D_P((863 - 13)- 48*12), true),
			103 => (D_dly(4)'last_event, tpd_D_P((863 - 13)- 48*13), true),
			104 => (D_dly(3)'last_event, tpd_D_P((863 - 13)- 48*14), true),
			105 => (D_dly(2)'last_event, tpd_D_P((863 - 13)- 48*15), true),
			106 => (D_dly(1)'last_event, tpd_D_P((863 - 13)- 48*16), true),
			107 => (D_dly(0)'last_event, tpd_D_P((863 - 13)- 48*17), true),
			108 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 13)- 48*0), true),
			109 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 13)- 48*1), true),
			110 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 13)- 48*2), true),
			111 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 13)- 48*3), true),
			112 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 13)- 48*4), true),
			113 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 13)- 48*5), true),
			114 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 13)- 48*6), true),
			115 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 13)- 48*7), true),
			116 => (PCIN_dly(34)'last_event, tpd_PCIN_P((2303 - 13)- 48*13), true),
			117 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 13)- 48*14), true),
			118 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 13)- 48*15), true),
			119 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 13)- 48*16), true),
			120 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 13)- 48*17), true),
			121 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 13)- 48*18), true),
			122 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 13)- 48*19), true),
			123 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 13)- 48*20), true),
			124 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 13)- 48*21), true),
			125 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 13)- 48*22), true),
			126 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 13)- 48*23), true),
			127 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 13)- 48*24), true),
			128 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 13)- 48*25), true),
			129 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 13)- 48*26), true),
			130 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 13)- 48*27), true),
			131 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 13)- 48*28), true),
			132 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 13)- 48*29), true),
			133 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 13)- 48*30), true),
			134 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 13)- 48*31), true),
			135 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 13)- 48*32), true),
			136 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 13)- 48*33), true),
			137 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 13)- 48*34), true),
			138 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 13)- 48*35), true),
			139 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 13)- 48*36), true),
			140 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 13)- 48*37), true),
			141 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 13)- 48*38), true),
			142 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 13)- 48*39), true),
			143 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 13)- 48*40), true),
			144 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 13)- 48*41), true),
			145 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 13)- 48*42), true),
			146 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 13)- 48*43), true),
			147 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 13)- 48*44), true),
			148 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 13)- 48*45), true),
			149 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 13)- 48*46), true),
			150 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 13)- 48*47), true),
			151 => (RSTA_dly'last_event, tpd_RSTA_P(34), true),
			152 => (RSTB_dly'last_event, tpd_RSTB_P(34), true),
			153 => (RSTC_dly'last_event, tpd_RSTC_P(34), true),
			154 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(34), true),
			155 => (RSTD_dly'last_event, tpd_RSTD_P(34), true),
			156 => (RSTM_dly'last_event, tpd_RSTM_P(34), true),
			157 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(34), true),
			158 => (RSTP_dly'last_event, tpd_RSTP_P(34), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(34), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(33),
         GlitchData	=> P_GlitchData(33),
         OutSignalName	=> "P(33)",
         OutTemp	=> P_zd(33),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 14)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 14)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 14)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 14)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 14)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 14)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 14)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 14)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 14)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 14)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 14)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 14)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 14)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 14)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 14)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 14)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 14)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 14)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 14)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 14)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 14)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 14)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 14)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 14)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 14)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 14)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 14)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 14)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 14)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 14)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 14)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 14)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 14)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 14)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 14)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 14)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 14)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 14)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 14)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 14)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 14)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 14)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 14)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 14)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 14)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 14)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 14)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 14)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 14)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 14)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 14)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 14)- 48*17), true),
			54 => (C_dly(33)'last_event, tpd_C_P((2303 - 14)- 48*14), true),
			55 => (C_dly(32)'last_event, tpd_C_P((2303 - 14)- 48*15), true),
			56 => (C_dly(31)'last_event, tpd_C_P((2303 - 14)- 48*16), true),
			57 => (C_dly(30)'last_event, tpd_C_P((2303 - 14)- 48*17), true),
			58 => (C_dly(29)'last_event, tpd_C_P((2303 - 14)- 48*18), true),
			59 => (C_dly(28)'last_event, tpd_C_P((2303 - 14)- 48*19), true),
			60 => (C_dly(27)'last_event, tpd_C_P((2303 - 14)- 48*20), true),
			61 => (C_dly(26)'last_event, tpd_C_P((2303 - 14)- 48*21), true),
			62 => (C_dly(25)'last_event, tpd_C_P((2303 - 14)- 48*22), true),
			63 => (C_dly(24)'last_event, tpd_C_P((2303 - 14)- 48*23), true),
			64 => (C_dly(23)'last_event, tpd_C_P((2303 - 14)- 48*24), true),
			65 => (C_dly(22)'last_event, tpd_C_P((2303 - 14)- 48*25), true),
			66 => (C_dly(21)'last_event, tpd_C_P((2303 - 14)- 48*26), true),
			67 => (C_dly(20)'last_event, tpd_C_P((2303 - 14)- 48*27), true),
			68 => (C_dly(19)'last_event, tpd_C_P((2303 - 14)- 48*28), true),
			69 => (C_dly(18)'last_event, tpd_C_P((2303 - 14)- 48*29), true),
			70 => (C_dly(17)'last_event, tpd_C_P((2303 - 14)- 48*30), true),
			71 => (C_dly(16)'last_event, tpd_C_P((2303 - 14)- 48*31), true),
			72 => (C_dly(15)'last_event, tpd_C_P((2303 - 14)- 48*32), true),
			73 => (C_dly(14)'last_event, tpd_C_P((2303 - 14)- 48*33), true),
			74 => (C_dly(13)'last_event, tpd_C_P((2303 - 14)- 48*34), true),
			75 => (C_dly(12)'last_event, tpd_C_P((2303 - 14)- 48*35), true),
			76 => (C_dly(11)'last_event, tpd_C_P((2303 - 14)- 48*36), true),
			77 => (C_dly(10)'last_event, tpd_C_P((2303 - 14)- 48*37), true),
			78 => (C_dly(9)'last_event, tpd_C_P((2303 - 14)- 48*38), true),
			79 => (C_dly(8)'last_event, tpd_C_P((2303 - 14)- 48*39), true),
			80 => (C_dly(7)'last_event, tpd_C_P((2303 - 14)- 48*40), true),
			81 => (C_dly(6)'last_event, tpd_C_P((2303 - 14)- 48*41), true),
			82 => (C_dly(5)'last_event, tpd_C_P((2303 - 14)- 48*42), true),
			83 => (C_dly(4)'last_event, tpd_C_P((2303 - 14)- 48*43), true),
			84 => (C_dly(3)'last_event, tpd_C_P((2303 - 14)- 48*44), true),
			85 => (C_dly(2)'last_event, tpd_C_P((2303 - 14)- 48*45), true),
			86 => (C_dly(1)'last_event, tpd_C_P((2303 - 14)- 48*46), true),
			87 => (C_dly(0)'last_event, tpd_C_P((2303 - 14)- 48*47), true),
			88 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(33), true),
			89 => (D_dly(17)'last_event, tpd_D_P((863 - 14)- 48*0), true),
			90 => (D_dly(16)'last_event, tpd_D_P((863 - 14)- 48*1), true),
			91 => (D_dly(15)'last_event, tpd_D_P((863 - 14)- 48*2), true),
			92 => (D_dly(14)'last_event, tpd_D_P((863 - 14)- 48*3), true),
			93 => (D_dly(13)'last_event, tpd_D_P((863 - 14)- 48*4), true),
			94 => (D_dly(12)'last_event, tpd_D_P((863 - 14)- 48*5), true),
			95 => (D_dly(11)'last_event, tpd_D_P((863 - 14)- 48*6), true),
			96 => (D_dly(10)'last_event, tpd_D_P((863 - 14)- 48*7), true),
			97 => (D_dly(9)'last_event, tpd_D_P((863 - 14)- 48*8), true),
			98 => (D_dly(8)'last_event, tpd_D_P((863 - 14)- 48*9), true),
			99 => (D_dly(7)'last_event, tpd_D_P((863 - 14)- 48*10), true),
			100 => (D_dly(6)'last_event, tpd_D_P((863 - 14)- 48*11), true),
			101 => (D_dly(5)'last_event, tpd_D_P((863 - 14)- 48*12), true),
			102 => (D_dly(4)'last_event, tpd_D_P((863 - 14)- 48*13), true),
			103 => (D_dly(3)'last_event, tpd_D_P((863 - 14)- 48*14), true),
			104 => (D_dly(2)'last_event, tpd_D_P((863 - 14)- 48*15), true),
			105 => (D_dly(1)'last_event, tpd_D_P((863 - 14)- 48*16), true),
			106 => (D_dly(0)'last_event, tpd_D_P((863 - 14)- 48*17), true),
			107 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 14)- 48*0), true),
			108 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 14)- 48*1), true),
			109 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 14)- 48*2), true),
			110 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 14)- 48*3), true),
			111 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 14)- 48*4), true),
			112 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 14)- 48*5), true),
			113 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 14)- 48*6), true),
			114 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 14)- 48*7), true),
			115 => (PCIN_dly(33)'last_event, tpd_PCIN_P((2303 - 14)- 48*14), true),
			116 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 14)- 48*15), true),
			117 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 14)- 48*16), true),
			118 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 14)- 48*17), true),
			119 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 14)- 48*18), true),
			120 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 14)- 48*19), true),
			121 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 14)- 48*20), true),
			122 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 14)- 48*21), true),
			123 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 14)- 48*22), true),
			124 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 14)- 48*23), true),
			125 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 14)- 48*24), true),
			126 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 14)- 48*25), true),
			127 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 14)- 48*26), true),
			128 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 14)- 48*27), true),
			129 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 14)- 48*28), true),
			130 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 14)- 48*29), true),
			131 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 14)- 48*30), true),
			132 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 14)- 48*31), true),
			133 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 14)- 48*32), true),
			134 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 14)- 48*33), true),
			135 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 14)- 48*34), true),
			136 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 14)- 48*35), true),
			137 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 14)- 48*36), true),
			138 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 14)- 48*37), true),
			139 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 14)- 48*38), true),
			140 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 14)- 48*39), true),
			141 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 14)- 48*40), true),
			142 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 14)- 48*41), true),
			143 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 14)- 48*42), true),
			144 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 14)- 48*43), true),
			145 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 14)- 48*44), true),
			146 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 14)- 48*45), true),
			147 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 14)- 48*46), true),
			148 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 14)- 48*47), true),
			149 => (RSTA_dly'last_event, tpd_RSTA_P(33), true),
			150 => (RSTB_dly'last_event, tpd_RSTB_P(33), true),
			151 => (RSTC_dly'last_event, tpd_RSTC_P(33), true),
			152 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(33), true),
			153 => (RSTD_dly'last_event, tpd_RSTD_P(33), true),
			154 => (RSTM_dly'last_event, tpd_RSTM_P(33), true),
			155 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(33), true),
			156 => (RSTP_dly'last_event, tpd_RSTP_P(33), true),
			157 => (CLK_dly'last_event, tpd_CLK_P(33), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(32),
         GlitchData	=> P_GlitchData(32),
         OutSignalName	=> "P(32)",
         OutTemp	=> P_zd(32),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 15)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 15)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 15)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 15)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 15)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 15)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 15)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 15)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 15)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 15)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 15)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 15)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 15)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 15)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 15)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 15)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 15)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 15)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 15)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 15)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 15)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 15)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 15)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 15)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 15)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 15)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 15)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 15)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 15)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 15)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 15)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 15)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 15)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 15)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 15)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 15)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 15)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 15)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 15)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 15)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 15)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 15)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 15)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 15)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 15)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 15)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 15)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 15)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 15)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 15)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 15)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 15)- 48*17), true),
			54 => (C_dly(32)'last_event, tpd_C_P((2303 - 15)- 48*15), true),
			55 => (C_dly(31)'last_event, tpd_C_P((2303 - 15)- 48*16), true),
			56 => (C_dly(30)'last_event, tpd_C_P((2303 - 15)- 48*17), true),
			57 => (C_dly(29)'last_event, tpd_C_P((2303 - 15)- 48*18), true),
			58 => (C_dly(28)'last_event, tpd_C_P((2303 - 15)- 48*19), true),
			59 => (C_dly(27)'last_event, tpd_C_P((2303 - 15)- 48*20), true),
			60 => (C_dly(26)'last_event, tpd_C_P((2303 - 15)- 48*21), true),
			61 => (C_dly(25)'last_event, tpd_C_P((2303 - 15)- 48*22), true),
			62 => (C_dly(24)'last_event, tpd_C_P((2303 - 15)- 48*23), true),
			63 => (C_dly(23)'last_event, tpd_C_P((2303 - 15)- 48*24), true),
			64 => (C_dly(22)'last_event, tpd_C_P((2303 - 15)- 48*25), true),
			65 => (C_dly(21)'last_event, tpd_C_P((2303 - 15)- 48*26), true),
			66 => (C_dly(20)'last_event, tpd_C_P((2303 - 15)- 48*27), true),
			67 => (C_dly(19)'last_event, tpd_C_P((2303 - 15)- 48*28), true),
			68 => (C_dly(18)'last_event, tpd_C_P((2303 - 15)- 48*29), true),
			69 => (C_dly(17)'last_event, tpd_C_P((2303 - 15)- 48*30), true),
			70 => (C_dly(16)'last_event, tpd_C_P((2303 - 15)- 48*31), true),
			71 => (C_dly(15)'last_event, tpd_C_P((2303 - 15)- 48*32), true),
			72 => (C_dly(14)'last_event, tpd_C_P((2303 - 15)- 48*33), true),
			73 => (C_dly(13)'last_event, tpd_C_P((2303 - 15)- 48*34), true),
			74 => (C_dly(12)'last_event, tpd_C_P((2303 - 15)- 48*35), true),
			75 => (C_dly(11)'last_event, tpd_C_P((2303 - 15)- 48*36), true),
			76 => (C_dly(10)'last_event, tpd_C_P((2303 - 15)- 48*37), true),
			77 => (C_dly(9)'last_event, tpd_C_P((2303 - 15)- 48*38), true),
			78 => (C_dly(8)'last_event, tpd_C_P((2303 - 15)- 48*39), true),
			79 => (C_dly(7)'last_event, tpd_C_P((2303 - 15)- 48*40), true),
			80 => (C_dly(6)'last_event, tpd_C_P((2303 - 15)- 48*41), true),
			81 => (C_dly(5)'last_event, tpd_C_P((2303 - 15)- 48*42), true),
			82 => (C_dly(4)'last_event, tpd_C_P((2303 - 15)- 48*43), true),
			83 => (C_dly(3)'last_event, tpd_C_P((2303 - 15)- 48*44), true),
			84 => (C_dly(2)'last_event, tpd_C_P((2303 - 15)- 48*45), true),
			85 => (C_dly(1)'last_event, tpd_C_P((2303 - 15)- 48*46), true),
			86 => (C_dly(0)'last_event, tpd_C_P((2303 - 15)- 48*47), true),
			87 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(32), true),
			88 => (D_dly(17)'last_event, tpd_D_P((863 - 15)- 48*0), true),
			89 => (D_dly(16)'last_event, tpd_D_P((863 - 15)- 48*1), true),
			90 => (D_dly(15)'last_event, tpd_D_P((863 - 15)- 48*2), true),
			91 => (D_dly(14)'last_event, tpd_D_P((863 - 15)- 48*3), true),
			92 => (D_dly(13)'last_event, tpd_D_P((863 - 15)- 48*4), true),
			93 => (D_dly(12)'last_event, tpd_D_P((863 - 15)- 48*5), true),
			94 => (D_dly(11)'last_event, tpd_D_P((863 - 15)- 48*6), true),
			95 => (D_dly(10)'last_event, tpd_D_P((863 - 15)- 48*7), true),
			96 => (D_dly(9)'last_event, tpd_D_P((863 - 15)- 48*8), true),
			97 => (D_dly(8)'last_event, tpd_D_P((863 - 15)- 48*9), true),
			98 => (D_dly(7)'last_event, tpd_D_P((863 - 15)- 48*10), true),
			99 => (D_dly(6)'last_event, tpd_D_P((863 - 15)- 48*11), true),
			100 => (D_dly(5)'last_event, tpd_D_P((863 - 15)- 48*12), true),
			101 => (D_dly(4)'last_event, tpd_D_P((863 - 15)- 48*13), true),
			102 => (D_dly(3)'last_event, tpd_D_P((863 - 15)- 48*14), true),
			103 => (D_dly(2)'last_event, tpd_D_P((863 - 15)- 48*15), true),
			104 => (D_dly(1)'last_event, tpd_D_P((863 - 15)- 48*16), true),
			105 => (D_dly(0)'last_event, tpd_D_P((863 - 15)- 48*17), true),
			106 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 15)- 48*0), true),
			107 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 15)- 48*1), true),
			108 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 15)- 48*2), true),
			109 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 15)- 48*3), true),
			110 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 15)- 48*4), true),
			111 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 15)- 48*5), true),
			112 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 15)- 48*6), true),
			113 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 15)- 48*7), true),
			114 => (PCIN_dly(32)'last_event, tpd_PCIN_P((2303 - 15)- 48*15), true),
			115 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 15)- 48*16), true),
			116 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 15)- 48*17), true),
			117 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 15)- 48*18), true),
			118 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 15)- 48*19), true),
			119 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 15)- 48*20), true),
			120 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 15)- 48*21), true),
			121 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 15)- 48*22), true),
			122 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 15)- 48*23), true),
			123 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 15)- 48*24), true),
			124 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 15)- 48*25), true),
			125 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 15)- 48*26), true),
			126 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 15)- 48*27), true),
			127 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 15)- 48*28), true),
			128 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 15)- 48*29), true),
			129 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 15)- 48*30), true),
			130 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 15)- 48*31), true),
			131 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 15)- 48*32), true),
			132 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 15)- 48*33), true),
			133 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 15)- 48*34), true),
			134 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 15)- 48*35), true),
			135 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 15)- 48*36), true),
			136 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 15)- 48*37), true),
			137 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 15)- 48*38), true),
			138 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 15)- 48*39), true),
			139 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 15)- 48*40), true),
			140 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 15)- 48*41), true),
			141 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 15)- 48*42), true),
			142 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 15)- 48*43), true),
			143 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 15)- 48*44), true),
			144 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 15)- 48*45), true),
			145 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 15)- 48*46), true),
			146 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 15)- 48*47), true),
			147 => (RSTA_dly'last_event, tpd_RSTA_P(32), true),
			148 => (RSTB_dly'last_event, tpd_RSTB_P(32), true),
			149 => (RSTC_dly'last_event, tpd_RSTC_P(32), true),
			150 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(32), true),
			151 => (RSTD_dly'last_event, tpd_RSTD_P(32), true),
			152 => (RSTM_dly'last_event, tpd_RSTM_P(32), true),
			153 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(32), true),
			154 => (RSTP_dly'last_event, tpd_RSTP_P(32), true),
			155 => (CLK_dly'last_event, tpd_CLK_P(32), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(31),
         GlitchData	=> P_GlitchData(31),
         OutSignalName	=> "P(31)",
         OutTemp	=> P_zd(31),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 16)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 16)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 16)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 16)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 16)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 16)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 16)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 16)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 16)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 16)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 16)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 16)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 16)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 16)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 16)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 16)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 16)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 16)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 16)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 16)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 16)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 16)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 16)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 16)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 16)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 16)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 16)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 16)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 16)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 16)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 16)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 16)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 16)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 16)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 16)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 16)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 16)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 16)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 16)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 16)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 16)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 16)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 16)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 16)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 16)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 16)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 16)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 16)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 16)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 16)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 16)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 16)- 48*17), true),
			54 => (C_dly(31)'last_event, tpd_C_P((2303 - 16)- 48*16), true),
			55 => (C_dly(30)'last_event, tpd_C_P((2303 - 16)- 48*17), true),
			56 => (C_dly(29)'last_event, tpd_C_P((2303 - 16)- 48*18), true),
			57 => (C_dly(28)'last_event, tpd_C_P((2303 - 16)- 48*19), true),
			58 => (C_dly(27)'last_event, tpd_C_P((2303 - 16)- 48*20), true),
			59 => (C_dly(26)'last_event, tpd_C_P((2303 - 16)- 48*21), true),
			60 => (C_dly(25)'last_event, tpd_C_P((2303 - 16)- 48*22), true),
			61 => (C_dly(24)'last_event, tpd_C_P((2303 - 16)- 48*23), true),
			62 => (C_dly(23)'last_event, tpd_C_P((2303 - 16)- 48*24), true),
			63 => (C_dly(22)'last_event, tpd_C_P((2303 - 16)- 48*25), true),
			64 => (C_dly(21)'last_event, tpd_C_P((2303 - 16)- 48*26), true),
			65 => (C_dly(20)'last_event, tpd_C_P((2303 - 16)- 48*27), true),
			66 => (C_dly(19)'last_event, tpd_C_P((2303 - 16)- 48*28), true),
			67 => (C_dly(18)'last_event, tpd_C_P((2303 - 16)- 48*29), true),
			68 => (C_dly(17)'last_event, tpd_C_P((2303 - 16)- 48*30), true),
			69 => (C_dly(16)'last_event, tpd_C_P((2303 - 16)- 48*31), true),
			70 => (C_dly(15)'last_event, tpd_C_P((2303 - 16)- 48*32), true),
			71 => (C_dly(14)'last_event, tpd_C_P((2303 - 16)- 48*33), true),
			72 => (C_dly(13)'last_event, tpd_C_P((2303 - 16)- 48*34), true),
			73 => (C_dly(12)'last_event, tpd_C_P((2303 - 16)- 48*35), true),
			74 => (C_dly(11)'last_event, tpd_C_P((2303 - 16)- 48*36), true),
			75 => (C_dly(10)'last_event, tpd_C_P((2303 - 16)- 48*37), true),
			76 => (C_dly(9)'last_event, tpd_C_P((2303 - 16)- 48*38), true),
			77 => (C_dly(8)'last_event, tpd_C_P((2303 - 16)- 48*39), true),
			78 => (C_dly(7)'last_event, tpd_C_P((2303 - 16)- 48*40), true),
			79 => (C_dly(6)'last_event, tpd_C_P((2303 - 16)- 48*41), true),
			80 => (C_dly(5)'last_event, tpd_C_P((2303 - 16)- 48*42), true),
			81 => (C_dly(4)'last_event, tpd_C_P((2303 - 16)- 48*43), true),
			82 => (C_dly(3)'last_event, tpd_C_P((2303 - 16)- 48*44), true),
			83 => (C_dly(2)'last_event, tpd_C_P((2303 - 16)- 48*45), true),
			84 => (C_dly(1)'last_event, tpd_C_P((2303 - 16)- 48*46), true),
			85 => (C_dly(0)'last_event, tpd_C_P((2303 - 16)- 48*47), true),
			86 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(31), true),
			87 => (D_dly(17)'last_event, tpd_D_P((863 - 16)- 48*0), true),
			88 => (D_dly(16)'last_event, tpd_D_P((863 - 16)- 48*1), true),
			89 => (D_dly(15)'last_event, tpd_D_P((863 - 16)- 48*2), true),
			90 => (D_dly(14)'last_event, tpd_D_P((863 - 16)- 48*3), true),
			91 => (D_dly(13)'last_event, tpd_D_P((863 - 16)- 48*4), true),
			92 => (D_dly(12)'last_event, tpd_D_P((863 - 16)- 48*5), true),
			93 => (D_dly(11)'last_event, tpd_D_P((863 - 16)- 48*6), true),
			94 => (D_dly(10)'last_event, tpd_D_P((863 - 16)- 48*7), true),
			95 => (D_dly(9)'last_event, tpd_D_P((863 - 16)- 48*8), true),
			96 => (D_dly(8)'last_event, tpd_D_P((863 - 16)- 48*9), true),
			97 => (D_dly(7)'last_event, tpd_D_P((863 - 16)- 48*10), true),
			98 => (D_dly(6)'last_event, tpd_D_P((863 - 16)- 48*11), true),
			99 => (D_dly(5)'last_event, tpd_D_P((863 - 16)- 48*12), true),
			100 => (D_dly(4)'last_event, tpd_D_P((863 - 16)- 48*13), true),
			101 => (D_dly(3)'last_event, tpd_D_P((863 - 16)- 48*14), true),
			102 => (D_dly(2)'last_event, tpd_D_P((863 - 16)- 48*15), true),
			103 => (D_dly(1)'last_event, tpd_D_P((863 - 16)- 48*16), true),
			104 => (D_dly(0)'last_event, tpd_D_P((863 - 16)- 48*17), true),
			105 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 16)- 48*0), true),
			106 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 16)- 48*1), true),
			107 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 16)- 48*2), true),
			108 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 16)- 48*3), true),
			109 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 16)- 48*4), true),
			110 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 16)- 48*5), true),
			111 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 16)- 48*6), true),
			112 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 16)- 48*7), true),
			113 => (PCIN_dly(31)'last_event, tpd_PCIN_P((2303 - 16)- 48*16), true),
			114 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 16)- 48*17), true),
			115 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 16)- 48*18), true),
			116 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 16)- 48*19), true),
			117 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 16)- 48*20), true),
			118 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 16)- 48*21), true),
			119 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 16)- 48*22), true),
			120 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 16)- 48*23), true),
			121 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 16)- 48*24), true),
			122 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 16)- 48*25), true),
			123 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 16)- 48*26), true),
			124 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 16)- 48*27), true),
			125 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 16)- 48*28), true),
			126 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 16)- 48*29), true),
			127 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 16)- 48*30), true),
			128 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 16)- 48*31), true),
			129 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 16)- 48*32), true),
			130 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 16)- 48*33), true),
			131 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 16)- 48*34), true),
			132 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 16)- 48*35), true),
			133 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 16)- 48*36), true),
			134 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 16)- 48*37), true),
			135 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 16)- 48*38), true),
			136 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 16)- 48*39), true),
			137 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 16)- 48*40), true),
			138 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 16)- 48*41), true),
			139 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 16)- 48*42), true),
			140 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 16)- 48*43), true),
			141 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 16)- 48*44), true),
			142 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 16)- 48*45), true),
			143 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 16)- 48*46), true),
			144 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 16)- 48*47), true),
			145 => (RSTA_dly'last_event, tpd_RSTA_P(31), true),
			146 => (RSTB_dly'last_event, tpd_RSTB_P(31), true),
			147 => (RSTC_dly'last_event, tpd_RSTC_P(31), true),
			148 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(31), true),
			149 => (RSTD_dly'last_event, tpd_RSTD_P(31), true),
			150 => (RSTM_dly'last_event, tpd_RSTM_P(31), true),
			151 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(31), true),
			152 => (RSTP_dly'last_event, tpd_RSTP_P(31), true),
			153 => (CLK_dly'last_event, tpd_CLK_P(31), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(30),
         GlitchData	=> P_GlitchData(30),
         OutSignalName	=> "P(30)",
         OutTemp	=> P_zd(30),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 17)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 17)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 17)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 17)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 17)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 17)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 17)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 17)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 17)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 17)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 17)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 17)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 17)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 17)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 17)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 17)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 17)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 17)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 17)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 17)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 17)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 17)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 17)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 17)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 17)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 17)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 17)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 17)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 17)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 17)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 17)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 17)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 17)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 17)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 17)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 17)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 17)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 17)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 17)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 17)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 17)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 17)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 17)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 17)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 17)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 17)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 17)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 17)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 17)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 17)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 17)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 17)- 48*17), true),
			54 => (C_dly(30)'last_event, tpd_C_P((2303 - 17)- 48*17), true),
			55 => (C_dly(29)'last_event, tpd_C_P((2303 - 17)- 48*18), true),
			56 => (C_dly(28)'last_event, tpd_C_P((2303 - 17)- 48*19), true),
			57 => (C_dly(27)'last_event, tpd_C_P((2303 - 17)- 48*20), true),
			58 => (C_dly(26)'last_event, tpd_C_P((2303 - 17)- 48*21), true),
			59 => (C_dly(25)'last_event, tpd_C_P((2303 - 17)- 48*22), true),
			60 => (C_dly(24)'last_event, tpd_C_P((2303 - 17)- 48*23), true),
			61 => (C_dly(23)'last_event, tpd_C_P((2303 - 17)- 48*24), true),
			62 => (C_dly(22)'last_event, tpd_C_P((2303 - 17)- 48*25), true),
			63 => (C_dly(21)'last_event, tpd_C_P((2303 - 17)- 48*26), true),
			64 => (C_dly(20)'last_event, tpd_C_P((2303 - 17)- 48*27), true),
			65 => (C_dly(19)'last_event, tpd_C_P((2303 - 17)- 48*28), true),
			66 => (C_dly(18)'last_event, tpd_C_P((2303 - 17)- 48*29), true),
			67 => (C_dly(17)'last_event, tpd_C_P((2303 - 17)- 48*30), true),
			68 => (C_dly(16)'last_event, tpd_C_P((2303 - 17)- 48*31), true),
			69 => (C_dly(15)'last_event, tpd_C_P((2303 - 17)- 48*32), true),
			70 => (C_dly(14)'last_event, tpd_C_P((2303 - 17)- 48*33), true),
			71 => (C_dly(13)'last_event, tpd_C_P((2303 - 17)- 48*34), true),
			72 => (C_dly(12)'last_event, tpd_C_P((2303 - 17)- 48*35), true),
			73 => (C_dly(11)'last_event, tpd_C_P((2303 - 17)- 48*36), true),
			74 => (C_dly(10)'last_event, tpd_C_P((2303 - 17)- 48*37), true),
			75 => (C_dly(9)'last_event, tpd_C_P((2303 - 17)- 48*38), true),
			76 => (C_dly(8)'last_event, tpd_C_P((2303 - 17)- 48*39), true),
			77 => (C_dly(7)'last_event, tpd_C_P((2303 - 17)- 48*40), true),
			78 => (C_dly(6)'last_event, tpd_C_P((2303 - 17)- 48*41), true),
			79 => (C_dly(5)'last_event, tpd_C_P((2303 - 17)- 48*42), true),
			80 => (C_dly(4)'last_event, tpd_C_P((2303 - 17)- 48*43), true),
			81 => (C_dly(3)'last_event, tpd_C_P((2303 - 17)- 48*44), true),
			82 => (C_dly(2)'last_event, tpd_C_P((2303 - 17)- 48*45), true),
			83 => (C_dly(1)'last_event, tpd_C_P((2303 - 17)- 48*46), true),
			84 => (C_dly(0)'last_event, tpd_C_P((2303 - 17)- 48*47), true),
			85 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(30), true),
			86 => (D_dly(17)'last_event, tpd_D_P((863 - 17)- 48*0), true),
			87 => (D_dly(16)'last_event, tpd_D_P((863 - 17)- 48*1), true),
			88 => (D_dly(15)'last_event, tpd_D_P((863 - 17)- 48*2), true),
			89 => (D_dly(14)'last_event, tpd_D_P((863 - 17)- 48*3), true),
			90 => (D_dly(13)'last_event, tpd_D_P((863 - 17)- 48*4), true),
			91 => (D_dly(12)'last_event, tpd_D_P((863 - 17)- 48*5), true),
			92 => (D_dly(11)'last_event, tpd_D_P((863 - 17)- 48*6), true),
			93 => (D_dly(10)'last_event, tpd_D_P((863 - 17)- 48*7), true),
			94 => (D_dly(9)'last_event, tpd_D_P((863 - 17)- 48*8), true),
			95 => (D_dly(8)'last_event, tpd_D_P((863 - 17)- 48*9), true),
			96 => (D_dly(7)'last_event, tpd_D_P((863 - 17)- 48*10), true),
			97 => (D_dly(6)'last_event, tpd_D_P((863 - 17)- 48*11), true),
			98 => (D_dly(5)'last_event, tpd_D_P((863 - 17)- 48*12), true),
			99 => (D_dly(4)'last_event, tpd_D_P((863 - 17)- 48*13), true),
			100 => (D_dly(3)'last_event, tpd_D_P((863 - 17)- 48*14), true),
			101 => (D_dly(2)'last_event, tpd_D_P((863 - 17)- 48*15), true),
			102 => (D_dly(1)'last_event, tpd_D_P((863 - 17)- 48*16), true),
			103 => (D_dly(0)'last_event, tpd_D_P((863 - 17)- 48*17), true),
			104 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 17)- 48*0), true),
			105 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 17)- 48*1), true),
			106 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 17)- 48*2), true),
			107 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 17)- 48*3), true),
			108 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 17)- 48*4), true),
			109 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 17)- 48*5), true),
			110 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 17)- 48*6), true),
			111 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 17)- 48*7), true),
			112 => (PCIN_dly(30)'last_event, tpd_PCIN_P((2303 - 17)- 48*17), true),
			113 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 17)- 48*18), true),
			114 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 17)- 48*19), true),
			115 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 17)- 48*20), true),
			116 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 17)- 48*21), true),
			117 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 17)- 48*22), true),
			118 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 17)- 48*23), true),
			119 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 17)- 48*24), true),
			120 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 17)- 48*25), true),
			121 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 17)- 48*26), true),
			122 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 17)- 48*27), true),
			123 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 17)- 48*28), true),
			124 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 17)- 48*29), true),
			125 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 17)- 48*30), true),
			126 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 17)- 48*31), true),
			127 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 17)- 48*32), true),
			128 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 17)- 48*33), true),
			129 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 17)- 48*34), true),
			130 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 17)- 48*35), true),
			131 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 17)- 48*36), true),
			132 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 17)- 48*37), true),
			133 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 17)- 48*38), true),
			134 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 17)- 48*39), true),
			135 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 17)- 48*40), true),
			136 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 17)- 48*41), true),
			137 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 17)- 48*42), true),
			138 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 17)- 48*43), true),
			139 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 17)- 48*44), true),
			140 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 17)- 48*45), true),
			141 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 17)- 48*46), true),
			142 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 17)- 48*47), true),
			143 => (RSTA_dly'last_event, tpd_RSTA_P(30), true),
			144 => (RSTB_dly'last_event, tpd_RSTB_P(30), true),
			145 => (RSTC_dly'last_event, tpd_RSTC_P(30), true),
			146 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(30), true),
			147 => (RSTD_dly'last_event, tpd_RSTD_P(30), true),
			148 => (RSTM_dly'last_event, tpd_RSTM_P(30), true),
			149 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(30), true),
			150 => (RSTP_dly'last_event, tpd_RSTP_P(30), true),
			151 => (CLK_dly'last_event, tpd_CLK_P(30), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(29),
         GlitchData	=> P_GlitchData(29),
         OutSignalName	=> "P(29)",
         OutTemp	=> P_zd(29),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 18)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 18)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 18)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 18)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 18)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 18)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 18)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 18)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 18)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 18)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 18)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 18)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 18)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 18)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 18)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 18)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 18)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 18)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 18)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 18)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 18)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 18)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 18)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 18)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 18)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 18)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 18)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 18)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 18)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 18)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 18)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 18)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 18)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 18)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 18)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 18)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 18)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 18)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 18)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 18)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 18)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 18)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 18)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 18)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 18)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 18)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 18)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 18)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 18)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 18)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 18)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 18)- 48*17), true),
			54 => (C_dly(29)'last_event, tpd_C_P((2303 - 18)- 48*18), true),
			55 => (C_dly(28)'last_event, tpd_C_P((2303 - 18)- 48*19), true),
			56 => (C_dly(27)'last_event, tpd_C_P((2303 - 18)- 48*20), true),
			57 => (C_dly(26)'last_event, tpd_C_P((2303 - 18)- 48*21), true),
			58 => (C_dly(25)'last_event, tpd_C_P((2303 - 18)- 48*22), true),
			59 => (C_dly(24)'last_event, tpd_C_P((2303 - 18)- 48*23), true),
			60 => (C_dly(23)'last_event, tpd_C_P((2303 - 18)- 48*24), true),
			61 => (C_dly(22)'last_event, tpd_C_P((2303 - 18)- 48*25), true),
			62 => (C_dly(21)'last_event, tpd_C_P((2303 - 18)- 48*26), true),
			63 => (C_dly(20)'last_event, tpd_C_P((2303 - 18)- 48*27), true),
			64 => (C_dly(19)'last_event, tpd_C_P((2303 - 18)- 48*28), true),
			65 => (C_dly(18)'last_event, tpd_C_P((2303 - 18)- 48*29), true),
			66 => (C_dly(17)'last_event, tpd_C_P((2303 - 18)- 48*30), true),
			67 => (C_dly(16)'last_event, tpd_C_P((2303 - 18)- 48*31), true),
			68 => (C_dly(15)'last_event, tpd_C_P((2303 - 18)- 48*32), true),
			69 => (C_dly(14)'last_event, tpd_C_P((2303 - 18)- 48*33), true),
			70 => (C_dly(13)'last_event, tpd_C_P((2303 - 18)- 48*34), true),
			71 => (C_dly(12)'last_event, tpd_C_P((2303 - 18)- 48*35), true),
			72 => (C_dly(11)'last_event, tpd_C_P((2303 - 18)- 48*36), true),
			73 => (C_dly(10)'last_event, tpd_C_P((2303 - 18)- 48*37), true),
			74 => (C_dly(9)'last_event, tpd_C_P((2303 - 18)- 48*38), true),
			75 => (C_dly(8)'last_event, tpd_C_P((2303 - 18)- 48*39), true),
			76 => (C_dly(7)'last_event, tpd_C_P((2303 - 18)- 48*40), true),
			77 => (C_dly(6)'last_event, tpd_C_P((2303 - 18)- 48*41), true),
			78 => (C_dly(5)'last_event, tpd_C_P((2303 - 18)- 48*42), true),
			79 => (C_dly(4)'last_event, tpd_C_P((2303 - 18)- 48*43), true),
			80 => (C_dly(3)'last_event, tpd_C_P((2303 - 18)- 48*44), true),
			81 => (C_dly(2)'last_event, tpd_C_P((2303 - 18)- 48*45), true),
			82 => (C_dly(1)'last_event, tpd_C_P((2303 - 18)- 48*46), true),
			83 => (C_dly(0)'last_event, tpd_C_P((2303 - 18)- 48*47), true),
			84 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(29), true),
			85 => (D_dly(17)'last_event, tpd_D_P((863 - 18)- 48*0), true),
			86 => (D_dly(16)'last_event, tpd_D_P((863 - 18)- 48*1), true),
			87 => (D_dly(15)'last_event, tpd_D_P((863 - 18)- 48*2), true),
			88 => (D_dly(14)'last_event, tpd_D_P((863 - 18)- 48*3), true),
			89 => (D_dly(13)'last_event, tpd_D_P((863 - 18)- 48*4), true),
			90 => (D_dly(12)'last_event, tpd_D_P((863 - 18)- 48*5), true),
			91 => (D_dly(11)'last_event, tpd_D_P((863 - 18)- 48*6), true),
			92 => (D_dly(10)'last_event, tpd_D_P((863 - 18)- 48*7), true),
			93 => (D_dly(9)'last_event, tpd_D_P((863 - 18)- 48*8), true),
			94 => (D_dly(8)'last_event, tpd_D_P((863 - 18)- 48*9), true),
			95 => (D_dly(7)'last_event, tpd_D_P((863 - 18)- 48*10), true),
			96 => (D_dly(6)'last_event, tpd_D_P((863 - 18)- 48*11), true),
			97 => (D_dly(5)'last_event, tpd_D_P((863 - 18)- 48*12), true),
			98 => (D_dly(4)'last_event, tpd_D_P((863 - 18)- 48*13), true),
			99 => (D_dly(3)'last_event, tpd_D_P((863 - 18)- 48*14), true),
			100 => (D_dly(2)'last_event, tpd_D_P((863 - 18)- 48*15), true),
			101 => (D_dly(1)'last_event, tpd_D_P((863 - 18)- 48*16), true),
			102 => (D_dly(0)'last_event, tpd_D_P((863 - 18)- 48*17), true),
			103 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 18)- 48*0), true),
			104 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 18)- 48*1), true),
			105 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 18)- 48*2), true),
			106 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 18)- 48*3), true),
			107 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 18)- 48*4), true),
			108 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 18)- 48*5), true),
			109 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 18)- 48*6), true),
			110 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 18)- 48*7), true),
			111 => (PCIN_dly(29)'last_event, tpd_PCIN_P((2303 - 18)- 48*18), true),
			112 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 18)- 48*19), true),
			113 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 18)- 48*20), true),
			114 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 18)- 48*21), true),
			115 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 18)- 48*22), true),
			116 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 18)- 48*23), true),
			117 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 18)- 48*24), true),
			118 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 18)- 48*25), true),
			119 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 18)- 48*26), true),
			120 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 18)- 48*27), true),
			121 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 18)- 48*28), true),
			122 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 18)- 48*29), true),
			123 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 18)- 48*30), true),
			124 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 18)- 48*31), true),
			125 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 18)- 48*32), true),
			126 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 18)- 48*33), true),
			127 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 18)- 48*34), true),
			128 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 18)- 48*35), true),
			129 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 18)- 48*36), true),
			130 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 18)- 48*37), true),
			131 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 18)- 48*38), true),
			132 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 18)- 48*39), true),
			133 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 18)- 48*40), true),
			134 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 18)- 48*41), true),
			135 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 18)- 48*42), true),
			136 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 18)- 48*43), true),
			137 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 18)- 48*44), true),
			138 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 18)- 48*45), true),
			139 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 18)- 48*46), true),
			140 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 18)- 48*47), true),
			141 => (RSTA_dly'last_event, tpd_RSTA_P(29), true),
			142 => (RSTB_dly'last_event, tpd_RSTB_P(29), true),
			143 => (RSTC_dly'last_event, tpd_RSTC_P(29), true),
			144 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(29), true),
			145 => (RSTD_dly'last_event, tpd_RSTD_P(29), true),
			146 => (RSTM_dly'last_event, tpd_RSTM_P(29), true),
			147 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(29), true),
			148 => (RSTP_dly'last_event, tpd_RSTP_P(29), true),
			149 => (CLK_dly'last_event, tpd_CLK_P(29), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(28),
         GlitchData	=> P_GlitchData(28),
         OutSignalName	=> "P(28)",
         OutTemp	=> P_zd(28),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 19)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 19)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 19)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 19)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 19)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 19)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 19)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 19)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 19)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 19)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 19)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 19)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 19)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 19)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 19)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 19)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 19)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 19)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 19)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 19)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 19)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 19)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 19)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 19)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 19)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 19)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 19)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 19)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 19)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 19)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 19)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 19)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 19)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 19)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 19)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 19)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 19)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 19)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 19)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 19)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 19)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 19)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 19)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 19)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 19)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 19)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 19)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 19)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 19)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 19)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 19)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 19)- 48*17), true),
			54 => (C_dly(28)'last_event, tpd_C_P((2303 - 19)- 48*19), true),
			55 => (C_dly(27)'last_event, tpd_C_P((2303 - 19)- 48*20), true),
			56 => (C_dly(26)'last_event, tpd_C_P((2303 - 19)- 48*21), true),
			57 => (C_dly(25)'last_event, tpd_C_P((2303 - 19)- 48*22), true),
			58 => (C_dly(24)'last_event, tpd_C_P((2303 - 19)- 48*23), true),
			59 => (C_dly(23)'last_event, tpd_C_P((2303 - 19)- 48*24), true),
			60 => (C_dly(22)'last_event, tpd_C_P((2303 - 19)- 48*25), true),
			61 => (C_dly(21)'last_event, tpd_C_P((2303 - 19)- 48*26), true),
			62 => (C_dly(20)'last_event, tpd_C_P((2303 - 19)- 48*27), true),
			63 => (C_dly(19)'last_event, tpd_C_P((2303 - 19)- 48*28), true),
			64 => (C_dly(18)'last_event, tpd_C_P((2303 - 19)- 48*29), true),
			65 => (C_dly(17)'last_event, tpd_C_P((2303 - 19)- 48*30), true),
			66 => (C_dly(16)'last_event, tpd_C_P((2303 - 19)- 48*31), true),
			67 => (C_dly(15)'last_event, tpd_C_P((2303 - 19)- 48*32), true),
			68 => (C_dly(14)'last_event, tpd_C_P((2303 - 19)- 48*33), true),
			69 => (C_dly(13)'last_event, tpd_C_P((2303 - 19)- 48*34), true),
			70 => (C_dly(12)'last_event, tpd_C_P((2303 - 19)- 48*35), true),
			71 => (C_dly(11)'last_event, tpd_C_P((2303 - 19)- 48*36), true),
			72 => (C_dly(10)'last_event, tpd_C_P((2303 - 19)- 48*37), true),
			73 => (C_dly(9)'last_event, tpd_C_P((2303 - 19)- 48*38), true),
			74 => (C_dly(8)'last_event, tpd_C_P((2303 - 19)- 48*39), true),
			75 => (C_dly(7)'last_event, tpd_C_P((2303 - 19)- 48*40), true),
			76 => (C_dly(6)'last_event, tpd_C_P((2303 - 19)- 48*41), true),
			77 => (C_dly(5)'last_event, tpd_C_P((2303 - 19)- 48*42), true),
			78 => (C_dly(4)'last_event, tpd_C_P((2303 - 19)- 48*43), true),
			79 => (C_dly(3)'last_event, tpd_C_P((2303 - 19)- 48*44), true),
			80 => (C_dly(2)'last_event, tpd_C_P((2303 - 19)- 48*45), true),
			81 => (C_dly(1)'last_event, tpd_C_P((2303 - 19)- 48*46), true),
			82 => (C_dly(0)'last_event, tpd_C_P((2303 - 19)- 48*47), true),
			83 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(28), true),
			84 => (D_dly(17)'last_event, tpd_D_P((863 - 19)- 48*0), true),
			85 => (D_dly(16)'last_event, tpd_D_P((863 - 19)- 48*1), true),
			86 => (D_dly(15)'last_event, tpd_D_P((863 - 19)- 48*2), true),
			87 => (D_dly(14)'last_event, tpd_D_P((863 - 19)- 48*3), true),
			88 => (D_dly(13)'last_event, tpd_D_P((863 - 19)- 48*4), true),
			89 => (D_dly(12)'last_event, tpd_D_P((863 - 19)- 48*5), true),
			90 => (D_dly(11)'last_event, tpd_D_P((863 - 19)- 48*6), true),
			91 => (D_dly(10)'last_event, tpd_D_P((863 - 19)- 48*7), true),
			92 => (D_dly(9)'last_event, tpd_D_P((863 - 19)- 48*8), true),
			93 => (D_dly(8)'last_event, tpd_D_P((863 - 19)- 48*9), true),
			94 => (D_dly(7)'last_event, tpd_D_P((863 - 19)- 48*10), true),
			95 => (D_dly(6)'last_event, tpd_D_P((863 - 19)- 48*11), true),
			96 => (D_dly(5)'last_event, tpd_D_P((863 - 19)- 48*12), true),
			97 => (D_dly(4)'last_event, tpd_D_P((863 - 19)- 48*13), true),
			98 => (D_dly(3)'last_event, tpd_D_P((863 - 19)- 48*14), true),
			99 => (D_dly(2)'last_event, tpd_D_P((863 - 19)- 48*15), true),
			100 => (D_dly(1)'last_event, tpd_D_P((863 - 19)- 48*16), true),
			101 => (D_dly(0)'last_event, tpd_D_P((863 - 19)- 48*17), true),
			102 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 19)- 48*0), true),
			103 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 19)- 48*1), true),
			104 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 19)- 48*2), true),
			105 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 19)- 48*3), true),
			106 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 19)- 48*4), true),
			107 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 19)- 48*5), true),
			108 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 19)- 48*6), true),
			109 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 19)- 48*7), true),
			110 => (PCIN_dly(28)'last_event, tpd_PCIN_P((2303 - 19)- 48*19), true),
			111 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 19)- 48*20), true),
			112 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 19)- 48*21), true),
			113 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 19)- 48*22), true),
			114 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 19)- 48*23), true),
			115 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 19)- 48*24), true),
			116 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 19)- 48*25), true),
			117 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 19)- 48*26), true),
			118 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 19)- 48*27), true),
			119 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 19)- 48*28), true),
			120 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 19)- 48*29), true),
			121 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 19)- 48*30), true),
			122 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 19)- 48*31), true),
			123 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 19)- 48*32), true),
			124 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 19)- 48*33), true),
			125 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 19)- 48*34), true),
			126 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 19)- 48*35), true),
			127 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 19)- 48*36), true),
			128 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 19)- 48*37), true),
			129 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 19)- 48*38), true),
			130 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 19)- 48*39), true),
			131 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 19)- 48*40), true),
			132 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 19)- 48*41), true),
			133 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 19)- 48*42), true),
			134 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 19)- 48*43), true),
			135 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 19)- 48*44), true),
			136 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 19)- 48*45), true),
			137 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 19)- 48*46), true),
			138 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 19)- 48*47), true),
			139 => (RSTA_dly'last_event, tpd_RSTA_P(28), true),
			140 => (RSTB_dly'last_event, tpd_RSTB_P(28), true),
			141 => (RSTC_dly'last_event, tpd_RSTC_P(28), true),
			142 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(28), true),
			143 => (RSTD_dly'last_event, tpd_RSTD_P(28), true),
			144 => (RSTM_dly'last_event, tpd_RSTM_P(28), true),
			145 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(28), true),
			146 => (RSTP_dly'last_event, tpd_RSTP_P(28), true),
			147 => (CLK_dly'last_event, tpd_CLK_P(28), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(27),
         GlitchData	=> P_GlitchData(27),
         OutSignalName	=> "P(27)",
         OutTemp	=> P_zd(27),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 20)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 20)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 20)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 20)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 20)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 20)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 20)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 20)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 20)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 20)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 20)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 20)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 20)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 20)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 20)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 20)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 20)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 20)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 20)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 20)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 20)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 20)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 20)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 20)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 20)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 20)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 20)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 20)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 20)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 20)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 20)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 20)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 20)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 20)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 20)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 20)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 20)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 20)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 20)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 20)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 20)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 20)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 20)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 20)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 20)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 20)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 20)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 20)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 20)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 20)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 20)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 20)- 48*17), true),
			54 => (C_dly(27)'last_event, tpd_C_P((2303 - 20)- 48*20), true),
			55 => (C_dly(26)'last_event, tpd_C_P((2303 - 20)- 48*21), true),
			56 => (C_dly(25)'last_event, tpd_C_P((2303 - 20)- 48*22), true),
			57 => (C_dly(24)'last_event, tpd_C_P((2303 - 20)- 48*23), true),
			58 => (C_dly(23)'last_event, tpd_C_P((2303 - 20)- 48*24), true),
			59 => (C_dly(22)'last_event, tpd_C_P((2303 - 20)- 48*25), true),
			60 => (C_dly(21)'last_event, tpd_C_P((2303 - 20)- 48*26), true),
			61 => (C_dly(20)'last_event, tpd_C_P((2303 - 20)- 48*27), true),
			62 => (C_dly(19)'last_event, tpd_C_P((2303 - 20)- 48*28), true),
			63 => (C_dly(18)'last_event, tpd_C_P((2303 - 20)- 48*29), true),
			64 => (C_dly(17)'last_event, tpd_C_P((2303 - 20)- 48*30), true),
			65 => (C_dly(16)'last_event, tpd_C_P((2303 - 20)- 48*31), true),
			66 => (C_dly(15)'last_event, tpd_C_P((2303 - 20)- 48*32), true),
			67 => (C_dly(14)'last_event, tpd_C_P((2303 - 20)- 48*33), true),
			68 => (C_dly(13)'last_event, tpd_C_P((2303 - 20)- 48*34), true),
			69 => (C_dly(12)'last_event, tpd_C_P((2303 - 20)- 48*35), true),
			70 => (C_dly(11)'last_event, tpd_C_P((2303 - 20)- 48*36), true),
			71 => (C_dly(10)'last_event, tpd_C_P((2303 - 20)- 48*37), true),
			72 => (C_dly(9)'last_event, tpd_C_P((2303 - 20)- 48*38), true),
			73 => (C_dly(8)'last_event, tpd_C_P((2303 - 20)- 48*39), true),
			74 => (C_dly(7)'last_event, tpd_C_P((2303 - 20)- 48*40), true),
			75 => (C_dly(6)'last_event, tpd_C_P((2303 - 20)- 48*41), true),
			76 => (C_dly(5)'last_event, tpd_C_P((2303 - 20)- 48*42), true),
			77 => (C_dly(4)'last_event, tpd_C_P((2303 - 20)- 48*43), true),
			78 => (C_dly(3)'last_event, tpd_C_P((2303 - 20)- 48*44), true),
			79 => (C_dly(2)'last_event, tpd_C_P((2303 - 20)- 48*45), true),
			80 => (C_dly(1)'last_event, tpd_C_P((2303 - 20)- 48*46), true),
			81 => (C_dly(0)'last_event, tpd_C_P((2303 - 20)- 48*47), true),
			82 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(27), true),
			83 => (D_dly(17)'last_event, tpd_D_P((863 - 20)- 48*0), true),
			84 => (D_dly(16)'last_event, tpd_D_P((863 - 20)- 48*1), true),
			85 => (D_dly(15)'last_event, tpd_D_P((863 - 20)- 48*2), true),
			86 => (D_dly(14)'last_event, tpd_D_P((863 - 20)- 48*3), true),
			87 => (D_dly(13)'last_event, tpd_D_P((863 - 20)- 48*4), true),
			88 => (D_dly(12)'last_event, tpd_D_P((863 - 20)- 48*5), true),
			89 => (D_dly(11)'last_event, tpd_D_P((863 - 20)- 48*6), true),
			90 => (D_dly(10)'last_event, tpd_D_P((863 - 20)- 48*7), true),
			91 => (D_dly(9)'last_event, tpd_D_P((863 - 20)- 48*8), true),
			92 => (D_dly(8)'last_event, tpd_D_P((863 - 20)- 48*9), true),
			93 => (D_dly(7)'last_event, tpd_D_P((863 - 20)- 48*10), true),
			94 => (D_dly(6)'last_event, tpd_D_P((863 - 20)- 48*11), true),
			95 => (D_dly(5)'last_event, tpd_D_P((863 - 20)- 48*12), true),
			96 => (D_dly(4)'last_event, tpd_D_P((863 - 20)- 48*13), true),
			97 => (D_dly(3)'last_event, tpd_D_P((863 - 20)- 48*14), true),
			98 => (D_dly(2)'last_event, tpd_D_P((863 - 20)- 48*15), true),
			99 => (D_dly(1)'last_event, tpd_D_P((863 - 20)- 48*16), true),
			100 => (D_dly(0)'last_event, tpd_D_P((863 - 20)- 48*17), true),
			101 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 20)- 48*0), true),
			102 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 20)- 48*1), true),
			103 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 20)- 48*2), true),
			104 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 20)- 48*3), true),
			105 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 20)- 48*4), true),
			106 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 20)- 48*5), true),
			107 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 20)- 48*6), true),
			108 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 20)- 48*7), true),
			109 => (PCIN_dly(27)'last_event, tpd_PCIN_P((2303 - 20)- 48*20), true),
			110 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 20)- 48*21), true),
			111 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 20)- 48*22), true),
			112 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 20)- 48*23), true),
			113 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 20)- 48*24), true),
			114 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 20)- 48*25), true),
			115 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 20)- 48*26), true),
			116 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 20)- 48*27), true),
			117 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 20)- 48*28), true),
			118 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 20)- 48*29), true),
			119 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 20)- 48*30), true),
			120 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 20)- 48*31), true),
			121 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 20)- 48*32), true),
			122 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 20)- 48*33), true),
			123 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 20)- 48*34), true),
			124 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 20)- 48*35), true),
			125 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 20)- 48*36), true),
			126 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 20)- 48*37), true),
			127 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 20)- 48*38), true),
			128 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 20)- 48*39), true),
			129 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 20)- 48*40), true),
			130 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 20)- 48*41), true),
			131 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 20)- 48*42), true),
			132 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 20)- 48*43), true),
			133 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 20)- 48*44), true),
			134 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 20)- 48*45), true),
			135 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 20)- 48*46), true),
			136 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 20)- 48*47), true),
			137 => (RSTA_dly'last_event, tpd_RSTA_P(27), true),
			138 => (RSTB_dly'last_event, tpd_RSTB_P(27), true),
			139 => (RSTC_dly'last_event, tpd_RSTC_P(27), true),
			140 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(27), true),
			141 => (RSTD_dly'last_event, tpd_RSTD_P(27), true),
			142 => (RSTM_dly'last_event, tpd_RSTM_P(27), true),
			143 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(27), true),
			144 => (RSTP_dly'last_event, tpd_RSTP_P(27), true),
			145 => (CLK_dly'last_event, tpd_CLK_P(27), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(26),
         GlitchData	=> P_GlitchData(26),
         OutSignalName	=> "P(26)",
         OutTemp	=> P_zd(26),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 21)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 21)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 21)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 21)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 21)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 21)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 21)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 21)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 21)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 21)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 21)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 21)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 21)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 21)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 21)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 21)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 21)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 21)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 21)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 21)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 21)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 21)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 21)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 21)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 21)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 21)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 21)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 21)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 21)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 21)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 21)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 21)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 21)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 21)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 21)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 21)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 21)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 21)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 21)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 21)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 21)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 21)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 21)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 21)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 21)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 21)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 21)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 21)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 21)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 21)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 21)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 21)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 21)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 21)- 48*17), true),
			54 => (C_dly(26)'last_event, tpd_C_P((2303 - 21)- 48*21), true),
			55 => (C_dly(25)'last_event, tpd_C_P((2303 - 21)- 48*22), true),
			56 => (C_dly(24)'last_event, tpd_C_P((2303 - 21)- 48*23), true),
			57 => (C_dly(23)'last_event, tpd_C_P((2303 - 21)- 48*24), true),
			58 => (C_dly(22)'last_event, tpd_C_P((2303 - 21)- 48*25), true),
			59 => (C_dly(21)'last_event, tpd_C_P((2303 - 21)- 48*26), true),
			60 => (C_dly(20)'last_event, tpd_C_P((2303 - 21)- 48*27), true),
			61 => (C_dly(19)'last_event, tpd_C_P((2303 - 21)- 48*28), true),
			62 => (C_dly(18)'last_event, tpd_C_P((2303 - 21)- 48*29), true),
			63 => (C_dly(17)'last_event, tpd_C_P((2303 - 21)- 48*30), true),
			64 => (C_dly(16)'last_event, tpd_C_P((2303 - 21)- 48*31), true),
			65 => (C_dly(15)'last_event, tpd_C_P((2303 - 21)- 48*32), true),
			66 => (C_dly(14)'last_event, tpd_C_P((2303 - 21)- 48*33), true),
			67 => (C_dly(13)'last_event, tpd_C_P((2303 - 21)- 48*34), true),
			68 => (C_dly(12)'last_event, tpd_C_P((2303 - 21)- 48*35), true),
			69 => (C_dly(11)'last_event, tpd_C_P((2303 - 21)- 48*36), true),
			70 => (C_dly(10)'last_event, tpd_C_P((2303 - 21)- 48*37), true),
			71 => (C_dly(9)'last_event, tpd_C_P((2303 - 21)- 48*38), true),
			72 => (C_dly(8)'last_event, tpd_C_P((2303 - 21)- 48*39), true),
			73 => (C_dly(7)'last_event, tpd_C_P((2303 - 21)- 48*40), true),
			74 => (C_dly(6)'last_event, tpd_C_P((2303 - 21)- 48*41), true),
			75 => (C_dly(5)'last_event, tpd_C_P((2303 - 21)- 48*42), true),
			76 => (C_dly(4)'last_event, tpd_C_P((2303 - 21)- 48*43), true),
			77 => (C_dly(3)'last_event, tpd_C_P((2303 - 21)- 48*44), true),
			78 => (C_dly(2)'last_event, tpd_C_P((2303 - 21)- 48*45), true),
			79 => (C_dly(1)'last_event, tpd_C_P((2303 - 21)- 48*46), true),
			80 => (C_dly(0)'last_event, tpd_C_P((2303 - 21)- 48*47), true),
			81 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(26), true),
			82 => (D_dly(17)'last_event, tpd_D_P((863 - 21)- 48*0), true),
			83 => (D_dly(16)'last_event, tpd_D_P((863 - 21)- 48*1), true),
			84 => (D_dly(15)'last_event, tpd_D_P((863 - 21)- 48*2), true),
			85 => (D_dly(14)'last_event, tpd_D_P((863 - 21)- 48*3), true),
			86 => (D_dly(13)'last_event, tpd_D_P((863 - 21)- 48*4), true),
			87 => (D_dly(12)'last_event, tpd_D_P((863 - 21)- 48*5), true),
			88 => (D_dly(11)'last_event, tpd_D_P((863 - 21)- 48*6), true),
			89 => (D_dly(10)'last_event, tpd_D_P((863 - 21)- 48*7), true),
			90 => (D_dly(9)'last_event, tpd_D_P((863 - 21)- 48*8), true),
			91 => (D_dly(8)'last_event, tpd_D_P((863 - 21)- 48*9), true),
			92 => (D_dly(7)'last_event, tpd_D_P((863 - 21)- 48*10), true),
			93 => (D_dly(6)'last_event, tpd_D_P((863 - 21)- 48*11), true),
			94 => (D_dly(5)'last_event, tpd_D_P((863 - 21)- 48*12), true),
			95 => (D_dly(4)'last_event, tpd_D_P((863 - 21)- 48*13), true),
			96 => (D_dly(3)'last_event, tpd_D_P((863 - 21)- 48*14), true),
			97 => (D_dly(2)'last_event, tpd_D_P((863 - 21)- 48*15), true),
			98 => (D_dly(1)'last_event, tpd_D_P((863 - 21)- 48*16), true),
			99 => (D_dly(0)'last_event, tpd_D_P((863 - 21)- 48*17), true),
			100 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 21)- 48*0), true),
			101 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 21)- 48*1), true),
			102 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 21)- 48*2), true),
			103 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 21)- 48*3), true),
			104 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 21)- 48*4), true),
			105 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 21)- 48*5), true),
			106 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 21)- 48*6), true),
			107 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 21)- 48*7), true),
			108 => (PCIN_dly(26)'last_event, tpd_PCIN_P((2303 - 21)- 48*21), true),
			109 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 21)- 48*22), true),
			110 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 21)- 48*23), true),
			111 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 21)- 48*24), true),
			112 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 21)- 48*25), true),
			113 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 21)- 48*26), true),
			114 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 21)- 48*27), true),
			115 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 21)- 48*28), true),
			116 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 21)- 48*29), true),
			117 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 21)- 48*30), true),
			118 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 21)- 48*31), true),
			119 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 21)- 48*32), true),
			120 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 21)- 48*33), true),
			121 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 21)- 48*34), true),
			122 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 21)- 48*35), true),
			123 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 21)- 48*36), true),
			124 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 21)- 48*37), true),
			125 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 21)- 48*38), true),
			126 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 21)- 48*39), true),
			127 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 21)- 48*40), true),
			128 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 21)- 48*41), true),
			129 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 21)- 48*42), true),
			130 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 21)- 48*43), true),
			131 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 21)- 48*44), true),
			132 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 21)- 48*45), true),
			133 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 21)- 48*46), true),
			134 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 21)- 48*47), true),
			135 => (RSTA_dly'last_event, tpd_RSTA_P(26), true),
			136 => (RSTB_dly'last_event, tpd_RSTB_P(26), true),
			137 => (RSTC_dly'last_event, tpd_RSTC_P(26), true),
			138 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(26), true),
			139 => (RSTD_dly'last_event, tpd_RSTD_P(26), true),
			140 => (RSTM_dly'last_event, tpd_RSTM_P(26), true),
			141 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(26), true),
			142 => (RSTP_dly'last_event, tpd_RSTP_P(26), true),
			143 => (CLK_dly'last_event, tpd_CLK_P(26), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(25),
         GlitchData	=> P_GlitchData(25),
         OutSignalName	=> "P(25)",
         OutTemp	=> P_zd(25),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 22)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 22)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 22)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 22)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 22)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 22)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 22)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 22)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 22)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 22)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 22)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 22)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 22)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 22)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 22)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 22)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 22)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 22)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 22)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 22)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 22)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 22)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 22)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 22)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 22)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 22)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 22)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 22)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 22)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 22)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 22)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 22)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 22)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 22)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 22)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 22)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 22)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 22)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 22)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 22)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 22)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 22)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 22)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 22)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 22)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 22)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 22)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 22)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 22)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 22)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 22)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 22)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 22)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 22)- 48*17), true),
			54 => (C_dly(25)'last_event, tpd_C_P((2303 - 22)- 48*22), true),
			55 => (C_dly(24)'last_event, tpd_C_P((2303 - 22)- 48*23), true),
			56 => (C_dly(23)'last_event, tpd_C_P((2303 - 22)- 48*24), true),
			57 => (C_dly(22)'last_event, tpd_C_P((2303 - 22)- 48*25), true),
			58 => (C_dly(21)'last_event, tpd_C_P((2303 - 22)- 48*26), true),
			59 => (C_dly(20)'last_event, tpd_C_P((2303 - 22)- 48*27), true),
			60 => (C_dly(19)'last_event, tpd_C_P((2303 - 22)- 48*28), true),
			61 => (C_dly(18)'last_event, tpd_C_P((2303 - 22)- 48*29), true),
			62 => (C_dly(17)'last_event, tpd_C_P((2303 - 22)- 48*30), true),
			63 => (C_dly(16)'last_event, tpd_C_P((2303 - 22)- 48*31), true),
			64 => (C_dly(15)'last_event, tpd_C_P((2303 - 22)- 48*32), true),
			65 => (C_dly(14)'last_event, tpd_C_P((2303 - 22)- 48*33), true),
			66 => (C_dly(13)'last_event, tpd_C_P((2303 - 22)- 48*34), true),
			67 => (C_dly(12)'last_event, tpd_C_P((2303 - 22)- 48*35), true),
			68 => (C_dly(11)'last_event, tpd_C_P((2303 - 22)- 48*36), true),
			69 => (C_dly(10)'last_event, tpd_C_P((2303 - 22)- 48*37), true),
			70 => (C_dly(9)'last_event, tpd_C_P((2303 - 22)- 48*38), true),
			71 => (C_dly(8)'last_event, tpd_C_P((2303 - 22)- 48*39), true),
			72 => (C_dly(7)'last_event, tpd_C_P((2303 - 22)- 48*40), true),
			73 => (C_dly(6)'last_event, tpd_C_P((2303 - 22)- 48*41), true),
			74 => (C_dly(5)'last_event, tpd_C_P((2303 - 22)- 48*42), true),
			75 => (C_dly(4)'last_event, tpd_C_P((2303 - 22)- 48*43), true),
			76 => (C_dly(3)'last_event, tpd_C_P((2303 - 22)- 48*44), true),
			77 => (C_dly(2)'last_event, tpd_C_P((2303 - 22)- 48*45), true),
			78 => (C_dly(1)'last_event, tpd_C_P((2303 - 22)- 48*46), true),
			79 => (C_dly(0)'last_event, tpd_C_P((2303 - 22)- 48*47), true),
			80 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(25), true),
			81 => (D_dly(17)'last_event, tpd_D_P((863 - 22)- 48*0), true),
			82 => (D_dly(16)'last_event, tpd_D_P((863 - 22)- 48*1), true),
			83 => (D_dly(15)'last_event, tpd_D_P((863 - 22)- 48*2), true),
			84 => (D_dly(14)'last_event, tpd_D_P((863 - 22)- 48*3), true),
			85 => (D_dly(13)'last_event, tpd_D_P((863 - 22)- 48*4), true),
			86 => (D_dly(12)'last_event, tpd_D_P((863 - 22)- 48*5), true),
			87 => (D_dly(11)'last_event, tpd_D_P((863 - 22)- 48*6), true),
			88 => (D_dly(10)'last_event, tpd_D_P((863 - 22)- 48*7), true),
			89 => (D_dly(9)'last_event, tpd_D_P((863 - 22)- 48*8), true),
			90 => (D_dly(8)'last_event, tpd_D_P((863 - 22)- 48*9), true),
			91 => (D_dly(7)'last_event, tpd_D_P((863 - 22)- 48*10), true),
			92 => (D_dly(6)'last_event, tpd_D_P((863 - 22)- 48*11), true),
			93 => (D_dly(5)'last_event, tpd_D_P((863 - 22)- 48*12), true),
			94 => (D_dly(4)'last_event, tpd_D_P((863 - 22)- 48*13), true),
			95 => (D_dly(3)'last_event, tpd_D_P((863 - 22)- 48*14), true),
			96 => (D_dly(2)'last_event, tpd_D_P((863 - 22)- 48*15), true),
			97 => (D_dly(1)'last_event, tpd_D_P((863 - 22)- 48*16), true),
			98 => (D_dly(0)'last_event, tpd_D_P((863 - 22)- 48*17), true),
			99 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 22)- 48*0), true),
			100 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 22)- 48*1), true),
			101 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 22)- 48*2), true),
			102 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 22)- 48*3), true),
			103 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 22)- 48*4), true),
			104 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 22)- 48*5), true),
			105 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 22)- 48*6), true),
			106 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 22)- 48*7), true),
			107 => (PCIN_dly(25)'last_event, tpd_PCIN_P((2303 - 22)- 48*22), true),
			108 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 22)- 48*23), true),
			109 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 22)- 48*24), true),
			110 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 22)- 48*25), true),
			111 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 22)- 48*26), true),
			112 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 22)- 48*27), true),
			113 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 22)- 48*28), true),
			114 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 22)- 48*29), true),
			115 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 22)- 48*30), true),
			116 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 22)- 48*31), true),
			117 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 22)- 48*32), true),
			118 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 22)- 48*33), true),
			119 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 22)- 48*34), true),
			120 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 22)- 48*35), true),
			121 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 22)- 48*36), true),
			122 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 22)- 48*37), true),
			123 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 22)- 48*38), true),
			124 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 22)- 48*39), true),
			125 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 22)- 48*40), true),
			126 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 22)- 48*41), true),
			127 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 22)- 48*42), true),
			128 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 22)- 48*43), true),
			129 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 22)- 48*44), true),
			130 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 22)- 48*45), true),
			131 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 22)- 48*46), true),
			132 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 22)- 48*47), true),
			133 => (RSTA_dly'last_event, tpd_RSTA_P(25), true),
			134 => (RSTB_dly'last_event, tpd_RSTB_P(25), true),
			135 => (RSTC_dly'last_event, tpd_RSTC_P(25), true),
			136 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(25), true),
			137 => (RSTD_dly'last_event, tpd_RSTD_P(25), true),
			138 => (RSTM_dly'last_event, tpd_RSTM_P(25), true),
			139 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(25), true),
			140 => (RSTP_dly'last_event, tpd_RSTP_P(25), true),
			141 => (CLK_dly'last_event, tpd_CLK_P(25), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(24),
         GlitchData	=> P_GlitchData(24),
         OutSignalName	=> "P(24)",
         OutTemp	=> P_zd(24),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 23)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 23)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 23)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 23)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 23)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 23)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 23)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 23)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 23)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 23)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 23)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 23)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 23)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 23)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 23)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 23)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 23)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 23)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 23)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 23)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 23)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 23)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 23)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 23)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 23)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 23)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 23)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 23)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 23)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 23)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 23)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 23)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 23)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 23)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 23)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 23)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 23)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 23)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 23)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 23)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 23)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 23)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 23)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 23)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 23)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 23)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 23)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 23)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 23)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 23)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 23)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 23)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 23)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 23)- 48*17), true),
			54 => (C_dly(24)'last_event, tpd_C_P((2303 - 23)- 48*23), true),
			55 => (C_dly(23)'last_event, tpd_C_P((2303 - 23)- 48*24), true),
			56 => (C_dly(22)'last_event, tpd_C_P((2303 - 23)- 48*25), true),
			57 => (C_dly(21)'last_event, tpd_C_P((2303 - 23)- 48*26), true),
			58 => (C_dly(20)'last_event, tpd_C_P((2303 - 23)- 48*27), true),
			59 => (C_dly(19)'last_event, tpd_C_P((2303 - 23)- 48*28), true),
			60 => (C_dly(18)'last_event, tpd_C_P((2303 - 23)- 48*29), true),
			61 => (C_dly(17)'last_event, tpd_C_P((2303 - 23)- 48*30), true),
			62 => (C_dly(16)'last_event, tpd_C_P((2303 - 23)- 48*31), true),
			63 => (C_dly(15)'last_event, tpd_C_P((2303 - 23)- 48*32), true),
			64 => (C_dly(14)'last_event, tpd_C_P((2303 - 23)- 48*33), true),
			65 => (C_dly(13)'last_event, tpd_C_P((2303 - 23)- 48*34), true),
			66 => (C_dly(12)'last_event, tpd_C_P((2303 - 23)- 48*35), true),
			67 => (C_dly(11)'last_event, tpd_C_P((2303 - 23)- 48*36), true),
			68 => (C_dly(10)'last_event, tpd_C_P((2303 - 23)- 48*37), true),
			69 => (C_dly(9)'last_event, tpd_C_P((2303 - 23)- 48*38), true),
			70 => (C_dly(8)'last_event, tpd_C_P((2303 - 23)- 48*39), true),
			71 => (C_dly(7)'last_event, tpd_C_P((2303 - 23)- 48*40), true),
			72 => (C_dly(6)'last_event, tpd_C_P((2303 - 23)- 48*41), true),
			73 => (C_dly(5)'last_event, tpd_C_P((2303 - 23)- 48*42), true),
			74 => (C_dly(4)'last_event, tpd_C_P((2303 - 23)- 48*43), true),
			75 => (C_dly(3)'last_event, tpd_C_P((2303 - 23)- 48*44), true),
			76 => (C_dly(2)'last_event, tpd_C_P((2303 - 23)- 48*45), true),
			77 => (C_dly(1)'last_event, tpd_C_P((2303 - 23)- 48*46), true),
			78 => (C_dly(0)'last_event, tpd_C_P((2303 - 23)- 48*47), true),
			79 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(24), true),
			80 => (D_dly(17)'last_event, tpd_D_P((863 - 23)- 48*0), true),
			81 => (D_dly(16)'last_event, tpd_D_P((863 - 23)- 48*1), true),
			82 => (D_dly(15)'last_event, tpd_D_P((863 - 23)- 48*2), true),
			83 => (D_dly(14)'last_event, tpd_D_P((863 - 23)- 48*3), true),
			84 => (D_dly(13)'last_event, tpd_D_P((863 - 23)- 48*4), true),
			85 => (D_dly(12)'last_event, tpd_D_P((863 - 23)- 48*5), true),
			86 => (D_dly(11)'last_event, tpd_D_P((863 - 23)- 48*6), true),
			87 => (D_dly(10)'last_event, tpd_D_P((863 - 23)- 48*7), true),
			88 => (D_dly(9)'last_event, tpd_D_P((863 - 23)- 48*8), true),
			89 => (D_dly(8)'last_event, tpd_D_P((863 - 23)- 48*9), true),
			90 => (D_dly(7)'last_event, tpd_D_P((863 - 23)- 48*10), true),
			91 => (D_dly(6)'last_event, tpd_D_P((863 - 23)- 48*11), true),
			92 => (D_dly(5)'last_event, tpd_D_P((863 - 23)- 48*12), true),
			93 => (D_dly(4)'last_event, tpd_D_P((863 - 23)- 48*13), true),
			94 => (D_dly(3)'last_event, tpd_D_P((863 - 23)- 48*14), true),
			95 => (D_dly(2)'last_event, tpd_D_P((863 - 23)- 48*15), true),
			96 => (D_dly(1)'last_event, tpd_D_P((863 - 23)- 48*16), true),
			97 => (D_dly(0)'last_event, tpd_D_P((863 - 23)- 48*17), true),
			98 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 23)- 48*0), true),
			99 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 23)- 48*1), true),
			100 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 23)- 48*2), true),
			101 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 23)- 48*3), true),
			102 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 23)- 48*4), true),
			103 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 23)- 48*5), true),
			104 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 23)- 48*6), true),
			105 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 23)- 48*7), true),
			106 => (PCIN_dly(24)'last_event, tpd_PCIN_P((2303 - 23)- 48*23), true),
			107 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 23)- 48*24), true),
			108 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 23)- 48*25), true),
			109 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 23)- 48*26), true),
			110 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 23)- 48*27), true),
			111 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 23)- 48*28), true),
			112 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 23)- 48*29), true),
			113 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 23)- 48*30), true),
			114 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 23)- 48*31), true),
			115 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 23)- 48*32), true),
			116 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 23)- 48*33), true),
			117 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 23)- 48*34), true),
			118 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 23)- 48*35), true),
			119 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 23)- 48*36), true),
			120 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 23)- 48*37), true),
			121 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 23)- 48*38), true),
			122 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 23)- 48*39), true),
			123 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 23)- 48*40), true),
			124 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 23)- 48*41), true),
			125 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 23)- 48*42), true),
			126 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 23)- 48*43), true),
			127 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 23)- 48*44), true),
			128 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 23)- 48*45), true),
			129 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 23)- 48*46), true),
			130 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 23)- 48*47), true),
			131 => (RSTA_dly'last_event, tpd_RSTA_P(24), true),
			132 => (RSTB_dly'last_event, tpd_RSTB_P(24), true),
			133 => (RSTC_dly'last_event, tpd_RSTC_P(24), true),
			134 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(24), true),
			135 => (RSTD_dly'last_event, tpd_RSTD_P(24), true),
			136 => (RSTM_dly'last_event, tpd_RSTM_P(24), true),
			137 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(24), true),
			138 => (RSTP_dly'last_event, tpd_RSTP_P(24), true),
			139 => (CLK_dly'last_event, tpd_CLK_P(24), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(23),
         GlitchData	=> P_GlitchData(23),
         OutSignalName	=> "P(23)",
         OutTemp	=> P_zd(23),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 24)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 24)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 24)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 24)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 24)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 24)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 24)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 24)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 24)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 24)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 24)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 24)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 24)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 24)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 24)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 24)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 24)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 24)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 24)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 24)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 24)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 24)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 24)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 24)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 24)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 24)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 24)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 24)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 24)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 24)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 24)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 24)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 24)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 24)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 24)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 24)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 24)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 24)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 24)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 24)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 24)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 24)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 24)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 24)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 24)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 24)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 24)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 24)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 24)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 24)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 24)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 24)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 24)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 24)- 48*17), true),
			54 => (C_dly(23)'last_event, tpd_C_P((2303 - 24)- 48*24), true),
			55 => (C_dly(22)'last_event, tpd_C_P((2303 - 24)- 48*25), true),
			56 => (C_dly(21)'last_event, tpd_C_P((2303 - 24)- 48*26), true),
			57 => (C_dly(20)'last_event, tpd_C_P((2303 - 24)- 48*27), true),
			58 => (C_dly(19)'last_event, tpd_C_P((2303 - 24)- 48*28), true),
			59 => (C_dly(18)'last_event, tpd_C_P((2303 - 24)- 48*29), true),
			60 => (C_dly(17)'last_event, tpd_C_P((2303 - 24)- 48*30), true),
			61 => (C_dly(16)'last_event, tpd_C_P((2303 - 24)- 48*31), true),
			62 => (C_dly(15)'last_event, tpd_C_P((2303 - 24)- 48*32), true),
			63 => (C_dly(14)'last_event, tpd_C_P((2303 - 24)- 48*33), true),
			64 => (C_dly(13)'last_event, tpd_C_P((2303 - 24)- 48*34), true),
			65 => (C_dly(12)'last_event, tpd_C_P((2303 - 24)- 48*35), true),
			66 => (C_dly(11)'last_event, tpd_C_P((2303 - 24)- 48*36), true),
			67 => (C_dly(10)'last_event, tpd_C_P((2303 - 24)- 48*37), true),
			68 => (C_dly(9)'last_event, tpd_C_P((2303 - 24)- 48*38), true),
			69 => (C_dly(8)'last_event, tpd_C_P((2303 - 24)- 48*39), true),
			70 => (C_dly(7)'last_event, tpd_C_P((2303 - 24)- 48*40), true),
			71 => (C_dly(6)'last_event, tpd_C_P((2303 - 24)- 48*41), true),
			72 => (C_dly(5)'last_event, tpd_C_P((2303 - 24)- 48*42), true),
			73 => (C_dly(4)'last_event, tpd_C_P((2303 - 24)- 48*43), true),
			74 => (C_dly(3)'last_event, tpd_C_P((2303 - 24)- 48*44), true),
			75 => (C_dly(2)'last_event, tpd_C_P((2303 - 24)- 48*45), true),
			76 => (C_dly(1)'last_event, tpd_C_P((2303 - 24)- 48*46), true),
			77 => (C_dly(0)'last_event, tpd_C_P((2303 - 24)- 48*47), true),
			78 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(23), true),
			79 => (D_dly(17)'last_event, tpd_D_P((863 - 24)- 48*0), true),
			80 => (D_dly(16)'last_event, tpd_D_P((863 - 24)- 48*1), true),
			81 => (D_dly(15)'last_event, tpd_D_P((863 - 24)- 48*2), true),
			82 => (D_dly(14)'last_event, tpd_D_P((863 - 24)- 48*3), true),
			83 => (D_dly(13)'last_event, tpd_D_P((863 - 24)- 48*4), true),
			84 => (D_dly(12)'last_event, tpd_D_P((863 - 24)- 48*5), true),
			85 => (D_dly(11)'last_event, tpd_D_P((863 - 24)- 48*6), true),
			86 => (D_dly(10)'last_event, tpd_D_P((863 - 24)- 48*7), true),
			87 => (D_dly(9)'last_event, tpd_D_P((863 - 24)- 48*8), true),
			88 => (D_dly(8)'last_event, tpd_D_P((863 - 24)- 48*9), true),
			89 => (D_dly(7)'last_event, tpd_D_P((863 - 24)- 48*10), true),
			90 => (D_dly(6)'last_event, tpd_D_P((863 - 24)- 48*11), true),
			91 => (D_dly(5)'last_event, tpd_D_P((863 - 24)- 48*12), true),
			92 => (D_dly(4)'last_event, tpd_D_P((863 - 24)- 48*13), true),
			93 => (D_dly(3)'last_event, tpd_D_P((863 - 24)- 48*14), true),
			94 => (D_dly(2)'last_event, tpd_D_P((863 - 24)- 48*15), true),
			95 => (D_dly(1)'last_event, tpd_D_P((863 - 24)- 48*16), true),
			96 => (D_dly(0)'last_event, tpd_D_P((863 - 24)- 48*17), true),
			97 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 24)- 48*0), true),
			98 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 24)- 48*1), true),
			99 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 24)- 48*2), true),
			100 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 24)- 48*3), true),
			101 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 24)- 48*4), true),
			102 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 24)- 48*5), true),
			103 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 24)- 48*6), true),
			104 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 24)- 48*7), true),
			105 => (PCIN_dly(23)'last_event, tpd_PCIN_P((2303 - 24)- 48*24), true),
			106 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 24)- 48*25), true),
			107 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 24)- 48*26), true),
			108 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 24)- 48*27), true),
			109 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 24)- 48*28), true),
			110 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 24)- 48*29), true),
			111 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 24)- 48*30), true),
			112 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 24)- 48*31), true),
			113 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 24)- 48*32), true),
			114 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 24)- 48*33), true),
			115 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 24)- 48*34), true),
			116 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 24)- 48*35), true),
			117 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 24)- 48*36), true),
			118 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 24)- 48*37), true),
			119 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 24)- 48*38), true),
			120 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 24)- 48*39), true),
			121 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 24)- 48*40), true),
			122 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 24)- 48*41), true),
			123 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 24)- 48*42), true),
			124 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 24)- 48*43), true),
			125 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 24)- 48*44), true),
			126 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 24)- 48*45), true),
			127 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 24)- 48*46), true),
			128 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 24)- 48*47), true),
			129 => (RSTA_dly'last_event, tpd_RSTA_P(23), true),
			130 => (RSTB_dly'last_event, tpd_RSTB_P(23), true),
			131 => (RSTC_dly'last_event, tpd_RSTC_P(23), true),
			132 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(23), true),
			133 => (RSTD_dly'last_event, tpd_RSTD_P(23), true),
			134 => (RSTM_dly'last_event, tpd_RSTM_P(23), true),
			135 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(23), true),
			136 => (RSTP_dly'last_event, tpd_RSTP_P(23), true),
			137 => (CLK_dly'last_event, tpd_CLK_P(23), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(22),
         GlitchData	=> P_GlitchData(22),
         OutSignalName	=> "P(22)",
         OutTemp	=> P_zd(22),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 25)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 25)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 25)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 25)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 25)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 25)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 25)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 25)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 25)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 25)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 25)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 25)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 25)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 25)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 25)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 25)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 25)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 25)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 25)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 25)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 25)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 25)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 25)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 25)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 25)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 25)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 25)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 25)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 25)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 25)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 25)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 25)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 25)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 25)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 25)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 25)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 25)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 25)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 25)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 25)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 25)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 25)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 25)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 25)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 25)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 25)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 25)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 25)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 25)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 25)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 25)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 25)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 25)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 25)- 48*17), true),
			54 => (C_dly(22)'last_event, tpd_C_P((2303 - 25)- 48*25), true),
			55 => (C_dly(21)'last_event, tpd_C_P((2303 - 25)- 48*26), true),
			56 => (C_dly(20)'last_event, tpd_C_P((2303 - 25)- 48*27), true),
			57 => (C_dly(19)'last_event, tpd_C_P((2303 - 25)- 48*28), true),
			58 => (C_dly(18)'last_event, tpd_C_P((2303 - 25)- 48*29), true),
			59 => (C_dly(17)'last_event, tpd_C_P((2303 - 25)- 48*30), true),
			60 => (C_dly(16)'last_event, tpd_C_P((2303 - 25)- 48*31), true),
			61 => (C_dly(15)'last_event, tpd_C_P((2303 - 25)- 48*32), true),
			62 => (C_dly(14)'last_event, tpd_C_P((2303 - 25)- 48*33), true),
			63 => (C_dly(13)'last_event, tpd_C_P((2303 - 25)- 48*34), true),
			64 => (C_dly(12)'last_event, tpd_C_P((2303 - 25)- 48*35), true),
			65 => (C_dly(11)'last_event, tpd_C_P((2303 - 25)- 48*36), true),
			66 => (C_dly(10)'last_event, tpd_C_P((2303 - 25)- 48*37), true),
			67 => (C_dly(9)'last_event, tpd_C_P((2303 - 25)- 48*38), true),
			68 => (C_dly(8)'last_event, tpd_C_P((2303 - 25)- 48*39), true),
			69 => (C_dly(7)'last_event, tpd_C_P((2303 - 25)- 48*40), true),
			70 => (C_dly(6)'last_event, tpd_C_P((2303 - 25)- 48*41), true),
			71 => (C_dly(5)'last_event, tpd_C_P((2303 - 25)- 48*42), true),
			72 => (C_dly(4)'last_event, tpd_C_P((2303 - 25)- 48*43), true),
			73 => (C_dly(3)'last_event, tpd_C_P((2303 - 25)- 48*44), true),
			74 => (C_dly(2)'last_event, tpd_C_P((2303 - 25)- 48*45), true),
			75 => (C_dly(1)'last_event, tpd_C_P((2303 - 25)- 48*46), true),
			76 => (C_dly(0)'last_event, tpd_C_P((2303 - 25)- 48*47), true),
			77 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(22), true),
			78 => (D_dly(17)'last_event, tpd_D_P((863 - 25)- 48*0), true),
			79 => (D_dly(16)'last_event, tpd_D_P((863 - 25)- 48*1), true),
			80 => (D_dly(15)'last_event, tpd_D_P((863 - 25)- 48*2), true),
			81 => (D_dly(14)'last_event, tpd_D_P((863 - 25)- 48*3), true),
			82 => (D_dly(13)'last_event, tpd_D_P((863 - 25)- 48*4), true),
			83 => (D_dly(12)'last_event, tpd_D_P((863 - 25)- 48*5), true),
			84 => (D_dly(11)'last_event, tpd_D_P((863 - 25)- 48*6), true),
			85 => (D_dly(10)'last_event, tpd_D_P((863 - 25)- 48*7), true),
			86 => (D_dly(9)'last_event, tpd_D_P((863 - 25)- 48*8), true),
			87 => (D_dly(8)'last_event, tpd_D_P((863 - 25)- 48*9), true),
			88 => (D_dly(7)'last_event, tpd_D_P((863 - 25)- 48*10), true),
			89 => (D_dly(6)'last_event, tpd_D_P((863 - 25)- 48*11), true),
			90 => (D_dly(5)'last_event, tpd_D_P((863 - 25)- 48*12), true),
			91 => (D_dly(4)'last_event, tpd_D_P((863 - 25)- 48*13), true),
			92 => (D_dly(3)'last_event, tpd_D_P((863 - 25)- 48*14), true),
			93 => (D_dly(2)'last_event, tpd_D_P((863 - 25)- 48*15), true),
			94 => (D_dly(1)'last_event, tpd_D_P((863 - 25)- 48*16), true),
			95 => (D_dly(0)'last_event, tpd_D_P((863 - 25)- 48*17), true),
			96 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 25)- 48*0), true),
			97 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 25)- 48*1), true),
			98 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 25)- 48*2), true),
			99 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 25)- 48*3), true),
			100 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 25)- 48*4), true),
			101 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 25)- 48*5), true),
			102 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 25)- 48*6), true),
			103 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 25)- 48*7), true),
			104 => (PCIN_dly(22)'last_event, tpd_PCIN_P((2303 - 25)- 48*25), true),
			105 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 25)- 48*26), true),
			106 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 25)- 48*27), true),
			107 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 25)- 48*28), true),
			108 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 25)- 48*29), true),
			109 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 25)- 48*30), true),
			110 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 25)- 48*31), true),
			111 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 25)- 48*32), true),
			112 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 25)- 48*33), true),
			113 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 25)- 48*34), true),
			114 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 25)- 48*35), true),
			115 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 25)- 48*36), true),
			116 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 25)- 48*37), true),
			117 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 25)- 48*38), true),
			118 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 25)- 48*39), true),
			119 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 25)- 48*40), true),
			120 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 25)- 48*41), true),
			121 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 25)- 48*42), true),
			122 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 25)- 48*43), true),
			123 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 25)- 48*44), true),
			124 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 25)- 48*45), true),
			125 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 25)- 48*46), true),
			126 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 25)- 48*47), true),
			127 => (RSTA_dly'last_event, tpd_RSTA_P(22), true),
			128 => (RSTB_dly'last_event, tpd_RSTB_P(22), true),
			129 => (RSTC_dly'last_event, tpd_RSTC_P(22), true),
			130 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(22), true),
			131 => (RSTD_dly'last_event, tpd_RSTD_P(22), true),
			132 => (RSTM_dly'last_event, tpd_RSTM_P(22), true),
			133 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(22), true),
			134 => (RSTP_dly'last_event, tpd_RSTP_P(22), true),
			135 => (CLK_dly'last_event, tpd_CLK_P(22), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(21),
         GlitchData	=> P_GlitchData(21),
         OutSignalName	=> "P(21)",
         OutTemp	=> P_zd(21),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 26)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 26)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 26)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 26)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 26)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 26)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 26)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 26)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 26)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 26)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 26)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 26)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 26)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 26)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 26)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 26)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 26)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 26)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 26)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 26)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 26)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 26)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 26)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 26)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 26)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 26)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 26)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 26)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 26)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 26)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 26)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 26)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 26)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 26)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 26)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 26)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 26)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 26)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 26)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 26)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 26)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 26)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 26)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 26)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 26)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 26)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 26)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 26)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 26)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 26)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 26)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 26)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 26)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 26)- 48*17), true),
			54 => (C_dly(21)'last_event, tpd_C_P((2303 - 26)- 48*26), true),
			55 => (C_dly(20)'last_event, tpd_C_P((2303 - 26)- 48*27), true),
			56 => (C_dly(19)'last_event, tpd_C_P((2303 - 26)- 48*28), true),
			57 => (C_dly(18)'last_event, tpd_C_P((2303 - 26)- 48*29), true),
			58 => (C_dly(17)'last_event, tpd_C_P((2303 - 26)- 48*30), true),
			59 => (C_dly(16)'last_event, tpd_C_P((2303 - 26)- 48*31), true),
			60 => (C_dly(15)'last_event, tpd_C_P((2303 - 26)- 48*32), true),
			61 => (C_dly(14)'last_event, tpd_C_P((2303 - 26)- 48*33), true),
			62 => (C_dly(13)'last_event, tpd_C_P((2303 - 26)- 48*34), true),
			63 => (C_dly(12)'last_event, tpd_C_P((2303 - 26)- 48*35), true),
			64 => (C_dly(11)'last_event, tpd_C_P((2303 - 26)- 48*36), true),
			65 => (C_dly(10)'last_event, tpd_C_P((2303 - 26)- 48*37), true),
			66 => (C_dly(9)'last_event, tpd_C_P((2303 - 26)- 48*38), true),
			67 => (C_dly(8)'last_event, tpd_C_P((2303 - 26)- 48*39), true),
			68 => (C_dly(7)'last_event, tpd_C_P((2303 - 26)- 48*40), true),
			69 => (C_dly(6)'last_event, tpd_C_P((2303 - 26)- 48*41), true),
			70 => (C_dly(5)'last_event, tpd_C_P((2303 - 26)- 48*42), true),
			71 => (C_dly(4)'last_event, tpd_C_P((2303 - 26)- 48*43), true),
			72 => (C_dly(3)'last_event, tpd_C_P((2303 - 26)- 48*44), true),
			73 => (C_dly(2)'last_event, tpd_C_P((2303 - 26)- 48*45), true),
			74 => (C_dly(1)'last_event, tpd_C_P((2303 - 26)- 48*46), true),
			75 => (C_dly(0)'last_event, tpd_C_P((2303 - 26)- 48*47), true),
			76 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(21), true),
			77 => (D_dly(17)'last_event, tpd_D_P((863 - 26)- 48*0), true),
			78 => (D_dly(16)'last_event, tpd_D_P((863 - 26)- 48*1), true),
			79 => (D_dly(15)'last_event, tpd_D_P((863 - 26)- 48*2), true),
			80 => (D_dly(14)'last_event, tpd_D_P((863 - 26)- 48*3), true),
			81 => (D_dly(13)'last_event, tpd_D_P((863 - 26)- 48*4), true),
			82 => (D_dly(12)'last_event, tpd_D_P((863 - 26)- 48*5), true),
			83 => (D_dly(11)'last_event, tpd_D_P((863 - 26)- 48*6), true),
			84 => (D_dly(10)'last_event, tpd_D_P((863 - 26)- 48*7), true),
			85 => (D_dly(9)'last_event, tpd_D_P((863 - 26)- 48*8), true),
			86 => (D_dly(8)'last_event, tpd_D_P((863 - 26)- 48*9), true),
			87 => (D_dly(7)'last_event, tpd_D_P((863 - 26)- 48*10), true),
			88 => (D_dly(6)'last_event, tpd_D_P((863 - 26)- 48*11), true),
			89 => (D_dly(5)'last_event, tpd_D_P((863 - 26)- 48*12), true),
			90 => (D_dly(4)'last_event, tpd_D_P((863 - 26)- 48*13), true),
			91 => (D_dly(3)'last_event, tpd_D_P((863 - 26)- 48*14), true),
			92 => (D_dly(2)'last_event, tpd_D_P((863 - 26)- 48*15), true),
			93 => (D_dly(1)'last_event, tpd_D_P((863 - 26)- 48*16), true),
			94 => (D_dly(0)'last_event, tpd_D_P((863 - 26)- 48*17), true),
			95 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 26)- 48*0), true),
			96 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 26)- 48*1), true),
			97 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 26)- 48*2), true),
			98 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 26)- 48*3), true),
			99 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 26)- 48*4), true),
			100 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 26)- 48*5), true),
			101 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 26)- 48*6), true),
			102 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 26)- 48*7), true),
			103 => (PCIN_dly(21)'last_event, tpd_PCIN_P((2303 - 26)- 48*26), true),
			104 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 26)- 48*27), true),
			105 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 26)- 48*28), true),
			106 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 26)- 48*29), true),
			107 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 26)- 48*30), true),
			108 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 26)- 48*31), true),
			109 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 26)- 48*32), true),
			110 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 26)- 48*33), true),
			111 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 26)- 48*34), true),
			112 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 26)- 48*35), true),
			113 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 26)- 48*36), true),
			114 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 26)- 48*37), true),
			115 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 26)- 48*38), true),
			116 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 26)- 48*39), true),
			117 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 26)- 48*40), true),
			118 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 26)- 48*41), true),
			119 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 26)- 48*42), true),
			120 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 26)- 48*43), true),
			121 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 26)- 48*44), true),
			122 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 26)- 48*45), true),
			123 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 26)- 48*46), true),
			124 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 26)- 48*47), true),
			125 => (RSTA_dly'last_event, tpd_RSTA_P(21), true),
			126 => (RSTB_dly'last_event, tpd_RSTB_P(21), true),
			127 => (RSTC_dly'last_event, tpd_RSTC_P(21), true),
			128 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(21), true),
			129 => (RSTD_dly'last_event, tpd_RSTD_P(21), true),
			130 => (RSTM_dly'last_event, tpd_RSTM_P(21), true),
			131 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(21), true),
			132 => (RSTP_dly'last_event, tpd_RSTP_P(21), true),
			133 => (CLK_dly'last_event, tpd_CLK_P(21), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(20),
         GlitchData	=> P_GlitchData(20),
         OutSignalName	=> "P(20)",
         OutTemp	=> P_zd(20),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 27)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 27)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 27)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 27)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 27)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 27)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 27)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 27)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 27)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 27)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 27)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 27)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 27)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 27)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 27)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 27)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 27)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 27)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 27)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 27)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 27)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 27)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 27)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 27)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 27)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 27)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 27)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 27)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 27)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 27)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 27)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 27)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 27)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 27)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 27)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 27)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 27)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 27)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 27)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 27)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 27)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 27)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 27)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 27)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 27)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 27)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 27)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 27)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 27)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 27)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 27)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 27)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 27)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 27)- 48*17), true),
			54 => (C_dly(20)'last_event, tpd_C_P((2303 - 27)- 48*27), true),
			55 => (C_dly(19)'last_event, tpd_C_P((2303 - 27)- 48*28), true),
			56 => (C_dly(18)'last_event, tpd_C_P((2303 - 27)- 48*29), true),
			57 => (C_dly(17)'last_event, tpd_C_P((2303 - 27)- 48*30), true),
			58 => (C_dly(16)'last_event, tpd_C_P((2303 - 27)- 48*31), true),
			59 => (C_dly(15)'last_event, tpd_C_P((2303 - 27)- 48*32), true),
			60 => (C_dly(14)'last_event, tpd_C_P((2303 - 27)- 48*33), true),
			61 => (C_dly(13)'last_event, tpd_C_P((2303 - 27)- 48*34), true),
			62 => (C_dly(12)'last_event, tpd_C_P((2303 - 27)- 48*35), true),
			63 => (C_dly(11)'last_event, tpd_C_P((2303 - 27)- 48*36), true),
			64 => (C_dly(10)'last_event, tpd_C_P((2303 - 27)- 48*37), true),
			65 => (C_dly(9)'last_event, tpd_C_P((2303 - 27)- 48*38), true),
			66 => (C_dly(8)'last_event, tpd_C_P((2303 - 27)- 48*39), true),
			67 => (C_dly(7)'last_event, tpd_C_P((2303 - 27)- 48*40), true),
			68 => (C_dly(6)'last_event, tpd_C_P((2303 - 27)- 48*41), true),
			69 => (C_dly(5)'last_event, tpd_C_P((2303 - 27)- 48*42), true),
			70 => (C_dly(4)'last_event, tpd_C_P((2303 - 27)- 48*43), true),
			71 => (C_dly(3)'last_event, tpd_C_P((2303 - 27)- 48*44), true),
			72 => (C_dly(2)'last_event, tpd_C_P((2303 - 27)- 48*45), true),
			73 => (C_dly(1)'last_event, tpd_C_P((2303 - 27)- 48*46), true),
			74 => (C_dly(0)'last_event, tpd_C_P((2303 - 27)- 48*47), true),
			75 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(20), true),
			76 => (D_dly(17)'last_event, tpd_D_P((863 - 27)- 48*0), true),
			77 => (D_dly(16)'last_event, tpd_D_P((863 - 27)- 48*1), true),
			78 => (D_dly(15)'last_event, tpd_D_P((863 - 27)- 48*2), true),
			79 => (D_dly(14)'last_event, tpd_D_P((863 - 27)- 48*3), true),
			80 => (D_dly(13)'last_event, tpd_D_P((863 - 27)- 48*4), true),
			81 => (D_dly(12)'last_event, tpd_D_P((863 - 27)- 48*5), true),
			82 => (D_dly(11)'last_event, tpd_D_P((863 - 27)- 48*6), true),
			83 => (D_dly(10)'last_event, tpd_D_P((863 - 27)- 48*7), true),
			84 => (D_dly(9)'last_event, tpd_D_P((863 - 27)- 48*8), true),
			85 => (D_dly(8)'last_event, tpd_D_P((863 - 27)- 48*9), true),
			86 => (D_dly(7)'last_event, tpd_D_P((863 - 27)- 48*10), true),
			87 => (D_dly(6)'last_event, tpd_D_P((863 - 27)- 48*11), true),
			88 => (D_dly(5)'last_event, tpd_D_P((863 - 27)- 48*12), true),
			89 => (D_dly(4)'last_event, tpd_D_P((863 - 27)- 48*13), true),
			90 => (D_dly(3)'last_event, tpd_D_P((863 - 27)- 48*14), true),
			91 => (D_dly(2)'last_event, tpd_D_P((863 - 27)- 48*15), true),
			92 => (D_dly(1)'last_event, tpd_D_P((863 - 27)- 48*16), true),
			93 => (D_dly(0)'last_event, tpd_D_P((863 - 27)- 48*17), true),
			94 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 27)- 48*0), true),
			95 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 27)- 48*1), true),
			96 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 27)- 48*2), true),
			97 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 27)- 48*3), true),
			98 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 27)- 48*4), true),
			99 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 27)- 48*5), true),
			100 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 27)- 48*6), true),
			101 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 27)- 48*7), true),
			102 => (PCIN_dly(20)'last_event, tpd_PCIN_P((2303 - 27)- 48*27), true),
			103 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 27)- 48*28), true),
			104 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 27)- 48*29), true),
			105 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 27)- 48*30), true),
			106 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 27)- 48*31), true),
			107 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 27)- 48*32), true),
			108 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 27)- 48*33), true),
			109 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 27)- 48*34), true),
			110 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 27)- 48*35), true),
			111 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 27)- 48*36), true),
			112 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 27)- 48*37), true),
			113 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 27)- 48*38), true),
			114 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 27)- 48*39), true),
			115 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 27)- 48*40), true),
			116 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 27)- 48*41), true),
			117 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 27)- 48*42), true),
			118 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 27)- 48*43), true),
			119 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 27)- 48*44), true),
			120 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 27)- 48*45), true),
			121 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 27)- 48*46), true),
			122 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 27)- 48*47), true),
			123 => (RSTA_dly'last_event, tpd_RSTA_P(20), true),
			124 => (RSTB_dly'last_event, tpd_RSTB_P(20), true),
			125 => (RSTC_dly'last_event, tpd_RSTC_P(20), true),
			126 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(20), true),
			127 => (RSTD_dly'last_event, tpd_RSTD_P(20), true),
			128 => (RSTM_dly'last_event, tpd_RSTM_P(20), true),
			129 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(20), true),
			130 => (RSTP_dly'last_event, tpd_RSTP_P(20), true),
			131 => (CLK_dly'last_event, tpd_CLK_P(20), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(19),
         GlitchData	=> P_GlitchData(19),
         OutSignalName	=> "P(19)",
         OutTemp	=> P_zd(19),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 28)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 28)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 28)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 28)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 28)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 28)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 28)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 28)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 28)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 28)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 28)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 28)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 28)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 28)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 28)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 28)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 28)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 28)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 28)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 28)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 28)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 28)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 28)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 28)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 28)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 28)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 28)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 28)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 28)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 28)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 28)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 28)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 28)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 28)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 28)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 28)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 28)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 28)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 28)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 28)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 28)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 28)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 28)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 28)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 28)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 28)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 28)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 28)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 28)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 28)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 28)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 28)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 28)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 28)- 48*17), true),
			54 => (C_dly(19)'last_event, tpd_C_P((2303 - 28)- 48*28), true),
			55 => (C_dly(18)'last_event, tpd_C_P((2303 - 28)- 48*29), true),
			56 => (C_dly(17)'last_event, tpd_C_P((2303 - 28)- 48*30), true),
			57 => (C_dly(16)'last_event, tpd_C_P((2303 - 28)- 48*31), true),
			58 => (C_dly(15)'last_event, tpd_C_P((2303 - 28)- 48*32), true),
			59 => (C_dly(14)'last_event, tpd_C_P((2303 - 28)- 48*33), true),
			60 => (C_dly(13)'last_event, tpd_C_P((2303 - 28)- 48*34), true),
			61 => (C_dly(12)'last_event, tpd_C_P((2303 - 28)- 48*35), true),
			62 => (C_dly(11)'last_event, tpd_C_P((2303 - 28)- 48*36), true),
			63 => (C_dly(10)'last_event, tpd_C_P((2303 - 28)- 48*37), true),
			64 => (C_dly(9)'last_event, tpd_C_P((2303 - 28)- 48*38), true),
			65 => (C_dly(8)'last_event, tpd_C_P((2303 - 28)- 48*39), true),
			66 => (C_dly(7)'last_event, tpd_C_P((2303 - 28)- 48*40), true),
			67 => (C_dly(6)'last_event, tpd_C_P((2303 - 28)- 48*41), true),
			68 => (C_dly(5)'last_event, tpd_C_P((2303 - 28)- 48*42), true),
			69 => (C_dly(4)'last_event, tpd_C_P((2303 - 28)- 48*43), true),
			70 => (C_dly(3)'last_event, tpd_C_P((2303 - 28)- 48*44), true),
			71 => (C_dly(2)'last_event, tpd_C_P((2303 - 28)- 48*45), true),
			72 => (C_dly(1)'last_event, tpd_C_P((2303 - 28)- 48*46), true),
			73 => (C_dly(0)'last_event, tpd_C_P((2303 - 28)- 48*47), true),
			74 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(19), true),
			75 => (D_dly(17)'last_event, tpd_D_P((863 - 28)- 48*0), true),
			76 => (D_dly(16)'last_event, tpd_D_P((863 - 28)- 48*1), true),
			77 => (D_dly(15)'last_event, tpd_D_P((863 - 28)- 48*2), true),
			78 => (D_dly(14)'last_event, tpd_D_P((863 - 28)- 48*3), true),
			79 => (D_dly(13)'last_event, tpd_D_P((863 - 28)- 48*4), true),
			80 => (D_dly(12)'last_event, tpd_D_P((863 - 28)- 48*5), true),
			81 => (D_dly(11)'last_event, tpd_D_P((863 - 28)- 48*6), true),
			82 => (D_dly(10)'last_event, tpd_D_P((863 - 28)- 48*7), true),
			83 => (D_dly(9)'last_event, tpd_D_P((863 - 28)- 48*8), true),
			84 => (D_dly(8)'last_event, tpd_D_P((863 - 28)- 48*9), true),
			85 => (D_dly(7)'last_event, tpd_D_P((863 - 28)- 48*10), true),
			86 => (D_dly(6)'last_event, tpd_D_P((863 - 28)- 48*11), true),
			87 => (D_dly(5)'last_event, tpd_D_P((863 - 28)- 48*12), true),
			88 => (D_dly(4)'last_event, tpd_D_P((863 - 28)- 48*13), true),
			89 => (D_dly(3)'last_event, tpd_D_P((863 - 28)- 48*14), true),
			90 => (D_dly(2)'last_event, tpd_D_P((863 - 28)- 48*15), true),
			91 => (D_dly(1)'last_event, tpd_D_P((863 - 28)- 48*16), true),
			92 => (D_dly(0)'last_event, tpd_D_P((863 - 28)- 48*17), true),
			93 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 28)- 48*0), true),
			94 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 28)- 48*1), true),
			95 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 28)- 48*2), true),
			96 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 28)- 48*3), true),
			97 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 28)- 48*4), true),
			98 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 28)- 48*5), true),
			99 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 28)- 48*6), true),
			100 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 28)- 48*7), true),
			101 => (PCIN_dly(19)'last_event, tpd_PCIN_P((2303 - 28)- 48*28), true),
			102 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 28)- 48*29), true),
			103 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 28)- 48*30), true),
			104 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 28)- 48*31), true),
			105 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 28)- 48*32), true),
			106 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 28)- 48*33), true),
			107 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 28)- 48*34), true),
			108 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 28)- 48*35), true),
			109 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 28)- 48*36), true),
			110 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 28)- 48*37), true),
			111 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 28)- 48*38), true),
			112 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 28)- 48*39), true),
			113 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 28)- 48*40), true),
			114 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 28)- 48*41), true),
			115 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 28)- 48*42), true),
			116 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 28)- 48*43), true),
			117 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 28)- 48*44), true),
			118 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 28)- 48*45), true),
			119 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 28)- 48*46), true),
			120 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 28)- 48*47), true),
			121 => (RSTA_dly'last_event, tpd_RSTA_P(19), true),
			122 => (RSTB_dly'last_event, tpd_RSTB_P(19), true),
			123 => (RSTC_dly'last_event, tpd_RSTC_P(19), true),
			124 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(19), true),
			125 => (RSTD_dly'last_event, tpd_RSTD_P(19), true),
			126 => (RSTM_dly'last_event, tpd_RSTM_P(19), true),
			127 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(19), true),
			128 => (RSTP_dly'last_event, tpd_RSTP_P(19), true),
			129 => (CLK_dly'last_event, tpd_CLK_P(19), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(18),
         GlitchData	=> P_GlitchData(18),
         OutSignalName	=> "P(18)",
         OutTemp	=> P_zd(18),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 29)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 29)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 29)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 29)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 29)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 29)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 29)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 29)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 29)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 29)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 29)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 29)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 29)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 29)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 29)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 29)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 29)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 29)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 29)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 29)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 29)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 29)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 29)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 29)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 29)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 29)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 29)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 29)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 29)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 29)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 29)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 29)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 29)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 29)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 29)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 29)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 29)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 29)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 29)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 29)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 29)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 29)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 29)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 29)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 29)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 29)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 29)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 29)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 29)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 29)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 29)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 29)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 29)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 29)- 48*17), true),
			54 => (C_dly(18)'last_event, tpd_C_P((2303 - 29)- 48*29), true),
			55 => (C_dly(17)'last_event, tpd_C_P((2303 - 29)- 48*30), true),
			56 => (C_dly(16)'last_event, tpd_C_P((2303 - 29)- 48*31), true),
			57 => (C_dly(15)'last_event, tpd_C_P((2303 - 29)- 48*32), true),
			58 => (C_dly(14)'last_event, tpd_C_P((2303 - 29)- 48*33), true),
			59 => (C_dly(13)'last_event, tpd_C_P((2303 - 29)- 48*34), true),
			60 => (C_dly(12)'last_event, tpd_C_P((2303 - 29)- 48*35), true),
			61 => (C_dly(11)'last_event, tpd_C_P((2303 - 29)- 48*36), true),
			62 => (C_dly(10)'last_event, tpd_C_P((2303 - 29)- 48*37), true),
			63 => (C_dly(9)'last_event, tpd_C_P((2303 - 29)- 48*38), true),
			64 => (C_dly(8)'last_event, tpd_C_P((2303 - 29)- 48*39), true),
			65 => (C_dly(7)'last_event, tpd_C_P((2303 - 29)- 48*40), true),
			66 => (C_dly(6)'last_event, tpd_C_P((2303 - 29)- 48*41), true),
			67 => (C_dly(5)'last_event, tpd_C_P((2303 - 29)- 48*42), true),
			68 => (C_dly(4)'last_event, tpd_C_P((2303 - 29)- 48*43), true),
			69 => (C_dly(3)'last_event, tpd_C_P((2303 - 29)- 48*44), true),
			70 => (C_dly(2)'last_event, tpd_C_P((2303 - 29)- 48*45), true),
			71 => (C_dly(1)'last_event, tpd_C_P((2303 - 29)- 48*46), true),
			72 => (C_dly(0)'last_event, tpd_C_P((2303 - 29)- 48*47), true),
			73 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(18), true),
			74 => (D_dly(17)'last_event, tpd_D_P((863 - 29)- 48*0), true),
			75 => (D_dly(16)'last_event, tpd_D_P((863 - 29)- 48*1), true),
			76 => (D_dly(15)'last_event, tpd_D_P((863 - 29)- 48*2), true),
			77 => (D_dly(14)'last_event, tpd_D_P((863 - 29)- 48*3), true),
			78 => (D_dly(13)'last_event, tpd_D_P((863 - 29)- 48*4), true),
			79 => (D_dly(12)'last_event, tpd_D_P((863 - 29)- 48*5), true),
			80 => (D_dly(11)'last_event, tpd_D_P((863 - 29)- 48*6), true),
			81 => (D_dly(10)'last_event, tpd_D_P((863 - 29)- 48*7), true),
			82 => (D_dly(9)'last_event, tpd_D_P((863 - 29)- 48*8), true),
			83 => (D_dly(8)'last_event, tpd_D_P((863 - 29)- 48*9), true),
			84 => (D_dly(7)'last_event, tpd_D_P((863 - 29)- 48*10), true),
			85 => (D_dly(6)'last_event, tpd_D_P((863 - 29)- 48*11), true),
			86 => (D_dly(5)'last_event, tpd_D_P((863 - 29)- 48*12), true),
			87 => (D_dly(4)'last_event, tpd_D_P((863 - 29)- 48*13), true),
			88 => (D_dly(3)'last_event, tpd_D_P((863 - 29)- 48*14), true),
			89 => (D_dly(2)'last_event, tpd_D_P((863 - 29)- 48*15), true),
			90 => (D_dly(1)'last_event, tpd_D_P((863 - 29)- 48*16), true),
			91 => (D_dly(0)'last_event, tpd_D_P((863 - 29)- 48*17), true),
			92 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 29)- 48*0), true),
			93 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 29)- 48*1), true),
			94 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 29)- 48*2), true),
			95 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 29)- 48*3), true),
			96 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 29)- 48*4), true),
			97 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 29)- 48*5), true),
			98 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 29)- 48*6), true),
			99 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 29)- 48*7), true),
			100 => (PCIN_dly(18)'last_event, tpd_PCIN_P((2303 - 29)- 48*29), true),
			101 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 29)- 48*30), true),
			102 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 29)- 48*31), true),
			103 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 29)- 48*32), true),
			104 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 29)- 48*33), true),
			105 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 29)- 48*34), true),
			106 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 29)- 48*35), true),
			107 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 29)- 48*36), true),
			108 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 29)- 48*37), true),
			109 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 29)- 48*38), true),
			110 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 29)- 48*39), true),
			111 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 29)- 48*40), true),
			112 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 29)- 48*41), true),
			113 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 29)- 48*42), true),
			114 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 29)- 48*43), true),
			115 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 29)- 48*44), true),
			116 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 29)- 48*45), true),
			117 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 29)- 48*46), true),
			118 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 29)- 48*47), true),
			119 => (RSTA_dly'last_event, tpd_RSTA_P(18), true),
			120 => (RSTB_dly'last_event, tpd_RSTB_P(18), true),
			121 => (RSTC_dly'last_event, tpd_RSTC_P(18), true),
			122 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(18), true),
			123 => (RSTD_dly'last_event, tpd_RSTD_P(18), true),
			124 => (RSTM_dly'last_event, tpd_RSTM_P(18), true),
			125 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(18), true),
			126 => (RSTP_dly'last_event, tpd_RSTP_P(18), true),
			127 => (CLK_dly'last_event, tpd_CLK_P(18), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(17),
         GlitchData	=> P_GlitchData(17),
         OutSignalName	=> "P(17)",
         OutTemp	=> P_zd(17),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_P((863 - 30)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_P((863 - 30)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_P((863 - 30)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_P((863 - 30)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_P((863 - 30)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_P((863 - 30)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_P((863 - 30)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_P((863 - 30)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_P((863 - 30)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_P((863 - 30)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_P((863 - 30)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_P((863 - 30)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_P((863 - 30)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_P((863 - 30)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_P((863 - 30)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_P((863 - 30)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_P((863 - 30)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_P((863 - 30)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_P((863 - 30)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_P((863 - 30)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_P((863 - 30)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_P((863 - 30)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_P((863 - 30)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_P((863 - 30)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_P((863 - 30)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_P((863 - 30)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_P((863 - 30)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_P((863 - 30)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_P((863 - 30)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_P((863 - 30)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_P((863 - 30)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_P((863 - 30)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_P((863 - 30)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_P((863 - 30)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_P((863 - 30)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_P((863 - 30)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_P((863 - 30)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 30)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 30)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 30)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 30)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 30)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 30)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 30)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 30)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 30)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 30)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 30)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 30)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 30)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 30)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 30)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 30)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 30)- 48*17), true),
			54 => (C_dly(17)'last_event, tpd_C_P((2303 - 30)- 48*30), true),
			55 => (C_dly(16)'last_event, tpd_C_P((2303 - 30)- 48*31), true),
			56 => (C_dly(15)'last_event, tpd_C_P((2303 - 30)- 48*32), true),
			57 => (C_dly(14)'last_event, tpd_C_P((2303 - 30)- 48*33), true),
			58 => (C_dly(13)'last_event, tpd_C_P((2303 - 30)- 48*34), true),
			59 => (C_dly(12)'last_event, tpd_C_P((2303 - 30)- 48*35), true),
			60 => (C_dly(11)'last_event, tpd_C_P((2303 - 30)- 48*36), true),
			61 => (C_dly(10)'last_event, tpd_C_P((2303 - 30)- 48*37), true),
			62 => (C_dly(9)'last_event, tpd_C_P((2303 - 30)- 48*38), true),
			63 => (C_dly(8)'last_event, tpd_C_P((2303 - 30)- 48*39), true),
			64 => (C_dly(7)'last_event, tpd_C_P((2303 - 30)- 48*40), true),
			65 => (C_dly(6)'last_event, tpd_C_P((2303 - 30)- 48*41), true),
			66 => (C_dly(5)'last_event, tpd_C_P((2303 - 30)- 48*42), true),
			67 => (C_dly(4)'last_event, tpd_C_P((2303 - 30)- 48*43), true),
			68 => (C_dly(3)'last_event, tpd_C_P((2303 - 30)- 48*44), true),
			69 => (C_dly(2)'last_event, tpd_C_P((2303 - 30)- 48*45), true),
			70 => (C_dly(1)'last_event, tpd_C_P((2303 - 30)- 48*46), true),
			71 => (C_dly(0)'last_event, tpd_C_P((2303 - 30)- 48*47), true),
			72 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(17), true),
			73 => (D_dly(17)'last_event, tpd_D_P((863 - 30)- 48*0), true),
			74 => (D_dly(16)'last_event, tpd_D_P((863 - 30)- 48*1), true),
			75 => (D_dly(15)'last_event, tpd_D_P((863 - 30)- 48*2), true),
			76 => (D_dly(14)'last_event, tpd_D_P((863 - 30)- 48*3), true),
			77 => (D_dly(13)'last_event, tpd_D_P((863 - 30)- 48*4), true),
			78 => (D_dly(12)'last_event, tpd_D_P((863 - 30)- 48*5), true),
			79 => (D_dly(11)'last_event, tpd_D_P((863 - 30)- 48*6), true),
			80 => (D_dly(10)'last_event, tpd_D_P((863 - 30)- 48*7), true),
			81 => (D_dly(9)'last_event, tpd_D_P((863 - 30)- 48*8), true),
			82 => (D_dly(8)'last_event, tpd_D_P((863 - 30)- 48*9), true),
			83 => (D_dly(7)'last_event, tpd_D_P((863 - 30)- 48*10), true),
			84 => (D_dly(6)'last_event, tpd_D_P((863 - 30)- 48*11), true),
			85 => (D_dly(5)'last_event, tpd_D_P((863 - 30)- 48*12), true),
			86 => (D_dly(4)'last_event, tpd_D_P((863 - 30)- 48*13), true),
			87 => (D_dly(3)'last_event, tpd_D_P((863 - 30)- 48*14), true),
			88 => (D_dly(2)'last_event, tpd_D_P((863 - 30)- 48*15), true),
			89 => (D_dly(1)'last_event, tpd_D_P((863 - 30)- 48*16), true),
			90 => (D_dly(0)'last_event, tpd_D_P((863 - 30)- 48*17), true),
			91 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 30)- 48*0), true),
			92 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 30)- 48*1), true),
			93 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 30)- 48*2), true),
			94 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 30)- 48*3), true),
			95 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 30)- 48*4), true),
			96 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 30)- 48*5), true),
			97 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 30)- 48*6), true),
			98 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 30)- 48*7), true),
			99 => (PCIN_dly(17)'last_event, tpd_PCIN_P((2303 - 30)- 48*30), true),
			100 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 30)- 48*31), true),
			101 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 30)- 48*32), true),
			102 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 30)- 48*33), true),
			103 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 30)- 48*34), true),
			104 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 30)- 48*35), true),
			105 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 30)- 48*36), true),
			106 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 30)- 48*37), true),
			107 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 30)- 48*38), true),
			108 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 30)- 48*39), true),
			109 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 30)- 48*40), true),
			110 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 30)- 48*41), true),
			111 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 30)- 48*42), true),
			112 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 30)- 48*43), true),
			113 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 30)- 48*44), true),
			114 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 30)- 48*45), true),
			115 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 30)- 48*46), true),
			116 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 30)- 48*47), true),
			117 => (RSTA_dly'last_event, tpd_RSTA_P(17), true),
			118 => (RSTB_dly'last_event, tpd_RSTB_P(17), true),
			119 => (RSTC_dly'last_event, tpd_RSTC_P(17), true),
			120 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(17), true),
			121 => (RSTD_dly'last_event, tpd_RSTD_P(17), true),
			122 => (RSTM_dly'last_event, tpd_RSTM_P(17), true),
			123 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(17), true),
			124 => (RSTP_dly'last_event, tpd_RSTP_P(17), true),
			125 => (CLK_dly'last_event, tpd_CLK_P(17), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(16),
         GlitchData	=> P_GlitchData(16),
         OutSignalName	=> "P(16)",
         OutTemp	=> P_zd(16),
         Paths		=> (
			0 => (A_dly(16)'last_event, tpd_A_P((863 - 31)- 48*1), true),
			1 => (A_dly(15)'last_event, tpd_A_P((863 - 31)- 48*2), true),
			2 => (A_dly(14)'last_event, tpd_A_P((863 - 31)- 48*3), true),
			3 => (A_dly(13)'last_event, tpd_A_P((863 - 31)- 48*4), true),
			4 => (A_dly(12)'last_event, tpd_A_P((863 - 31)- 48*5), true),
			5 => (A_dly(11)'last_event, tpd_A_P((863 - 31)- 48*6), true),
			6 => (A_dly(10)'last_event, tpd_A_P((863 - 31)- 48*7), true),
			7 => (A_dly(9)'last_event, tpd_A_P((863 - 31)- 48*8), true),
			8 => (A_dly(8)'last_event, tpd_A_P((863 - 31)- 48*9), true),
			9 => (A_dly(7)'last_event, tpd_A_P((863 - 31)- 48*10), true),
			10 => (A_dly(6)'last_event, tpd_A_P((863 - 31)- 48*11), true),
			11 => (A_dly(5)'last_event, tpd_A_P((863 - 31)- 48*12), true),
			12 => (A_dly(4)'last_event, tpd_A_P((863 - 31)- 48*13), true),
			13 => (A_dly(3)'last_event, tpd_A_P((863 - 31)- 48*14), true),
			14 => (A_dly(2)'last_event, tpd_A_P((863 - 31)- 48*15), true),
			15 => (A_dly(1)'last_event, tpd_A_P((863 - 31)- 48*16), true),
			16 => (A_dly(0)'last_event, tpd_A_P((863 - 31)- 48*17), true),
			17 => (B_dly(16)'last_event, tpd_B_P((863 - 31)- 48*1), true),
			18 => (B_dly(15)'last_event, tpd_B_P((863 - 31)- 48*2), true),
			19 => (B_dly(14)'last_event, tpd_B_P((863 - 31)- 48*3), true),
			20 => (B_dly(13)'last_event, tpd_B_P((863 - 31)- 48*4), true),
			21 => (B_dly(12)'last_event, tpd_B_P((863 - 31)- 48*5), true),
			22 => (B_dly(11)'last_event, tpd_B_P((863 - 31)- 48*6), true),
			23 => (B_dly(10)'last_event, tpd_B_P((863 - 31)- 48*7), true),
			24 => (B_dly(9)'last_event, tpd_B_P((863 - 31)- 48*8), true),
			25 => (B_dly(8)'last_event, tpd_B_P((863 - 31)- 48*9), true),
			26 => (B_dly(7)'last_event, tpd_B_P((863 - 31)- 48*10), true),
			27 => (B_dly(6)'last_event, tpd_B_P((863 - 31)- 48*11), true),
			28 => (B_dly(5)'last_event, tpd_B_P((863 - 31)- 48*12), true),
			29 => (B_dly(4)'last_event, tpd_B_P((863 - 31)- 48*13), true),
			30 => (B_dly(3)'last_event, tpd_B_P((863 - 31)- 48*14), true),
			31 => (B_dly(2)'last_event, tpd_B_P((863 - 31)- 48*15), true),
			32 => (B_dly(1)'last_event, tpd_B_P((863 - 31)- 48*16), true),
			33 => (B_dly(0)'last_event, tpd_B_P((863 - 31)- 48*17), true),
			34 => (BCIN_dly(16)'last_event, tpd_BCIN_P((863 - 31)- 48*1), true),
			35 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 31)- 48*2), true),
			36 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 31)- 48*3), true),
			37 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 31)- 48*4), true),
			38 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 31)- 48*5), true),
			39 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 31)- 48*6), true),
			40 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 31)- 48*7), true),
			41 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 31)- 48*8), true),
			42 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 31)- 48*9), true),
			43 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 31)- 48*10), true),
			44 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 31)- 48*11), true),
			45 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 31)- 48*12), true),
			46 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 31)- 48*13), true),
			47 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 31)- 48*14), true),
			48 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 31)- 48*15), true),
			49 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 31)- 48*16), true),
			50 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 31)- 48*17), true),
			51 => (C_dly(16)'last_event, tpd_C_P((2303 - 31)- 48*31), true),
			52 => (C_dly(15)'last_event, tpd_C_P((2303 - 31)- 48*32), true),
			53 => (C_dly(14)'last_event, tpd_C_P((2303 - 31)- 48*33), true),
			54 => (C_dly(13)'last_event, tpd_C_P((2303 - 31)- 48*34), true),
			55 => (C_dly(12)'last_event, tpd_C_P((2303 - 31)- 48*35), true),
			56 => (C_dly(11)'last_event, tpd_C_P((2303 - 31)- 48*36), true),
			57 => (C_dly(10)'last_event, tpd_C_P((2303 - 31)- 48*37), true),
			58 => (C_dly(9)'last_event, tpd_C_P((2303 - 31)- 48*38), true),
			59 => (C_dly(8)'last_event, tpd_C_P((2303 - 31)- 48*39), true),
			60 => (C_dly(7)'last_event, tpd_C_P((2303 - 31)- 48*40), true),
			61 => (C_dly(6)'last_event, tpd_C_P((2303 - 31)- 48*41), true),
			62 => (C_dly(5)'last_event, tpd_C_P((2303 - 31)- 48*42), true),
			63 => (C_dly(4)'last_event, tpd_C_P((2303 - 31)- 48*43), true),
			64 => (C_dly(3)'last_event, tpd_C_P((2303 - 31)- 48*44), true),
			65 => (C_dly(2)'last_event, tpd_C_P((2303 - 31)- 48*45), true),
			66 => (C_dly(1)'last_event, tpd_C_P((2303 - 31)- 48*46), true),
			67 => (C_dly(0)'last_event, tpd_C_P((2303 - 31)- 48*47), true),
			68 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(16), true),
			69 => (D_dly(16)'last_event, tpd_D_P((863 - 31)- 48*1), true),
			70 => (D_dly(15)'last_event, tpd_D_P((863 - 31)- 48*2), true),
			71 => (D_dly(14)'last_event, tpd_D_P((863 - 31)- 48*3), true),
			72 => (D_dly(13)'last_event, tpd_D_P((863 - 31)- 48*4), true),
			73 => (D_dly(12)'last_event, tpd_D_P((863 - 31)- 48*5), true),
			74 => (D_dly(11)'last_event, tpd_D_P((863 - 31)- 48*6), true),
			75 => (D_dly(10)'last_event, tpd_D_P((863 - 31)- 48*7), true),
			76 => (D_dly(9)'last_event, tpd_D_P((863 - 31)- 48*8), true),
			77 => (D_dly(8)'last_event, tpd_D_P((863 - 31)- 48*9), true),
			78 => (D_dly(7)'last_event, tpd_D_P((863 - 31)- 48*10), true),
			79 => (D_dly(6)'last_event, tpd_D_P((863 - 31)- 48*11), true),
			80 => (D_dly(5)'last_event, tpd_D_P((863 - 31)- 48*12), true),
			81 => (D_dly(4)'last_event, tpd_D_P((863 - 31)- 48*13), true),
			82 => (D_dly(3)'last_event, tpd_D_P((863 - 31)- 48*14), true),
			83 => (D_dly(2)'last_event, tpd_D_P((863 - 31)- 48*15), true),
			84 => (D_dly(1)'last_event, tpd_D_P((863 - 31)- 48*16), true),
			85 => (D_dly(0)'last_event, tpd_D_P((863 - 31)- 48*17), true),
			86 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 31)- 48*0), true),
			87 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 31)- 48*1), true),
			88 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 31)- 48*2), true),
			89 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 31)- 48*3), true),
			90 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 31)- 48*4), true),
			91 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 31)- 48*5), true),
			92 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 31)- 48*6), true),
			93 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 31)- 48*7), true),
			94 => (PCIN_dly(16)'last_event, tpd_PCIN_P((2303 - 31)- 48*31), true),
			95 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 31)- 48*32), true),
			96 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 31)- 48*33), true),
			97 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 31)- 48*34), true),
			98 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 31)- 48*35), true),
			99 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 31)- 48*36), true),
			100 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 31)- 48*37), true),
			101 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 31)- 48*38), true),
			102 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 31)- 48*39), true),
			103 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 31)- 48*40), true),
			104 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 31)- 48*41), true),
			105 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 31)- 48*42), true),
			106 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 31)- 48*43), true),
			107 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 31)- 48*44), true),
			108 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 31)- 48*45), true),
			109 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 31)- 48*46), true),
			110 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 31)- 48*47), true),
			111 => (RSTA_dly'last_event, tpd_RSTA_P(16), true),
			112 => (RSTB_dly'last_event, tpd_RSTB_P(16), true),
			113 => (RSTC_dly'last_event, tpd_RSTC_P(16), true),
			114 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(16), true),
			115 => (RSTD_dly'last_event, tpd_RSTD_P(16), true),
			116 => (RSTM_dly'last_event, tpd_RSTM_P(16), true),
			117 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(16), true),
			118 => (RSTP_dly'last_event, tpd_RSTP_P(16), true),
			119 => (CLK_dly'last_event, tpd_CLK_P(16), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(15),
         GlitchData	=> P_GlitchData(15),
         OutSignalName	=> "P(15)",
         OutTemp	=> P_zd(15),
         Paths		=> (
			0 => (A_dly(15)'last_event, tpd_A_P((863 - 32)- 48*2), true),
			1 => (A_dly(14)'last_event, tpd_A_P((863 - 32)- 48*3), true),
			2 => (A_dly(13)'last_event, tpd_A_P((863 - 32)- 48*4), true),
			3 => (A_dly(12)'last_event, tpd_A_P((863 - 32)- 48*5), true),
			4 => (A_dly(11)'last_event, tpd_A_P((863 - 32)- 48*6), true),
			5 => (A_dly(10)'last_event, tpd_A_P((863 - 32)- 48*7), true),
			6 => (A_dly(9)'last_event, tpd_A_P((863 - 32)- 48*8), true),
			7 => (A_dly(8)'last_event, tpd_A_P((863 - 32)- 48*9), true),
			8 => (A_dly(7)'last_event, tpd_A_P((863 - 32)- 48*10), true),
			9 => (A_dly(6)'last_event, tpd_A_P((863 - 32)- 48*11), true),
			10 => (A_dly(5)'last_event, tpd_A_P((863 - 32)- 48*12), true),
			11 => (A_dly(4)'last_event, tpd_A_P((863 - 32)- 48*13), true),
			12 => (A_dly(3)'last_event, tpd_A_P((863 - 32)- 48*14), true),
			13 => (A_dly(2)'last_event, tpd_A_P((863 - 32)- 48*15), true),
			14 => (A_dly(1)'last_event, tpd_A_P((863 - 32)- 48*16), true),
			15 => (A_dly(0)'last_event, tpd_A_P((863 - 32)- 48*17), true),
			16 => (B_dly(15)'last_event, tpd_B_P((863 - 32)- 48*2), true),
			17 => (B_dly(14)'last_event, tpd_B_P((863 - 32)- 48*3), true),
			18 => (B_dly(13)'last_event, tpd_B_P((863 - 32)- 48*4), true),
			19 => (B_dly(12)'last_event, tpd_B_P((863 - 32)- 48*5), true),
			20 => (B_dly(11)'last_event, tpd_B_P((863 - 32)- 48*6), true),
			21 => (B_dly(10)'last_event, tpd_B_P((863 - 32)- 48*7), true),
			22 => (B_dly(9)'last_event, tpd_B_P((863 - 32)- 48*8), true),
			23 => (B_dly(8)'last_event, tpd_B_P((863 - 32)- 48*9), true),
			24 => (B_dly(7)'last_event, tpd_B_P((863 - 32)- 48*10), true),
			25 => (B_dly(6)'last_event, tpd_B_P((863 - 32)- 48*11), true),
			26 => (B_dly(5)'last_event, tpd_B_P((863 - 32)- 48*12), true),
			27 => (B_dly(4)'last_event, tpd_B_P((863 - 32)- 48*13), true),
			28 => (B_dly(3)'last_event, tpd_B_P((863 - 32)- 48*14), true),
			29 => (B_dly(2)'last_event, tpd_B_P((863 - 32)- 48*15), true),
			30 => (B_dly(1)'last_event, tpd_B_P((863 - 32)- 48*16), true),
			31 => (B_dly(0)'last_event, tpd_B_P((863 - 32)- 48*17), true),
			32 => (BCIN_dly(15)'last_event, tpd_BCIN_P((863 - 32)- 48*2), true),
			33 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 32)- 48*3), true),
			34 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 32)- 48*4), true),
			35 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 32)- 48*5), true),
			36 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 32)- 48*6), true),
			37 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 32)- 48*7), true),
			38 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 32)- 48*8), true),
			39 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 32)- 48*9), true),
			40 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 32)- 48*10), true),
			41 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 32)- 48*11), true),
			42 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 32)- 48*12), true),
			43 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 32)- 48*13), true),
			44 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 32)- 48*14), true),
			45 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 32)- 48*15), true),
			46 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 32)- 48*16), true),
			47 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 32)- 48*17), true),
			48 => (C_dly(15)'last_event, tpd_C_P((2303 - 32)- 48*32), true),
			49 => (C_dly(14)'last_event, tpd_C_P((2303 - 32)- 48*33), true),
			50 => (C_dly(13)'last_event, tpd_C_P((2303 - 32)- 48*34), true),
			51 => (C_dly(12)'last_event, tpd_C_P((2303 - 32)- 48*35), true),
			52 => (C_dly(11)'last_event, tpd_C_P((2303 - 32)- 48*36), true),
			53 => (C_dly(10)'last_event, tpd_C_P((2303 - 32)- 48*37), true),
			54 => (C_dly(9)'last_event, tpd_C_P((2303 - 32)- 48*38), true),
			55 => (C_dly(8)'last_event, tpd_C_P((2303 - 32)- 48*39), true),
			56 => (C_dly(7)'last_event, tpd_C_P((2303 - 32)- 48*40), true),
			57 => (C_dly(6)'last_event, tpd_C_P((2303 - 32)- 48*41), true),
			58 => (C_dly(5)'last_event, tpd_C_P((2303 - 32)- 48*42), true),
			59 => (C_dly(4)'last_event, tpd_C_P((2303 - 32)- 48*43), true),
			60 => (C_dly(3)'last_event, tpd_C_P((2303 - 32)- 48*44), true),
			61 => (C_dly(2)'last_event, tpd_C_P((2303 - 32)- 48*45), true),
			62 => (C_dly(1)'last_event, tpd_C_P((2303 - 32)- 48*46), true),
			63 => (C_dly(0)'last_event, tpd_C_P((2303 - 32)- 48*47), true),
			64 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(15), true),
			65 => (D_dly(15)'last_event, tpd_D_P((863 - 32)- 48*2), true),
			66 => (D_dly(14)'last_event, tpd_D_P((863 - 32)- 48*3), true),
			67 => (D_dly(13)'last_event, tpd_D_P((863 - 32)- 48*4), true),
			68 => (D_dly(12)'last_event, tpd_D_P((863 - 32)- 48*5), true),
			69 => (D_dly(11)'last_event, tpd_D_P((863 - 32)- 48*6), true),
			70 => (D_dly(10)'last_event, tpd_D_P((863 - 32)- 48*7), true),
			71 => (D_dly(9)'last_event, tpd_D_P((863 - 32)- 48*8), true),
			72 => (D_dly(8)'last_event, tpd_D_P((863 - 32)- 48*9), true),
			73 => (D_dly(7)'last_event, tpd_D_P((863 - 32)- 48*10), true),
			74 => (D_dly(6)'last_event, tpd_D_P((863 - 32)- 48*11), true),
			75 => (D_dly(5)'last_event, tpd_D_P((863 - 32)- 48*12), true),
			76 => (D_dly(4)'last_event, tpd_D_P((863 - 32)- 48*13), true),
			77 => (D_dly(3)'last_event, tpd_D_P((863 - 32)- 48*14), true),
			78 => (D_dly(2)'last_event, tpd_D_P((863 - 32)- 48*15), true),
			79 => (D_dly(1)'last_event, tpd_D_P((863 - 32)- 48*16), true),
			80 => (D_dly(0)'last_event, tpd_D_P((863 - 32)- 48*17), true),
			81 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 32)- 48*0), true),
			82 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 32)- 48*1), true),
			83 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 32)- 48*2), true),
			84 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 32)- 48*3), true),
			85 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 32)- 48*4), true),
			86 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 32)- 48*5), true),
			87 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 32)- 48*6), true),
			88 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 32)- 48*7), true),
			89 => (PCIN_dly(15)'last_event, tpd_PCIN_P((2303 - 32)- 48*32), true),
			90 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 32)- 48*33), true),
			91 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 32)- 48*34), true),
			92 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 32)- 48*35), true),
			93 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 32)- 48*36), true),
			94 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 32)- 48*37), true),
			95 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 32)- 48*38), true),
			96 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 32)- 48*39), true),
			97 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 32)- 48*40), true),
			98 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 32)- 48*41), true),
			99 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 32)- 48*42), true),
			100 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 32)- 48*43), true),
			101 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 32)- 48*44), true),
			102 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 32)- 48*45), true),
			103 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 32)- 48*46), true),
			104 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 32)- 48*47), true),
			105 => (RSTA_dly'last_event, tpd_RSTA_P(15), true),
			106 => (RSTB_dly'last_event, tpd_RSTB_P(15), true),
			107 => (RSTC_dly'last_event, tpd_RSTC_P(15), true),
			108 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(15), true),
			109 => (RSTD_dly'last_event, tpd_RSTD_P(15), true),
			110 => (RSTM_dly'last_event, tpd_RSTM_P(15), true),
			111 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(15), true),
			112 => (RSTP_dly'last_event, tpd_RSTP_P(15), true),
			113 => (CLK_dly'last_event, tpd_CLK_P(15), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(14),
         GlitchData	=> P_GlitchData(14),
         OutSignalName	=> "P(14)",
         OutTemp	=> P_zd(14),
         Paths		=> (
			0 => (A_dly(14)'last_event, tpd_A_P((863 - 33)- 48*3), true),
			1 => (A_dly(13)'last_event, tpd_A_P((863 - 33)- 48*4), true),
			2 => (A_dly(12)'last_event, tpd_A_P((863 - 33)- 48*5), true),
			3 => (A_dly(11)'last_event, tpd_A_P((863 - 33)- 48*6), true),
			4 => (A_dly(10)'last_event, tpd_A_P((863 - 33)- 48*7), true),
			5 => (A_dly(9)'last_event, tpd_A_P((863 - 33)- 48*8), true),
			6 => (A_dly(8)'last_event, tpd_A_P((863 - 33)- 48*9), true),
			7 => (A_dly(7)'last_event, tpd_A_P((863 - 33)- 48*10), true),
			8 => (A_dly(6)'last_event, tpd_A_P((863 - 33)- 48*11), true),
			9 => (A_dly(5)'last_event, tpd_A_P((863 - 33)- 48*12), true),
			10 => (A_dly(4)'last_event, tpd_A_P((863 - 33)- 48*13), true),
			11 => (A_dly(3)'last_event, tpd_A_P((863 - 33)- 48*14), true),
			12 => (A_dly(2)'last_event, tpd_A_P((863 - 33)- 48*15), true),
			13 => (A_dly(1)'last_event, tpd_A_P((863 - 33)- 48*16), true),
			14 => (A_dly(0)'last_event, tpd_A_P((863 - 33)- 48*17), true),
			15 => (B_dly(14)'last_event, tpd_B_P((863 - 33)- 48*3), true),
			16 => (B_dly(13)'last_event, tpd_B_P((863 - 33)- 48*4), true),
			17 => (B_dly(12)'last_event, tpd_B_P((863 - 33)- 48*5), true),
			18 => (B_dly(11)'last_event, tpd_B_P((863 - 33)- 48*6), true),
			19 => (B_dly(10)'last_event, tpd_B_P((863 - 33)- 48*7), true),
			20 => (B_dly(9)'last_event, tpd_B_P((863 - 33)- 48*8), true),
			21 => (B_dly(8)'last_event, tpd_B_P((863 - 33)- 48*9), true),
			22 => (B_dly(7)'last_event, tpd_B_P((863 - 33)- 48*10), true),
			23 => (B_dly(6)'last_event, tpd_B_P((863 - 33)- 48*11), true),
			24 => (B_dly(5)'last_event, tpd_B_P((863 - 33)- 48*12), true),
			25 => (B_dly(4)'last_event, tpd_B_P((863 - 33)- 48*13), true),
			26 => (B_dly(3)'last_event, tpd_B_P((863 - 33)- 48*14), true),
			27 => (B_dly(2)'last_event, tpd_B_P((863 - 33)- 48*15), true),
			28 => (B_dly(1)'last_event, tpd_B_P((863 - 33)- 48*16), true),
			29 => (B_dly(0)'last_event, tpd_B_P((863 - 33)- 48*17), true),
			30 => (BCIN_dly(14)'last_event, tpd_BCIN_P((863 - 33)- 48*3), true),
			31 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 33)- 48*4), true),
			32 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 33)- 48*5), true),
			33 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 33)- 48*6), true),
			34 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 33)- 48*7), true),
			35 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 33)- 48*8), true),
			36 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 33)- 48*9), true),
			37 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 33)- 48*10), true),
			38 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 33)- 48*11), true),
			39 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 33)- 48*12), true),
			40 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 33)- 48*13), true),
			41 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 33)- 48*14), true),
			42 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 33)- 48*15), true),
			43 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 33)- 48*16), true),
			44 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 33)- 48*17), true),
			45 => (C_dly(14)'last_event, tpd_C_P((2303 - 33)- 48*33), true),
			46 => (C_dly(13)'last_event, tpd_C_P((2303 - 33)- 48*34), true),
			47 => (C_dly(12)'last_event, tpd_C_P((2303 - 33)- 48*35), true),
			48 => (C_dly(11)'last_event, tpd_C_P((2303 - 33)- 48*36), true),
			49 => (C_dly(10)'last_event, tpd_C_P((2303 - 33)- 48*37), true),
			50 => (C_dly(9)'last_event, tpd_C_P((2303 - 33)- 48*38), true),
			51 => (C_dly(8)'last_event, tpd_C_P((2303 - 33)- 48*39), true),
			52 => (C_dly(7)'last_event, tpd_C_P((2303 - 33)- 48*40), true),
			53 => (C_dly(6)'last_event, tpd_C_P((2303 - 33)- 48*41), true),
			54 => (C_dly(5)'last_event, tpd_C_P((2303 - 33)- 48*42), true),
			55 => (C_dly(4)'last_event, tpd_C_P((2303 - 33)- 48*43), true),
			56 => (C_dly(3)'last_event, tpd_C_P((2303 - 33)- 48*44), true),
			57 => (C_dly(2)'last_event, tpd_C_P((2303 - 33)- 48*45), true),
			58 => (C_dly(1)'last_event, tpd_C_P((2303 - 33)- 48*46), true),
			59 => (C_dly(0)'last_event, tpd_C_P((2303 - 33)- 48*47), true),
			60 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(14), true),
			61 => (D_dly(14)'last_event, tpd_D_P((863 - 33)- 48*3), true),
			62 => (D_dly(13)'last_event, tpd_D_P((863 - 33)- 48*4), true),
			63 => (D_dly(12)'last_event, tpd_D_P((863 - 33)- 48*5), true),
			64 => (D_dly(11)'last_event, tpd_D_P((863 - 33)- 48*6), true),
			65 => (D_dly(10)'last_event, tpd_D_P((863 - 33)- 48*7), true),
			66 => (D_dly(9)'last_event, tpd_D_P((863 - 33)- 48*8), true),
			67 => (D_dly(8)'last_event, tpd_D_P((863 - 33)- 48*9), true),
			68 => (D_dly(7)'last_event, tpd_D_P((863 - 33)- 48*10), true),
			69 => (D_dly(6)'last_event, tpd_D_P((863 - 33)- 48*11), true),
			70 => (D_dly(5)'last_event, tpd_D_P((863 - 33)- 48*12), true),
			71 => (D_dly(4)'last_event, tpd_D_P((863 - 33)- 48*13), true),
			72 => (D_dly(3)'last_event, tpd_D_P((863 - 33)- 48*14), true),
			73 => (D_dly(2)'last_event, tpd_D_P((863 - 33)- 48*15), true),
			74 => (D_dly(1)'last_event, tpd_D_P((863 - 33)- 48*16), true),
			75 => (D_dly(0)'last_event, tpd_D_P((863 - 33)- 48*17), true),
			76 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 33)- 48*0), true),
			77 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 33)- 48*1), true),
			78 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 33)- 48*2), true),
			79 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 33)- 48*3), true),
			80 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 33)- 48*4), true),
			81 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 33)- 48*5), true),
			82 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 33)- 48*6), true),
			83 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 33)- 48*7), true),
			84 => (PCIN_dly(14)'last_event, tpd_PCIN_P((2303 - 33)- 48*33), true),
			85 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 33)- 48*34), true),
			86 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 33)- 48*35), true),
			87 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 33)- 48*36), true),
			88 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 33)- 48*37), true),
			89 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 33)- 48*38), true),
			90 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 33)- 48*39), true),
			91 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 33)- 48*40), true),
			92 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 33)- 48*41), true),
			93 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 33)- 48*42), true),
			94 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 33)- 48*43), true),
			95 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 33)- 48*44), true),
			96 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 33)- 48*45), true),
			97 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 33)- 48*46), true),
			98 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 33)- 48*47), true),
			99 => (RSTA_dly'last_event, tpd_RSTA_P(14), true),
			100 => (RSTB_dly'last_event, tpd_RSTB_P(14), true),
			101 => (RSTC_dly'last_event, tpd_RSTC_P(14), true),
			102 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(14), true),
			103 => (RSTD_dly'last_event, tpd_RSTD_P(14), true),
			104 => (RSTM_dly'last_event, tpd_RSTM_P(14), true),
			105 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(14), true),
			106 => (RSTP_dly'last_event, tpd_RSTP_P(14), true),
			107 => (CLK_dly'last_event, tpd_CLK_P(14), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(13),
         GlitchData	=> P_GlitchData(13),
         OutSignalName	=> "P(13)",
         OutTemp	=> P_zd(13),
         Paths		=> (
			0 => (A_dly(13)'last_event, tpd_A_P((863 - 34)- 48*4), true),
			1 => (A_dly(12)'last_event, tpd_A_P((863 - 34)- 48*5), true),
			2 => (A_dly(11)'last_event, tpd_A_P((863 - 34)- 48*6), true),
			3 => (A_dly(10)'last_event, tpd_A_P((863 - 34)- 48*7), true),
			4 => (A_dly(9)'last_event, tpd_A_P((863 - 34)- 48*8), true),
			5 => (A_dly(8)'last_event, tpd_A_P((863 - 34)- 48*9), true),
			6 => (A_dly(7)'last_event, tpd_A_P((863 - 34)- 48*10), true),
			7 => (A_dly(6)'last_event, tpd_A_P((863 - 34)- 48*11), true),
			8 => (A_dly(5)'last_event, tpd_A_P((863 - 34)- 48*12), true),
			9 => (A_dly(4)'last_event, tpd_A_P((863 - 34)- 48*13), true),
			10 => (A_dly(3)'last_event, tpd_A_P((863 - 34)- 48*14), true),
			11 => (A_dly(2)'last_event, tpd_A_P((863 - 34)- 48*15), true),
			12 => (A_dly(1)'last_event, tpd_A_P((863 - 34)- 48*16), true),
			13 => (A_dly(0)'last_event, tpd_A_P((863 - 34)- 48*17), true),
			14 => (B_dly(13)'last_event, tpd_B_P((863 - 34)- 48*4), true),
			15 => (B_dly(12)'last_event, tpd_B_P((863 - 34)- 48*5), true),
			16 => (B_dly(11)'last_event, tpd_B_P((863 - 34)- 48*6), true),
			17 => (B_dly(10)'last_event, tpd_B_P((863 - 34)- 48*7), true),
			18 => (B_dly(9)'last_event, tpd_B_P((863 - 34)- 48*8), true),
			19 => (B_dly(8)'last_event, tpd_B_P((863 - 34)- 48*9), true),
			20 => (B_dly(7)'last_event, tpd_B_P((863 - 34)- 48*10), true),
			21 => (B_dly(6)'last_event, tpd_B_P((863 - 34)- 48*11), true),
			22 => (B_dly(5)'last_event, tpd_B_P((863 - 34)- 48*12), true),
			23 => (B_dly(4)'last_event, tpd_B_P((863 - 34)- 48*13), true),
			24 => (B_dly(3)'last_event, tpd_B_P((863 - 34)- 48*14), true),
			25 => (B_dly(2)'last_event, tpd_B_P((863 - 34)- 48*15), true),
			26 => (B_dly(1)'last_event, tpd_B_P((863 - 34)- 48*16), true),
			27 => (B_dly(0)'last_event, tpd_B_P((863 - 34)- 48*17), true),
			28 => (BCIN_dly(13)'last_event, tpd_BCIN_P((863 - 34)- 48*4), true),
			29 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 34)- 48*5), true),
			30 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 34)- 48*6), true),
			31 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 34)- 48*7), true),
			32 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 34)- 48*8), true),
			33 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 34)- 48*9), true),
			34 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 34)- 48*10), true),
			35 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 34)- 48*11), true),
			36 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 34)- 48*12), true),
			37 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 34)- 48*13), true),
			38 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 34)- 48*14), true),
			39 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 34)- 48*15), true),
			40 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 34)- 48*16), true),
			41 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 34)- 48*17), true),
			42 => (C_dly(13)'last_event, tpd_C_P((2303 - 34)- 48*34), true),
			43 => (C_dly(12)'last_event, tpd_C_P((2303 - 34)- 48*35), true),
			44 => (C_dly(11)'last_event, tpd_C_P((2303 - 34)- 48*36), true),
			45 => (C_dly(10)'last_event, tpd_C_P((2303 - 34)- 48*37), true),
			46 => (C_dly(9)'last_event, tpd_C_P((2303 - 34)- 48*38), true),
			47 => (C_dly(8)'last_event, tpd_C_P((2303 - 34)- 48*39), true),
			48 => (C_dly(7)'last_event, tpd_C_P((2303 - 34)- 48*40), true),
			49 => (C_dly(6)'last_event, tpd_C_P((2303 - 34)- 48*41), true),
			50 => (C_dly(5)'last_event, tpd_C_P((2303 - 34)- 48*42), true),
			51 => (C_dly(4)'last_event, tpd_C_P((2303 - 34)- 48*43), true),
			52 => (C_dly(3)'last_event, tpd_C_P((2303 - 34)- 48*44), true),
			53 => (C_dly(2)'last_event, tpd_C_P((2303 - 34)- 48*45), true),
			54 => (C_dly(1)'last_event, tpd_C_P((2303 - 34)- 48*46), true),
			55 => (C_dly(0)'last_event, tpd_C_P((2303 - 34)- 48*47), true),
			56 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(13), true),
			57 => (D_dly(13)'last_event, tpd_D_P((863 - 34)- 48*4), true),
			58 => (D_dly(12)'last_event, tpd_D_P((863 - 34)- 48*5), true),
			59 => (D_dly(11)'last_event, tpd_D_P((863 - 34)- 48*6), true),
			60 => (D_dly(10)'last_event, tpd_D_P((863 - 34)- 48*7), true),
			61 => (D_dly(9)'last_event, tpd_D_P((863 - 34)- 48*8), true),
			62 => (D_dly(8)'last_event, tpd_D_P((863 - 34)- 48*9), true),
			63 => (D_dly(7)'last_event, tpd_D_P((863 - 34)- 48*10), true),
			64 => (D_dly(6)'last_event, tpd_D_P((863 - 34)- 48*11), true),
			65 => (D_dly(5)'last_event, tpd_D_P((863 - 34)- 48*12), true),
			66 => (D_dly(4)'last_event, tpd_D_P((863 - 34)- 48*13), true),
			67 => (D_dly(3)'last_event, tpd_D_P((863 - 34)- 48*14), true),
			68 => (D_dly(2)'last_event, tpd_D_P((863 - 34)- 48*15), true),
			69 => (D_dly(1)'last_event, tpd_D_P((863 - 34)- 48*16), true),
			70 => (D_dly(0)'last_event, tpd_D_P((863 - 34)- 48*17), true),
			71 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 34)- 48*0), true),
			72 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 34)- 48*1), true),
			73 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 34)- 48*2), true),
			74 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 34)- 48*3), true),
			75 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 34)- 48*4), true),
			76 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 34)- 48*5), true),
			77 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 34)- 48*6), true),
			78 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 34)- 48*7), true),
			79 => (PCIN_dly(13)'last_event, tpd_PCIN_P((2303 - 34)- 48*34), true),
			80 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 34)- 48*35), true),
			81 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 34)- 48*36), true),
			82 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 34)- 48*37), true),
			83 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 34)- 48*38), true),
			84 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 34)- 48*39), true),
			85 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 34)- 48*40), true),
			86 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 34)- 48*41), true),
			87 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 34)- 48*42), true),
			88 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 34)- 48*43), true),
			89 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 34)- 48*44), true),
			90 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 34)- 48*45), true),
			91 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 34)- 48*46), true),
			92 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 34)- 48*47), true),
			93 => (RSTA_dly'last_event, tpd_RSTA_P(13), true),
			94 => (RSTB_dly'last_event, tpd_RSTB_P(13), true),
			95 => (RSTC_dly'last_event, tpd_RSTC_P(13), true),
			96 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(13), true),
			97 => (RSTD_dly'last_event, tpd_RSTD_P(13), true),
			98 => (RSTM_dly'last_event, tpd_RSTM_P(13), true),
			99 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(13), true),
			100 => (RSTP_dly'last_event, tpd_RSTP_P(13), true),
			101 => (CLK_dly'last_event, tpd_CLK_P(13), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(12),
         GlitchData	=> P_GlitchData(12),
         OutSignalName	=> "P(12)",
         OutTemp	=> P_zd(12),
         Paths		=> (
			0 => (A_dly(12)'last_event, tpd_A_P((863 - 35)- 48*5), true),
			1 => (A_dly(11)'last_event, tpd_A_P((863 - 35)- 48*6), true),
			2 => (A_dly(10)'last_event, tpd_A_P((863 - 35)- 48*7), true),
			3 => (A_dly(9)'last_event, tpd_A_P((863 - 35)- 48*8), true),
			4 => (A_dly(8)'last_event, tpd_A_P((863 - 35)- 48*9), true),
			5 => (A_dly(7)'last_event, tpd_A_P((863 - 35)- 48*10), true),
			6 => (A_dly(6)'last_event, tpd_A_P((863 - 35)- 48*11), true),
			7 => (A_dly(5)'last_event, tpd_A_P((863 - 35)- 48*12), true),
			8 => (A_dly(4)'last_event, tpd_A_P((863 - 35)- 48*13), true),
			9 => (A_dly(3)'last_event, tpd_A_P((863 - 35)- 48*14), true),
			10 => (A_dly(2)'last_event, tpd_A_P((863 - 35)- 48*15), true),
			11 => (A_dly(1)'last_event, tpd_A_P((863 - 35)- 48*16), true),
			12 => (A_dly(0)'last_event, tpd_A_P((863 - 35)- 48*17), true),
			13 => (B_dly(12)'last_event, tpd_B_P((863 - 35)- 48*5), true),
			14 => (B_dly(11)'last_event, tpd_B_P((863 - 35)- 48*6), true),
			15 => (B_dly(10)'last_event, tpd_B_P((863 - 35)- 48*7), true),
			16 => (B_dly(9)'last_event, tpd_B_P((863 - 35)- 48*8), true),
			17 => (B_dly(8)'last_event, tpd_B_P((863 - 35)- 48*9), true),
			18 => (B_dly(7)'last_event, tpd_B_P((863 - 35)- 48*10), true),
			19 => (B_dly(6)'last_event, tpd_B_P((863 - 35)- 48*11), true),
			20 => (B_dly(5)'last_event, tpd_B_P((863 - 35)- 48*12), true),
			21 => (B_dly(4)'last_event, tpd_B_P((863 - 35)- 48*13), true),
			22 => (B_dly(3)'last_event, tpd_B_P((863 - 35)- 48*14), true),
			23 => (B_dly(2)'last_event, tpd_B_P((863 - 35)- 48*15), true),
			24 => (B_dly(1)'last_event, tpd_B_P((863 - 35)- 48*16), true),
			25 => (B_dly(0)'last_event, tpd_B_P((863 - 35)- 48*17), true),
			26 => (BCIN_dly(12)'last_event, tpd_BCIN_P((863 - 35)- 48*5), true),
			27 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 35)- 48*6), true),
			28 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 35)- 48*7), true),
			29 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 35)- 48*8), true),
			30 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 35)- 48*9), true),
			31 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 35)- 48*10), true),
			32 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 35)- 48*11), true),
			33 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 35)- 48*12), true),
			34 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 35)- 48*13), true),
			35 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 35)- 48*14), true),
			36 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 35)- 48*15), true),
			37 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 35)- 48*16), true),
			38 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 35)- 48*17), true),
			39 => (C_dly(12)'last_event, tpd_C_P((2303 - 35)- 48*35), true),
			40 => (C_dly(11)'last_event, tpd_C_P((2303 - 35)- 48*36), true),
			41 => (C_dly(10)'last_event, tpd_C_P((2303 - 35)- 48*37), true),
			42 => (C_dly(9)'last_event, tpd_C_P((2303 - 35)- 48*38), true),
			43 => (C_dly(8)'last_event, tpd_C_P((2303 - 35)- 48*39), true),
			44 => (C_dly(7)'last_event, tpd_C_P((2303 - 35)- 48*40), true),
			45 => (C_dly(6)'last_event, tpd_C_P((2303 - 35)- 48*41), true),
			46 => (C_dly(5)'last_event, tpd_C_P((2303 - 35)- 48*42), true),
			47 => (C_dly(4)'last_event, tpd_C_P((2303 - 35)- 48*43), true),
			48 => (C_dly(3)'last_event, tpd_C_P((2303 - 35)- 48*44), true),
			49 => (C_dly(2)'last_event, tpd_C_P((2303 - 35)- 48*45), true),
			50 => (C_dly(1)'last_event, tpd_C_P((2303 - 35)- 48*46), true),
			51 => (C_dly(0)'last_event, tpd_C_P((2303 - 35)- 48*47), true),
			52 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(12), true),
			53 => (D_dly(12)'last_event, tpd_D_P((863 - 35)- 48*5), true),
			54 => (D_dly(11)'last_event, tpd_D_P((863 - 35)- 48*6), true),
			55 => (D_dly(10)'last_event, tpd_D_P((863 - 35)- 48*7), true),
			56 => (D_dly(9)'last_event, tpd_D_P((863 - 35)- 48*8), true),
			57 => (D_dly(8)'last_event, tpd_D_P((863 - 35)- 48*9), true),
			58 => (D_dly(7)'last_event, tpd_D_P((863 - 35)- 48*10), true),
			59 => (D_dly(6)'last_event, tpd_D_P((863 - 35)- 48*11), true),
			60 => (D_dly(5)'last_event, tpd_D_P((863 - 35)- 48*12), true),
			61 => (D_dly(4)'last_event, tpd_D_P((863 - 35)- 48*13), true),
			62 => (D_dly(3)'last_event, tpd_D_P((863 - 35)- 48*14), true),
			63 => (D_dly(2)'last_event, tpd_D_P((863 - 35)- 48*15), true),
			64 => (D_dly(1)'last_event, tpd_D_P((863 - 35)- 48*16), true),
			65 => (D_dly(0)'last_event, tpd_D_P((863 - 35)- 48*17), true),
			66 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 35)- 48*0), true),
			67 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 35)- 48*1), true),
			68 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 35)- 48*2), true),
			69 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 35)- 48*3), true),
			70 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 35)- 48*4), true),
			71 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 35)- 48*5), true),
			72 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 35)- 48*6), true),
			73 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 35)- 48*7), true),
			74 => (PCIN_dly(12)'last_event, tpd_PCIN_P((2303 - 35)- 48*35), true),
			75 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 35)- 48*36), true),
			76 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 35)- 48*37), true),
			77 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 35)- 48*38), true),
			78 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 35)- 48*39), true),
			79 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 35)- 48*40), true),
			80 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 35)- 48*41), true),
			81 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 35)- 48*42), true),
			82 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 35)- 48*43), true),
			83 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 35)- 48*44), true),
			84 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 35)- 48*45), true),
			85 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 35)- 48*46), true),
			86 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 35)- 48*47), true),
			87 => (RSTA_dly'last_event, tpd_RSTA_P(12), true),
			88 => (RSTB_dly'last_event, tpd_RSTB_P(12), true),
			89 => (RSTC_dly'last_event, tpd_RSTC_P(12), true),
			90 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(12), true),
			91 => (RSTD_dly'last_event, tpd_RSTD_P(12), true),
			92 => (RSTM_dly'last_event, tpd_RSTM_P(12), true),
			93 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(12), true),
			94 => (RSTP_dly'last_event, tpd_RSTP_P(12), true),
			95 => (CLK_dly'last_event, tpd_CLK_P(12), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(11),
         GlitchData	=> P_GlitchData(11),
         OutSignalName	=> "P(11)",
         OutTemp	=> P_zd(11),
         Paths		=> (
			0 => (A_dly(11)'last_event, tpd_A_P((863 - 36)- 48*6), true),
			1 => (A_dly(10)'last_event, tpd_A_P((863 - 36)- 48*7), true),
			2 => (A_dly(9)'last_event, tpd_A_P((863 - 36)- 48*8), true),
			3 => (A_dly(8)'last_event, tpd_A_P((863 - 36)- 48*9), true),
			4 => (A_dly(7)'last_event, tpd_A_P((863 - 36)- 48*10), true),
			5 => (A_dly(6)'last_event, tpd_A_P((863 - 36)- 48*11), true),
			6 => (A_dly(5)'last_event, tpd_A_P((863 - 36)- 48*12), true),
			7 => (A_dly(4)'last_event, tpd_A_P((863 - 36)- 48*13), true),
			8 => (A_dly(3)'last_event, tpd_A_P((863 - 36)- 48*14), true),
			9 => (A_dly(2)'last_event, tpd_A_P((863 - 36)- 48*15), true),
			10 => (A_dly(1)'last_event, tpd_A_P((863 - 36)- 48*16), true),
			11 => (A_dly(0)'last_event, tpd_A_P((863 - 36)- 48*17), true),
			12 => (B_dly(11)'last_event, tpd_B_P((863 - 36)- 48*6), true),
			13 => (B_dly(10)'last_event, tpd_B_P((863 - 36)- 48*7), true),
			14 => (B_dly(9)'last_event, tpd_B_P((863 - 36)- 48*8), true),
			15 => (B_dly(8)'last_event, tpd_B_P((863 - 36)- 48*9), true),
			16 => (B_dly(7)'last_event, tpd_B_P((863 - 36)- 48*10), true),
			17 => (B_dly(6)'last_event, tpd_B_P((863 - 36)- 48*11), true),
			18 => (B_dly(5)'last_event, tpd_B_P((863 - 36)- 48*12), true),
			19 => (B_dly(4)'last_event, tpd_B_P((863 - 36)- 48*13), true),
			20 => (B_dly(3)'last_event, tpd_B_P((863 - 36)- 48*14), true),
			21 => (B_dly(2)'last_event, tpd_B_P((863 - 36)- 48*15), true),
			22 => (B_dly(1)'last_event, tpd_B_P((863 - 36)- 48*16), true),
			23 => (B_dly(0)'last_event, tpd_B_P((863 - 36)- 48*17), true),
			24 => (BCIN_dly(11)'last_event, tpd_BCIN_P((863 - 36)- 48*6), true),
			25 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 36)- 48*7), true),
			26 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 36)- 48*8), true),
			27 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 36)- 48*9), true),
			28 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 36)- 48*10), true),
			29 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 36)- 48*11), true),
			30 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 36)- 48*12), true),
			31 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 36)- 48*13), true),
			32 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 36)- 48*14), true),
			33 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 36)- 48*15), true),
			34 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 36)- 48*16), true),
			35 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 36)- 48*17), true),
			36 => (C_dly(11)'last_event, tpd_C_P((2303 - 36)- 48*36), true),
			37 => (C_dly(10)'last_event, tpd_C_P((2303 - 36)- 48*37), true),
			38 => (C_dly(9)'last_event, tpd_C_P((2303 - 36)- 48*38), true),
			39 => (C_dly(8)'last_event, tpd_C_P((2303 - 36)- 48*39), true),
			40 => (C_dly(7)'last_event, tpd_C_P((2303 - 36)- 48*40), true),
			41 => (C_dly(6)'last_event, tpd_C_P((2303 - 36)- 48*41), true),
			42 => (C_dly(5)'last_event, tpd_C_P((2303 - 36)- 48*42), true),
			43 => (C_dly(4)'last_event, tpd_C_P((2303 - 36)- 48*43), true),
			44 => (C_dly(3)'last_event, tpd_C_P((2303 - 36)- 48*44), true),
			45 => (C_dly(2)'last_event, tpd_C_P((2303 - 36)- 48*45), true),
			46 => (C_dly(1)'last_event, tpd_C_P((2303 - 36)- 48*46), true),
			47 => (C_dly(0)'last_event, tpd_C_P((2303 - 36)- 48*47), true),
			48 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(11), true),
			49 => (D_dly(11)'last_event, tpd_D_P((863 - 36)- 48*6), true),
			50 => (D_dly(10)'last_event, tpd_D_P((863 - 36)- 48*7), true),
			51 => (D_dly(9)'last_event, tpd_D_P((863 - 36)- 48*8), true),
			52 => (D_dly(8)'last_event, tpd_D_P((863 - 36)- 48*9), true),
			53 => (D_dly(7)'last_event, tpd_D_P((863 - 36)- 48*10), true),
			54 => (D_dly(6)'last_event, tpd_D_P((863 - 36)- 48*11), true),
			55 => (D_dly(5)'last_event, tpd_D_P((863 - 36)- 48*12), true),
			56 => (D_dly(4)'last_event, tpd_D_P((863 - 36)- 48*13), true),
			57 => (D_dly(3)'last_event, tpd_D_P((863 - 36)- 48*14), true),
			58 => (D_dly(2)'last_event, tpd_D_P((863 - 36)- 48*15), true),
			59 => (D_dly(1)'last_event, tpd_D_P((863 - 36)- 48*16), true),
			60 => (D_dly(0)'last_event, tpd_D_P((863 - 36)- 48*17), true),
			61 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 36)- 48*0), true),
			62 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 36)- 48*1), true),
			63 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 36)- 48*2), true),
			64 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 36)- 48*3), true),
			65 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 36)- 48*4), true),
			66 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 36)- 48*5), true),
			67 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 36)- 48*6), true),
			68 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 36)- 48*7), true),
			69 => (PCIN_dly(11)'last_event, tpd_PCIN_P((2303 - 36)- 48*36), true),
			70 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 36)- 48*37), true),
			71 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 36)- 48*38), true),
			72 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 36)- 48*39), true),
			73 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 36)- 48*40), true),
			74 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 36)- 48*41), true),
			75 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 36)- 48*42), true),
			76 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 36)- 48*43), true),
			77 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 36)- 48*44), true),
			78 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 36)- 48*45), true),
			79 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 36)- 48*46), true),
			80 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 36)- 48*47), true),
			81 => (RSTA_dly'last_event, tpd_RSTA_P(11), true),
			82 => (RSTB_dly'last_event, tpd_RSTB_P(11), true),
			83 => (RSTC_dly'last_event, tpd_RSTC_P(11), true),
			84 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(11), true),
			85 => (RSTD_dly'last_event, tpd_RSTD_P(11), true),
			86 => (RSTM_dly'last_event, tpd_RSTM_P(11), true),
			87 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(11), true),
			88 => (RSTP_dly'last_event, tpd_RSTP_P(11), true),
			89 => (CLK_dly'last_event, tpd_CLK_P(11), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(10),
         GlitchData	=> P_GlitchData(10),
         OutSignalName	=> "P(10)",
         OutTemp	=> P_zd(10),
         Paths		=> (
			0 => (A_dly(10)'last_event, tpd_A_P((863 - 37)- 48*7), true),
			1 => (A_dly(9)'last_event, tpd_A_P((863 - 37)- 48*8), true),
			2 => (A_dly(8)'last_event, tpd_A_P((863 - 37)- 48*9), true),
			3 => (A_dly(7)'last_event, tpd_A_P((863 - 37)- 48*10), true),
			4 => (A_dly(6)'last_event, tpd_A_P((863 - 37)- 48*11), true),
			5 => (A_dly(5)'last_event, tpd_A_P((863 - 37)- 48*12), true),
			6 => (A_dly(4)'last_event, tpd_A_P((863 - 37)- 48*13), true),
			7 => (A_dly(3)'last_event, tpd_A_P((863 - 37)- 48*14), true),
			8 => (A_dly(2)'last_event, tpd_A_P((863 - 37)- 48*15), true),
			9 => (A_dly(1)'last_event, tpd_A_P((863 - 37)- 48*16), true),
			10 => (A_dly(0)'last_event, tpd_A_P((863 - 37)- 48*17), true),
			11 => (B_dly(10)'last_event, tpd_B_P((863 - 37)- 48*7), true),
			12 => (B_dly(9)'last_event, tpd_B_P((863 - 37)- 48*8), true),
			13 => (B_dly(8)'last_event, tpd_B_P((863 - 37)- 48*9), true),
			14 => (B_dly(7)'last_event, tpd_B_P((863 - 37)- 48*10), true),
			15 => (B_dly(6)'last_event, tpd_B_P((863 - 37)- 48*11), true),
			16 => (B_dly(5)'last_event, tpd_B_P((863 - 37)- 48*12), true),
			17 => (B_dly(4)'last_event, tpd_B_P((863 - 37)- 48*13), true),
			18 => (B_dly(3)'last_event, tpd_B_P((863 - 37)- 48*14), true),
			19 => (B_dly(2)'last_event, tpd_B_P((863 - 37)- 48*15), true),
			20 => (B_dly(1)'last_event, tpd_B_P((863 - 37)- 48*16), true),
			21 => (B_dly(0)'last_event, tpd_B_P((863 - 37)- 48*17), true),
			22 => (BCIN_dly(10)'last_event, tpd_BCIN_P((863 - 37)- 48*7), true),
			23 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 37)- 48*8), true),
			24 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 37)- 48*9), true),
			25 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 37)- 48*10), true),
			26 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 37)- 48*11), true),
			27 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 37)- 48*12), true),
			28 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 37)- 48*13), true),
			29 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 37)- 48*14), true),
			30 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 37)- 48*15), true),
			31 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 37)- 48*16), true),
			32 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 37)- 48*17), true),
			33 => (C_dly(10)'last_event, tpd_C_P((2303 - 37)- 48*37), true),
			34 => (C_dly(9)'last_event, tpd_C_P((2303 - 37)- 48*38), true),
			35 => (C_dly(8)'last_event, tpd_C_P((2303 - 37)- 48*39), true),
			36 => (C_dly(7)'last_event, tpd_C_P((2303 - 37)- 48*40), true),
			37 => (C_dly(6)'last_event, tpd_C_P((2303 - 37)- 48*41), true),
			38 => (C_dly(5)'last_event, tpd_C_P((2303 - 37)- 48*42), true),
			39 => (C_dly(4)'last_event, tpd_C_P((2303 - 37)- 48*43), true),
			40 => (C_dly(3)'last_event, tpd_C_P((2303 - 37)- 48*44), true),
			41 => (C_dly(2)'last_event, tpd_C_P((2303 - 37)- 48*45), true),
			42 => (C_dly(1)'last_event, tpd_C_P((2303 - 37)- 48*46), true),
			43 => (C_dly(0)'last_event, tpd_C_P((2303 - 37)- 48*47), true),
			44 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(10), true),
			45 => (D_dly(10)'last_event, tpd_D_P((863 - 37)- 48*7), true),
			46 => (D_dly(9)'last_event, tpd_D_P((863 - 37)- 48*8), true),
			47 => (D_dly(8)'last_event, tpd_D_P((863 - 37)- 48*9), true),
			48 => (D_dly(7)'last_event, tpd_D_P((863 - 37)- 48*10), true),
			49 => (D_dly(6)'last_event, tpd_D_P((863 - 37)- 48*11), true),
			50 => (D_dly(5)'last_event, tpd_D_P((863 - 37)- 48*12), true),
			51 => (D_dly(4)'last_event, tpd_D_P((863 - 37)- 48*13), true),
			52 => (D_dly(3)'last_event, tpd_D_P((863 - 37)- 48*14), true),
			53 => (D_dly(2)'last_event, tpd_D_P((863 - 37)- 48*15), true),
			54 => (D_dly(1)'last_event, tpd_D_P((863 - 37)- 48*16), true),
			55 => (D_dly(0)'last_event, tpd_D_P((863 - 37)- 48*17), true),
			56 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 37)- 48*0), true),
			57 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 37)- 48*1), true),
			58 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 37)- 48*2), true),
			59 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 37)- 48*3), true),
			60 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 37)- 48*4), true),
			61 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 37)- 48*5), true),
			62 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 37)- 48*6), true),
			63 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 37)- 48*7), true),
			64 => (PCIN_dly(10)'last_event, tpd_PCIN_P((2303 - 37)- 48*37), true),
			65 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 37)- 48*38), true),
			66 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 37)- 48*39), true),
			67 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 37)- 48*40), true),
			68 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 37)- 48*41), true),
			69 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 37)- 48*42), true),
			70 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 37)- 48*43), true),
			71 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 37)- 48*44), true),
			72 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 37)- 48*45), true),
			73 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 37)- 48*46), true),
			74 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 37)- 48*47), true),
			75 => (RSTA_dly'last_event, tpd_RSTA_P(10), true),
			76 => (RSTB_dly'last_event, tpd_RSTB_P(10), true),
			77 => (RSTC_dly'last_event, tpd_RSTC_P(10), true),
			78 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(10), true),
			79 => (RSTD_dly'last_event, tpd_RSTD_P(10), true),
			80 => (RSTM_dly'last_event, tpd_RSTM_P(10), true),
			81 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(10), true),
			82 => (RSTP_dly'last_event, tpd_RSTP_P(10), true),
			83 => (CLK_dly'last_event, tpd_CLK_P(10), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(9),
         GlitchData	=> P_GlitchData(9),
         OutSignalName	=> "P(9)",
         OutTemp	=> P_zd(9),
         Paths		=> (
			0 => (A_dly(9)'last_event, tpd_A_P((863 - 38)- 48*8), true),
			1 => (A_dly(8)'last_event, tpd_A_P((863 - 38)- 48*9), true),
			2 => (A_dly(7)'last_event, tpd_A_P((863 - 38)- 48*10), true),
			3 => (A_dly(6)'last_event, tpd_A_P((863 - 38)- 48*11), true),
			4 => (A_dly(5)'last_event, tpd_A_P((863 - 38)- 48*12), true),
			5 => (A_dly(4)'last_event, tpd_A_P((863 - 38)- 48*13), true),
			6 => (A_dly(3)'last_event, tpd_A_P((863 - 38)- 48*14), true),
			7 => (A_dly(2)'last_event, tpd_A_P((863 - 38)- 48*15), true),
			8 => (A_dly(1)'last_event, tpd_A_P((863 - 38)- 48*16), true),
			9 => (A_dly(0)'last_event, tpd_A_P((863 - 38)- 48*17), true),
			10 => (B_dly(9)'last_event, tpd_B_P((863 - 38)- 48*8), true),
			11 => (B_dly(8)'last_event, tpd_B_P((863 - 38)- 48*9), true),
			12 => (B_dly(7)'last_event, tpd_B_P((863 - 38)- 48*10), true),
			13 => (B_dly(6)'last_event, tpd_B_P((863 - 38)- 48*11), true),
			14 => (B_dly(5)'last_event, tpd_B_P((863 - 38)- 48*12), true),
			15 => (B_dly(4)'last_event, tpd_B_P((863 - 38)- 48*13), true),
			16 => (B_dly(3)'last_event, tpd_B_P((863 - 38)- 48*14), true),
			17 => (B_dly(2)'last_event, tpd_B_P((863 - 38)- 48*15), true),
			18 => (B_dly(1)'last_event, tpd_B_P((863 - 38)- 48*16), true),
			19 => (B_dly(0)'last_event, tpd_B_P((863 - 38)- 48*17), true),
			20 => (BCIN_dly(9)'last_event, tpd_BCIN_P((863 - 38)- 48*8), true),
			21 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 38)- 48*9), true),
			22 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 38)- 48*10), true),
			23 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 38)- 48*11), true),
			24 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 38)- 48*12), true),
			25 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 38)- 48*13), true),
			26 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 38)- 48*14), true),
			27 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 38)- 48*15), true),
			28 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 38)- 48*16), true),
			29 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 38)- 48*17), true),
			30 => (C_dly(9)'last_event, tpd_C_P((2303 - 38)- 48*38), true),
			31 => (C_dly(8)'last_event, tpd_C_P((2303 - 38)- 48*39), true),
			32 => (C_dly(7)'last_event, tpd_C_P((2303 - 38)- 48*40), true),
			33 => (C_dly(6)'last_event, tpd_C_P((2303 - 38)- 48*41), true),
			34 => (C_dly(5)'last_event, tpd_C_P((2303 - 38)- 48*42), true),
			35 => (C_dly(4)'last_event, tpd_C_P((2303 - 38)- 48*43), true),
			36 => (C_dly(3)'last_event, tpd_C_P((2303 - 38)- 48*44), true),
			37 => (C_dly(2)'last_event, tpd_C_P((2303 - 38)- 48*45), true),
			38 => (C_dly(1)'last_event, tpd_C_P((2303 - 38)- 48*46), true),
			39 => (C_dly(0)'last_event, tpd_C_P((2303 - 38)- 48*47), true),
			40 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(9), true),
			41 => (D_dly(9)'last_event, tpd_D_P((863 - 38)- 48*8), true),
			42 => (D_dly(8)'last_event, tpd_D_P((863 - 38)- 48*9), true),
			43 => (D_dly(7)'last_event, tpd_D_P((863 - 38)- 48*10), true),
			44 => (D_dly(6)'last_event, tpd_D_P((863 - 38)- 48*11), true),
			45 => (D_dly(5)'last_event, tpd_D_P((863 - 38)- 48*12), true),
			46 => (D_dly(4)'last_event, tpd_D_P((863 - 38)- 48*13), true),
			47 => (D_dly(3)'last_event, tpd_D_P((863 - 38)- 48*14), true),
			48 => (D_dly(2)'last_event, tpd_D_P((863 - 38)- 48*15), true),
			49 => (D_dly(1)'last_event, tpd_D_P((863 - 38)- 48*16), true),
			50 => (D_dly(0)'last_event, tpd_D_P((863 - 38)- 48*17), true),
			51 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 38)- 48*0), true),
			52 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 38)- 48*1), true),
			53 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 38)- 48*2), true),
			54 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 38)- 48*3), true),
			55 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 38)- 48*4), true),
			56 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 38)- 48*5), true),
			57 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 38)- 48*6), true),
			58 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 38)- 48*7), true),
			59 => (PCIN_dly(9)'last_event, tpd_PCIN_P((2303 - 38)- 48*38), true),
			60 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 38)- 48*39), true),
			61 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 38)- 48*40), true),
			62 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 38)- 48*41), true),
			63 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 38)- 48*42), true),
			64 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 38)- 48*43), true),
			65 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 38)- 48*44), true),
			66 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 38)- 48*45), true),
			67 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 38)- 48*46), true),
			68 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 38)- 48*47), true),
			69 => (RSTA_dly'last_event, tpd_RSTA_P(9), true),
			70 => (RSTB_dly'last_event, tpd_RSTB_P(9), true),
			71 => (RSTC_dly'last_event, tpd_RSTC_P(9), true),
			72 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(9), true),
			73 => (RSTD_dly'last_event, tpd_RSTD_P(9), true),
			74 => (RSTM_dly'last_event, tpd_RSTM_P(9), true),
			75 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(9), true),
			76 => (RSTP_dly'last_event, tpd_RSTP_P(9), true),
			77 => (CLK_dly'last_event, tpd_CLK_P(9), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(8),
         GlitchData	=> P_GlitchData(8),
         OutSignalName	=> "P(8)",
         OutTemp	=> P_zd(8),
         Paths		=> (
			0 => (A_dly(8)'last_event, tpd_A_P((863 - 39)- 48*9), true),
			1 => (A_dly(7)'last_event, tpd_A_P((863 - 39)- 48*10), true),
			2 => (A_dly(6)'last_event, tpd_A_P((863 - 39)- 48*11), true),
			3 => (A_dly(5)'last_event, tpd_A_P((863 - 39)- 48*12), true),
			4 => (A_dly(4)'last_event, tpd_A_P((863 - 39)- 48*13), true),
			5 => (A_dly(3)'last_event, tpd_A_P((863 - 39)- 48*14), true),
			6 => (A_dly(2)'last_event, tpd_A_P((863 - 39)- 48*15), true),
			7 => (A_dly(1)'last_event, tpd_A_P((863 - 39)- 48*16), true),
			8 => (A_dly(0)'last_event, tpd_A_P((863 - 39)- 48*17), true),
			9 => (B_dly(8)'last_event, tpd_B_P((863 - 39)- 48*9), true),
			10 => (B_dly(7)'last_event, tpd_B_P((863 - 39)- 48*10), true),
			11 => (B_dly(6)'last_event, tpd_B_P((863 - 39)- 48*11), true),
			12 => (B_dly(5)'last_event, tpd_B_P((863 - 39)- 48*12), true),
			13 => (B_dly(4)'last_event, tpd_B_P((863 - 39)- 48*13), true),
			14 => (B_dly(3)'last_event, tpd_B_P((863 - 39)- 48*14), true),
			15 => (B_dly(2)'last_event, tpd_B_P((863 - 39)- 48*15), true),
			16 => (B_dly(1)'last_event, tpd_B_P((863 - 39)- 48*16), true),
			17 => (B_dly(0)'last_event, tpd_B_P((863 - 39)- 48*17), true),
			18 => (BCIN_dly(8)'last_event, tpd_BCIN_P((863 - 39)- 48*9), true),
			19 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 39)- 48*10), true),
			20 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 39)- 48*11), true),
			21 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 39)- 48*12), true),
			22 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 39)- 48*13), true),
			23 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 39)- 48*14), true),
			24 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 39)- 48*15), true),
			25 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 39)- 48*16), true),
			26 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 39)- 48*17), true),
			27 => (C_dly(8)'last_event, tpd_C_P((2303 - 39)- 48*39), true),
			28 => (C_dly(7)'last_event, tpd_C_P((2303 - 39)- 48*40), true),
			29 => (C_dly(6)'last_event, tpd_C_P((2303 - 39)- 48*41), true),
			30 => (C_dly(5)'last_event, tpd_C_P((2303 - 39)- 48*42), true),
			31 => (C_dly(4)'last_event, tpd_C_P((2303 - 39)- 48*43), true),
			32 => (C_dly(3)'last_event, tpd_C_P((2303 - 39)- 48*44), true),
			33 => (C_dly(2)'last_event, tpd_C_P((2303 - 39)- 48*45), true),
			34 => (C_dly(1)'last_event, tpd_C_P((2303 - 39)- 48*46), true),
			35 => (C_dly(0)'last_event, tpd_C_P((2303 - 39)- 48*47), true),
			36 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(8), true),
			37 => (D_dly(8)'last_event, tpd_D_P((863 - 39)- 48*9), true),
			38 => (D_dly(7)'last_event, tpd_D_P((863 - 39)- 48*10), true),
			39 => (D_dly(6)'last_event, tpd_D_P((863 - 39)- 48*11), true),
			40 => (D_dly(5)'last_event, tpd_D_P((863 - 39)- 48*12), true),
			41 => (D_dly(4)'last_event, tpd_D_P((863 - 39)- 48*13), true),
			42 => (D_dly(3)'last_event, tpd_D_P((863 - 39)- 48*14), true),
			43 => (D_dly(2)'last_event, tpd_D_P((863 - 39)- 48*15), true),
			44 => (D_dly(1)'last_event, tpd_D_P((863 - 39)- 48*16), true),
			45 => (D_dly(0)'last_event, tpd_D_P((863 - 39)- 48*17), true),
			46 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 39)- 48*0), true),
			47 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 39)- 48*1), true),
			48 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 39)- 48*2), true),
			49 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 39)- 48*3), true),
			50 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 39)- 48*4), true),
			51 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 39)- 48*5), true),
			52 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 39)- 48*6), true),
			53 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 39)- 48*7), true),
			54 => (PCIN_dly(8)'last_event, tpd_PCIN_P((2303 - 39)- 48*39), true),
			55 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 39)- 48*40), true),
			56 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 39)- 48*41), true),
			57 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 39)- 48*42), true),
			58 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 39)- 48*43), true),
			59 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 39)- 48*44), true),
			60 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 39)- 48*45), true),
			61 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 39)- 48*46), true),
			62 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 39)- 48*47), true),
			63 => (RSTA_dly'last_event, tpd_RSTA_P(8), true),
			64 => (RSTB_dly'last_event, tpd_RSTB_P(8), true),
			65 => (RSTC_dly'last_event, tpd_RSTC_P(8), true),
			66 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(8), true),
			67 => (RSTD_dly'last_event, tpd_RSTD_P(8), true),
			68 => (RSTM_dly'last_event, tpd_RSTM_P(8), true),
			69 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(8), true),
			70 => (RSTP_dly'last_event, tpd_RSTP_P(8), true),
			71 => (CLK_dly'last_event, tpd_CLK_P(8), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(7),
         GlitchData	=> P_GlitchData(7),
         OutSignalName	=> "P(7)",
         OutTemp	=> P_zd(7),
         Paths		=> (
			0 => (A_dly(7)'last_event, tpd_A_P((863 - 40)- 48*10), true),
			1 => (A_dly(6)'last_event, tpd_A_P((863 - 40)- 48*11), true),
			2 => (A_dly(5)'last_event, tpd_A_P((863 - 40)- 48*12), true),
			3 => (A_dly(4)'last_event, tpd_A_P((863 - 40)- 48*13), true),
			4 => (A_dly(3)'last_event, tpd_A_P((863 - 40)- 48*14), true),
			5 => (A_dly(2)'last_event, tpd_A_P((863 - 40)- 48*15), true),
			6 => (A_dly(1)'last_event, tpd_A_P((863 - 40)- 48*16), true),
			7 => (A_dly(0)'last_event, tpd_A_P((863 - 40)- 48*17), true),
			8 => (B_dly(7)'last_event, tpd_B_P((863 - 40)- 48*10), true),
			9 => (B_dly(6)'last_event, tpd_B_P((863 - 40)- 48*11), true),
			10 => (B_dly(5)'last_event, tpd_B_P((863 - 40)- 48*12), true),
			11 => (B_dly(4)'last_event, tpd_B_P((863 - 40)- 48*13), true),
			12 => (B_dly(3)'last_event, tpd_B_P((863 - 40)- 48*14), true),
			13 => (B_dly(2)'last_event, tpd_B_P((863 - 40)- 48*15), true),
			14 => (B_dly(1)'last_event, tpd_B_P((863 - 40)- 48*16), true),
			15 => (B_dly(0)'last_event, tpd_B_P((863 - 40)- 48*17), true),
			16 => (BCIN_dly(7)'last_event, tpd_BCIN_P((863 - 40)- 48*10), true),
			17 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 40)- 48*11), true),
			18 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 40)- 48*12), true),
			19 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 40)- 48*13), true),
			20 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 40)- 48*14), true),
			21 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 40)- 48*15), true),
			22 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 40)- 48*16), true),
			23 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 40)- 48*17), true),
			24 => (C_dly(7)'last_event, tpd_C_P((2303 - 40)- 48*40), true),
			25 => (C_dly(6)'last_event, tpd_C_P((2303 - 40)- 48*41), true),
			26 => (C_dly(5)'last_event, tpd_C_P((2303 - 40)- 48*42), true),
			27 => (C_dly(4)'last_event, tpd_C_P((2303 - 40)- 48*43), true),
			28 => (C_dly(3)'last_event, tpd_C_P((2303 - 40)- 48*44), true),
			29 => (C_dly(2)'last_event, tpd_C_P((2303 - 40)- 48*45), true),
			30 => (C_dly(1)'last_event, tpd_C_P((2303 - 40)- 48*46), true),
			31 => (C_dly(0)'last_event, tpd_C_P((2303 - 40)- 48*47), true),
			32 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(7), true),
			33 => (D_dly(7)'last_event, tpd_D_P((863 - 40)- 48*10), true),
			34 => (D_dly(6)'last_event, tpd_D_P((863 - 40)- 48*11), true),
			35 => (D_dly(5)'last_event, tpd_D_P((863 - 40)- 48*12), true),
			36 => (D_dly(4)'last_event, tpd_D_P((863 - 40)- 48*13), true),
			37 => (D_dly(3)'last_event, tpd_D_P((863 - 40)- 48*14), true),
			38 => (D_dly(2)'last_event, tpd_D_P((863 - 40)- 48*15), true),
			39 => (D_dly(1)'last_event, tpd_D_P((863 - 40)- 48*16), true),
			40 => (D_dly(0)'last_event, tpd_D_P((863 - 40)- 48*17), true),
			41 => (OPMODE_dly(7)'last_event, tpd_OPMODE_P((383 - 40)- 48*0), true),
			42 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 40)- 48*1), true),
			43 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 40)- 48*2), true),
			44 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 40)- 48*3), true),
			45 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 40)- 48*4), true),
			46 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 40)- 48*5), true),
			47 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 40)- 48*6), true),
			48 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 40)- 48*7), true),
			49 => (PCIN_dly(7)'last_event, tpd_PCIN_P((2303 - 40)- 48*40), true),
			50 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 40)- 48*41), true),
			51 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 40)- 48*42), true),
			52 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 40)- 48*43), true),
			53 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 40)- 48*44), true),
			54 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 40)- 48*45), true),
			55 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 40)- 48*46), true),
			56 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 40)- 48*47), true),
			57 => (RSTA_dly'last_event, tpd_RSTA_P(7), true),
			58 => (RSTB_dly'last_event, tpd_RSTB_P(7), true),
			59 => (RSTC_dly'last_event, tpd_RSTC_P(7), true),
			60 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(7), true),
			61 => (RSTD_dly'last_event, tpd_RSTD_P(7), true),
			62 => (RSTM_dly'last_event, tpd_RSTM_P(7), true),
			63 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(7), true),
			64 => (RSTP_dly'last_event, tpd_RSTP_P(7), true),
			65 => (CLK_dly'last_event, tpd_CLK_P(7), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(6),
         GlitchData	=> P_GlitchData(6),
         OutSignalName	=> "P(6)",
         OutTemp	=> P_zd(6),
         Paths		=> (
			0 => (A_dly(6)'last_event, tpd_A_P((863 - 41)- 48*11), true),
			1 => (A_dly(5)'last_event, tpd_A_P((863 - 41)- 48*12), true),
			2 => (A_dly(4)'last_event, tpd_A_P((863 - 41)- 48*13), true),
			3 => (A_dly(3)'last_event, tpd_A_P((863 - 41)- 48*14), true),
			4 => (A_dly(2)'last_event, tpd_A_P((863 - 41)- 48*15), true),
			5 => (A_dly(1)'last_event, tpd_A_P((863 - 41)- 48*16), true),
			6 => (A_dly(0)'last_event, tpd_A_P((863 - 41)- 48*17), true),
			7 => (B_dly(6)'last_event, tpd_B_P((863 - 41)- 48*11), true),
			8 => (B_dly(5)'last_event, tpd_B_P((863 - 41)- 48*12), true),
			9 => (B_dly(4)'last_event, tpd_B_P((863 - 41)- 48*13), true),
			10 => (B_dly(3)'last_event, tpd_B_P((863 - 41)- 48*14), true),
			11 => (B_dly(2)'last_event, tpd_B_P((863 - 41)- 48*15), true),
			12 => (B_dly(1)'last_event, tpd_B_P((863 - 41)- 48*16), true),
			13 => (B_dly(0)'last_event, tpd_B_P((863 - 41)- 48*17), true),
			14 => (BCIN_dly(6)'last_event, tpd_BCIN_P((863 - 41)- 48*11), true),
			15 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 41)- 48*12), true),
			16 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 41)- 48*13), true),
			17 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 41)- 48*14), true),
			18 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 41)- 48*15), true),
			19 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 41)- 48*16), true),
			20 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 41)- 48*17), true),
			21 => (C_dly(6)'last_event, tpd_C_P((2303 - 41)- 48*41), true),
			22 => (C_dly(5)'last_event, tpd_C_P((2303 - 41)- 48*42), true),
			23 => (C_dly(4)'last_event, tpd_C_P((2303 - 41)- 48*43), true),
			24 => (C_dly(3)'last_event, tpd_C_P((2303 - 41)- 48*44), true),
			25 => (C_dly(2)'last_event, tpd_C_P((2303 - 41)- 48*45), true),
			26 => (C_dly(1)'last_event, tpd_C_P((2303 - 41)- 48*46), true),
			27 => (C_dly(0)'last_event, tpd_C_P((2303 - 41)- 48*47), true),
			28 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(6), true),
			29 => (D_dly(6)'last_event, tpd_D_P((863 - 41)- 48*11), true),
			30 => (D_dly(5)'last_event, tpd_D_P((863 - 41)- 48*12), true),
			31 => (D_dly(4)'last_event, tpd_D_P((863 - 41)- 48*13), true),
			32 => (D_dly(3)'last_event, tpd_D_P((863 - 41)- 48*14), true),
			33 => (D_dly(2)'last_event, tpd_D_P((863 - 41)- 48*15), true),
			34 => (D_dly(1)'last_event, tpd_D_P((863 - 41)- 48*16), true),
			35 => (D_dly(0)'last_event, tpd_D_P((863 - 41)- 48*17), true),
			36 => (OPMODE_dly(6)'last_event, tpd_OPMODE_P((383 - 41)- 48*1), true),
			37 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 41)- 48*2), true),
			38 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 41)- 48*3), true),
			39 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 41)- 48*4), true),
			40 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 41)- 48*5), true),
			41 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 41)- 48*6), true),
			42 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 41)- 48*7), true),
			43 => (PCIN_dly(6)'last_event, tpd_PCIN_P((2303 - 41)- 48*41), true),
			44 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 41)- 48*42), true),
			45 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 41)- 48*43), true),
			46 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 41)- 48*44), true),
			47 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 41)- 48*45), true),
			48 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 41)- 48*46), true),
			49 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 41)- 48*47), true),
			50 => (RSTA_dly'last_event, tpd_RSTA_P(6), true),
			51 => (RSTB_dly'last_event, tpd_RSTB_P(6), true),
			52 => (RSTC_dly'last_event, tpd_RSTC_P(6), true),
			53 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(6), true),
			54 => (RSTD_dly'last_event, tpd_RSTD_P(6), true),
			55 => (RSTM_dly'last_event, tpd_RSTM_P(6), true),
			56 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(6), true),
			57 => (RSTP_dly'last_event, tpd_RSTP_P(6), true),
			58 => (CLK_dly'last_event, tpd_CLK_P(6), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(5),
         GlitchData	=> P_GlitchData(5),
         OutSignalName	=> "P(5)",
         OutTemp	=> P_zd(5),
         Paths		=> (
			0 => (A_dly(5)'last_event, tpd_A_P((863 - 42)- 48*12), true),
			1 => (A_dly(4)'last_event, tpd_A_P((863 - 42)- 48*13), true),
			2 => (A_dly(3)'last_event, tpd_A_P((863 - 42)- 48*14), true),
			3 => (A_dly(2)'last_event, tpd_A_P((863 - 42)- 48*15), true),
			4 => (A_dly(1)'last_event, tpd_A_P((863 - 42)- 48*16), true),
			5 => (A_dly(0)'last_event, tpd_A_P((863 - 42)- 48*17), true),
			6 => (B_dly(5)'last_event, tpd_B_P((863 - 42)- 48*12), true),
			7 => (B_dly(4)'last_event, tpd_B_P((863 - 42)- 48*13), true),
			8 => (B_dly(3)'last_event, tpd_B_P((863 - 42)- 48*14), true),
			9 => (B_dly(2)'last_event, tpd_B_P((863 - 42)- 48*15), true),
			10 => (B_dly(1)'last_event, tpd_B_P((863 - 42)- 48*16), true),
			11 => (B_dly(0)'last_event, tpd_B_P((863 - 42)- 48*17), true),
			12 => (BCIN_dly(5)'last_event, tpd_BCIN_P((863 - 42)- 48*12), true),
			13 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 42)- 48*13), true),
			14 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 42)- 48*14), true),
			15 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 42)- 48*15), true),
			16 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 42)- 48*16), true),
			17 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 42)- 48*17), true),
			18 => (C_dly(5)'last_event, tpd_C_P((2303 - 42)- 48*42), true),
			19 => (C_dly(4)'last_event, tpd_C_P((2303 - 42)- 48*43), true),
			20 => (C_dly(3)'last_event, tpd_C_P((2303 - 42)- 48*44), true),
			21 => (C_dly(2)'last_event, tpd_C_P((2303 - 42)- 48*45), true),
			22 => (C_dly(1)'last_event, tpd_C_P((2303 - 42)- 48*46), true),
			23 => (C_dly(0)'last_event, tpd_C_P((2303 - 42)- 48*47), true),
			24 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(5), true),
			25 => (D_dly(5)'last_event, tpd_D_P((863 - 42)- 48*12), true),
			26 => (D_dly(4)'last_event, tpd_D_P((863 - 42)- 48*13), true),
			27 => (D_dly(3)'last_event, tpd_D_P((863 - 42)- 48*14), true),
			28 => (D_dly(2)'last_event, tpd_D_P((863 - 42)- 48*15), true),
			29 => (D_dly(1)'last_event, tpd_D_P((863 - 42)- 48*16), true),
			30 => (D_dly(0)'last_event, tpd_D_P((863 - 42)- 48*17), true),
			31 => (OPMODE_dly(5)'last_event, tpd_OPMODE_P((383 - 42)- 48*2), true),
			32 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 42)- 48*3), true),
			33 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 42)- 48*4), true),
			34 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 42)- 48*5), true),
			35 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 42)- 48*6), true),
			36 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 42)- 48*7), true),
			37 => (PCIN_dly(5)'last_event, tpd_PCIN_P((2303 - 42)- 48*42), true),
			38 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 42)- 48*43), true),
			39 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 42)- 48*44), true),
			40 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 42)- 48*45), true),
			41 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 42)- 48*46), true),
			42 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 42)- 48*47), true),
			43 => (RSTA_dly'last_event, tpd_RSTA_P(5), true),
			44 => (RSTB_dly'last_event, tpd_RSTB_P(5), true),
			45 => (RSTC_dly'last_event, tpd_RSTC_P(5), true),
			46 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(5), true),
			47 => (RSTD_dly'last_event, tpd_RSTD_P(5), true),
			48 => (RSTM_dly'last_event, tpd_RSTM_P(5), true),
			49 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(5), true),
			50 => (RSTP_dly'last_event, tpd_RSTP_P(5), true),
			51 => (CLK_dly'last_event, tpd_CLK_P(5), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(4),
         GlitchData	=> P_GlitchData(4),
         OutSignalName	=> "P(4)",
         OutTemp	=> P_zd(4),
         Paths		=> (
			0 => (A_dly(4)'last_event, tpd_A_P((863 - 43)- 48*13), true),
			1 => (A_dly(3)'last_event, tpd_A_P((863 - 43)- 48*14), true),
			2 => (A_dly(2)'last_event, tpd_A_P((863 - 43)- 48*15), true),
			3 => (A_dly(1)'last_event, tpd_A_P((863 - 43)- 48*16), true),
			4 => (A_dly(0)'last_event, tpd_A_P((863 - 43)- 48*17), true),
			5 => (B_dly(4)'last_event, tpd_B_P((863 - 43)- 48*13), true),
			6 => (B_dly(3)'last_event, tpd_B_P((863 - 43)- 48*14), true),
			7 => (B_dly(2)'last_event, tpd_B_P((863 - 43)- 48*15), true),
			8 => (B_dly(1)'last_event, tpd_B_P((863 - 43)- 48*16), true),
			9 => (B_dly(0)'last_event, tpd_B_P((863 - 43)- 48*17), true),
			10 => (BCIN_dly(4)'last_event, tpd_BCIN_P((863 - 43)- 48*13), true),
			11 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 43)- 48*14), true),
			12 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 43)- 48*15), true),
			13 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 43)- 48*16), true),
			14 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 43)- 48*17), true),
			15 => (C_dly(4)'last_event, tpd_C_P((2303 - 43)- 48*43), true),
			16 => (C_dly(3)'last_event, tpd_C_P((2303 - 43)- 48*44), true),
			17 => (C_dly(2)'last_event, tpd_C_P((2303 - 43)- 48*45), true),
			18 => (C_dly(1)'last_event, tpd_C_P((2303 - 43)- 48*46), true),
			19 => (C_dly(0)'last_event, tpd_C_P((2303 - 43)- 48*47), true),
			20 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(4), true),
			21 => (D_dly(4)'last_event, tpd_D_P((863 - 43)- 48*13), true),
			22 => (D_dly(3)'last_event, tpd_D_P((863 - 43)- 48*14), true),
			23 => (D_dly(2)'last_event, tpd_D_P((863 - 43)- 48*15), true),
			24 => (D_dly(1)'last_event, tpd_D_P((863 - 43)- 48*16), true),
			25 => (D_dly(0)'last_event, tpd_D_P((863 - 43)- 48*17), true),
			26 => (OPMODE_dly(4)'last_event, tpd_OPMODE_P((383 - 43)- 48*3), true),
			27 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 43)- 48*4), true),
			28 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 43)- 48*5), true),
			29 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 43)- 48*6), true),
			30 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 43)- 48*7), true),
			31 => (PCIN_dly(4)'last_event, tpd_PCIN_P((2303 - 43)- 48*43), true),
			32 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 43)- 48*44), true),
			33 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 43)- 48*45), true),
			34 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 43)- 48*46), true),
			35 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 43)- 48*47), true),
			36 => (RSTA_dly'last_event, tpd_RSTA_P(4), true),
			37 => (RSTB_dly'last_event, tpd_RSTB_P(4), true),
			38 => (RSTC_dly'last_event, tpd_RSTC_P(4), true),
			39 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(4), true),
			40 => (RSTD_dly'last_event, tpd_RSTD_P(4), true),
			41 => (RSTM_dly'last_event, tpd_RSTM_P(4), true),
			42 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(4), true),
			43 => (RSTP_dly'last_event, tpd_RSTP_P(4), true),
			44 => (CLK_dly'last_event, tpd_CLK_P(4), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(3),
         GlitchData	=> P_GlitchData(3),
         OutSignalName	=> "P(3)",
         OutTemp	=> P_zd(3),
         Paths		=> (
			0 => (A_dly(3)'last_event, tpd_A_P((863 - 44)- 48*14), true),
			1 => (A_dly(2)'last_event, tpd_A_P((863 - 44)- 48*15), true),
			2 => (A_dly(1)'last_event, tpd_A_P((863 - 44)- 48*16), true),
			3 => (A_dly(0)'last_event, tpd_A_P((863 - 44)- 48*17), true),
			4 => (B_dly(3)'last_event, tpd_B_P((863 - 44)- 48*14), true),
			5 => (B_dly(2)'last_event, tpd_B_P((863 - 44)- 48*15), true),
			6 => (B_dly(1)'last_event, tpd_B_P((863 - 44)- 48*16), true),
			7 => (B_dly(0)'last_event, tpd_B_P((863 - 44)- 48*17), true),
			8 => (BCIN_dly(3)'last_event, tpd_BCIN_P((863 - 44)- 48*14), true),
			9 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 44)- 48*15), true),
			10 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 44)- 48*16), true),
			11 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 44)- 48*17), true),
			12 => (C_dly(3)'last_event, tpd_C_P((2303 - 44)- 48*44), true),
			13 => (C_dly(2)'last_event, tpd_C_P((2303 - 44)- 48*45), true),
			14 => (C_dly(1)'last_event, tpd_C_P((2303 - 44)- 48*46), true),
			15 => (C_dly(0)'last_event, tpd_C_P((2303 - 44)- 48*47), true),
			16 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(3), true),
			17 => (D_dly(3)'last_event, tpd_D_P((863 - 44)- 48*14), true),
			18 => (D_dly(2)'last_event, tpd_D_P((863 - 44)- 48*15), true),
			19 => (D_dly(1)'last_event, tpd_D_P((863 - 44)- 48*16), true),
			20 => (D_dly(0)'last_event, tpd_D_P((863 - 44)- 48*17), true),
			21 => (OPMODE_dly(3)'last_event, tpd_OPMODE_P((383 - 44)- 48*4), true),
			22 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 44)- 48*5), true),
			23 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 44)- 48*6), true),
			24 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 44)- 48*7), true),
			25 => (PCIN_dly(3)'last_event, tpd_PCIN_P((2303 - 44)- 48*44), true),
			26 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 44)- 48*45), true),
			27 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 44)- 48*46), true),
			28 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 44)- 48*47), true),
			29 => (RSTA_dly'last_event, tpd_RSTA_P(3), true),
			30 => (RSTB_dly'last_event, tpd_RSTB_P(3), true),
			31 => (RSTC_dly'last_event, tpd_RSTC_P(3), true),
			32 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(3), true),
			33 => (RSTD_dly'last_event, tpd_RSTD_P(3), true),
			34 => (RSTM_dly'last_event, tpd_RSTM_P(3), true),
			35 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(3), true),
			36 => (RSTP_dly'last_event, tpd_RSTP_P(3), true),
			37 => (CLK_dly'last_event, tpd_CLK_P(3), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(2),
         GlitchData	=> P_GlitchData(2),
         OutSignalName	=> "P(2)",
         OutTemp	=> P_zd(2),
         Paths		=> (
			0 => (A_dly(2)'last_event, tpd_A_P((863 - 45)- 48*15), true),
			1 => (A_dly(1)'last_event, tpd_A_P((863 - 45)- 48*16), true),
			2 => (A_dly(0)'last_event, tpd_A_P((863 - 45)- 48*17), true),
			3 => (B_dly(2)'last_event, tpd_B_P((863 - 45)- 48*15), true),
			4 => (B_dly(1)'last_event, tpd_B_P((863 - 45)- 48*16), true),
			5 => (B_dly(0)'last_event, tpd_B_P((863 - 45)- 48*17), true),
			6 => (BCIN_dly(2)'last_event, tpd_BCIN_P((863 - 45)- 48*15), true),
			7 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 45)- 48*16), true),
			8 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 45)- 48*17), true),
			9 => (C_dly(2)'last_event, tpd_C_P((2303 - 45)- 48*45), true),
			10 => (C_dly(1)'last_event, tpd_C_P((2303 - 45)- 48*46), true),
			11 => (C_dly(0)'last_event, tpd_C_P((2303 - 45)- 48*47), true),
			12 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(2), true),
			13 => (D_dly(2)'last_event, tpd_D_P((863 - 45)- 48*15), true),
			14 => (D_dly(1)'last_event, tpd_D_P((863 - 45)- 48*16), true),
			15 => (D_dly(0)'last_event, tpd_D_P((863 - 45)- 48*17), true),
			16 => (OPMODE_dly(2)'last_event, tpd_OPMODE_P((383 - 45)- 48*5), true),
			17 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 45)- 48*6), true),
			18 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 45)- 48*7), true),
			19 => (PCIN_dly(2)'last_event, tpd_PCIN_P((2303 - 45)- 48*45), true),
			20 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 45)- 48*46), true),
			21 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 45)- 48*47), true),
			22 => (RSTA_dly'last_event, tpd_RSTA_P(2), true),
			23 => (RSTB_dly'last_event, tpd_RSTB_P(2), true),
			24 => (RSTC_dly'last_event, tpd_RSTC_P(2), true),
			25 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(2), true),
			26 => (RSTD_dly'last_event, tpd_RSTD_P(2), true),
			27 => (RSTM_dly'last_event, tpd_RSTM_P(2), true),
			28 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(2), true),
			29 => (RSTP_dly'last_event, tpd_RSTP_P(2), true),
			30 => (CLK_dly'last_event, tpd_CLK_P(2), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(1),
         GlitchData	=> P_GlitchData(1),
         OutSignalName	=> "P(1)",
         OutTemp	=> P_zd(1),
         Paths		=> (
			0 => (A_dly(1)'last_event, tpd_A_P((863 - 46)- 48*16), true),
			1 => (A_dly(0)'last_event, tpd_A_P((863 - 46)- 48*17), true),
			2 => (B_dly(1)'last_event, tpd_B_P((863 - 46)- 48*16), true),
			3 => (B_dly(0)'last_event, tpd_B_P((863 - 46)- 48*17), true),
			4 => (BCIN_dly(1)'last_event, tpd_BCIN_P((863 - 46)- 48*16), true),
			5 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 46)- 48*17), true),
			6 => (C_dly(1)'last_event, tpd_C_P((2303 - 46)- 48*46), true),
			7 => (C_dly(0)'last_event, tpd_C_P((2303 - 46)- 48*47), true),
			8 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(1), true),
			9 => (D_dly(1)'last_event, tpd_D_P((863 - 46)- 48*16), true),
			10 => (D_dly(0)'last_event, tpd_D_P((863 - 46)- 48*17), true),
			11 => (OPMODE_dly(1)'last_event, tpd_OPMODE_P((383 - 46)- 48*6), true),
			12 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 46)- 48*7), true),
			13 => (PCIN_dly(1)'last_event, tpd_PCIN_P((2303 - 46)- 48*46), true),
			14 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 46)- 48*47), true),
			15 => (RSTA_dly'last_event, tpd_RSTA_P(1), true),
			16 => (RSTB_dly'last_event, tpd_RSTB_P(1), true),
			17 => (RSTC_dly'last_event, tpd_RSTC_P(1), true),
			18 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(1), true),
			19 => (RSTD_dly'last_event, tpd_RSTD_P(1), true),
			20 => (RSTM_dly'last_event, tpd_RSTM_P(1), true),
			21 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(1), true),
			22 => (RSTP_dly'last_event, tpd_RSTP_P(1), true),
			23 => (CLK_dly'last_event, tpd_CLK_P(1), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> P(0),
         GlitchData	=> P_GlitchData(0),
         OutSignalName	=> "P(0)",
         OutTemp	=> P_zd(0),
         Paths		=> (
			0 => (A_dly(0)'last_event, tpd_A_P((863 - 47)- 48*17), true),
			1 => (B_dly(0)'last_event, tpd_B_P((863 - 47)- 48*17), true),
			2 => (BCIN_dly(0)'last_event, tpd_BCIN_P((863 - 47)- 48*17), true),
			3 => (C_dly(0)'last_event, tpd_C_P((2303 - 47)- 48*47), true),
			4 => (CARRYIN_dly'last_event, tpd_CARRYIN_P(0), true),
			5 => (D_dly(0)'last_event, tpd_D_P((863 - 47)- 48*17), true),
			6 => (OPMODE_dly(0)'last_event, tpd_OPMODE_P((383 - 47)- 48*7), true),
			7 => (PCIN_dly(0)'last_event, tpd_PCIN_P((2303 - 47)- 48*47), true),
			8 => (RSTA_dly'last_event, tpd_RSTA_P(0), true),
			9 => (RSTB_dly'last_event, tpd_RSTB_P(0), true),
			10 => (RSTC_dly'last_event, tpd_RSTC_P(0), true),
			11 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_P(0), true),
			12 => (RSTD_dly'last_event, tpd_RSTD_P(0), true),
			13 => (RSTM_dly'last_event, tpd_RSTM_P(0), true),
			14 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_P(0), true),
			15 => (RSTP_dly'last_event, tpd_RSTP_P(0), true),
			16 => (CLK_dly'last_event, tpd_CLK_P(0), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(47),
         GlitchData	=> PCOUT_GlitchData(47),
         OutSignalName	=> "PCOUT(47)",
         OutTemp	=> PCOUT_zd(47),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 0)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 0)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 0)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 0)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 0)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 0)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 0)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 0)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 0)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 0)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 0)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 0)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 0)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 0)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 0)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 0)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 0)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 0)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 0)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 0)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 0)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 0)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 0)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 0)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 0)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 0)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 0)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 0)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 0)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 0)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 0)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 0)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 0)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 0)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 0)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 0)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 0)- 48*17), true),
			54 => (C_dly(47)'last_event, tpd_C_PCOUT((2303 - 0)- 48*0), true),
			55 => (C_dly(46)'last_event, tpd_C_PCOUT((2303 - 0)- 48*1), true),
			56 => (C_dly(45)'last_event, tpd_C_PCOUT((2303 - 0)- 48*2), true),
			57 => (C_dly(44)'last_event, tpd_C_PCOUT((2303 - 0)- 48*3), true),
			58 => (C_dly(43)'last_event, tpd_C_PCOUT((2303 - 0)- 48*4), true),
			59 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 0)- 48*5), true),
			60 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 0)- 48*6), true),
			61 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 0)- 48*7), true),
			62 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 0)- 48*8), true),
			63 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 0)- 48*9), true),
			64 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 0)- 48*10), true),
			65 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 0)- 48*11), true),
			66 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 0)- 48*12), true),
			67 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 0)- 48*13), true),
			68 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 0)- 48*14), true),
			69 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 0)- 48*15), true),
			70 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 0)- 48*16), true),
			71 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 0)- 48*17), true),
			72 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 0)- 48*18), true),
			73 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 0)- 48*19), true),
			74 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 0)- 48*20), true),
			75 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 0)- 48*21), true),
			76 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 0)- 48*22), true),
			77 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 0)- 48*23), true),
			78 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 0)- 48*24), true),
			79 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 0)- 48*25), true),
			80 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 0)- 48*26), true),
			81 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 0)- 48*27), true),
			82 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 0)- 48*28), true),
			83 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 0)- 48*29), true),
			84 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 0)- 48*30), true),
			85 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 0)- 48*31), true),
			86 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 0)- 48*32), true),
			87 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 0)- 48*33), true),
			88 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 0)- 48*34), true),
			89 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 0)- 48*35), true),
			90 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 0)- 48*36), true),
			91 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 0)- 48*37), true),
			92 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 0)- 48*38), true),
			93 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 0)- 48*39), true),
			94 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 0)- 48*40), true),
			95 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 0)- 48*41), true),
			96 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 0)- 48*42), true),
			97 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 0)- 48*43), true),
			98 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 0)- 48*44), true),
			99 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 0)- 48*45), true),
			100 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 0)- 48*46), true),
			101 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 0)- 48*47), true),
			102 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(47), true),
			103 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 0)- 48*0), true),
			104 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 0)- 48*1), true),
			105 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 0)- 48*2), true),
			106 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 0)- 48*3), true),
			107 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 0)- 48*4), true),
			108 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 0)- 48*5), true),
			109 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 0)- 48*6), true),
			110 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 0)- 48*7), true),
			111 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 0)- 48*8), true),
			112 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 0)- 48*9), true),
			113 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 0)- 48*10), true),
			114 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 0)- 48*11), true),
			115 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 0)- 48*12), true),
			116 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 0)- 48*13), true),
			117 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 0)- 48*14), true),
			118 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 0)- 48*15), true),
			119 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 0)- 48*16), true),
			120 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 0)- 48*17), true),
			121 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*0), true),
			122 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*1), true),
			123 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*2), true),
			124 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*3), true),
			125 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*4), true),
			126 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*5), true),
			127 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*6), true),
			128 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 0)- 48*7), true),
			129 => (PCIN_dly(47)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*0), true),
			130 => (PCIN_dly(46)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*1), true),
			131 => (PCIN_dly(45)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*2), true),
			132 => (PCIN_dly(44)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*3), true),
			133 => (PCIN_dly(43)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*4), true),
			134 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*5), true),
			135 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*6), true),
			136 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*7), true),
			137 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*8), true),
			138 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*9), true),
			139 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*10), true),
			140 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*11), true),
			141 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*12), true),
			142 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*13), true),
			143 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*14), true),
			144 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*15), true),
			145 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*16), true),
			146 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*17), true),
			147 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*18), true),
			148 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*19), true),
			149 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*20), true),
			150 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*21), true),
			151 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*22), true),
			152 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*23), true),
			153 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*24), true),
			154 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*25), true),
			155 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*26), true),
			156 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*27), true),
			157 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*28), true),
			158 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*29), true),
			159 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*30), true),
			160 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*31), true),
			161 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*32), true),
			162 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*33), true),
			163 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*34), true),
			164 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*35), true),
			165 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*36), true),
			166 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*37), true),
			167 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*38), true),
			168 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*39), true),
			169 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*40), true),
			170 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*41), true),
			171 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*42), true),
			172 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*43), true),
			173 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*44), true),
			174 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*45), true),
			175 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*46), true),
			176 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 0)- 48*47), true),
			177 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(47), true),
			178 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(47), true),
			179 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(47), true),
			180 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(47), true),
			181 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(47), true),
			182 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(47), true),
			183 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(47), true),
			184 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(47), true),
			185 => (CLK_dly'last_event, tpd_CLK_PCOUT(47), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(46),
         GlitchData	=> PCOUT_GlitchData(46),
         OutSignalName	=> "PCOUT(46)",
         OutTemp	=> PCOUT_zd(46),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 1)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 1)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 1)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 1)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 1)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 1)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 1)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 1)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 1)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 1)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 1)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 1)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 1)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 1)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 1)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 1)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 1)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 1)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 1)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 1)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 1)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 1)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 1)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 1)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 1)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 1)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 1)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 1)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 1)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 1)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 1)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 1)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 1)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 1)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 1)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 1)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 1)- 48*17), true),
			54 => (C_dly(46)'last_event, tpd_C_PCOUT((2303 - 1)- 48*1), true),
			55 => (C_dly(45)'last_event, tpd_C_PCOUT((2303 - 1)- 48*2), true),
			56 => (C_dly(44)'last_event, tpd_C_PCOUT((2303 - 1)- 48*3), true),
			57 => (C_dly(43)'last_event, tpd_C_PCOUT((2303 - 1)- 48*4), true),
			58 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 1)- 48*5), true),
			59 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 1)- 48*6), true),
			60 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 1)- 48*7), true),
			61 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 1)- 48*8), true),
			62 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 1)- 48*9), true),
			63 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 1)- 48*10), true),
			64 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 1)- 48*11), true),
			65 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 1)- 48*12), true),
			66 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 1)- 48*13), true),
			67 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 1)- 48*14), true),
			68 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 1)- 48*15), true),
			69 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 1)- 48*16), true),
			70 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 1)- 48*17), true),
			71 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 1)- 48*18), true),
			72 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 1)- 48*19), true),
			73 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 1)- 48*20), true),
			74 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 1)- 48*21), true),
			75 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 1)- 48*22), true),
			76 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 1)- 48*23), true),
			77 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 1)- 48*24), true),
			78 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 1)- 48*25), true),
			79 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 1)- 48*26), true),
			80 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 1)- 48*27), true),
			81 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 1)- 48*28), true),
			82 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 1)- 48*29), true),
			83 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 1)- 48*30), true),
			84 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 1)- 48*31), true),
			85 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 1)- 48*32), true),
			86 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 1)- 48*33), true),
			87 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 1)- 48*34), true),
			88 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 1)- 48*35), true),
			89 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 1)- 48*36), true),
			90 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 1)- 48*37), true),
			91 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 1)- 48*38), true),
			92 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 1)- 48*39), true),
			93 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 1)- 48*40), true),
			94 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 1)- 48*41), true),
			95 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 1)- 48*42), true),
			96 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 1)- 48*43), true),
			97 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 1)- 48*44), true),
			98 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 1)- 48*45), true),
			99 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 1)- 48*46), true),
			100 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 1)- 48*47), true),
			101 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(46), true),
			102 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 1)- 48*0), true),
			103 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 1)- 48*1), true),
			104 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 1)- 48*2), true),
			105 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 1)- 48*3), true),
			106 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 1)- 48*4), true),
			107 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 1)- 48*5), true),
			108 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 1)- 48*6), true),
			109 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 1)- 48*7), true),
			110 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 1)- 48*8), true),
			111 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 1)- 48*9), true),
			112 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 1)- 48*10), true),
			113 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 1)- 48*11), true),
			114 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 1)- 48*12), true),
			115 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 1)- 48*13), true),
			116 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 1)- 48*14), true),
			117 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 1)- 48*15), true),
			118 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 1)- 48*16), true),
			119 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 1)- 48*17), true),
			120 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*0), true),
			121 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*1), true),
			122 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*2), true),
			123 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*3), true),
			124 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*4), true),
			125 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*5), true),
			126 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*6), true),
			127 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 1)- 48*7), true),
			128 => (PCIN_dly(46)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*1), true),
			129 => (PCIN_dly(45)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*2), true),
			130 => (PCIN_dly(44)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*3), true),
			131 => (PCIN_dly(43)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*4), true),
			132 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*5), true),
			133 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*6), true),
			134 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*7), true),
			135 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*8), true),
			136 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*9), true),
			137 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*10), true),
			138 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*11), true),
			139 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*12), true),
			140 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*13), true),
			141 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*14), true),
			142 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*15), true),
			143 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*16), true),
			144 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*17), true),
			145 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*18), true),
			146 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*19), true),
			147 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*20), true),
			148 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*21), true),
			149 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*22), true),
			150 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*23), true),
			151 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*24), true),
			152 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*25), true),
			153 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*26), true),
			154 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*27), true),
			155 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*28), true),
			156 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*29), true),
			157 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*30), true),
			158 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*31), true),
			159 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*32), true),
			160 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*33), true),
			161 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*34), true),
			162 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*35), true),
			163 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*36), true),
			164 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*37), true),
			165 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*38), true),
			166 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*39), true),
			167 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*40), true),
			168 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*41), true),
			169 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*42), true),
			170 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*43), true),
			171 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*44), true),
			172 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*45), true),
			173 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*46), true),
			174 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 1)- 48*47), true),
			175 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(46), true),
			176 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(46), true),
			177 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(46), true),
			178 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(46), true),
			179 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(46), true),
			180 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(46), true),
			181 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(46), true),
			182 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(46), true),
			183 => (CLK_dly'last_event, tpd_CLK_PCOUT(46), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(45),
         GlitchData	=> PCOUT_GlitchData(45),
         OutSignalName	=> "PCOUT(45)",
         OutTemp	=> PCOUT_zd(45),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 2)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 2)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 2)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 2)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 2)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 2)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 2)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 2)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 2)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 2)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 2)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 2)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 2)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 2)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 2)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 2)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 2)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 2)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 2)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 2)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 2)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 2)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 2)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 2)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 2)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 2)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 2)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 2)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 2)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 2)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 2)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 2)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 2)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 2)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 2)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 2)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 2)- 48*17), true),
			54 => (C_dly(45)'last_event, tpd_C_PCOUT((2303 - 2)- 48*2), true),
			55 => (C_dly(44)'last_event, tpd_C_PCOUT((2303 - 2)- 48*3), true),
			56 => (C_dly(43)'last_event, tpd_C_PCOUT((2303 - 2)- 48*4), true),
			57 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 2)- 48*5), true),
			58 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 2)- 48*6), true),
			59 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 2)- 48*7), true),
			60 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 2)- 48*8), true),
			61 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 2)- 48*9), true),
			62 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 2)- 48*10), true),
			63 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 2)- 48*11), true),
			64 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 2)- 48*12), true),
			65 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 2)- 48*13), true),
			66 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 2)- 48*14), true),
			67 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 2)- 48*15), true),
			68 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 2)- 48*16), true),
			69 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 2)- 48*17), true),
			70 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 2)- 48*18), true),
			71 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 2)- 48*19), true),
			72 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 2)- 48*20), true),
			73 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 2)- 48*21), true),
			74 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 2)- 48*22), true),
			75 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 2)- 48*23), true),
			76 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 2)- 48*24), true),
			77 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 2)- 48*25), true),
			78 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 2)- 48*26), true),
			79 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 2)- 48*27), true),
			80 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 2)- 48*28), true),
			81 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 2)- 48*29), true),
			82 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 2)- 48*30), true),
			83 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 2)- 48*31), true),
			84 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 2)- 48*32), true),
			85 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 2)- 48*33), true),
			86 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 2)- 48*34), true),
			87 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 2)- 48*35), true),
			88 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 2)- 48*36), true),
			89 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 2)- 48*37), true),
			90 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 2)- 48*38), true),
			91 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 2)- 48*39), true),
			92 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 2)- 48*40), true),
			93 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 2)- 48*41), true),
			94 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 2)- 48*42), true),
			95 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 2)- 48*43), true),
			96 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 2)- 48*44), true),
			97 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 2)- 48*45), true),
			98 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 2)- 48*46), true),
			99 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 2)- 48*47), true),
			100 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(45), true),
			101 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 2)- 48*0), true),
			102 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 2)- 48*1), true),
			103 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 2)- 48*2), true),
			104 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 2)- 48*3), true),
			105 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 2)- 48*4), true),
			106 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 2)- 48*5), true),
			107 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 2)- 48*6), true),
			108 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 2)- 48*7), true),
			109 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 2)- 48*8), true),
			110 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 2)- 48*9), true),
			111 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 2)- 48*10), true),
			112 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 2)- 48*11), true),
			113 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 2)- 48*12), true),
			114 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 2)- 48*13), true),
			115 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 2)- 48*14), true),
			116 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 2)- 48*15), true),
			117 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 2)- 48*16), true),
			118 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 2)- 48*17), true),
			119 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*0), true),
			120 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*1), true),
			121 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*2), true),
			122 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*3), true),
			123 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*4), true),
			124 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*5), true),
			125 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*6), true),
			126 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 2)- 48*7), true),
			127 => (PCIN_dly(45)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*2), true),
			128 => (PCIN_dly(44)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*3), true),
			129 => (PCIN_dly(43)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*4), true),
			130 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*5), true),
			131 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*6), true),
			132 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*7), true),
			133 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*8), true),
			134 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*9), true),
			135 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*10), true),
			136 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*11), true),
			137 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*12), true),
			138 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*13), true),
			139 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*14), true),
			140 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*15), true),
			141 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*16), true),
			142 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*17), true),
			143 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*18), true),
			144 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*19), true),
			145 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*20), true),
			146 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*21), true),
			147 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*22), true),
			148 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*23), true),
			149 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*24), true),
			150 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*25), true),
			151 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*26), true),
			152 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*27), true),
			153 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*28), true),
			154 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*29), true),
			155 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*30), true),
			156 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*31), true),
			157 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*32), true),
			158 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*33), true),
			159 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*34), true),
			160 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*35), true),
			161 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*36), true),
			162 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*37), true),
			163 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*38), true),
			164 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*39), true),
			165 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*40), true),
			166 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*41), true),
			167 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*42), true),
			168 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*43), true),
			169 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*44), true),
			170 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*45), true),
			171 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*46), true),
			172 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 2)- 48*47), true),
			173 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(45), true),
			174 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(45), true),
			175 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(45), true),
			176 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(45), true),
			177 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(45), true),
			178 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(45), true),
			179 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(45), true),
			180 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(45), true),
			181 => (CLK_dly'last_event, tpd_CLK_PCOUT(45), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(44),
         GlitchData	=> PCOUT_GlitchData(44),
         OutSignalName	=> "PCOUT(44)",
         OutTemp	=> PCOUT_zd(44),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 3)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 3)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 3)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 3)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 3)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 3)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 3)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 3)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 3)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 3)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 3)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 3)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 3)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 3)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 3)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 3)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 3)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 3)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 3)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 3)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 3)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 3)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 3)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 3)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 3)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 3)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 3)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 3)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 3)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 3)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 3)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 3)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 3)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 3)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 3)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 3)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 3)- 48*17), true),
			54 => (C_dly(44)'last_event, tpd_C_PCOUT((2303 - 3)- 48*3), true),
			55 => (C_dly(43)'last_event, tpd_C_PCOUT((2303 - 3)- 48*4), true),
			56 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 3)- 48*5), true),
			57 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 3)- 48*6), true),
			58 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 3)- 48*7), true),
			59 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 3)- 48*8), true),
			60 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 3)- 48*9), true),
			61 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 3)- 48*10), true),
			62 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 3)- 48*11), true),
			63 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 3)- 48*12), true),
			64 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 3)- 48*13), true),
			65 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 3)- 48*14), true),
			66 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 3)- 48*15), true),
			67 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 3)- 48*16), true),
			68 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 3)- 48*17), true),
			69 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 3)- 48*18), true),
			70 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 3)- 48*19), true),
			71 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 3)- 48*20), true),
			72 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 3)- 48*21), true),
			73 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 3)- 48*22), true),
			74 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 3)- 48*23), true),
			75 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 3)- 48*24), true),
			76 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 3)- 48*25), true),
			77 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 3)- 48*26), true),
			78 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 3)- 48*27), true),
			79 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 3)- 48*28), true),
			80 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 3)- 48*29), true),
			81 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 3)- 48*30), true),
			82 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 3)- 48*31), true),
			83 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 3)- 48*32), true),
			84 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 3)- 48*33), true),
			85 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 3)- 48*34), true),
			86 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 3)- 48*35), true),
			87 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 3)- 48*36), true),
			88 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 3)- 48*37), true),
			89 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 3)- 48*38), true),
			90 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 3)- 48*39), true),
			91 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 3)- 48*40), true),
			92 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 3)- 48*41), true),
			93 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 3)- 48*42), true),
			94 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 3)- 48*43), true),
			95 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 3)- 48*44), true),
			96 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 3)- 48*45), true),
			97 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 3)- 48*46), true),
			98 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 3)- 48*47), true),
			99 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(44), true),
			100 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 3)- 48*0), true),
			101 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 3)- 48*1), true),
			102 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 3)- 48*2), true),
			103 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 3)- 48*3), true),
			104 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 3)- 48*4), true),
			105 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 3)- 48*5), true),
			106 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 3)- 48*6), true),
			107 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 3)- 48*7), true),
			108 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 3)- 48*8), true),
			109 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 3)- 48*9), true),
			110 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 3)- 48*10), true),
			111 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 3)- 48*11), true),
			112 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 3)- 48*12), true),
			113 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 3)- 48*13), true),
			114 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 3)- 48*14), true),
			115 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 3)- 48*15), true),
			116 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 3)- 48*16), true),
			117 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 3)- 48*17), true),
			118 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*0), true),
			119 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*1), true),
			120 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*2), true),
			121 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*3), true),
			122 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*4), true),
			123 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*5), true),
			124 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*6), true),
			125 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 3)- 48*7), true),
			126 => (PCIN_dly(44)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*3), true),
			127 => (PCIN_dly(43)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*4), true),
			128 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*5), true),
			129 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*6), true),
			130 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*7), true),
			131 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*8), true),
			132 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*9), true),
			133 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*10), true),
			134 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*11), true),
			135 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*12), true),
			136 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*13), true),
			137 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*14), true),
			138 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*15), true),
			139 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*16), true),
			140 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*17), true),
			141 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*18), true),
			142 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*19), true),
			143 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*20), true),
			144 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*21), true),
			145 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*22), true),
			146 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*23), true),
			147 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*24), true),
			148 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*25), true),
			149 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*26), true),
			150 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*27), true),
			151 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*28), true),
			152 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*29), true),
			153 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*30), true),
			154 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*31), true),
			155 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*32), true),
			156 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*33), true),
			157 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*34), true),
			158 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*35), true),
			159 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*36), true),
			160 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*37), true),
			161 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*38), true),
			162 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*39), true),
			163 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*40), true),
			164 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*41), true),
			165 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*42), true),
			166 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*43), true),
			167 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*44), true),
			168 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*45), true),
			169 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*46), true),
			170 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 3)- 48*47), true),
			171 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(44), true),
			172 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(44), true),
			173 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(44), true),
			174 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(44), true),
			175 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(44), true),
			176 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(44), true),
			177 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(44), true),
			178 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(44), true),
			179 => (CLK_dly'last_event, tpd_CLK_PCOUT(44), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(43),
         GlitchData	=> PCOUT_GlitchData(43),
         OutSignalName	=> "PCOUT(43)",
         OutTemp	=> PCOUT_zd(43),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 4)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 4)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 4)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 4)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 4)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 4)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 4)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 4)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 4)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 4)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 4)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 4)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 4)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 4)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 4)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 4)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 4)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 4)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 4)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 4)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 4)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 4)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 4)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 4)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 4)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 4)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 4)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 4)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 4)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 4)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 4)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 4)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 4)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 4)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 4)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 4)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 4)- 48*17), true),
			54 => (C_dly(43)'last_event, tpd_C_PCOUT((2303 - 4)- 48*4), true),
			55 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 4)- 48*5), true),
			56 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 4)- 48*6), true),
			57 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 4)- 48*7), true),
			58 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 4)- 48*8), true),
			59 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 4)- 48*9), true),
			60 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 4)- 48*10), true),
			61 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 4)- 48*11), true),
			62 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 4)- 48*12), true),
			63 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 4)- 48*13), true),
			64 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 4)- 48*14), true),
			65 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 4)- 48*15), true),
			66 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 4)- 48*16), true),
			67 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 4)- 48*17), true),
			68 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 4)- 48*18), true),
			69 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 4)- 48*19), true),
			70 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 4)- 48*20), true),
			71 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 4)- 48*21), true),
			72 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 4)- 48*22), true),
			73 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 4)- 48*23), true),
			74 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 4)- 48*24), true),
			75 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 4)- 48*25), true),
			76 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 4)- 48*26), true),
			77 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 4)- 48*27), true),
			78 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 4)- 48*28), true),
			79 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 4)- 48*29), true),
			80 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 4)- 48*30), true),
			81 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 4)- 48*31), true),
			82 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 4)- 48*32), true),
			83 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 4)- 48*33), true),
			84 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 4)- 48*34), true),
			85 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 4)- 48*35), true),
			86 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 4)- 48*36), true),
			87 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 4)- 48*37), true),
			88 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 4)- 48*38), true),
			89 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 4)- 48*39), true),
			90 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 4)- 48*40), true),
			91 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 4)- 48*41), true),
			92 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 4)- 48*42), true),
			93 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 4)- 48*43), true),
			94 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 4)- 48*44), true),
			95 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 4)- 48*45), true),
			96 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 4)- 48*46), true),
			97 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 4)- 48*47), true),
			98 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(43), true),
			99 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 4)- 48*0), true),
			100 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 4)- 48*1), true),
			101 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 4)- 48*2), true),
			102 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 4)- 48*3), true),
			103 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 4)- 48*4), true),
			104 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 4)- 48*5), true),
			105 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 4)- 48*6), true),
			106 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 4)- 48*7), true),
			107 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 4)- 48*8), true),
			108 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 4)- 48*9), true),
			109 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 4)- 48*10), true),
			110 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 4)- 48*11), true),
			111 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 4)- 48*12), true),
			112 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 4)- 48*13), true),
			113 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 4)- 48*14), true),
			114 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 4)- 48*15), true),
			115 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 4)- 48*16), true),
			116 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 4)- 48*17), true),
			117 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*0), true),
			118 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*1), true),
			119 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*2), true),
			120 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*3), true),
			121 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*4), true),
			122 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*5), true),
			123 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*6), true),
			124 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 4)- 48*7), true),
			125 => (PCIN_dly(43)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*4), true),
			126 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*5), true),
			127 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*6), true),
			128 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*7), true),
			129 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*8), true),
			130 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*9), true),
			131 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*10), true),
			132 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*11), true),
			133 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*12), true),
			134 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*13), true),
			135 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*14), true),
			136 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*15), true),
			137 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*16), true),
			138 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*17), true),
			139 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*18), true),
			140 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*19), true),
			141 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*20), true),
			142 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*21), true),
			143 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*22), true),
			144 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*23), true),
			145 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*24), true),
			146 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*25), true),
			147 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*26), true),
			148 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*27), true),
			149 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*28), true),
			150 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*29), true),
			151 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*30), true),
			152 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*31), true),
			153 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*32), true),
			154 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*33), true),
			155 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*34), true),
			156 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*35), true),
			157 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*36), true),
			158 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*37), true),
			159 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*38), true),
			160 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*39), true),
			161 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*40), true),
			162 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*41), true),
			163 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*42), true),
			164 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*43), true),
			165 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*44), true),
			166 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*45), true),
			167 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*46), true),
			168 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 4)- 48*47), true),
			169 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(43), true),
			170 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(43), true),
			171 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(43), true),
			172 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(43), true),
			173 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(43), true),
			174 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(43), true),
			175 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(43), true),
			176 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(43), true),
			177 => (CLK_dly'last_event, tpd_CLK_PCOUT(43), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(42),
         GlitchData	=> PCOUT_GlitchData(42),
         OutSignalName	=> "PCOUT(42)",
         OutTemp	=> PCOUT_zd(42),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 5)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 5)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 5)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 5)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 5)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 5)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 5)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 5)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 5)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 5)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 5)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 5)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 5)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 5)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 5)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 5)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 5)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 5)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 5)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 5)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 5)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 5)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 5)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 5)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 5)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 5)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 5)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 5)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 5)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 5)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 5)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 5)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 5)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 5)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 5)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 5)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 5)- 48*17), true),
			54 => (C_dly(42)'last_event, tpd_C_PCOUT((2303 - 5)- 48*5), true),
			55 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 5)- 48*6), true),
			56 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 5)- 48*7), true),
			57 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 5)- 48*8), true),
			58 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 5)- 48*9), true),
			59 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 5)- 48*10), true),
			60 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 5)- 48*11), true),
			61 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 5)- 48*12), true),
			62 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 5)- 48*13), true),
			63 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 5)- 48*14), true),
			64 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 5)- 48*15), true),
			65 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 5)- 48*16), true),
			66 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 5)- 48*17), true),
			67 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 5)- 48*18), true),
			68 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 5)- 48*19), true),
			69 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 5)- 48*20), true),
			70 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 5)- 48*21), true),
			71 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 5)- 48*22), true),
			72 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 5)- 48*23), true),
			73 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 5)- 48*24), true),
			74 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 5)- 48*25), true),
			75 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 5)- 48*26), true),
			76 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 5)- 48*27), true),
			77 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 5)- 48*28), true),
			78 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 5)- 48*29), true),
			79 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 5)- 48*30), true),
			80 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 5)- 48*31), true),
			81 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 5)- 48*32), true),
			82 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 5)- 48*33), true),
			83 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 5)- 48*34), true),
			84 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 5)- 48*35), true),
			85 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 5)- 48*36), true),
			86 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 5)- 48*37), true),
			87 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 5)- 48*38), true),
			88 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 5)- 48*39), true),
			89 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 5)- 48*40), true),
			90 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 5)- 48*41), true),
			91 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 5)- 48*42), true),
			92 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 5)- 48*43), true),
			93 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 5)- 48*44), true),
			94 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 5)- 48*45), true),
			95 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 5)- 48*46), true),
			96 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 5)- 48*47), true),
			97 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(42), true),
			98 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 5)- 48*0), true),
			99 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 5)- 48*1), true),
			100 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 5)- 48*2), true),
			101 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 5)- 48*3), true),
			102 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 5)- 48*4), true),
			103 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 5)- 48*5), true),
			104 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 5)- 48*6), true),
			105 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 5)- 48*7), true),
			106 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 5)- 48*8), true),
			107 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 5)- 48*9), true),
			108 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 5)- 48*10), true),
			109 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 5)- 48*11), true),
			110 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 5)- 48*12), true),
			111 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 5)- 48*13), true),
			112 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 5)- 48*14), true),
			113 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 5)- 48*15), true),
			114 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 5)- 48*16), true),
			115 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 5)- 48*17), true),
			116 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*0), true),
			117 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*1), true),
			118 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*2), true),
			119 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*3), true),
			120 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*4), true),
			121 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*5), true),
			122 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*6), true),
			123 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 5)- 48*7), true),
			124 => (PCIN_dly(42)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*5), true),
			125 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*6), true),
			126 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*7), true),
			127 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*8), true),
			128 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*9), true),
			129 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*10), true),
			130 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*11), true),
			131 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*12), true),
			132 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*13), true),
			133 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*14), true),
			134 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*15), true),
			135 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*16), true),
			136 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*17), true),
			137 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*18), true),
			138 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*19), true),
			139 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*20), true),
			140 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*21), true),
			141 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*22), true),
			142 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*23), true),
			143 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*24), true),
			144 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*25), true),
			145 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*26), true),
			146 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*27), true),
			147 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*28), true),
			148 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*29), true),
			149 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*30), true),
			150 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*31), true),
			151 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*32), true),
			152 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*33), true),
			153 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*34), true),
			154 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*35), true),
			155 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*36), true),
			156 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*37), true),
			157 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*38), true),
			158 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*39), true),
			159 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*40), true),
			160 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*41), true),
			161 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*42), true),
			162 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*43), true),
			163 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*44), true),
			164 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*45), true),
			165 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*46), true),
			166 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 5)- 48*47), true),
			167 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(42), true),
			168 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(42), true),
			169 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(42), true),
			170 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(42), true),
			171 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(42), true),
			172 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(42), true),
			173 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(42), true),
			174 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(42), true),
			175 => (CLK_dly'last_event, tpd_CLK_PCOUT(42), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(41),
         GlitchData	=> PCOUT_GlitchData(41),
         OutSignalName	=> "PCOUT(41)",
         OutTemp	=> PCOUT_zd(41),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 6)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 6)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 6)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 6)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 6)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 6)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 6)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 6)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 6)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 6)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 6)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 6)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 6)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 6)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 6)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 6)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 6)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 6)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 6)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 6)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 6)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 6)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 6)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 6)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 6)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 6)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 6)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 6)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 6)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 6)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 6)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 6)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 6)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 6)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 6)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 6)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 6)- 48*17), true),
			54 => (C_dly(41)'last_event, tpd_C_PCOUT((2303 - 6)- 48*6), true),
			55 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 6)- 48*7), true),
			56 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 6)- 48*8), true),
			57 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 6)- 48*9), true),
			58 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 6)- 48*10), true),
			59 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 6)- 48*11), true),
			60 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 6)- 48*12), true),
			61 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 6)- 48*13), true),
			62 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 6)- 48*14), true),
			63 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 6)- 48*15), true),
			64 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 6)- 48*16), true),
			65 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 6)- 48*17), true),
			66 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 6)- 48*18), true),
			67 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 6)- 48*19), true),
			68 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 6)- 48*20), true),
			69 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 6)- 48*21), true),
			70 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 6)- 48*22), true),
			71 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 6)- 48*23), true),
			72 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 6)- 48*24), true),
			73 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 6)- 48*25), true),
			74 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 6)- 48*26), true),
			75 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 6)- 48*27), true),
			76 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 6)- 48*28), true),
			77 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 6)- 48*29), true),
			78 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 6)- 48*30), true),
			79 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 6)- 48*31), true),
			80 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 6)- 48*32), true),
			81 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 6)- 48*33), true),
			82 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 6)- 48*34), true),
			83 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 6)- 48*35), true),
			84 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 6)- 48*36), true),
			85 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 6)- 48*37), true),
			86 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 6)- 48*38), true),
			87 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 6)- 48*39), true),
			88 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 6)- 48*40), true),
			89 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 6)- 48*41), true),
			90 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 6)- 48*42), true),
			91 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 6)- 48*43), true),
			92 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 6)- 48*44), true),
			93 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 6)- 48*45), true),
			94 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 6)- 48*46), true),
			95 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 6)- 48*47), true),
			96 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(41), true),
			97 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 6)- 48*0), true),
			98 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 6)- 48*1), true),
			99 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 6)- 48*2), true),
			100 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 6)- 48*3), true),
			101 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 6)- 48*4), true),
			102 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 6)- 48*5), true),
			103 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 6)- 48*6), true),
			104 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 6)- 48*7), true),
			105 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 6)- 48*8), true),
			106 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 6)- 48*9), true),
			107 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 6)- 48*10), true),
			108 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 6)- 48*11), true),
			109 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 6)- 48*12), true),
			110 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 6)- 48*13), true),
			111 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 6)- 48*14), true),
			112 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 6)- 48*15), true),
			113 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 6)- 48*16), true),
			114 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 6)- 48*17), true),
			115 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*0), true),
			116 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*1), true),
			117 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*2), true),
			118 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*3), true),
			119 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*4), true),
			120 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*5), true),
			121 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*6), true),
			122 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 6)- 48*7), true),
			123 => (PCIN_dly(41)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*6), true),
			124 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*7), true),
			125 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*8), true),
			126 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*9), true),
			127 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*10), true),
			128 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*11), true),
			129 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*12), true),
			130 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*13), true),
			131 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*14), true),
			132 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*15), true),
			133 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*16), true),
			134 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*17), true),
			135 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*18), true),
			136 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*19), true),
			137 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*20), true),
			138 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*21), true),
			139 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*22), true),
			140 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*23), true),
			141 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*24), true),
			142 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*25), true),
			143 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*26), true),
			144 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*27), true),
			145 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*28), true),
			146 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*29), true),
			147 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*30), true),
			148 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*31), true),
			149 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*32), true),
			150 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*33), true),
			151 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*34), true),
			152 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*35), true),
			153 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*36), true),
			154 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*37), true),
			155 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*38), true),
			156 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*39), true),
			157 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*40), true),
			158 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*41), true),
			159 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*42), true),
			160 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*43), true),
			161 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*44), true),
			162 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*45), true),
			163 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*46), true),
			164 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 6)- 48*47), true),
			165 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(41), true),
			166 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(41), true),
			167 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(41), true),
			168 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(41), true),
			169 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(41), true),
			170 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(41), true),
			171 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(41), true),
			172 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(41), true),
			173 => (CLK_dly'last_event, tpd_CLK_PCOUT(41), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(40),
         GlitchData	=> PCOUT_GlitchData(40),
         OutSignalName	=> "PCOUT(40)",
         OutTemp	=> PCOUT_zd(40),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 7)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 7)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 7)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 7)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 7)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 7)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 7)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 7)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 7)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 7)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 7)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 7)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 7)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 7)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 7)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 7)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 7)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 7)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 7)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 7)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 7)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 7)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 7)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 7)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 7)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 7)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 7)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 7)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 7)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 7)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 7)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 7)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 7)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 7)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 7)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 7)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 7)- 48*17), true),
			54 => (C_dly(40)'last_event, tpd_C_PCOUT((2303 - 7)- 48*7), true),
			55 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 7)- 48*8), true),
			56 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 7)- 48*9), true),
			57 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 7)- 48*10), true),
			58 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 7)- 48*11), true),
			59 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 7)- 48*12), true),
			60 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 7)- 48*13), true),
			61 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 7)- 48*14), true),
			62 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 7)- 48*15), true),
			63 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 7)- 48*16), true),
			64 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 7)- 48*17), true),
			65 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 7)- 48*18), true),
			66 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 7)- 48*19), true),
			67 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 7)- 48*20), true),
			68 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 7)- 48*21), true),
			69 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 7)- 48*22), true),
			70 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 7)- 48*23), true),
			71 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 7)- 48*24), true),
			72 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 7)- 48*25), true),
			73 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 7)- 48*26), true),
			74 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 7)- 48*27), true),
			75 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 7)- 48*28), true),
			76 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 7)- 48*29), true),
			77 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 7)- 48*30), true),
			78 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 7)- 48*31), true),
			79 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 7)- 48*32), true),
			80 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 7)- 48*33), true),
			81 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 7)- 48*34), true),
			82 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 7)- 48*35), true),
			83 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 7)- 48*36), true),
			84 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 7)- 48*37), true),
			85 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 7)- 48*38), true),
			86 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 7)- 48*39), true),
			87 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 7)- 48*40), true),
			88 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 7)- 48*41), true),
			89 => (C_dly(5)'last_event, tpd_C_PCOUT((2303 - 7)- 48*42), true),
			90 => (C_dly(4)'last_event, tpd_C_PCOUT((2303 - 7)- 48*43), true),
			91 => (C_dly(3)'last_event, tpd_C_PCOUT((2303 - 7)- 48*44), true),
			92 => (C_dly(2)'last_event, tpd_C_PCOUT((2303 - 7)- 48*45), true),
			93 => (C_dly(1)'last_event, tpd_C_PCOUT((2303 - 7)- 48*46), true),
			94 => (C_dly(0)'last_event, tpd_C_PCOUT((2303 - 7)- 48*47), true),
			95 => (CARRYIN_dly'last_event, tpd_CARRYIN_PCOUT(40), true),
			96 => (D_dly(17)'last_event, tpd_D_PCOUT((863 - 7)- 48*0), true),
			97 => (D_dly(16)'last_event, tpd_D_PCOUT((863 - 7)- 48*1), true),
			98 => (D_dly(15)'last_event, tpd_D_PCOUT((863 - 7)- 48*2), true),
			99 => (D_dly(14)'last_event, tpd_D_PCOUT((863 - 7)- 48*3), true),
			100 => (D_dly(13)'last_event, tpd_D_PCOUT((863 - 7)- 48*4), true),
			101 => (D_dly(12)'last_event, tpd_D_PCOUT((863 - 7)- 48*5), true),
			102 => (D_dly(11)'last_event, tpd_D_PCOUT((863 - 7)- 48*6), true),
			103 => (D_dly(10)'last_event, tpd_D_PCOUT((863 - 7)- 48*7), true),
			104 => (D_dly(9)'last_event, tpd_D_PCOUT((863 - 7)- 48*8), true),
			105 => (D_dly(8)'last_event, tpd_D_PCOUT((863 - 7)- 48*9), true),
			106 => (D_dly(7)'last_event, tpd_D_PCOUT((863 - 7)- 48*10), true),
			107 => (D_dly(6)'last_event, tpd_D_PCOUT((863 - 7)- 48*11), true),
			108 => (D_dly(5)'last_event, tpd_D_PCOUT((863 - 7)- 48*12), true),
			109 => (D_dly(4)'last_event, tpd_D_PCOUT((863 - 7)- 48*13), true),
			110 => (D_dly(3)'last_event, tpd_D_PCOUT((863 - 7)- 48*14), true),
			111 => (D_dly(2)'last_event, tpd_D_PCOUT((863 - 7)- 48*15), true),
			112 => (D_dly(1)'last_event, tpd_D_PCOUT((863 - 7)- 48*16), true),
			113 => (D_dly(0)'last_event, tpd_D_PCOUT((863 - 7)- 48*17), true),
			114 => (OPMODE_dly(7)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*0), true),
			115 => (OPMODE_dly(6)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*1), true),
			116 => (OPMODE_dly(5)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*2), true),
			117 => (OPMODE_dly(4)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*3), true),
			118 => (OPMODE_dly(3)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*4), true),
			119 => (OPMODE_dly(2)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*5), true),
			120 => (OPMODE_dly(1)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*6), true),
			121 => (OPMODE_dly(0)'last_event, tpd_OPMODE_PCOUT((383 - 7)- 48*7), true),
			122 => (PCIN_dly(40)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*7), true),
			123 => (PCIN_dly(39)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*8), true),
			124 => (PCIN_dly(38)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*9), true),
			125 => (PCIN_dly(37)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*10), true),
			126 => (PCIN_dly(36)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*11), true),
			127 => (PCIN_dly(35)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*12), true),
			128 => (PCIN_dly(34)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*13), true),
			129 => (PCIN_dly(33)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*14), true),
			130 => (PCIN_dly(32)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*15), true),
			131 => (PCIN_dly(31)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*16), true),
			132 => (PCIN_dly(30)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*17), true),
			133 => (PCIN_dly(29)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*18), true),
			134 => (PCIN_dly(28)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*19), true),
			135 => (PCIN_dly(27)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*20), true),
			136 => (PCIN_dly(26)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*21), true),
			137 => (PCIN_dly(25)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*22), true),
			138 => (PCIN_dly(24)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*23), true),
			139 => (PCIN_dly(23)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*24), true),
			140 => (PCIN_dly(22)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*25), true),
			141 => (PCIN_dly(21)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*26), true),
			142 => (PCIN_dly(20)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*27), true),
			143 => (PCIN_dly(19)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*28), true),
			144 => (PCIN_dly(18)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*29), true),
			145 => (PCIN_dly(17)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*30), true),
			146 => (PCIN_dly(16)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*31), true),
			147 => (PCIN_dly(15)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*32), true),
			148 => (PCIN_dly(14)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*33), true),
			149 => (PCIN_dly(13)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*34), true),
			150 => (PCIN_dly(12)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*35), true),
			151 => (PCIN_dly(11)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*36), true),
			152 => (PCIN_dly(10)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*37), true),
			153 => (PCIN_dly(9)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*38), true),
			154 => (PCIN_dly(8)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*39), true),
			155 => (PCIN_dly(7)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*40), true),
			156 => (PCIN_dly(6)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*41), true),
			157 => (PCIN_dly(5)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*42), true),
			158 => (PCIN_dly(4)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*43), true),
			159 => (PCIN_dly(3)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*44), true),
			160 => (PCIN_dly(2)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*45), true),
			161 => (PCIN_dly(1)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*46), true),
			162 => (PCIN_dly(0)'last_event, tpd_PCIN_PCOUT((2303 - 7)- 48*47), true),
			163 => (RSTA_dly'last_event, tpd_RSTA_PCOUT(40), true),
			164 => (RSTB_dly'last_event, tpd_RSTB_PCOUT(40), true),
			165 => (RSTC_dly'last_event, tpd_RSTC_PCOUT(40), true),
			166 => (RSTCARRYIN_dly'last_event, tpd_RSTCARRYIN_PCOUT(40), true),
			167 => (RSTD_dly'last_event, tpd_RSTD_PCOUT(40), true),
			168 => (RSTM_dly'last_event, tpd_RSTM_PCOUT(40), true),
			169 => (RSTOPMODE_dly'last_event, tpd_RSTOPMODE_PCOUT(40), true),
			170 => (RSTP_dly'last_event, tpd_RSTP_PCOUT(40), true),
			171 => (CLK_dly'last_event, tpd_CLK_PCOUT(40), true)),
         Mode	=> VitalTransport,
         Xon		=> Xon,
         MsgOn	=> MsgOn,
         MsgSeverity	=> Warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(39),
         GlitchData	=> PCOUT_GlitchData(39),
         OutSignalName	=> "PCOUT(39)",
         OutTemp	=> PCOUT_zd(39),
         Paths		=> (
			0 => (A_dly(17)'last_event, tpd_A_PCOUT((863 - 8)- 48*0), true),
			1 => (A_dly(16)'last_event, tpd_A_PCOUT((863 - 8)- 48*1), true),
			2 => (A_dly(15)'last_event, tpd_A_PCOUT((863 - 8)- 48*2), true),
			3 => (A_dly(14)'last_event, tpd_A_PCOUT((863 - 8)- 48*3), true),
			4 => (A_dly(13)'last_event, tpd_A_PCOUT((863 - 8)- 48*4), true),
			5 => (A_dly(12)'last_event, tpd_A_PCOUT((863 - 8)- 48*5), true),
			6 => (A_dly(11)'last_event, tpd_A_PCOUT((863 - 8)- 48*6), true),
			7 => (A_dly(10)'last_event, tpd_A_PCOUT((863 - 8)- 48*7), true),
			8 => (A_dly(9)'last_event, tpd_A_PCOUT((863 - 8)- 48*8), true),
			9 => (A_dly(8)'last_event, tpd_A_PCOUT((863 - 8)- 48*9), true),
			10 => (A_dly(7)'last_event, tpd_A_PCOUT((863 - 8)- 48*10), true),
			11 => (A_dly(6)'last_event, tpd_A_PCOUT((863 - 8)- 48*11), true),
			12 => (A_dly(5)'last_event, tpd_A_PCOUT((863 - 8)- 48*12), true),
			13 => (A_dly(4)'last_event, tpd_A_PCOUT((863 - 8)- 48*13), true),
			14 => (A_dly(3)'last_event, tpd_A_PCOUT((863 - 8)- 48*14), true),
			15 => (A_dly(2)'last_event, tpd_A_PCOUT((863 - 8)- 48*15), true),
			16 => (A_dly(1)'last_event, tpd_A_PCOUT((863 - 8)- 48*16), true),
			17 => (A_dly(0)'last_event, tpd_A_PCOUT((863 - 8)- 48*17), true),
			18 => (B_dly(17)'last_event, tpd_B_PCOUT((863 - 8)- 48*0), true),
			19 => (B_dly(16)'last_event, tpd_B_PCOUT((863 - 8)- 48*1), true),
			20 => (B_dly(15)'last_event, tpd_B_PCOUT((863 - 8)- 48*2), true),
			21 => (B_dly(14)'last_event, tpd_B_PCOUT((863 - 8)- 48*3), true),
			22 => (B_dly(13)'last_event, tpd_B_PCOUT((863 - 8)- 48*4), true),
			23 => (B_dly(12)'last_event, tpd_B_PCOUT((863 - 8)- 48*5), true),
			24 => (B_dly(11)'last_event, tpd_B_PCOUT((863 - 8)- 48*6), true),
			25 => (B_dly(10)'last_event, tpd_B_PCOUT((863 - 8)- 48*7), true),
			26 => (B_dly(9)'last_event, tpd_B_PCOUT((863 - 8)- 48*8), true),
			27 => (B_dly(8)'last_event, tpd_B_PCOUT((863 - 8)- 48*9), true),
			28 => (B_dly(7)'last_event, tpd_B_PCOUT((863 - 8)- 48*10), true),
			29 => (B_dly(6)'last_event, tpd_B_PCOUT((863 - 8)- 48*11), true),
			30 => (B_dly(5)'last_event, tpd_B_PCOUT((863 - 8)- 48*12), true),
			31 => (B_dly(4)'last_event, tpd_B_PCOUT((863 - 8)- 48*13), true),
			32 => (B_dly(3)'last_event, tpd_B_PCOUT((863 - 8)- 48*14), true),
			33 => (B_dly(2)'last_event, tpd_B_PCOUT((863 - 8)- 48*15), true),
			34 => (B_dly(1)'last_event, tpd_B_PCOUT((863 - 8)- 48*16), true),
			35 => (B_dly(0)'last_event, tpd_B_PCOUT((863 - 8)- 48*17), true),
			36 => (BCIN_dly(17)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*0), true),
			37 => (BCIN_dly(16)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*1), true),
			38 => (BCIN_dly(15)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*2), true),
			39 => (BCIN_dly(14)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*3), true),
			40 => (BCIN_dly(13)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*4), true),
			41 => (BCIN_dly(12)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*5), true),
			42 => (BCIN_dly(11)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*6), true),
			43 => (BCIN_dly(10)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*7), true),
			44 => (BCIN_dly(9)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*8), true),
			45 => (BCIN_dly(8)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*9), true),
			46 => (BCIN_dly(7)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*10), true),
			47 => (BCIN_dly(6)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*11), true),
			48 => (BCIN_dly(5)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*12), true),
			49 => (BCIN_dly(4)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*13), true),
			50 => (BCIN_dly(3)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*14), true),
			51 => (BCIN_dly(2)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*15), true),
			52 => (BCIN_dly(1)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*16), true),
			53 => (BCIN_dly(0)'last_event, tpd_BCIN_PCOUT((863 - 8)- 48*17), true),
			54 => (C_dly(39)'last_event, tpd_C_PCOUT((2303 - 8)- 48*8), true),
			55 => (C_dly(38)'last_event, tpd_C_PCOUT((2303 - 8)- 48*9), true),
			56 => (C_dly(37)'last_event, tpd_C_PCOUT((2303 - 8)- 48*10), true),
			57 => (C_dly(36)'last_event, tpd_C_PCOUT((2303 - 8)- 48*11), true),
			58 => (C_dly(35)'last_event, tpd_C_PCOUT((2303 - 8)- 48*12), true),
			59 => (C_dly(34)'last_event, tpd_C_PCOUT((2303 - 8)- 48*13), true),
			60 => (C_dly(33)'last_event, tpd_C_PCOUT((2303 - 8)- 48*14), true),
			61 => (C_dly(32)'last_event, tpd_C_PCOUT((2303 - 8)- 48*15), true),
			62 => (C_dly(31)'last_event, tpd_C_PCOUT((2303 - 8)- 48*16), true),
			63 => (C_dly(30)'last_event, tpd_C_PCOUT((2303 - 8)- 48*17), true),
			64 => (C_dly(29)'last_event, tpd_C_PCOUT((2303 - 8)- 48*18), true),
			65 => (C_dly(28)'last_event, tpd_C_PCOUT((2303 - 8)- 48*19), true),
			66 => (C_dly(27)'last_event, tpd_C_PCOUT((2303 - 8)- 48*20), true),
			67 => (C_dly(26)'last_event, tpd_C_PCOUT((2303 - 8)- 48*21), true),
			68 => (C_dly(25)'last_event, tpd_C_PCOUT((2303 - 8)- 48*22), true),
			69 => (C_dly(24)'last_event, tpd_C_PCOUT((2303 - 8)- 48*23), true),
			70 => (C_dly(23)'last_event, tpd_C_PCOUT((2303 - 8)- 48*24), true),
			71 => (C_dly(22)'last_event, tpd_C_PCOUT((2303 - 8)- 48*25), true),
			72 => (C_dly(21)'last_event, tpd_C_PCOUT((2303 - 8)- 48*26), true),
			73 => (C_dly(20)'last_event, tpd_C_PCOUT((2303 - 8)- 48*27), true),
			74 => (C_dly(19)'last_event, tpd_C_PCOUT((2303 - 8)- 48*28), true),
			75 => (C_dly(18)'last_event, tpd_C_PCOUT((2303 - 8)- 48*29), true),
			76 => (C_dly(17)'last_event, tpd_C_PCOUT((2303 - 8)- 48*30), true),
			77 => (C_dly(16)'last_event, tpd_C_PCOUT((2303 - 8)- 48*31), true),
			78 => (C_dly(15)'last_event, tpd_C_PCOUT((2303 - 8)- 48*32), true),
			79 => (C_dly(14)'last_event, tpd_C_PCOUT((2303 - 8)- 48*33), true),
			80 => (C_dly(13)'last_event, tpd_C_PCOUT((2303 - 8)- 48*34), true),
			81 => (C_dly(12)'last_event, tpd_C_PCOUT((2303 - 8)- 48*35), true),
			82 => (C_dly(11)'last_event, tpd_C_PCOUT((2303 - 8)- 48*36), true),
			83 => (C_dly(10)'last_event, tpd_C_PCOUT((2303 - 8)- 48*37), true),
			84 => (C_dly(9)'last_event, tpd_C_PCOUT((2303 - 8)- 48*38), true),
			85 => (C_dly(8)'last_event, tpd_C_PCOUT((2303 - 8)- 48*39), true),
			86 => (C_dly(7)'last_event, tpd_C_PCOUT((2303 - 8)- 48*40), true),
			87 => (C_dly(6)'last_event, tpd_C_PCOUT((2303 - 8)- 48*41), true),
			88 => (